/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.intro.messaging;

import com.aptana.ide.core.FileUtils;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.core.ui.SWTUtils;
import com.aptana.ide.editors.preferences.PreferenceMastHead;
import com.aptana.ide.editors.unified.UnifiedColorManager;
import com.aptana.ide.intro.IntroPlugin;
import com.aptana.ide.intro.messaging.IMessageListener;
import com.aptana.ide.intro.messaging.Message;
import com.aptana.ide.intro.messaging.Messages;
import com.aptana.ide.intro.messaging.MessagingManager;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.progress.UIJob;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessagesEditor
extends EditorPart {
    public static final String ID = "com.aptana.ide.intro.messageEditor";
    public static final String MESSAGE_MARKER = "<!-- Put Message Here -->";
    public static final String TITLE_MARKER = "<!-- Put Title Here -->";
    private static final IEditorInput INPUT = new IEditorInput(){

        public Object getAdapter(Class adapter) {
            return null;
        }

        public String getToolTipText() {
            return Messages.MessagesEditor_Tooltip;
        }

        public IPersistableElement getPersistable() {
            return null;
        }

        public String getName() {
            return Messages.MessagesEditor_Name;
        }

        public ImageDescriptor getImageDescriptor() {
            return IntroPlugin.getImageDescriptor("icons/aptana_envelope.png");
        }

        public boolean exists() {
            return false;
        }
    };
    private Color MAIN_BG = UnifiedColorManager.getInstance().getColor(new RGB(225, 225, 225));
    private Color HEADER_BG = UnifiedColorManager.getInstance().getColor(new RGB(110, 110, 110));
    private Color HEADER_FG = UnifiedColorManager.getInstance().getColor(new RGB(196, 196, 196));
    private Composite header;
    private Composite displayArea;
    private SashForm sides;
    private ToolBar toolbar;
    private TableViewer messages;
    private Composite messagePreview;
    private Browser preview;
    private Font standard;
    private Font bold;
    private File previewFile;
    private ToolItem markAsNew;
    private ToolItem markAsOld;
    private ToolItem delete;
    private ToolItem showDeleted;
    private ToolItem vertical;
    private ToolItem horizontal;
    private ToolItem refresh;
    private ToolItem configure;
    private String loadingPage;
    private String messageTemplate;
    private Label inbox;
    private Font localFont;
    private IStructuredContentProvider contentProvider = new IStructuredContentProvider(){
        private List<Message> messages = null;

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput instanceof List) {
                this.messages = (List)newInput;
            }
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return this.messages.toArray();
        }
    };
    private ITableLabelProvider labelProvider = new MessagesEditorLabelProvider();
    private MessageTableSorter sorter = new MessageTableSorter();
    private IMessageListener listener = new IMessageListener(){

        public void messageChanged(final Message message, int eventType) {
            UIJob job = new UIJob("Updating message editor"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    if (MessagesEditor.this.messages == null || MessagesEditor.this.messages.getTable().isDisposed()) {
                        MessagingManager.removeListener(MessagesEditor.this.listener);
                        return Status.CANCEL_STATUS;
                    }
                    MessagesEditor.this.messages.update((Object)message, null);
                    TableItem[] items = MessagesEditor.this.messages.getTable().getItems();
                    boolean exists = false;
                    int i = 0;
                    while (i < items.length) {
                        if (message.equals(items[i].getData())) {
                            exists = true;
                            break;
                        }
                        ++i;
                    }
                    if (!exists && (MessagesEditor.this.showDeleted.getSelection() || !message.isDeleted()) || message.isPurged()) {
                        MessagesEditor.this.populateMessageTable();
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }
    };

    public static void openMessageCenter() {
        try {
            IWorkbenchWindow ww;
            IWorkbench wb = IntroPlugin.getDefault().getWorkbench();
            if (wb != null && (ww = wb.getActiveWorkbenchWindow()) != null && ww.getActivePage() != null) {
                IDE.openEditor((IWorkbenchPage)ww.getActivePage(), (IEditorInput)INPUT, (String)ID);
            }
        }
        catch (PartInitException e) {
            IdeLog.logError((Plugin)IntroPlugin.getDefault(), (String)Messages.MessagesEditor_Error_Opening, (Throwable)e);
        }
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void dispose() {
        super.dispose();
        if (this.localFont != null && !this.localFont.isDisposed()) {
            this.localFont.dispose();
        }
        if (this.listener != null) {
            MessagingManager.removeListener(this.listener);
        }
    }

    public void createPartControl(Composite parent) {
        Bundle bundle = Platform.getBundle((String)"com.aptana.ide.intro");
        URL contentUrl = bundle.getEntry("/content");
        try {
            FileLocator.toFileURL((URL)contentUrl);
        }
        catch (IOException iOException) {}
        URL loadingUrl = bundle.getEntry("/content/loading_message.html");
        try {
            loadingUrl = FileLocator.toFileURL((URL)loadingUrl);
            this.loadingPage = loadingUrl.toExternalForm();
        }
        catch (IOException iOException) {
            this.loadingPage = null;
        }
        String newFileName = FileUtils.getRandomFileName((String)"message", (String)".html");
        this.previewFile = new File(String.valueOf(FileUtils.systemTempDir) + File.separator + newFileName);
        this.previewFile.deleteOnExit();
        URL messageUrl = bundle.getEntry("/content/message.html");
        try {
            messageUrl = FileLocator.toFileURL((URL)messageUrl);
            this.messageTemplate = FileUtils.readContent((File)new File(messageUrl.getFile()));
        }
        catch (IOException iOException) {
            this.messageTemplate = "";
        }
        this.standard = new Font((Device)parent.getDisplay(), "Arial", 10, 0);
        this.bold = new Font((Device)parent.getDisplay(), "Arial", 10, 1);
        this.displayArea = new Composite(parent, 0);
        GridLayout daLayout = new GridLayout(2, false);
        daLayout.marginHeight = 0;
        daLayout.marginWidth = 0;
        this.displayArea.setLayout((Layout)daLayout);
        this.displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.displayArea.setBackground(this.HEADER_BG);
        this.header = new Composite(this.displayArea, 0);
        this.header.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.drawImage(IntroPlugin.getImage("icons/message_center_top.png"), 33, 15);
            }
        });
        this.header.setBackground(PreferenceMastHead.HEADER_BG_COLOR);
        GridData pmhData = new GridData(4, 4, true, false);
        pmhData.heightHint = IntroPlugin.getImage((String)"icons/message_center_top.png").getImageData().height + 20;
        pmhData.horizontalSpan = 2;
        this.header.setLayoutData((Object)pmhData);
        Composite topBar = new Composite(this.displayArea, 0);
        topBar.setBackground(this.HEADER_BG);
        GridLayout tbLayout = new GridLayout(3, false);
        tbLayout.marginHeight = 0;
        tbLayout.marginLeft = 33;
        tbLayout.marginWidth = 0;
        topBar.setLayout((Layout)tbLayout);
        GridData tbData = new GridData(4, 4, true, false);
        tbData.horizontalSpan = 2;
        topBar.setLayoutData((Object)tbData);
        this.inbox = new Label(topBar, 16384);
        this.inbox.setBackground(this.HEADER_BG);
        this.inbox.setText(Messages.MessagesEditor_Inbox_Text);
        this.inbox.setLayoutData((Object)new GridData(4, 0x1000008, true, false));
        this.inbox.setForeground(this.HEADER_FG);
        this.localFont = new Font((Device)Display.getDefault(), SWTUtils.resizeFont((Font)this.standard, (int)2));
        this.inbox.setFont(this.localFont);
        Composite toolbarComp = new Composite(this.displayArea, 0);
        toolbarComp.setBackground(this.HEADER_BG);
        GridLayout tbcLayout = new GridLayout(1, false);
        tbcLayout.marginHeight = 0;
        tbcLayout.marginLeft = 5;
        tbcLayout.marginWidth = 0;
        toolbarComp.setLayout((Layout)tbcLayout);
        toolbarComp.setLayoutData((Object)new GridData(4, 4, false, true));
        this.toolbar = new ToolBar(toolbarComp, 0x800000);
        this.toolbar.setLayout((Layout)new GridLayout(1, false));
        this.toolbar.setBackground(this.HEADER_BG);
        this.markAsOld = new ToolItem(this.toolbar, 8);
        this.markAsOld.setImage(IntroPlugin.getImage("icons/mail_read.gif"));
        this.markAsOld.setToolTipText(Messages.MessagesEditor_MarkAsRead_Tooltip);
        this.markAsOld.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] tItems = MessagesEditor.this.messages.getTable().getSelection();
                int i = 0;
                while (i < tItems.length) {
                    Message curr = (Message)tItems[i].getData();
                    curr.setRead(true);
                    MessagingManager.notifyListeners(curr, 2);
                    ++i;
                }
            }
        });
        this.toolbar = new ToolBar(toolbarComp, 0x800000);
        this.toolbar.setLayout((Layout)new GridLayout(1, false));
        this.toolbar.setBackground(this.HEADER_BG);
        this.markAsNew = new ToolItem(this.toolbar, 8);
        this.markAsNew.setImage(IntroPlugin.getImage("icons/mail_unread.gif"));
        this.markAsNew.setToolTipText(Messages.MessagesEditor_MarkAsUnread_Tooltip);
        this.markAsNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] tItems = MessagesEditor.this.messages.getTable().getSelection();
                int i = 0;
                while (i < tItems.length) {
                    Message curr = (Message)tItems[i].getData();
                    curr.setRead(false);
                    curr.setDeleted(false);
                    MessagingManager.notifyListeners(curr, 3);
                    ++i;
                }
            }
        });
        this.toolbar = new ToolBar(toolbarComp, 0x800000);
        this.toolbar.setLayout((Layout)new GridLayout(1, false));
        this.toolbar.setBackground(this.HEADER_BG);
        this.delete = new ToolItem(this.toolbar, 8);
        this.delete.setToolTipText(Messages.MessagesEditor_Delete_Tooltip);
        this.delete.setImage(IntroPlugin.getImage("icons/delete.gif"));
        this.delete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MessagesEditor.this.deleteSelectedMessages();
            }
        });
        this.toolbar = new ToolBar(toolbarComp, 0x800000);
        this.toolbar.setLayout((Layout)new GridLayout(1, false));
        this.toolbar.setBackground(this.HEADER_BG);
        this.showDeleted = new ToolItem(this.toolbar, 32);
        this.showDeleted.setToolTipText(Messages.MessagesEditor_ShowDeleted_Tooltip);
        this.showDeleted.setImage(IntroPlugin.getImage("icons/show_deleted.png"));
        this.showDeleted.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MessagesEditor.this.messages.refresh();
            }
        });
        this.toolbar = new ToolBar(toolbarComp, 0x800000);
        this.toolbar.setLayout((Layout)new GridLayout(1, false));
        this.toolbar.setBackground(this.HEADER_BG);
        this.horizontal = new ToolItem(this.toolbar, 8);
        this.horizontal.setImage(IntroPlugin.getImage("icons/horizontal.gif"));
        this.horizontal.setToolTipText(Messages.MessagesEditor_SplitHorizontal_Tooltip);
        this.horizontal.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MessagesEditor.this.sides.setOrientation(512);
                IPreferenceStore store = IntroPlugin.getDefault().getPreferenceStore();
                store.setValue("com.aptana.ide.intro.MESSAGE_CENTER_ORIENTATION", "horizontal");
            }
        });
        this.toolbar = new ToolBar(toolbarComp, 0x800000);
        this.toolbar.setLayout((Layout)new GridLayout(1, false));
        this.toolbar.setBackground(this.HEADER_BG);
        this.vertical = new ToolItem(this.toolbar, 0);
        this.vertical.setToolTipText(Messages.MessagesEditor_SplitVertical_Tooltip);
        this.vertical.setImage(IntroPlugin.getImage("icons/vertical.gif"));
        this.vertical.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MessagesEditor.this.sides.setOrientation(256);
                IPreferenceStore store = IntroPlugin.getDefault().getPreferenceStore();
                store.setValue("com.aptana.ide.intro.MESSAGE_CENTER_ORIENTATION", "vertical");
            }
        });
        this.toolbar = new ToolBar(toolbarComp, 0x800000);
        this.toolbar.setLayout((Layout)new GridLayout(1, false));
        this.toolbar.setBackground(this.HEADER_BG);
        this.refresh = new ToolItem(this.toolbar, 0);
        this.refresh.setToolTipText(Messages.MessagesEditor_Refresh_Tooltip);
        this.refresh.setImage(IntroPlugin.getImage("icons/refresh.gif"));
        this.refresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MessagingManager.getNewMessages(new Date(0L));
            }
        });
        this.toolbar = new ToolBar(toolbarComp, 0x800000);
        this.toolbar.setLayout((Layout)new GridLayout(1, false));
        this.toolbar.setBackground(this.HEADER_BG);
        this.configure = new ToolItem(this.toolbar, 0);
        this.configure.setToolTipText(Messages.MessagesEditor_Configure_Tooltip);
        this.configure.setImage(IntroPlugin.getImage("icons/configure.gif"));
        this.configure.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)Display.getDefault().getActiveShell(), (String)"com.aptana.ide.intro.preferences.IntroPreferencePage", (String[])new String[]{"com.aptana.ide.intro.preferences.IntroPreferencePage"}, null);
                dialog.open();
            }
        });
        IPreferenceStore store = IntroPlugin.getDefault().getPreferenceStore();
        String value = store.getString("com.aptana.ide.intro.MESSAGE_CENTER_ORIENTATION");
        int orientation = value.equals("horizontal") ? 512 : 256;
        this.sides = new SashForm(this.displayArea, orientation);
        GridLayout sLayout = new GridLayout(2, false);
        sLayout.marginHeight = 0;
        sLayout.marginWidth = 0;
        this.sides.setLayout((Layout)sLayout);
        this.sides.setBackground(this.HEADER_FG);
        this.sides.setLayoutData((Object)new GridData(4, 4, true, true));
        this.messages = new TableViewer((Composite)this.sides, 65538);
        this.messages.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.messages.setContentProvider((IContentProvider)this.contentProvider);
        this.messages.setSorter((ViewerSorter)this.sorter);
        this.messages.getTable().setHeaderVisible(true);
        this.messages.getTable().setBackground(this.MAIN_BG);
        this.messages.getTable().setLinesVisible(true);
        this.messages.getTable().setFont(this.bold);
        this.messages.getTable().addListener(40, new Listener(){

            public void handleEvent(Event event) {
                if ((event.detail & 2) != 0 && Platform.getOS().equals("win32")) {
                    int clientWidth = ((MessagesEditor)MessagesEditor.this).messages.getTable().getClientArea().width;
                    Color oldBg = event.gc.getBackground();
                    event.gc.setBackground(MessagesEditor.this.HEADER_FG);
                    RGB converted = new RGB(0, 0, 0);
                    converted.red = Math.abs(MessagesEditor.this.HEADER_BG.getRed() - MessagesEditor.this.HEADER_FG.getRed());
                    converted.blue = Math.abs(MessagesEditor.this.HEADER_BG.getBlue() - MessagesEditor.this.HEADER_FG.getBlue());
                    converted.green = Math.abs(MessagesEditor.this.HEADER_BG.getGreen() - MessagesEditor.this.HEADER_FG.getGreen());
                    event.gc.setForeground(UnifiedColorManager.getInstance().getColor(converted));
                    event.gc.fillRectangle(0, event.y, clientWidth, event.height);
                    event.gc.setBackground(oldBg);
                    event.detail &= 0xFFFFFFFD;
                }
            }
        });
        this.messages.getTable().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                int total;
                double percentage;
                int[] weights = MessagesEditor.this.sides.getWeights();
                if (weights != null && weights.length == 2 && (percentage = (double)weights[0] / (double)(total = weights[0] + weights[1]) * 100.0) > 0.0 && percentage < 100.0) {
                    IPreferenceStore store = IntroPlugin.getDefault().getPreferenceStore();
                    store.setValue("com.aptana.ide.intro.MESSAGE_CENTER_LEFT_WEIGHT", (int)percentage);
                }
            }
        });
        this.messages.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    MessagesEditor.this.deleteSelectedMessages();
                } else if ((Platform.getOS().equals("macosx") && e.stateMask == 0x400000 || e.stateMask == 262144) && (char)e.keyCode == 'a') {
                    MessagesEditor.this.messages.getTable().selectAll();
                }
            }
        });
        TableColumn tc1 = new TableColumn(this.messages.getTable(), 16384);
        tc1.setText(Messages.MessagesEditor_Column_Subject);
        TableColumn tc2 = new TableColumn(this.messages.getTable(), 16384);
        tc2.setText(Messages.MessagesEditor_Column_Category);
        tc2.setWidth(275);
        TableColumn tc3 = new TableColumn(this.messages.getTable(), 16384);
        tc3.setText(Messages.MessagesEditor_Column_Date);
        tc3.setWidth(175);
        this.messages.getTable().setSortColumn(tc3);
        this.messages.getTable().setSortDirection(1024);
        this.sorter.bind(this.messages);
        this.messages.getTable().addControlListener((ControlListener)new ControlAdapter(){
            boolean firstResize = true;

            public void controlResized(ControlEvent e) {
                if (this.firstResize) {
                    ScrollBar vScrolls;
                    this.firstResize = false;
                    TableColumn c = MessagesEditor.this.messages.getTable().getColumn(0);
                    TableColumn c2 = MessagesEditor.this.messages.getTable().getColumn(1);
                    TableColumn c3 = MessagesEditor.this.messages.getTable().getColumn(2);
                    if (CoreUIUtils.onLinux) {
                        c2.setWidth(275);
                        c3.setWidth(175);
                    }
                    Point size = MessagesEditor.this.messages.getTable().getSize();
                    if ((CoreUIUtils.onMacOSX || CoreUIUtils.onLinux) && (vScrolls = MessagesEditor.this.messages.getTable().getVerticalBar()) != null) {
                        size.x = size.x - vScrolls.getSize().x - 5;
                    }
                    c.setWidth(size.x - c2.getWidth() - c3.getWidth() - 1);
                }
            }
        });
        this.messagePreview = new Composite((Composite)this.sides, 0);
        this.messagePreview.setBackground(this.MAIN_BG);
        GridLayout mpLayout = new GridLayout(1, true);
        mpLayout.marginWidth = 0;
        mpLayout.marginHeight = 0;
        this.messagePreview.setLayout((Layout)mpLayout);
        this.preview = new Browser(this.messagePreview, 0);
        this.preview.setLayoutData((Object)new GridData(4, 4, true, true));
        int left = store.getInt("com.aptana.ide.intro.MESSAGE_CENTER_LEFT_WEIGHT");
        if (left < 100 && left > 0) {
            this.sides.setWeights(new int[]{left, 100 - left});
        }
        MessagingManager.addListener(this.listener);
        this.populateMessageTable();
        this.messages.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                block5: {
                    try {
                        TableItem[] items = MessagesEditor.this.messages.getTable().getSelection();
                        if (items == null || items.length != 1) break block5;
                        MessagesEditor.this.preview.setUrl(MessagesEditor.this.loadingPage);
                        Message msg = (Message)items[0].getData();
                        String html = "";
                        html = StringUtils.replace((String)MessagesEditor.this.messageTemplate, (String)MessagesEditor.TITLE_MARKER, (String)msg.getTitle());
                        html = StringUtils.replace((String)html, (String)MessagesEditor.MESSAGE_MARKER, (String)StringUtils.replace((String)msg.getContent(), (String)"\n", (String)"<br>"));
                        String charset = "UTF-8";
                        PrintWriter pw = null;
                        FileOutputStream out = new FileOutputStream(MessagesEditor.this.previewFile.getAbsolutePath());
                        pw = charset != null ? new PrintWriter((Writer)new OutputStreamWriter((OutputStream)out, charset), true) : new PrintWriter((Writer)new OutputStreamWriter(out), true);
                        pw.write(html);
                        pw.close();
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                        MessagesEditor.this.preview.setUrl(MessagesEditor.this.previewFile.getAbsolutePath());
                        if (!msg.isRead()) {
                            msg.setRead(true);
                            MessagesEditor.this.messages.update((Object)msg, null);
                            MessagingManager.notifyListeners(msg, 2);
                        }
                    }
                    catch (Exception e) {
                        IdeLog.logError((Plugin)IntroPlugin.getDefault(), (String)Messages.MessagesEditor_Error_ShowingMessage, (Throwable)e);
                    }
                }
            }
        });
        ByteArrayInputStream stream = new ByteArrayInputStream(this.messageTemplate.getBytes());
        FileUtils.writeStreamToFile((InputStream)stream, (String)this.previewFile.getAbsolutePath());
        try {
            stream.close();
        }
        catch (IOException iOException) {}
        this.preview.setUrl(this.previewFile.getAbsolutePath());
    }

    private void deleteSelectedMessages() {
        TableItem[] tItems = this.messages.getTable().getSelection();
        int index = this.messages.getTable().getSelectionIndex();
        int i = 0;
        while (i < tItems.length) {
            Message curr = (Message)tItems[i].getData();
            curr.setDeleted(true);
            curr.setRead(true);
            MessagingManager.notifyListeners(curr, 1);
            ++i;
        }
        this.messages.refresh();
        if (index != -1) {
            int count = this.messages.getTable().getItemCount();
            if (count < 1) {
                return;
            }
            if (index >= count) {
                this.messages.getTable().select(0);
            } else {
                this.messages.getTable().select(index);
            }
        }
    }

    private void populateMessageTable() {
        this.messages.setInput(this.getDisplayedList(MessagingManager.getMessages()));
    }

    private List<Message> getDisplayedList(List<Message> list) {
        ArrayList<Message> subList = new ArrayList<Message>();
        int i = 0;
        while (i < list.size()) {
            Message msg = list.get(i);
            if (this.showDeleted.getSelection() || !msg.isDeleted()) {
                subList.add(msg);
            }
            ++i;
        }
        return subList;
    }

    public void setFocus() {
        this.displayArea.setFocus();
    }

    public static String HTMLEntityEncode(String s) {
        StringBuilder buf = new StringBuilder();
        int len = s == null ? -1 : s.length();
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') {
                buf.append(c);
            } else {
                buf.append("&#" + c + ";");
            }
            ++i;
        }
        return buf.toString();
    }

    private class MessagesEditorLabelProvider
    implements ITableLabelProvider,
    ITableColorProvider,
    ITableFontProvider {
        private MessagesEditorLabelProvider() {
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void dispose() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof Message) {
                Message message = (Message)element;
                switch (columnIndex) {
                    case 0: {
                        if (message.getTitle() == null) break;
                        return message.getTitle();
                    }
                    case 1: {
                        if (message.getChannelTitle() == null) break;
                        return message.getChannelTitle();
                    }
                    case 2: {
                        if (message.getDate() == null) break;
                        DateFormat df = DateFormat.getDateTimeInstance(2, 3);
                        return df.format(message.getDate());
                    }
                }
            }
            return "";
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (element instanceof Message && columnIndex == 0) {
                Message message = (Message)element;
                if (message.isDeleted()) {
                    return IntroPlugin.getImage("icons/delete.gif");
                }
                if (message.isUrgent()) {
                    return IntroPlugin.getImage("icons/urgent.gif");
                }
            }
            return null;
        }

        public Color getBackground(Object element, int columnIndex) {
            return MessagesEditor.this.MAIN_BG;
        }

        public Color getForeground(Object element, int columnIndex) {
            Message message;
            if (element instanceof Message && columnIndex == 0 && ((message = (Message)element).isDeleted() ? message.isUrgent() : message.isUrgent())) {
                return UnifiedColorManager.getInstance().getColor(new RGB(200, 25, 42));
            }
            return null;
        }

        public Font getFont(Object element, int columnIndex) {
            if (element instanceof Message) {
                Message message = (Message)element;
                if (message.isRead()) {
                    return MessagesEditor.this.standard;
                }
                return MessagesEditor.this.bold;
            }
            return null;
        }
    }

    private class MessageTableSorter
    extends ViewerSorter {
        private TableViewer fTableViewer;

        public void bind(TableViewer tableViewer) {
            this.fTableViewer = tableViewer;
            final Table table = this.fTableViewer.getTable();
            int i = 0;
            while (i < table.getColumnCount()) {
                final TableColumn column = table.getColumn(i);
                column.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        TableColumn sortedColumn = table.getSortColumn();
                        int direction = table.getSortDirection();
                        if (sortedColumn == column) {
                            direction = direction == 128 ? 1024 : 128;
                        } else {
                            sortedColumn = column;
                        }
                        table.setSortColumn(column);
                        table.setSortDirection(direction);
                        MessageTableSorter.this.fTableViewer.refresh();
                    }
                });
                ++i;
            }
            this.fTableViewer.setSorter((ViewerSorter)this);
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof Message && e2 instanceof Message) {
                Message msg1 = (Message)e1;
                Message msg2 = (Message)e2;
                String sortedColumn = this.fTableViewer.getTable().getSortColumn().getText();
                int direction = MessagesEditor.this.messages.getTable().getSortDirection();
                if (sortedColumn.equals(Messages.MessagesEditor_Column_Date)) {
                    if (direction == 1024) {
                        return msg2.getDate().compareTo(msg1.getDate());
                    }
                    return msg1.getDate().compareTo(msg2.getDate());
                }
            }
            return super.compare(viewer, e1, e2);
        }
    }
}

