/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.intro.messaging;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.intro.IntroPlugin;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;

public class MessageIconRegistry {
    private static MessageIconRegistry instance = null;
    private Map filterImages = new HashMap();
    private Map labelImages = new HashMap();

    public static MessageIconRegistry getInstance() {
        if (instance == null) {
            instance = new MessageIconRegistry();
        }
        return instance;
    }

    private MessageIconRegistry() {
        this.loadExtensionPoint();
    }

    private void loadExtensionPoint() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint ep = reg.getExtensionPoint("com.aptana.ide.intro.messaging");
        IExtension[] extensions = ep.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] ce = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < ce.length) {
                String declaringPluginID = ce[j].getNamespaceIdentifier();
                Bundle bundle = Platform.getBundle((String)declaringPluginID);
                String site = ce[j].getAttribute("site");
                String filterIcon = ce[j].getAttribute("filter-icon");
                String labelIcon = ce[j].getAttribute("label-icon");
                if (site != null && filterIcon != null && labelIcon != null) {
                    if (!site.endsWith("/")) {
                        site = String.valueOf(site) + "/";
                    }
                    site = String.valueOf(site) + "messages.xml";
                    String filterPath = MessageIconRegistry.getResolvedFilename(bundle, filterIcon);
                    if (filterPath != null) {
                        String labelPath;
                        File file = new File(filterPath);
                        if (file.exists()) {
                            Image fImg = new Image((Device)Display.getDefault(), file.getAbsolutePath());
                            this.filterImages.put(site, fImg);
                        }
                        if ((labelPath = MessageIconRegistry.getResolvedFilename(bundle, labelIcon)) != null && (file = new File(labelPath)).exists()) {
                            Image lImg = new Image((Device)Display.getDefault(), file.getAbsolutePath());
                            this.labelImages.put(site, lImg);
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public Image getFilterIcon(String updateSite) {
        Image image = (Image)this.filterImages.get(updateSite);
        return image;
    }

    public Collection getFilterIcons() {
        return this.filterImages.values();
    }

    public Image getLabelIcon(String updateSite) {
        Image image = (Image)this.labelImages.get(updateSite);
        return image;
    }

    private static URL getResolvedURL(Bundle b, String fullPath) {
        URL url = FileLocator.find((Bundle)b, (IPath)new Path(fullPath), null);
        if (url != null) {
            try {
                URL localUrl = FileLocator.toFileURL((URL)url);
                if (localUrl != null) {
                    return localUrl;
                }
            }
            catch (IOException e) {
                IdeLog.logError((Plugin)IntroPlugin.getDefault(), (String)e.getMessage());
            }
        }
        return null;
    }

    private static String getResolvedFilename(Bundle b, String fullPath) {
        URL url = MessageIconRegistry.getResolvedURL(b, fullPath);
        if (url != null) {
            return url.getFile();
        }
        return null;
    }
}

