/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.intro.messaging;

import com.aptana.ide.core.licensing.ClientKey;
import com.aptana.ide.core.ui.CoreUIPlugin;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.core.ui.WebPerspectiveFactory;
import com.aptana.ide.core.ui.preferences.ApplicationPreferences;
import com.aptana.ide.editors.unified.UnifiedColorManager;
import com.aptana.ide.editors.unified.utils.HTMLTextPresenter;
import com.aptana.ide.intro.IntroPlugin;
import com.aptana.ide.intro.messaging.ExtensibleInformationControl;
import com.aptana.ide.intro.messaging.IMessageListener;
import com.aptana.ide.intro.messaging.Message;
import com.aptana.ide.intro.messaging.MessagesEditor;
import com.aptana.ide.intro.messaging.MessagingManager;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PerspectiveAdapter;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.menus.AbstractWorkbenchTrimWidget;
import org.eclipse.ui.progress.UIJob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AptanaMessenger
extends AbstractWorkbenchTrimWidget {
    private static final String UPGRADE = "Try Pro";
    private static final String BUY = "Buy Pro";
    private static final String RENEW = "Renew Pro";
    private static final String RENEW_LINK = "<a>Renew Pro</a>";
    private static final String BUY_LINK = "<a>Buy Pro</a>";
    private static final String UPGRADE_LINK = "<a>Try Pro</a>";
    private static final String UNREAD = "unread";
    private static final String NO_UNREAD_MESSAGES = "No Unread Messages";
    private static AptanaMessenger instance;
    private Color bg;
    private Color fg;
    private Composite displayArea;
    private Label messageIcon;
    private Label messages;
    private ExtensibleInformationControl dic;
    private Cursor hand;
    private String information = "No Unread Messages";
    private Link updateLabel;
    private Label separator;
    private ToolBar arrowBar;
    private ToolItem arrowItem;
    private MouseListener downListener = new MouseAdapter(){

        public void mouseDown(MouseEvent e) {
            Point mc = AptanaMessenger.this.messages.getSize();
            if (!AptanaMessenger.this.updateLabel.getVisible() || e.x < mc.x + 20) {
                MessagesEditor.openMessageCenter();
                if (AptanaMessenger.this.dic != null) {
                    AptanaMessenger.this.dic.dispose();
                }
            } else {
                AptanaMessenger.this.openLicensePrefPage();
            }
        }
    };
    private MouseTrackAdapter enterListener = new MouseTrackAdapter(){

        public void mouseHover(MouseEvent e) {
            if (AptanaMessenger.this.dic == null) {
                AptanaMessenger.this.dic = new ExtensibleInformationControl(AptanaMessenger.this.displayArea.getShell(), (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter());
                AptanaMessenger.this.dic.getWidget().setWordWrap(false);
                AptanaMessenger.this.dic.setSizeConstraints(500, 300);
                AptanaMessenger.this.dic.setInformation(AptanaMessenger.this.information);
                Point trimWidget = e.display.map((Control)AptanaMessenger.this.displayArea, null, AptanaMessenger.this.displayArea.getLocation());
                Point messagesSize = AptanaMessenger.this.dic.computeSizeHint();
                AptanaMessenger.this.dic.setBackgroundColor(AptanaMessenger.this.bg);
                AptanaMessenger.this.dic.setForegroundColor(AptanaMessenger.this.fg);
                AptanaMessenger.this.dic.setSize(messagesSize.x, messagesSize.y);
                Point tip = new Point(trimWidget.x, trimWidget.y - messagesSize.y);
                AptanaMessenger.this.dic.setLocation(tip);
                AptanaMessenger.this.dic.setVisible(true);
                AptanaMessenger.this.dic.getWidget().addMouseMoveListener(new MouseMoveListener(){

                    public void mouseMove(MouseEvent e) {
                        if (AptanaMessenger.this.dic != null) {
                            AptanaMessenger.this.dic.dispose();
                        }
                    }
                });
                AptanaMessenger.this.dic.addFocusListener(new FocusListener(){

                    public void focusLost(FocusEvent e) {
                        if (AptanaMessenger.this.dic != null) {
                            AptanaMessenger.this.dic.dispose();
                        }
                    }

                    public void focusGained(FocusEvent e) {
                        if (AptanaMessenger.this.dic != null) {
                            AptanaMessenger.this.dic.dispose();
                        }
                    }
                });
                AptanaMessenger.this.dic.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        AptanaMessenger.this.dic = null;
                    }
                });
            }
        }
    };
    private MouseTrackAdapter exitListener = new MouseTrackAdapter(){

        public void mouseExit(MouseEvent e) {
            Point daSize = AptanaMessenger.this.displayArea.getSize();
            if ((e.x < 0 || e.x >= daSize.x || e.y < 0 || e.y >= daSize.y) && AptanaMessenger.this.dic != null) {
                AptanaMessenger.this.dic.dispose();
                AptanaMessenger.this.dic = null;
            }
        }
    };
    private MouseTrackAdapter exitMessagesListener = new MouseTrackAdapter(){

        public void mouseExit(MouseEvent e) {
            Point mSize = AptanaMessenger.this.messages.getSize();
            if ((e.y >= mSize.y || e.x >= mSize.x) && AptanaMessenger.this.dic != null) {
                AptanaMessenger.this.dic.dispose();
                AptanaMessenger.this.dic = null;
            }
        }
    };
    private IMessageListener messageListener = new IMessageListener(){

        public void messageChanged(Message message, int eventType) {
            if (AptanaMessenger.this.displayArea == null || AptanaMessenger.this.displayArea.isDisposed()) {
                MessagingManager.removeListener(this);
            } else {
                UIJob job = new UIJob("Updating messenger"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        AptanaMessenger.this.loadNewMessages();
                        return Status.OK_STATUS;
                    }
                };
                job.setSystem(true);
                job.schedule();
            }
        }
    };
    private IPropertyChangeListener prefListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if ("com.aptana.ide.core.ui.ACTIVATION_KEY".equals(event.getProperty())) {
                if (AptanaMessenger.this.updateLabel != null && !AptanaMessenger.this.updateLabel.isDisposed() && AptanaMessenger.this.displayArea != null && !AptanaMessenger.this.displayArea.isDisposed()) {
                    AptanaMessenger.this.updateLinkLabel(true);
                } else {
                    ApplicationPreferences.getInstance().removePropertyChangeListener(AptanaMessenger.this.prefListener);
                }
            }
        }
    };

    public static AptanaMessenger getInstance() {
        return instance;
    }

    private void openLicensePrefPage() {
        if (UPGRADE_LINK.equals(this.updateLabel.getText())) {
            CoreUIUtils.openBrowserURLWithAllInfo((String)"http://www.aptana.com/studio/redirect/?action=try", (boolean)false, (String)"studio_trim");
        } else if (RENEW_LINK.equals(this.updateLabel.getText())) {
            CoreUIUtils.openBrowserURLWithAllInfo((String)"http://www.aptana.com/studio/redirect/?action=renew", (boolean)false, (String)"studio_trim");
        } else {
            CoreUIUtils.openBrowserURLWithAllInfo((String)"http://www.aptana.com/studio/redirect/?action=buy", (boolean)false, (String)"studio_trim");
        }
    }

    private void updateLinkLabel(boolean layout) {
        ClientKey newKey = CoreUIPlugin.getActivationKey();
        GridData data = new GridData();
        String previous = this.updateLabel.getText();
        if (newKey.isValid()) {
            if (newKey.isCloseToExpiring() && newKey.isPro()) {
                this.updateLabel.setText(RENEW_LINK);
                this.updateLabel.setToolTipText(RENEW);
            } else if (newKey.isExpired()) {
                if (newKey.isPro()) {
                    this.updateLabel.setText(RENEW_LINK);
                    this.updateLabel.setToolTipText(RENEW);
                } else {
                    this.updateLabel.setText(BUY_LINK);
                    this.updateLabel.setToolTipText(BUY);
                }
            } else if (newKey.isCloseToExpiring() && newKey.isTrial()) {
                Calendar currentCalendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
                long currMilis = currentCalendar.getTimeInMillis();
                long expMillis = newKey.getExpiration().getTimeInMillis();
                long daysLeft = expMillis - currMilis;
                double days = (double)daysLeft / 8.64E7;
                if ((daysLeft = (long)Math.floor(days)) == 1L) {
                    this.updateLabel.setText("<a>" + daysLeft + " day left</a>");
                } else if (daysLeft > 1L) {
                    this.updateLabel.setText("<a>" + daysLeft + " days left</a>");
                } else {
                    this.updateLabel.setText(BUY_LINK);
                }
                this.updateLabel.setToolTipText("");
            } else {
                data.exclude = true;
                this.updateLabel.setText("");
                this.updateLabel.setToolTipText("");
                this.updateLabel.setVisible(false);
                this.separator.setVisible(false);
            }
        } else {
            this.updateLabel.setText(UPGRADE_LINK);
            this.updateLabel.setToolTipText(UPGRADE);
        }
        this.updateLabel.setLayoutData((Object)data);
        if (layout) {
            if (previous.equals("")) {
                this.updateLabel.setVisible(false);
            } else {
                this.updateLabel.setVisible(true);
            }
            this.displayArea.layout(true, true);
            this.displayArea.getParent().layout(true, true);
        }
    }

    public AptanaMessenger() {
        instance = this;
        IntroPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().addPerspectiveListener((IPerspectiveListener)new PerspectiveAdapter(){

            public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
                if (AptanaMessenger.this.displayArea != null && !AptanaMessenger.this.displayArea.isDisposed()) {
                    AptanaMessenger.this.displayArea.setVisible(WebPerspectiveFactory.isValidAptanaPerspective((IPerspectiveDescriptor)perspective));
                }
            }
        });
    }

    public void dispose() {
        if (this.fg != null && !this.fg.isDisposed()) {
            this.fg.dispose();
        }
        if (this.displayArea != null && !this.displayArea.isDisposed()) {
            this.displayArea.dispose();
        }
        if (this.hand != null && !this.hand.isDisposed()) {
            this.hand.dispose();
        }
        MessagingManager.removeListener(this.messageListener);
        ApplicationPreferences.getInstance().removePropertyChangeListener(this.prefListener);
    }

    private void loadMenu(Menu menu) {
        MenuItem open = new MenuItem(menu, 8);
        open.setText("Open Message Center");
        open.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MessagesEditor.openMessageCenter();
            }
        });
        open.setImage(IntroPlugin.getImage("icons/aptana_envelope.png"));
        MenuItem refresh = new MenuItem(menu, 8);
        refresh.setText("Refresh Feeds");
        refresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MessagingManager.getNewMessages(new Date(0L));
            }
        });
        refresh.setImage(IntroPlugin.getImage("icons/refresh.gif"));
        MenuItem configure = new MenuItem(menu, 8);
        configure.setText("Configure Feeds");
        configure.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)Display.getDefault().getActiveShell(), (String)"com.aptana.ide.intro.preferences.IntroPreferencePage", (String[])new String[]{"com.aptana.ide.intro.preferences.IntroPreferencePage"}, null);
                dialog.open();
            }
        });
        configure.setImage(IntroPlugin.getImage("icons/configure.gif"));
    }

    public void fill(Composite parent, int oldSide, final int newSide) {
        if (this.bg == null || this.bg.isDisposed()) {
            this.bg = Display.getDefault().getSystemColor(22);
        }
        if (this.fg == null || this.fg.isDisposed()) {
            this.fg = new Color((Device)Display.getDefault(), 70, 70, 69);
        }
        if (this.hand == null || this.hand.isDisposed()) {
            this.hand = new Cursor((Device)Display.getDefault(), 21);
        }
        if (this.displayArea == null || this.displayArea.isDisposed()) {
            this.displayArea = new Composite(parent, 0);
            this.displayArea.setBackground(this.bg);
            this.displayArea.setToolTipText("Aptana Message Center");
            GridLayout layout = new GridLayout(5, false);
            layout.marginHeight = 2;
            layout.marginWidth = 0;
            layout.marginLeft = 5;
            layout.marginRight = 10;
            this.displayArea.setLayout((Layout)layout);
            this.messageIcon = new Label(this.displayArea, 16384);
            this.messageIcon.setImage(IntroPlugin.getImage("icons/aptana_envelope.png"));
            this.messageIcon.addMouseListener(this.downListener);
            this.messages = new Label(this.displayArea, 16384);
            this.displayArea.addMouseTrackListener((MouseTrackListener)this.enterListener);
            this.displayArea.addMouseTrackListener((MouseTrackListener)this.exitListener);
            this.displayArea.addMouseListener(this.downListener);
            this.displayArea.setCursor(this.hand);
            this.messages.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.messages.addMouseListener(this.downListener);
            this.messages.addMouseTrackListener((MouseTrackListener)this.enterListener);
            this.messages.addMouseTrackListener((MouseTrackListener)this.exitMessagesListener);
            this.messages.setBackground(this.bg);
            this.messages.setForeground(this.fg);
            this.loadNewMessages();
            MessagingManager.addListener(this.messageListener);
            this.arrowBar = new ToolBar(this.displayArea, 64);
            this.arrowItem = new ToolItem(this.arrowBar, 8);
            if (newSide == 1024) {
                this.arrowItem.setImage(IntroPlugin.getImage("icons/up_arrow.png"));
            } else {
                this.arrowItem.setImage(IntroPlugin.getImage("icons/down_arrow.png"));
            }
            this.arrowItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Rectangle rect = AptanaMessenger.this.arrowBar.getBounds();
                    Point pt = new Point(rect.x, rect.y + rect.height);
                    pt = AptanaMessenger.this.displayArea.toDisplay(pt);
                    Menu menu = new Menu((Control)AptanaMessenger.this.displayArea);
                    AptanaMessenger.this.loadMenu(menu);
                    if (newSide == 1024) {
                        menu.setLocation(pt.x, pt.y - ((AptanaMessenger)AptanaMessenger.this).displayArea.getBounds().height);
                    }
                    menu.setVisible(true);
                }
            });
            this.separator = new Label(this.displayArea, 514);
            GridData sData = new GridData(4, 4, false, false);
            sData.heightHint = 10;
            this.separator.setLayoutData((Object)sData);
            this.updateLabel = new Link(this.displayArea, 16384);
            this.updateLabel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AptanaMessenger.this.openLicensePrefPage();
                }
            });
            this.updateLinkLabel(false);
            ApplicationPreferences.getInstance().addPropertyChangeListener(this.prefListener);
        }
    }

    public synchronized void loadNewMessages() {
        ArrayList<Message> newMessages = new ArrayList<Message>();
        List<Message> allMessages = MessagingManager.getMessages();
        int i = 0;
        while (i < allMessages.size()) {
            Message curr = allMessages.get(i);
            if (!curr.isRead()) {
                newMessages.add(curr);
            }
            ++i;
        }
        this.setNewMessages(newMessages);
    }

    public void setNewMessages(List<Message> messageList) {
        this.information = NO_UNREAD_MESSAGES;
        if (messageList != null) {
            this.setNewMessageCount(messageList.size());
            if (messageList.size() > 0) {
                this.information = "<b>Messages:</b><ul>";
            }
            int i = 0;
            while (i < messageList.size()) {
                this.information = String.valueOf(this.information) + "<li>" + messageList.get(i).getTitle() + " </li>";
                ++i;
            }
            this.information = String.valueOf(this.information) + "</ul>";
        } else {
            this.setNewMessageCount(0);
        }
    }

    public void setNewMessageCount(int count) {
        if (this.messageIcon == null || this.messageIcon.isDisposed()) {
            return;
        }
        if (count > 0) {
            if (MessagingManager.getUnreadUrgentMessages() > 0) {
                this.messageIcon.setImage(IntroPlugin.getImage("icons/rss_urgent.png"));
            } else {
                this.messageIcon.setImage(IntroPlugin.getImage("icons/aptana_envelope.png"));
            }
            String text = "";
            if (count < 10) {
                text = String.valueOf(text) + " ";
            }
            text = String.valueOf(text) + count + " " + UNREAD;
            this.messages.setText(text);
            this.messages.setForeground(UnifiedColorManager.getInstance().getColor(new RGB(0, 0, 0)));
        } else {
            this.messages.setText(" 0 unread");
            this.messages.setForeground(UnifiedColorManager.getInstance().getColor(new RGB(140, 140, 140)));
            this.messageIcon.setImage(IntroPlugin.getImage("icons/rss_empty.png"));
        }
        this.displayArea.setSize(this.displayArea.computeSize(-1, -1));
        this.displayArea.layout(true, true);
        this.displayArea.redraw();
        this.displayArea.update();
    }
}

