/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.intro.licensing;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.MutexJobRule;
import com.aptana.ide.core.licensing.ClientKey;
import com.aptana.ide.core.licensing.ClientKeyService;
import com.aptana.ide.core.ui.DialogUtils;
import com.aptana.ide.core.ui.preferences.ApplicationPreferences;
import com.aptana.ide.intro.IntroPlugin;
import com.aptana.ide.intro.licensing.ProFeatureUtilities;
import com.aptana.ide.trialkey.TrialKey;
import com.eaio.uuid.MACAddress;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.update.standalone.DisableCommand;

public class TrialKeyStartup
implements IStartup {
    private boolean dialogShown = false;
    private boolean trialDialogShown = false;
    private static final Logger LOG = Logger.getLogger(TrialKeyStartup.class.getName());
    private static final String PREF_PRO_OBSOLETE_DISABLE = "com.aptana.ide.intro.licensing.PREF_PRO_OBSOLETE_DISABLE";
    private static final String FEATURE_ID_PRO = "com.aptana.ide.feature.professional";
    private static final String PREF_PRO_FEATURE_DISABLE = "com.aptana.ide.professional.PROFESSIONAL_FEATURE_DISABLED";
    private static final String MESSAGE_FAILED_DIALOG = "Unable to show license valid message.";

    public void earlyStartup() {
        ClientKey key = TrialKeyStartup.getActivationKey();
        assert (key != null);
        String emailAddress = ApplicationPreferences.getInstance().getString("com.aptana.ide.core.ui.ACTIVATION_EMAIL_ADDRESS");
        if (key.getEmail() == null && emailAddress != null) {
            return;
        }
        if (key.getEmail() == null) {
            if (ProFeatureUtilities.isProInstalled()) {
                TrialKeySet trialKeySet = this.getTrialKey();
                if (trialKeySet != null) {
                    this.setNewTrialKey(trialKeySet);
                    ProFeatureUtilities.enableProFeature(false);
                } else {
                    this.disableProfessional();
                }
                throw new IllegalStateException("Aptana Studio Professional is not licensed.  No key found.");
            }
        } else {
            if (key.getEmail() == "EMAILS_NON_MATCHING") {
                this.disableProfessionalWithDialog("Aptana Studio Professional Invalid License", "Aptana Studio Professional license is invalid. Please update your license or restart\nAptana Studio to remove disabled professional features\nand restore Community Edition functionality.");
                throw new IllegalStateException("Aptana Studio Professional is not licensed.  Invalid key.");
            }
            if (key.isTrial() && key.isExpired()) {
                this.disableProfessionalWithDialog("Aptana Studio Professional Expired", "Aptana Studio Professional license has expired. Please restart\nAptana Studio to remove disabled professional features\nand restore Community Edition functionality.");
                throw new IllegalStateException("Aptana Studio Professional is not licensed. Key is expired.");
            }
        }
    }

    public TrialKeySet getTrialKey() {
        TrialKeySet key = new TrialKeySet();
        key.uuid = TrialKeyStartup.getUUID();
        if (key.uuid != null) {
            TrialKey tkFetcher = new TrialKey();
            key.key = tkFetcher.fetchTrialLicense(key.uuid);
            if (key.key != null) {
                key.clientKey = ClientKeyService.createTrialClientKey((String)key.key, (String)key.uuid);
                if (key.clientKey != null && key.clientKey.isValid()) {
                    return key;
                }
            }
        }
        return null;
    }

    public static final String getUUID() {
        return MACAddress.getMACAddress();
    }

    private void disableProfessionalWithDialog(final String dialogTitle, final String dialogMessage) {
        this.disableProfessional();
        try {
            if (!this.dialogShown) {
                this.dialogShown = true;
                UIJob job = new UIJob("expire"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        DialogUtils.openIgnoreMessageDialogInformation((Shell)Display.getDefault().getActiveShell(), (String)dialogTitle, (String)dialogMessage, (IPreferenceStore)IntroPlugin.getDefault().getPreferenceStore(), (String)TrialKeyStartup.PREF_PRO_FEATURE_DISABLE);
                        return Status.OK_STATUS;
                    }
                };
                job.setRule((ISchedulingRule)MutexJobRule.getInstance());
                job.setSystem(true);
                job.schedule();
            }
        }
        catch (Exception exception) {
            throw new IllegalStateException(MESSAGE_FAILED_DIALOG);
        }
    }

    private void disableProfessional() {
        try {
            TrialKeyStartup.disableFeature(FEATURE_ID_PRO);
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)IntroPlugin.getDefault(), (String)"Unable to disable feature", (Throwable)e);
        }
    }

    public static boolean disableFeature(String id) throws CoreException {
        try {
            DisableCommand dc = new DisableCommand(id, null, null, null);
            dc.run(null);
            return true;
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)IntroPlugin.getDefault(), (String)"Unable to disable feature", (Throwable)e);
            return false;
        }
    }

    private void setNewTrialKey(TrialKeySet trialKeySet) {
        ProFeatureUtilities.setPrefAndRegistry(trialKeySet.key, trialKeySet.uuid);
    }

    public static final ClientKey getActivationKey() {
        return ClientKeyService.getClientKey();
    }

    public boolean isKeyValid() {
        boolean valid = false;
        ClientKey key = TrialKeyStartup.getActivationKey();
        if (key != null) {
            valid = key.isValid() && (key.isPro() || key.isTrial() && !key.isExpired());
        }
        return valid;
    }

    class TrialKeySet {
        public String uuid = null;
        public String key = null;
        public ClientKey clientKey = null;

        TrialKeySet() {
        }
    }
}

