/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.intro.actions;

import com.aptana.ide.core.model.IModelListener;
import com.aptana.ide.core.model.IModifiableObject;
import com.aptana.ide.core.model.user.AptanaUser;
import com.aptana.ide.core.model.user.User;
import com.aptana.ide.intro.actions.Messages;
import com.aptana.ide.server.jetty.portal.PortalEditor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.progress.UIJob;

public class SignInSignOutAction
implements IWorkbenchWindowActionDelegate {
    private IAction action;
    private User user;
    private IModelListener modelListener = new IModelListener(){

        public void modelChanged(IModifiableObject object) {
            UIJob job = new UIJob("Updating label"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    SignInSignOutAction.this.updateState();
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }
    };

    public void dispose() {
        if (this.user != null) {
            this.user.removeListener(this.modelListener);
        }
        this.user = null;
        this.action = null;
    }

    public void init(IWorkbenchWindow window) {
        this.user = AptanaUser.getSignedInUser();
        if (this.user != null) {
            this.user.addListener(this.modelListener);
        }
    }

    public void run(IAction action) {
        this.action = action;
        User user = AptanaUser.getSignedInUser();
        if (user != null) {
            if (user.hasCredentials()) {
                AptanaUser.signOut();
            } else {
                this.signIn();
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.action = action;
        this.updateState();
    }

    private void updateState() {
        User user;
        if (this.action != null && (user = AptanaUser.getSignedInUser()) != null) {
            if (user.hasCredentials()) {
                this.action.setText(Messages.StartPageTrimWidget_SignOut);
            } else {
                this.action.setText(Messages.StartPageTrimWidget_SignIn);
            }
        }
    }

    private void signIn() {
        PortalEditor.signIn();
    }
}

