/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.intro.actions;

import com.aptana.ide.core.model.user.AptanaUser;
import com.aptana.ide.core.model.user.User;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.core.ui.PerspectiveManager;
import com.aptana.ide.intro.IntroPlugin;
import com.aptana.ide.intro.actions.Messages;
import com.aptana.ide.intro.actions.StartPortalAction;
import com.aptana.ide.server.jetty.portal.PortalEditor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate2;
import org.eclipse.ui.PlatformUI;

public class ShowMyAptanaAction
implements IWorkbenchWindowPulldownDelegate2 {
    private static final String ICON = "icons/identity.png";
    private static final String HOME_ICON = "icons/aptana_home.png";
    static final String ID_URL = "http://www.aptana.com/aptana_id";
    private static final String MYCLOUD_ICON = "icons/my_cloud.png";
    private static final String MYACCOUNT_ICON = "icons/my_account.png";
    private static final String HOME_URL = "http://www.aptana.com";
    private static final String HOME_URL_DISPLAY = "www.aptana.com";
    private static final String HOME_URL_ICON = "icons/window1616.png";
    private User user = AptanaUser.getSignedInUser();
    private Menu toolbarMenu = null;

    public Menu getMenu(Control parent) {
        if (this.toolbarMenu != null) {
            this.toolbarMenu.dispose();
        }
        this.toolbarMenu = new Menu(parent);
        this.buildMenu(this.toolbarMenu);
        return this.toolbarMenu;
    }

    public Menu getMenu(Menu parent) {
        Menu menu = new Menu(parent);
        this.buildMenu(menu);
        return menu;
    }

    public void dispose() {
    }

    private void buildMenu(Menu menu) {
        MenuItem item = new MenuItem(menu, 8);
        item.setImage(IntroPlugin.getImage(ICON));
        if (this.user.hasCredentials()) {
            item.setText(Messages.StartPageTrimWidget_SignOut);
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AptanaUser.signOut();
                }
            });
        } else {
            item.setText(Messages.StartPageTrimWidget_SignIn);
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ShowMyAptanaAction.this.switchPerspective();
                    ShowMyAptanaAction.this.signIn();
                }
            });
            item = new MenuItem(menu, 8);
            item.setText(Messages.StartPageTrimWidget_ID_HELP);
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CoreUIUtils.openBrowserURL((String)ShowMyAptanaAction.ID_URL);
                }
            });
        }
        new MenuItem(menu, 2);
        item = new MenuItem(menu, 8);
        item.setText(Messages.StartPageTrimWidget_MyAptana);
        item.setImage(IntroPlugin.getImage(HOME_ICON));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ShowMyAptanaAction.this.switchPerspective();
                StartPortalAction.openPortalEditor();
            }
        });
        if (this.user.hasCredentials()) {
            item = new MenuItem(menu, 8);
            item.setText(Messages.StartPageTrimWidget_MyCloud);
            item.setImage(IntroPlugin.getImage(MYCLOUD_ICON));
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ShowMyAptanaAction.this.switchPerspective();
                    StartPortalAction.openPortalEditor("my_cloud");
                }
            });
            item = new MenuItem(menu, 8);
            item.setText(Messages.StartPageTrimWidget_MyAccount);
            item.setImage(IntroPlugin.getImage(MYACCOUNT_ICON));
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ShowMyAptanaAction.this.switchPerspective();
                    StartPortalAction.openPortalEditor("my_account");
                }
            });
        }
        item = new MenuItem(menu, 8);
        item.setText(HOME_URL_DISPLAY);
        item.setImage(IntroPlugin.getImage(HOME_URL_ICON));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CoreUIUtils.openBrowserURL((String)ShowMyAptanaAction.HOME_URL);
            }
        });
    }

    private void signIn() {
        PortalEditor.signIn();
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
        this.switchPerspective();
        StartPortalAction.openPortalEditor();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    private void switchPerspective() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (PerspectiveManager.shouldSwitchPerspective((IWorkbenchWindow)window, (String)"com.aptana.ide.js.ui.WebPerspective")) {
            PerspectiveManager.switchToPerspective((IWorkbenchWindow)window, (String)"com.aptana.ide.js.ui.WebPerspective");
        }
    }
}

