/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.intro;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.intro.IntroPlugin;
import com.aptana.ide.intro.preferences.FeatureDescriptor;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.update.search.BackLevelFilter;
import org.eclipse.update.search.EnvironmentFilter;
import org.eclipse.update.search.IUpdateSearchFilter;
import org.eclipse.update.search.UpdateSearchRequest;
import org.eclipse.update.search.UpdateSearchScope;
import org.eclipse.update.ui.UpdateJob;
import org.eclipse.update.ui.UpdateManagerUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureInstallJob
extends Job {
    List<FeatureDescriptor> features = new ArrayList<FeatureDescriptor>();

    public FeatureInstallJob(List<FeatureDescriptor> features) {
        super("Installing New Features");
        this.features = features;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            if (this.features == null || this.features.size() == 0) {
                return Status.OK_STATUS;
            }
            UpdateSearchScope scope = new UpdateSearchScope();
            for (FeatureDescriptor descriptor : this.features) {
                IdeLog.logInfo((Plugin)IntroPlugin.getDefault(), (String)("Adding search site:" + descriptor.getUrl()));
                scope.addSearchSite(descriptor.getLabel(), new URL(descriptor.getUrl()), new String[0]);
            }
            if (scope.getSearchSites().length == 0) {
                return Status.OK_STATUS;
            }
            UpdateSearchRequest request = new UpdateSearchRequest(UpdateSearchRequest.createDefaultSiteSearchCategory(), scope);
            request.addFilter((IUpdateSearchFilter)new BackLevelFilter());
            request.addFilter((IUpdateSearchFilter)new EnvironmentFilter());
            UpdateJob job = new UpdateJob("Searching for new features", request);
            job.setSystem(false);
            final UpdateJob finalJob = job;
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
                    Shell shell = null;
                    shell = windows != null && windows.length > 0 ? windows[0].getShell() : Display.getDefault().getActiveShell();
                    UpdateManagerUI.openInstaller((Shell)shell, (UpdateJob)finalJob);
                }
            });
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)IntroPlugin.getDefault(), (String)"Error searching for update site", (Throwable)e);
        }
        return Status.OK_STATUS;
    }
}

