/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.samples.model;

import com.aptana.ide.samples.handlers.IPreviewHandler;
import com.aptana.ide.samples.handlers.IProjectCreationHandler;
import com.aptana.ide.samples.model.SamplesEntry;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SamplesInfo {
    private String name;
    private String directory;
    private URL infoFile;
    private String iconFile;
    private IProjectCreationHandler creationHandler;
    private IPreviewHandler previewHandler;
    private List<String> natures = new ArrayList<String>();
    private List<SamplesEntry> rootSamples = new ArrayList<SamplesEntry>();
    private List<String> includes = new ArrayList<String>();

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
        this.loadRootSamples();
    }

    private void loadRootSamples() {
        this.rootSamples.clear();
        File file = new File(this.directory);
        File[] samps = file.listFiles();
        if (samps != null) {
            int i = 0;
            while (i < samps.length) {
                if (samps[i].isDirectory()) {
                    SamplesEntry entry = new SamplesEntry(this, samps[i], true);
                    this.rootSamples.add(entry);
                }
                ++i;
            }
        }
    }

    public void addNature(String natureId) {
        this.natures.add(natureId);
    }

    public String[] getNatures() {
        return this.natures.toArray(new String[0]);
    }

    public List<SamplesEntry> getRootSamples() {
        return this.rootSamples;
    }

    public String getIconFile() {
        return this.iconFile;
    }

    public void setIconFile(String iconFile) {
        this.iconFile = iconFile;
    }

    public URL getInfoFile() {
        return this.infoFile;
    }

    public void setInfoFile(URL infoFile) {
        this.infoFile = infoFile;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCreationHandler(IProjectCreationHandler handler) {
        this.creationHandler = handler;
    }

    public IProjectCreationHandler getCreationHandler() {
        return this.creationHandler;
    }

    public void setPreviewHandler(IPreviewHandler handler) {
        this.previewHandler = handler;
    }

    public IPreviewHandler getPreviewHandler() {
        return this.previewHandler;
    }

    public void addIncludePath(String file) {
        this.includes.add(file);
    }

    public List<String> getIncludePaths() {
        return this.includes;
    }
}

