/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.samples;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.ui.EclipseUIUtils;
import com.aptana.ide.core.ui.ImageUtils;
import com.aptana.ide.editors.unified.UnifiedColorManager;
import com.aptana.ide.samples.SamplesPlugin;
import com.aptana.ide.samples.SamplesViewContentProvider;
import com.aptana.ide.samples.model.SamplesEntry;
import com.aptana.ide.samples.model.SamplesInfo;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorRegistry;

public class SamplesViewLabelProvider
extends LabelProvider {
    private IEditorRegistry registry = EclipseUIUtils.getWorkbenchEditorRegistry();
    private HashMap<Object, Image> images = new HashMap();
    private Image folder = null;

    public void dispose() {
        super.dispose();
        Iterator<Image> iter = this.images.values().iterator();
        while (iter.hasNext()) {
            iter.next().dispose();
        }
    }

    public Image getImage(Object element) {
        SamplesEntry entry;
        File file;
        if (element == SamplesViewContentProvider.LOADING) {
            return SamplesPlugin.getImage("icons/hourglass.png");
        }
        Image result = null;
        if (element instanceof SamplesInfo) {
            String iconFile = ((SamplesInfo)element).getIconFile();
            if (iconFile != null) {
                File file2 = new File(iconFile);
                if (file2.exists()) {
                    result = new Image((Device)Display.getDefault(), file2.getAbsolutePath());
                    this.images.put(file2.getAbsoluteFile(), result);
                } else {
                    result = SamplesPlugin.getImage("icons/folder.gif");
                    IdeLog.logInfo((Plugin)SamplesPlugin.getDefault(), (String)StringUtils.format((String)"Unable to find image {0}", (String)file2.getAbsolutePath()));
                }
            }
        } else if (element instanceof SamplesEntry && (file = (entry = (SamplesEntry)element).getFile()) != null) {
            IEditorDescriptor desc = this.registry.getDefaultEditor(file.getName());
            if (desc == null || desc.getImageDescriptor() == null) {
                if (file.isDirectory()) {
                    if (this.folder == null) {
                        this.folder = SamplesPlugin.getImage("icons/folder.gif");
                    }
                    result = this.folder;
                } else {
                    result = ImageUtils.getIcon((File)file, (Color)UnifiedColorManager.getInstance().getColor(new RGB(255, 255, 255)));
                }
            } else if (this.images.containsKey(desc)) {
                result = this.images.get(desc);
            } else {
                result = desc.getImageDescriptor().createImage();
                this.images.put(desc, result);
            }
        }
        return result;
    }

    public String getText(Object element) {
        if (element == SamplesViewContentProvider.LOADING) {
            return "Loading...";
        }
        String result = "";
        if (element instanceof SamplesEntry) {
            File file = ((SamplesEntry)element).getFile();
            if (file != null) {
                result = file.getName();
            }
        } else if (element instanceof SamplesInfo) {
            SamplesInfo snippet = (SamplesInfo)element;
            result = snippet.getName();
        } else {
            result = element.toString();
        }
        return result;
    }
}

