/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.samples;

import com.aptana.ide.core.FileUtils;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.core.ui.PreferenceUtils;
import com.aptana.ide.intro.IntroPlugin;
import com.aptana.ide.intro.browser.CoreBrowserEditorInput;
import com.aptana.ide.samples.Messages;
import com.aptana.ide.samples.SamplesManager;
import com.aptana.ide.samples.SamplesPlugin;
import com.aptana.ide.samples.SamplesProjectCreator;
import com.aptana.ide.samples.SamplesViewContentProvider;
import com.aptana.ide.samples.SamplesViewLabelProvider;
import com.aptana.ide.samples.handlers.IPreviewHandler;
import com.aptana.ide.samples.model.SamplesEntry;
import com.aptana.ide.samples.model.SamplesInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.ErrorEditorPart;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class SamplesView
extends ViewPart {
    private Composite displayArea;
    private TreeViewer _viewer;
    private Action doubleClickAction;
    private Action importAction;
    private Action viewHelpAction;
    private Action collapseAllAction;
    private Action viewPreviewAction;
    private String firstReveal;
    private static String LINE_DELIM = System.getProperty("line.separator", "\r\n");
    public static final String ID = "com.aptana.ide.samples.SamplesView";

    private void createActions() {
        this.createImportAction();
        this.createViewInfoAction();
        this.createDoubleClickAction();
        this.createCollapseAllAction();
        this.createViewPreviewAction();
    }

    private void createImportAction() {
        this.importAction = new Action(Messages.SamplesView_ImportSample){

            public void run() {
                ISelection selection = SamplesView.this._viewer.getSelection();
                Object firstElement = ((IStructuredSelection)selection).getFirstElement();
                SamplesEntry entry = null;
                if (firstElement instanceof SamplesEntry) {
                    entry = ((SamplesEntry)firstElement).getRoot();
                }
                if (entry != null) {
                    SamplesProjectCreator.createSamplesProject(entry);
                }
            }
        };
        this.importAction.setEnabled(false);
        this.importAction.setImageDescriptor(SamplesPlugin.getImageDescriptor("icons/import_wiz.gif"));
    }

    private void createCollapseAllAction() {
        this.collapseAllAction = new Action(Messages.SamplesView_CollapseAll){

            public void run() {
                if (SamplesView.this._viewer != null) {
                    SamplesView.this._viewer.collapseAll();
                }
            }
        };
        this.collapseAllAction.setToolTipText(Messages.SamplesView_CollapseAll);
        this.collapseAllAction.setImageDescriptor(SamplesPlugin.getImageDescriptor("icons/collapseall.gif"));
    }

    private void createViewPreviewAction() {
        this.viewPreviewAction = new Action(Messages.SamplesView_PreviewSample){

            public void run() {
                IPreviewHandler handler;
                ISelection selection = SamplesView.this._viewer.getSelection();
                Object firstElement = ((IStructuredSelection)selection).getFirstElement();
                SamplesEntry entry = null;
                if (firstElement instanceof SamplesEntry) {
                    entry = ((SamplesEntry)firstElement).getRoot();
                }
                if (entry != null && (handler = entry.getParent().getPreviewHandler()) != null) {
                    handler.previewRequested(entry);
                }
            }
        };
        this.viewPreviewAction.setToolTipText(Messages.SamplesView_ViewPreview);
        this.viewPreviewAction.setEnabled(false);
        this.viewPreviewAction.setImageDescriptor(SamplesPlugin.getImageDescriptor("icons/preview.gif"));
    }

    private void createViewInfoAction() {
        this.viewHelpAction = new Action(Messages.SamplesView_ViewHelp){

            public void run() {
                ISelection selection = SamplesView.this._viewer.getSelection();
                Object firstElement = ((IStructuredSelection)selection).getFirstElement();
                SamplesInfo info = null;
                if (firstElement instanceof SamplesInfo) {
                    info = (SamplesInfo)firstElement;
                } else if (firstElement instanceof SamplesEntry) {
                    info = ((SamplesEntry)firstElement).getParent();
                }
                if (info != null) {
                    try {
                        URL url = info.getInfoFile();
                        if (url != null) {
                            CoreBrowserEditorInput input = new CoreBrowserEditorInput(url);
                            input.setImage(SamplesPlugin.getImageDescriptor("icons/window1616.png"));
                            IWorkbenchWindow window = IntroPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
                            if (window != null) {
                                IWorkbenchPage page = window.getActivePage();
                                IDE.openEditor((IWorkbenchPage)page, (IEditorInput)input, (String)"com.aptana.ide.intro.browserEditor");
                            }
                        }
                    }
                    catch (PartInitException partInitException) {}
                }
            }
        };
        this.viewHelpAction.setImageDescriptor(SamplesPlugin.getImageDescriptor("icons/book_open.png"));
        this.viewHelpAction.setEnabled(false);
    }

    private void toggleActionState() {
        ISelection selection = this._viewer.getSelection();
        Object firstElement = ((IStructuredSelection)selection).getFirstElement();
        SamplesInfo info = null;
        SamplesEntry entry = null;
        if (firstElement instanceof SamplesEntry) {
            entry = (SamplesEntry)firstElement;
            info = entry.getParent();
        } else if (firstElement instanceof SamplesInfo) {
            info = (SamplesInfo)firstElement;
        }
        this.viewHelpAction.setEnabled(info != null && info.getInfoFile() != null);
        this.viewPreviewAction.setEnabled(entry != null && info != null && info.getPreviewHandler() != null);
        this.importAction.setEnabled(entry != null);
    }

    protected IEditorDescriptor getEditorId(File file) {
        IWorkbench workbench = SamplesPlugin.getDefault().getWorkbench();
        IEditorRegistry editorRegistry = workbench.getEditorRegistry();
        IEditorDescriptor descriptor = editorRegistry.getDefaultEditor(file.getName());
        if (descriptor != null) {
            return descriptor;
        }
        return editorRegistry.findEditor("org.eclipse.ui.systemExternalEditor");
    }

    private void createDoubleClickAction() {
        this.doubleClickAction = new Action(){

            public void run() {
                block12: {
                    ISelection selection = SamplesView.this._viewer.getSelection();
                    Object firstElement = ((IStructuredSelection)selection).getFirstElement();
                    if (firstElement instanceof SamplesEntry) {
                        SamplesEntry entry = (SamplesEntry)firstElement;
                        File file = entry.getFile();
                        String name = String.valueOf(entry.getRoot().getFile().getName()) + "-";
                        if (file != null && file.isFile()) {
                            IEditorDescriptor editorDesc = SamplesView.this.getEditorId(file);
                            if (editorDesc.getId().equals("org.eclipse.ui.systemExternalEditor")) {
                                SamplesView.this.openExternalFile(file);
                            } else {
                                String filePrefix = FileUtils.stripExtension((String)file.getName());
                                String fileExt = "." + FileUtils.getExtension((String)file.getName());
                                String newFileName = FileUtils.getRandomFileName((String)filePrefix, (String)fileExt);
                                File newFile = new File(String.valueOf(FileUtils.systemTempDir) + File.separator + newFileName);
                                IEditorInput input = CoreUIUtils.createNonExistingFileEditorInput((File)newFile, (String)(String.valueOf(name) + filePrefix));
                                IWorkbench workbench = SamplesPlugin.getDefault().getWorkbench();
                                IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
                                try {
                                    IEditorPart part = page.openEditor(input, editorDesc.getId());
                                    if (!(part instanceof ITextEditor)) break block12;
                                    ITextEditor editor = (ITextEditor)part;
                                    IDocumentProvider dp = editor.getDocumentProvider();
                                    IDocument doc = dp.getDocument((Object)editor.getEditorInput());
                                    try {
                                        BufferedReader stream = new BufferedReader(new FileReader(file));
                                        StringBuffer sb = new StringBuffer();
                                        while (stream.ready()) {
                                            sb.append(String.valueOf(stream.readLine()) + LINE_DELIM);
                                        }
                                        if (sb.length() > 0) {
                                            doc.replace(0, 0, sb.toString());
                                        }
                                    }
                                    catch (BadLocationException badLocationException) {
                                    }
                                    catch (FileNotFoundException fileNotFoundException) {
                                    }
                                    catch (IOException iOException) {}
                                }
                                catch (PartInitException partInitException) {
                                    IdeLog.logError((Plugin)SamplesPlugin.getDefault(), (String)StringUtils.format((String)Messages.SamplesView_UnableToOpenFile, (String)newFile.getAbsolutePath()), null);
                                }
                            }
                        }
                    }
                }
            }
        };
        this.doubleClickAction.setText("Open a copy");
    }

    private void openExternalFile(File file) {
        File newFile = this.createTemporaryFile(file);
        if (file == null) {
            return;
        }
        FileUtils.copy((File)file, (File)newFile);
        IWorkbench workbench = SamplesPlugin.getDefault().getWorkbench();
        IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
        IEditorDescriptor editorDesc = this.getEditorId(newFile);
        try {
            IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)page, (IEditorInput)CoreUIUtils.createJavaFileEditorInput((File)newFile), (String)editorDesc.getId());
            if (editorPart != null && editorPart instanceof ErrorEditorPart) {
                page.closeEditor(editorPart, false);
                IdeLog.logError((Plugin)SamplesPlugin.getDefault(), (String)StringUtils.format((String)Messages.SamplesView_UnableToOpenFile, (String)newFile.getAbsolutePath()), null);
            }
        }
        catch (PartInitException partInitException) {
            IdeLog.logError((Plugin)SamplesPlugin.getDefault(), (String)StringUtils.format((String)Messages.SamplesView_UnableToOpenFile, (String)newFile.getAbsolutePath()), null);
        }
    }

    private File createTemporaryFile(final File file) {
        String fileName = FileUtils.stripExtension((String)file.getName());
        String fileExt = "." + FileUtils.getExtension((String)file.getName());
        File newFile = null;
        try {
            newFile = File.createTempFile(fileName, fileExt);
        }
        catch (IOException e1) {
            this._viewer.getControl().getDisplay().syncExec(new Runnable(){

                public void run() {
                    MessageDialog.openError((Shell)SamplesView.this._viewer.getControl().getShell(), (String)Messages.SamplesView_UnableToPreview, (String)Messages.SamplesView_ErrorOpening);
                    IdeLog.logError((Plugin)SamplesPlugin.getDefault(), (String)StringUtils.format((String)Messages.SamplesView_UnableToCreateTemp, (String)file.getAbsolutePath()), (Throwable)e1);
                }
            });
            return null;
        }
        return newFile;
    }

    public void createPartControl(Composite parent) {
        this.displayArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.displayArea.setLayout((Layout)layout);
        this.displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this._viewer = this.createTreeViewer(this.displayArea);
        this._viewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.createActions();
        this.hookContextMenu();
        this._viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SamplesView.this.doubleClickAction.run();
            }
        });
        this._viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SamplesView.this.toggleActionState();
            }
        });
        this.hookToolbarActions();
        this._viewer.setInput(SamplesViewContentProvider.LOADING);
        Job loadingJob = new Job("Loading samples"){

            protected IStatus run(IProgressMonitor monitor) {
                final SamplesManager snippets = SamplesManager.getInstance();
                UIJob job = new UIJob("Updating samples view"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        if (SamplesView.this._viewer != null && !SamplesView.this._viewer.getTree().isDisposed()) {
                            SamplesView.this._viewer.setInput((Object)snippets);
                            if (SamplesView.this.firstReveal != null) {
                                SamplesView.this.selectAndReveal(SamplesView.this.firstReveal);
                            }
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.setSystem(true);
                job.schedule();
                return Status.OK_STATUS;
            }
        };
        loadingJob.schedule();
        PreferenceUtils.registerBackgroundColorPreference((Control)this._viewer.getControl(), (String)"com.aptana.ide.core.ui.background.color.samplesView");
        PreferenceUtils.registerForegroundColorPreference((Control)this._viewer.getControl(), (String)"com.aptana.ide.core.ui.foreground.color.samplesView");
        this.getSite().getWorkbenchWindow().getWorkbench().getHelpSystem().setHelp((Control)parent, ID);
    }

    private void hookToolbarActions() {
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager manager = bars.getToolBarManager();
        manager.add((IAction)this.importAction);
        manager.add((IAction)this.viewPreviewAction);
        manager.add((IAction)this.viewHelpAction);
        manager.add((IAction)this.collapseAllAction);
    }

    private TreeViewer createTreeViewer(Composite parent) {
        Tree tree = new Tree(parent, 772);
        TreeViewer viewer = new TreeViewer(tree);
        viewer.setContentProvider((IContentProvider)new SamplesViewContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new SamplesViewLabelProvider());
        return viewer;
    }

    private void fillContextMenu(IMenuManager manager, Object element) {
        if (element instanceof SamplesInfo) {
            manager.add((IAction)this.viewHelpAction);
        } else if (element instanceof SamplesEntry) {
            File file;
            manager.add((IAction)this.importAction);
            SamplesEntry entry = (SamplesEntry)element;
            SamplesInfo info = entry.getParent();
            if (entry.getRoot() != null && info != null && info.getPreviewHandler() != null) {
                manager.add((IAction)this.viewPreviewAction);
            }
            if (entry instanceof SamplesEntry && (file = entry.getFile()) != null && file.isFile()) {
                manager.add((IAction)this.doubleClickAction);
            }
        }
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ISelection selection = SamplesView.this._viewer.getSelection();
                Object firstElement = ((IStructuredSelection)selection).getFirstElement();
                SamplesView.this.fillContextMenu(manager, firstElement);
            }
        });
        Menu menu = menuMgr.createContextMenu(this._viewer.getControl());
        this._viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this._viewer);
    }

    public void listChanged(final SamplesManager list) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        Display display = workbench.getDisplay();
        display.syncExec(new Runnable(){

            public void run() {
                if (!SamplesView.this._viewer.getTree().isDisposed() && SamplesView.this._viewer.getContentProvider() != null) {
                    SamplesView.this._viewer.setInput((Object)list);
                }
            }
        });
    }

    public void selectAndReveal(String entryName) {
        if (entryName == null) {
            return;
        }
        if (this._viewer.getInput() == SamplesViewContentProvider.LOADING) {
            this.firstReveal = entryName;
        }
        SamplesInfo[] infos = SamplesManager.getInstance().getSamplesInfos();
        int i = 0;
        while (i < infos.length) {
            if (infos[i].getName().equals(entryName)) {
                this._viewer.expandToLevel((Object)infos[i], 1);
                this._viewer.setSelection((ISelection)new StructuredSelection((Object)infos[i]), true);
                break;
            }
            ++i;
        }
    }

    public void setFocus() {
    }
}

