/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.scripting;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.Trace;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.core.ui.WebPerspectiveFactory;
import com.aptana.ide.core.ui.editors.ISaveAsEvent;
import com.aptana.ide.core.ui.views.scriptable.GenericScriptableView;
import com.aptana.ide.editors.unified.EditorFileContext;
import com.aptana.ide.editors.unified.FileContextContentEvent;
import com.aptana.ide.editors.unified.IFileContextListener;
import com.aptana.ide.editors.unified.IFileService;
import com.aptana.ide.editors.unified.IUnifiedBracketMatcherListener;
import com.aptana.ide.editors.unified.IUnifiedEditor;
import com.aptana.ide.editors.unified.errors.IFileError;
import com.aptana.ide.editors.unified.errors.IFileErrorListener;
import com.aptana.ide.editors.views.actions.ActionsView;
import com.aptana.ide.scripting.FileUtilities;
import com.aptana.ide.scripting.Global;
import com.aptana.ide.scripting.Messages;
import com.aptana.ide.scripting.ScriptInfo;
import com.aptana.ide.scripting.ScriptThread;
import com.aptana.ide.scripting.ScriptingConsole;
import com.aptana.ide.scripting.ScriptingHttpServer;
import com.aptana.ide.scripting.ScriptingPlugin;
import com.aptana.ide.scripting.editors.Editor;
import com.aptana.ide.scripting.editors.EditorType;
import com.aptana.ide.scripting.events.ContentChangedEvent;
import com.aptana.ide.scripting.events.ErrorsChangedEvent;
import com.aptana.ide.scripting.events.PartActivatedEvent;
import com.aptana.ide.scripting.events.PartClosedEvent;
import com.aptana.ide.scripting.events.PartDeactivatedEvent;
import com.aptana.ide.scripting.events.PartOpenedEvent;
import com.aptana.ide.scripting.views.ScriptableView;
import com.aptana.ide.scripting.views.View;
import com.aptana.ide.scripting.views.Views;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IRegion;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;

public class ScriptingEngine
implements IStartup,
IFileErrorListener,
IFileContextListener,
IUnifiedBracketMatcherListener,
ISaveAsEvent {
    public static final int SCRIPTING_SERVER_START_PORT = 9000;
    private static Hashtable supportedPerspectives;
    private static ScriptingEngine instance;
    private Global _global = null;
    private ScriptingHttpServer _server = null;
    private IPerspectiveListener _perspectiveListener;
    private IPartListener _partListener;
    private boolean _loaded;
    private ScriptingConsole _console;
    private MessageConsoleStream _consoleStream;

    static {
        instance = null;
        supportedPerspectives = new Hashtable();
        supportedPerspectives.put("com.aptana.ide.js.ui.WebPerspective", new Object());
    }

    public static ScriptingEngine getInstance() {
        if (instance == null) {
            instance = new ScriptingEngine();
        }
        return instance;
    }

    public Global getGlobal() {
        return this._global;
    }

    public ScriptingEngine() {
        if (instance != null) {
            throw new IllegalStateException(Messages.ScriptingEngine_ScriptingEngine_Is_Singleton);
        }
        instance = this;
    }

    private void addListenerToWindow(IWorkbenchWindow window) {
        IPerspectiveDescriptor perspective;
        IWorkbenchPage page = window.getActivePage();
        if (page != null && (perspective = page.getPerspective()) != null && !this.perspectiveActivated(page, perspective)) {
            window.addPerspectiveListener(this._perspectiveListener);
        }
    }

    private void bindToWorkbench() {
        final ScriptingEngine me = this;
        me._partListener = new IPartListener(){

            public void partActivated(IWorkbenchPart part) {
                View view;
                String secondaryId = null;
                if (part instanceof IUnifiedEditor) {
                    IUnifiedEditor editor = (IUnifiedEditor)part;
                    editor.getFileContext().addLongDelayedFileListener((IFileContextListener)me);
                    editor.getFileContext().addErrorListener((IFileErrorListener)me);
                    editor.addSaveAsListener((ISaveAsEvent)me);
                }
                if (part instanceof ActionsView) {
                    view = (View)me._global.getViews().getActionsView();
                    if (view != null) {
                        view.setView(part);
                    }
                } else if (part instanceof GenericScriptableView) {
                    secondaryId = ((GenericScriptableView)part).getViewSite().getSecondaryId();
                    view = me._global.getViews().getView(secondaryId);
                    if (view != null) {
                        ((ScriptableView)view).setView(part);
                    }
                }
                ScriptingEngine.this.firePartActivated(part, secondaryId);
            }

            public void partDeactivated(IWorkbenchPart part) {
                View view;
                IUnifiedEditor editor;
                EditorFileContext context;
                String secondaryId = null;
                if (part instanceof IUnifiedEditor && (context = (editor = (IUnifiedEditor)part).getFileContext()) != null) {
                    context.removeLongDelayedFileListener((IFileContextListener)me);
                    context.removeErrorListener((IFileErrorListener)me);
                }
                if (part instanceof ActionsView) {
                    view = (View)me._global.getViews().getActionsView();
                    if (view != null) {
                        view.setView(null);
                    }
                } else if (part instanceof GenericScriptableView) {
                    secondaryId = ((GenericScriptableView)part).getViewSite().getSecondaryId();
                    view = me._global.getViews().getView(secondaryId);
                    if (view != null) {
                        ((ScriptableView)view).setView(null);
                    }
                }
                ScriptingEngine.this.firePartDeactivated(part, secondaryId);
            }

            public void partBroughtToTop(IWorkbenchPart part) {
            }

            public void partOpened(IWorkbenchPart part) {
                String secondaryId = null;
                if (part instanceof ActionsView) {
                    View view = (View)me._global.getViews().getActionsView();
                    if (view != null) {
                        view.setView(part);
                    }
                } else if (part instanceof GenericScriptableView) {
                    secondaryId = ((GenericScriptableView)part).getViewSite().getSecondaryId();
                    ScriptableView view = me._global.getViews().getView(secondaryId);
                    if (view != null) {
                        view.setView(part);
                    }
                }
                ScriptingEngine.this.firePartOpened(part, secondaryId);
            }

            public void partClosed(IWorkbenchPart part) {
                View view;
                String secondaryId = null;
                if (part instanceof IUnifiedEditor) {
                    IUnifiedEditor editor = (IUnifiedEditor)part;
                    editor.getFileContext().removeLongDelayedFileListener((IFileContextListener)me);
                    editor.getFileContext().removeErrorListener((IFileErrorListener)me);
                    editor.removeSaveAsListener((ISaveAsEvent)me);
                }
                if (part instanceof ActionsView) {
                    view = (View)me._global.getViews().getActionsView();
                    if (view != null) {
                        view.setView(null);
                    }
                } else if (part instanceof GenericScriptableView) {
                    secondaryId = ((GenericScriptableView)part).getViewSite().getSecondaryId();
                    view = me._global.getViews().getView(secondaryId);
                    if (view != null) {
                        ((ScriptableView)view).setView(null);
                    }
                }
                ScriptingEngine.this.firePartClosed(part, secondaryId);
            }
        };
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            public void run() {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window != null) {
                    window.getPartService().addPartListener(me._partListener);
                }
            }
        });
    }

    public void onSaveAs(IEditorPart part, File oldFile, File newFIle) {
        this.firePartSaveAs((IWorkbenchPart)part, oldFile, newFIle);
    }

    public void fireCallback(String scriptID, Object callback, Object[] args) {
        try {
            ScriptInfo info = this._global.getScriptInfo(scriptID);
            if (info != null) {
                Scriptable scope = info.getScope();
                IWorkbench workbench = PlatformUI.getWorkbench();
                Display display = workbench.getDisplay();
                display.syncExec((Runnable)new ScriptThread(scope, callback, args, info.getClassLoader()));
            } else {
                String message = StringUtils.format((String)Messages.ScriptingEngine_Script_Id_Not_Found, (String)scriptID);
                IdeLog.logError((Plugin)ScriptingPlugin.getDefault(), (String)message);
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)ScriptingPlugin.getDefault(), (String)Messages.ScriptingEngine_Error, (Throwable)e);
        }
    }

    private void firePartActivated(IWorkbenchPart part, String secondaryId) {
        Views views = this._global.getViews();
        String id = part.getSite().getId();
        String title = part.getTitle();
        String path = "";
        if (part instanceof IEditorPart) {
            path = this.getPathFromPart((IEditorPart)part);
        }
        PartActivatedEvent event = new PartActivatedEvent(views, title, id, secondaryId, path);
        views.fireEventListeners(event);
    }

    private void firePartDeactivated(IWorkbenchPart part, String secondaryId) {
        Views views = this._global.getViews();
        String id = part.getSite().getId();
        String title = part.getTitle();
        String path = null;
        if (part instanceof IEditorPart) {
            path = this.getPathFromPart((IEditorPart)part);
        }
        PartDeactivatedEvent event = new PartDeactivatedEvent(views, title, id, secondaryId, path);
        views.fireEventListeners(event);
    }

    private void firePartOpened(IWorkbenchPart part, String secondaryId) {
        Views views = this._global.getViews();
        String id = part.getSite().getId();
        String title = part.getTitle();
        String path = "";
        if (part instanceof IEditorPart) {
            path = this.getPathFromPart((IEditorPart)part);
        }
        PartOpenedEvent event = new PartOpenedEvent(views, title, id, secondaryId, path);
        views.fireEventListeners(event);
    }

    private void firePartSaveAs(IWorkbenchPart part, File oldFile, File newFile) {
        if (oldFile == null || newFile == null) {
            return;
        }
        Views views = this._global.getViews();
        String id = part.getSite().getId();
        String title = part.getTitle();
        PartClosedEvent event1 = new PartClosedEvent(views, title, id, null, oldFile.getAbsolutePath());
        views.fireEventListeners(event1);
        PartActivatedEvent event2 = new PartActivatedEvent(views, title, id, null, newFile.getAbsolutePath());
        views.fireEventListeners(event2);
    }

    private void firePartClosed(IWorkbenchPart part, String secondaryId) {
        Views views = this._global.getViews();
        String id = part.getSite().getId();
        String title = part.getTitle();
        String path = null;
        if (part instanceof IEditorPart) {
            path = this.getPathFromPart((IEditorPart)part);
        }
        PartClosedEvent event = new PartClosedEvent(views, title, id, secondaryId, path);
        views.fireEventListeners(event);
    }

    private String getPathFromPart(IEditorPart part) {
        IEditorInput input = part.getEditorInput();
        return CoreUIUtils.getPathFromEditorInput((IEditorInput)input);
    }

    public void earlyStartup() {
        Trace.info((String)"ScriptingEngine: earlyStartup");
        final ScriptingEngine me = this;
        this._perspectiveListener = new IPerspectiveListener(){

            public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
                String message = StringUtils.format((String)Messages.ScriptingEngine_Activated, (String)perspective.getId());
                Trace.info((String)message);
                me.perspectiveActivated(page, perspective);
            }

            public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
                String message = StringUtils.format((String)Messages.ScriptingEngine_Changed, (String)perspective.getId());
                Trace.info((String)message);
            }
        };
        Runnable resetEngine = new Runnable(){

            public void run() {
                Trace.info((String)Messages.ScriptingEngine_Reset);
                me.shutdown();
            }
        };
        WebPerspectiveFactory.addResettingHandler((Runnable)resetEngine);
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window != null) {
                    Trace.info((String)Messages.ScriptingEngine_Registering_Listener);
                    ScriptingEngine.this.addListenerToWindow(window);
                }
            }
        });
    }

    public void initConsole() {
        if (this._console == null) {
            this._console = new ScriptingConsole("Aptana Scripting Console", null);
            this._consoleStream = this._console.newMessageStream();
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                public void run() {
                    ScriptingEngine.this._consoleStream.setColor(PlatformUI.getWorkbench().getDisplay().getSystemColor(9));
                }
            });
            ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{this._console});
        }
    }

    public MessageConsoleStream getConsoleStream() {
        if (this._consoleStream == null) {
            this.initConsole();
        }
        return this._consoleStream;
    }

    public static IEditorPart getActiveEditor() {
        IEditorPart result;
        final IWorkbench workbench = PlatformUI.getWorkbench();
        class ActiveEditorRef {
            public IEditorPart activeEditor;

            ActiveEditorRef() {
            }
        }
        final ActiveEditorRef activeEditor = new ActiveEditorRef();
        Display display = workbench.getDisplay();
        display.syncExec(new Runnable(){
            {
            }

            public void run() {
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                if (window != null && window.getActivePage() != null) {
                    activeEditor.activeEditor = window.getActivePage().getActiveEditor();
                }
            }
        });
        if (activeEditor.activeEditor instanceof IUnifiedEditor) {
            IUnifiedEditor editor = (IUnifiedEditor)activeEditor.activeEditor;
            result = editor.getEditor();
        } else {
            result = activeEditor.activeEditor;
        }
        return result;
    }

    public void init() {
        if (!this._loaded) {
            Context cx = Context.enter();
            try {
                try {
                    this._global = new Global(cx);
                    this.startServer();
                    if (this._server != null) {
                        this._global.put("serverPort", (Scriptable)this._global, new Integer(this._server.getPort()));
                        String scriptName = "/com/aptana/ide/scripting/resources/bootstrap.js";
                        String source = FileUtilities.getResourceText(scriptName);
                        cx.evaluateString((Scriptable)this._global, source, scriptName, 1, null);
                    }
                    this.bindToWorkbench();
                    IEditorPart activeEditor = ScriptingEngine.getActiveEditor();
                    if (activeEditor != null && activeEditor instanceof IUnifiedEditor) {
                        IUnifiedEditor editor = (IUnifiedEditor)activeEditor;
                        editor.getFileContext().addLongDelayedFileListener((IFileContextListener)this);
                        editor.getFileContext().addErrorListener((IFileErrorListener)this);
                    }
                    this._loaded = true;
                }
                catch (EcmaError e) {
                    IdeLog.logError((Plugin)ScriptingPlugin.getDefault(), (String)Messages.ScriptingEngine_Error, (Throwable)e);
                }
                catch (EvaluatorException e) {
                    IdeLog.logError((Plugin)ScriptingPlugin.getDefault(), (String)Messages.ScriptingEngine_Error, (Throwable)e);
                }
            }
            finally {
                Context.exit();
            }
        }
    }

    private boolean perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        IPreferenceStore store;
        boolean result = false;
        if (supportedPerspectives.containsKey(perspective.getId()) && (store = ScriptingPlugin.getDefault().getPreferenceStore()).getBoolean("com.aptana.ide.scripting.preferences.SCRIPTING_SERVER_START_AUTOMATICALLY")) {
            this.init();
            result = true;
        }
        return result;
    }

    public void reload() {
        this.shutdown();
        this.init();
    }

    private void shutdown() {
        if (this._loaded) {
            this.unbindToWorkbench();
            String[] keys = this._global.getScriptIds();
            int i = 0;
            while (i < keys.length) {
                String key = keys[i];
                ScriptInfo info = this._global.getScriptInfo(key);
                Scriptable scope = info.getScope();
                Object onunload = scope.get("onunload", scope);
                if (onunload instanceof Function) {
                    Function unloadFunction = (Function)onunload;
                    Context cx = Context.enter();
                    unloadFunction.call(cx, scope, scope, new Object[0]);
                    Context.exit();
                }
                ++i;
            }
            this._global.shutdown();
            this._loaded = false;
        }
    }

    private void startServer() {
        if (this._server == null) {
            this.initConsole();
            String pluginDir = CoreUIUtils.getPluginLocation((Plugin)ScriptingPlugin.getDefault());
            String scriptsDir = String.valueOf(pluginDir) + File.separator + "scripts";
            System.setProperty("scripts.dir", scriptsDir);
            String workspaceDir = CoreUIUtils.getWorkspaceDirectory();
            String userScriptsDir = String.valueOf(workspaceDir) + File.separator + "user.scripts";
            System.setProperty("user.scripts.dir", userScriptsDir);
            if (new File(scriptsDir).exists()) {
                IPreferenceStore store = ScriptingPlugin.getDefault().getPreferenceStore();
                int startPort = 9000;
                if (store != null) {
                    startPort = store.getInt("com.aptana.ide.scripting.preferences.SCRIPTING_SERVER_START_PORT");
                }
                this._server = new ScriptingHttpServer(this, scriptsDir, startPort, startPort + 100);
                try {
                    this._server.start();
                    String message = StringUtils.format((String)Messages.ScriptingEngine_Started, (int)this._server.getPort());
                    IdeLog.logInfo((Plugin)ScriptingPlugin.getDefault(), (String)message);
                }
                catch (IOException e) {
                    IdeLog.logError((Plugin)ScriptingPlugin.getDefault(), (String)Messages.ScriptingEngine_Error_On_Start, (Throwable)e);
                }
            } else {
                String message = StringUtils.format((String)Messages.ScriptingEngine_Base_Directory_Does_Not_Exist, (String)scriptsDir);
                IdeLog.logError((Plugin)ScriptingPlugin.getDefault(), (String)message);
            }
        }
    }

    private void unbindToWorkbench() {
        if (this._partListener != null) {
            final ScriptingEngine me = this;
            IWorkbench workbench = PlatformUI.getWorkbench();
            Display display = workbench.getDisplay();
            display.syncExec(new Runnable(){

                public void run() {
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    if (window != null) {
                        window.getPartService().removePartListener(me._partListener);
                        me._partListener = null;
                    }
                }
            });
        }
    }

    public void onErrorsChanged(IFileError[] errors) {
        IEditorPart part;
        if (this._global != null && (part = ScriptingEngine.getActiveEditor()) instanceof IUnifiedEditor) {
            IUnifiedEditor editor = (IUnifiedEditor)part;
            String mimeType = editor.getFileContext().getDefaultLanguage();
            EditorType editorType = this._global.getEditors().getEventTarget(mimeType);
            if (editorType != null) {
                ErrorsChangedEvent event = new ErrorsChangedEvent(editorType, errors);
                editorType.fireEventListeners(event);
            }
        }
    }

    public void onContentChanged(FileContextContentEvent evt) {
        final IFileService fcx = evt.getSource();
        String mimeType = fcx.getDefaultLanguage();
        EditorType editorType = this._global.getEditors().getEventTarget(mimeType);
        if (editorType != null) {
            final IWorkbench workbench = PlatformUI.getWorkbench();
            class ActiveEditorRef {
                public IEditorPart activeEditor;

                ActiveEditorRef() {
                }
            }
            final ActiveEditorRef activeEditor = new ActiveEditorRef();
            Display display = workbench.getDisplay();
            display.syncExec(new Runnable(){
                {
                }

                public void run() {
                    IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                    if (window == null) {
                        return;
                    }
                    IWorkbenchPage[] pages = window.getPages();
                    int i = 0;
                    block0: while (i < pages.length) {
                        IWorkbenchPage page = pages[i];
                        IEditorReference[] editorRefs = page.getEditorReferences();
                        int j = 0;
                        while (j < editorRefs.length) {
                            IEditorPart editor = editorRefs[j].getEditor(false);
                            if (editor instanceof IUnifiedEditor) {
                                IUnifiedEditor uniEditor = (IUnifiedEditor)editor;
                                EditorFileContext service = uniEditor.getFileContext();
                                if (service instanceof EditorFileContext) {
                                    service = service.getFileContext();
                                }
                                if (service == fcx) {
                                    activeEditor.activeEditor = editor;
                                    break block0;
                                }
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
            });
            Editor editor = new Editor((Scriptable)this._global, activeEditor.activeEditor);
            ContentChangedEvent event = new ContentChangedEvent(editor);
            editorType.fireEventListeners("ContentChanged", new Object[]{event});
        }
    }

    public IRegion onBracketMatch(int offset) {
        Callable callback = this._global.getEditors().getBracketMatcher();
        if (callback != null) {
            Context.enter();
            try {
                Object o = callback.call(Context.getCurrentContext(), (Scriptable)this._global, (Scriptable)this._global, new Object[]{new Integer(offset)});
                if (o instanceof Undefined) {
                    return null;
                }
                IRegion iRegion = (IRegion)o;
                return iRegion;
            }
            finally {
                Context.exit();
            }
        }
        return null;
    }
}

