/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.core.impl.servers;

import com.aptana.ide.server.core.IAbstractConfiguration;
import com.aptana.ide.server.core.IModule;
import com.aptana.ide.server.core.IServerType;
import com.aptana.ide.server.core.ServerPathUtils;
import com.aptana.ide.server.core.impl.servers.AbstractServer;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public abstract class AbstractExternalServer
extends AbstractServer {
    private Properties properties;
    private String path;

    public boolean isExternal() {
        return true;
    }

    public String getPath() {
        return ServerPathUtils.getFileNameByPathWithParameters(this.path);
    }

    public String[] getPathParameters() {
        return ServerPathUtils.getParameters(this.path);
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void reconfigure(IAbstractConfiguration configuration) throws CoreException {
        this.properties = null;
        super.reconfigure(configuration);
    }

    protected void installConfig(IAbstractConfiguration configuration) {
        super.installConfig(configuration);
        super.setName(configuration.getStringAttribute("name"));
        this.setPath(configuration.getStringAttribute("path"));
        this.properties = null;
    }

    public void storeConfiguration(IAbstractConfiguration config) {
        config.setStringAttribute("name", this.getName());
        config.setStringAttribute("path", this.getPath());
        super.storeConfiguration(config);
    }

    public AbstractExternalServer(IServerType type, IAbstractConfiguration configuration) {
        super(type, configuration);
    }

    protected IStatus restart(String mode, IProgressMonitor monitor) {
        return null;
    }

    protected IStatus start(String mode, IProgressMonitor monitor) {
        return null;
    }

    protected IStatus stop(boolean force, IProgressMonitor monitor) {
        return null;
    }

    public IStatus canHaveModule(IModule module) {
        return new Status(4, "com.aptana.ide.server", 4, "modules not supported yet", null);
    }

    public String fetchStatistics() {
        return null;
    }

    public IPath getDocumentRoot() {
        return null;
    }

    protected void checkProperties() {
        if (this.properties == null) {
            this.properties = this.loadProperties();
        }
    }

    protected abstract Properties loadProperties();

    public Properties getProperties() {
        this.checkProperties();
        return this.properties;
    }
}

