/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.core;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.server.ServerCore;
import com.aptana.ide.server.core.IServerLauncher;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServerLaunchers {
    private static final String EXTENSION_POINT_NAME = "serverLaunchers";
    private static final String INFO_ELEMENT_NAME = "launcher";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String OS_ATTRIBUTE = "OpSystem";
    private static final String TYPE_ATTRIBUTE = "serverTypeID";

    public static List<IServerLauncher> getLaunchers(String serverTypeID) {
        ArrayList<IServerLauncher> result = new ArrayList<IServerLauncher>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor("com.aptana.ide.server", EXTENSION_POINT_NAME);
        if (elements == null || elements.length == 0) {
            return null;
        }
        String osName = System.getProperty("os.name").toLowerCase();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = 0;
        int n2 = iConfigurationElementArray.length;
        while (n < n2) {
            IConfigurationElement element = iConfigurationElementArray[n];
            if (INFO_ELEMENT_NAME.equals(element.getName())) {
                String os = element.getAttribute(OS_ATTRIBUTE);
                String serverType = element.getAttribute(TYPE_ATTRIBUTE);
                if (osName.startsWith(os) && serverTypeID.equals(serverType)) {
                    try {
                        IServerLauncher launcher = (IServerLauncher)element.createExecutableExtension(CLASS_ATTRIBUTE);
                        result.add(launcher);
                    }
                    catch (CoreException e) {
                        IdeLog.logError((Plugin)ServerCore.getDefault(), (String)"Unable creating server launcher", (Throwable)e);
                    }
                }
            }
            ++n;
        }
        return result;
    }

    private ServerLaunchers() {
    }
}

