/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.jetty.comet;

import com.aptana.ide.core.model.IModelListener;
import com.aptana.ide.core.model.IModifiableObject;
import com.aptana.ide.core.model.IServiceProvider;
import com.aptana.ide.core.model.IServiceRequestBuilder;
import com.aptana.ide.core.model.RESTServiceProvider;
import com.aptana.ide.core.model.ServiceError;
import com.aptana.ide.core.model.ServiceErrors;
import com.aptana.ide.core.model.channel.ChannelType;
import com.aptana.ide.core.model.user.AptanaUser;
import com.aptana.ide.core.model.user.User;
import com.aptana.ide.core.model.user.UserRequestBuilder;
import com.aptana.ide.core.model.user.UsernameAvailable;
import com.aptana.ide.core.model.user.UsernameResolver;
import com.aptana.ide.server.jetty.comet.CometClient;
import dojox.cometd.Bayeux;
import dojox.cometd.Channel;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import sun.misc.BASE64Decoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserClient
extends CometClient {
    public static final String SUCCESS = "success";
    public static final String USER_VALID = "userValid";
    public static final String USERNAME_VALID = "usernameValid";
    public static final String PASSWORD_VALID = "passwordValid";
    public static final String RESOLVE_USER_ACTION = "resolveUser";
    public static final String CREATE_USER_ACTION = "createUser";
    public static final String LOGIN_USER_ACTION = "loginUser";
    public static final String LOGOUT_USER_ACTION = "logoutUser";
    public static final String CURRENT_USER_ACTION = "currentUser";
    public static final String UPDATE_USER_ACTION = "updateUser";
    public static final String CURRENT_USER = "/portal/user";
    public static final String LOGIN_USER = "/portal/user/login";
    public static final String LOGOUT_USER = "/portal/user/logout";
    public static final String CREATE_USER = "/portal/user/create";
    public static final String RESOLVE_USER = "/portal/user/resolve";
    public static final String UPDATE_USER = "/portal/user/update";
    public static final String EMAIL_CHANNEL = "1";
    private IModelListener listener = new IModelListener(){

        public void modelChanged(IModifiableObject object) {
            if (object instanceof User) {
                HashMap<String, Object> responseData = new HashMap<String, Object>();
                responseData.put("response", UserClient.CURRENT_USER_ACTION);
                User user = (User)object;
                if (user.hasCredentials()) {
                    UserClient.this.fillResponse(responseData, user);
                    Bayeux localBayeux = UserClient.this.bayeux;
                    if (localBayeux != null) {
                        Channel userChannel = localBayeux.getChannel(UserClient.CURRENT_USER, true);
                        userChannel.publish(UserClient.this.client, responseData, UserClient.this.getID(null));
                    }
                } else {
                    responseData.put("response", UserClient.LOGOUT_USER_ACTION);
                    responseData.put(UserClient.SUCCESS, Boolean.TRUE);
                    Bayeux localBayeux = UserClient.this.bayeux;
                    if (localBayeux != null) {
                        Channel userChannel = localBayeux.getChannel(UserClient.LOGOUT_USER, true);
                        userChannel.publish(UserClient.this.client, responseData, UserClient.this.getID(null));
                    }
                }
            }
        }
    };

    public UserClient() {
        Job listenerJob = new Job("Adding user listener"){

            protected IStatus run(IProgressMonitor monitor) {
                AptanaUser.getSignedInUser().addListener(UserClient.this.listener);
                return Status.OK_STATUS;
            }
        };
        listenerJob.setPriority(40);
        listenerJob.schedule();
    }

    @Override
    public void destroy() {
        AptanaUser.getSignedInUser().removeListener(this.listener);
        super.destroy();
    }

    private void fillResponse(Map<Object, Object> responseData, User user) {
        if (user.hasCredentials()) {
            try {
                BASE64Decoder decoder = new BASE64Decoder();
                String encryptedPassword = user.getField("encryptedPassword");
                String password = null;
                password = encryptedPassword != null ? new String(decoder.decodeBuffer(encryptedPassword)) : user.getField("password");
                responseData.put("password", password);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            responseData.put("id", user.getField("id"));
            responseData.put("username", user.getField("username"));
            responseData.put("first_name", user.getField("first_name"));
            responseData.put("last_name", user.getField("last_name"));
            responseData.put("phone", user.getField("phone"));
            responseData.put("ip_address", user.getField("ip_address"));
            responseData.put("address1", user.getField("address1"));
            responseData.put("address2", user.getField("address2"));
            responseData.put("city", user.getField("city"));
            responseData.put("state", user.getField("state"));
            responseData.put("zipcode", user.getField("zipcode"));
            responseData.put("country", user.getField("country"));
            responseData.put("role", user.getField("role"));
            responseData.put("company", user.getField("company"));
            responseData.put("organization_type", user.getField("organization_type"));
            responseData.put("organization_size", user.getField("organization_size"));
            responseData.put("sites_per_year", user.getField("sites_per_year"));
            responseData.put("ajax", Boolean.parseBoolean(user.getField("ajax")));
            responseData.put("javascript", Boolean.parseBoolean(user.getField("javascript")));
            responseData.put("php", Boolean.parseBoolean(user.getField("php")));
            responseData.put("ruby", Boolean.parseBoolean(user.getField("ruby")));
            responseData.put("java", Boolean.parseBoolean(user.getField("java")));
            responseData.put("python", Boolean.parseBoolean(user.getField("python")));
            responseData.put("net", Boolean.parseBoolean(user.getField("net")));
            responseData.put("site_development", Boolean.parseBoolean(user.getField("site_development")));
            responseData.put("application_development", Boolean.parseBoolean(user.getField("application_development")));
            responseData.put("newsletter", Boolean.parseBoolean(user.getField("newsletter")));
            com.aptana.ide.core.model.channel.Channel[] channelArray = (com.aptana.ide.core.model.channel.Channel[])user.getChannels().getItems();
            int n = 0;
            int n2 = channelArray.length;
            while (n < n2) {
                com.aptana.ide.core.model.channel.Channel channel = channelArray[n];
                ChannelType type = channel.getChannelType();
                if (type != null && EMAIL_CHANNEL.equals(type.getId()) && channel.isPrimary()) {
                    responseData.put("email", channel.getValue());
                    break;
                }
                ++n;
            }
        } else {
            responseData.put("id", Boolean.FALSE);
            responseData.put("username", Boolean.FALSE);
            responseData.put("password", Boolean.FALSE);
            responseData.put("email", Boolean.FALSE);
        }
    }

    @Override
    protected Object getResponse(String toChannel, Object request) {
        if (CURRENT_USER.equals(toChannel)) {
            HashMap<Object, Object> responseData = new HashMap<Object, Object>();
            responseData.put("response", CURRENT_USER_ACTION);
            this.fillResponse(responseData, AptanaUser.getSignedInUser());
            return responseData;
        }
        if (LOGIN_USER.equals(toChannel)) {
            Map values;
            if (request instanceof Map && (values = (Map)request).containsKey("username") && values.containsKey("password")) {
                String name = values.get("username").toString();
                String password = values.get("password").toString();
                HashMap<String, Object> responseData = new HashMap<String, Object>();
                User user = new User(name, password, null, null, null, null, null);
                user.setRequestBuilder((IServiceRequestBuilder)new UserRequestBuilder());
                user.setServiceProvider((IServiceProvider)new RESTServiceProvider());
                responseData.put("response", LOGIN_USER_ACTION);
                try {
                    user.setDefaultLocation(new URL(AptanaUser.LOGINS));
                    user.update();
                    if (user.hasLocation()) {
                        user.update();
                        AptanaUser.signIn((String)name, (String)password, (URL)user.getLocation(), (String)user.getId());
                        responseData.put(USER_VALID, Boolean.TRUE);
                        responseData.put(USERNAME_VALID, Boolean.TRUE);
                        responseData.put(PASSWORD_VALID, Boolean.TRUE);
                        responseData.put("id", user.getId());
                        responseData.put("username", user.getUsername());
                        responseData.put("password", user.getPassword());
                    } else {
                        responseData.put(USER_VALID, Boolean.FALSE);
                        responseData.put(USERNAME_VALID, Boolean.FALSE);
                        responseData.put(PASSWORD_VALID, Boolean.FALSE);
                    }
                }
                catch (MalformedURLException malformedURLException) {}
                return responseData;
            }
        } else {
            if (LOGOUT_USER.equals(toChannel)) {
                HashMap<String, Object> responseData = new HashMap<String, Object>();
                responseData.put("response", LOGOUT_USER_ACTION);
                try {
                    AptanaUser.signOut();
                    responseData.put(SUCCESS, Boolean.TRUE);
                }
                catch (Exception exception) {
                    responseData.put(SUCCESS, Boolean.FALSE);
                }
                return responseData;
            }
            if (CREATE_USER.equals(toChannel)) {
                Map values;
                if (request instanceof Map && (values = (Map)request).containsKey("username") && values.containsKey("password") && values.containsKey("email")) {
                    String name = values.get("username").toString();
                    String firstName = values.get("first_name").toString();
                    String lastName = values.get("last_name").toString();
                    String password = values.get("password").toString();
                    String email = values.get("email").toString();
                    String challenge = values.get("captcha_token").toString();
                    String response = values.get("captcha_response").toString();
                    HashMap<String, Object> responseData = new HashMap<String, Object>();
                    responseData.put("response", CREATE_USER_ACTION);
                    responseData.put(PASSWORD_VALID, Boolean.TRUE);
                    User user = new User(name, password, email, firstName, lastName, challenge, response);
                    user.setRequestBuilder((IServiceRequestBuilder)new UserRequestBuilder());
                    user.setServiceProvider((IServiceProvider)new RESTServiceProvider());
                    try {
                        user.setDefaultLocation(new URL(AptanaUser.USERS));
                        user.commit();
                        if (user.hasLocation()) {
                            user.update();
                            responseData.put(USERNAME_VALID, Boolean.TRUE);
                            responseData.put(SUCCESS, Boolean.TRUE);
                            AptanaUser.signIn((String)user.getUsername(), (String)user.getPassword(), (URL)user.getLocation(), (String)user.getId());
                        } else {
                            responseData.put(USERNAME_VALID, UsernameAvailable.isUsernameAvailable((String)name));
                            responseData.put(SUCCESS, Boolean.FALSE);
                            ArrayList<String> errors = new ArrayList<String>();
                            ServiceErrors serviceErrors = user.getLastServiceErrors();
                            if (serviceErrors != null && serviceErrors.getItems() != null) {
                                ServiceError[] serviceErrorArray = (ServiceError[])serviceErrors.getItems();
                                int n = 0;
                                int n2 = serviceErrorArray.length;
                                while (n < n2) {
                                    ServiceError se = serviceErrorArray[n];
                                    errors.add(se.getMessage());
                                    ++n;
                                }
                            }
                            responseData.put("errors", errors);
                        }
                    }
                    catch (MalformedURLException e) {
                        responseData.put(USERNAME_VALID, UsernameAvailable.isUsernameAvailable((String)name));
                        responseData.put("errors", Arrays.asList(e.getMessage()));
                    }
                    responseData.put("response", CREATE_USER_ACTION);
                    return responseData;
                }
            } else if (RESOLVE_USER.equals(toChannel)) {
                String email;
                User possibleUser;
                Map values;
                if (request instanceof Map && (values = (Map)request).containsKey("email") && (possibleUser = UsernameResolver.doesUsernameResolve((String)(email = values.get("email").toString()))) != null) {
                    HashMap<String, Object> responseData = new HashMap<String, Object>();
                    responseData.put("username", possibleUser.getUsername());
                    responseData.put("response", RESOLVE_USER_ACTION);
                    ServiceErrors errors = possibleUser.getLastServiceErrors();
                    if (errors != null) {
                        responseData.put("errors", errors.getErrorStrings());
                    }
                    return responseData;
                }
            } else if (UPDATE_USER.equals(toChannel) && request instanceof Map) {
                Map values = (Map)request;
                String firstName = values.get("first_name").toString();
                String lastName = values.get("last_name").toString();
                String phone = values.get("phone").toString();
                String email = values.get("email").toString();
                String address1 = values.get("address1").toString();
                String address2 = values.get("address2").toString();
                String city = values.get("city").toString();
                String state = values.get("state").toString();
                String zip = values.get("zipcode").toString();
                String country = values.get("country").toString();
                String role = values.get("role").toString();
                String company = values.get("company").toString();
                String organizationType = values.get("organization_type").toString();
                String organizationSize = values.get("organization_size").toString();
                String sitesPerYear = values.get("sites_per_year").toString();
                String ajax = this.getBooleanString(values, "ajax");
                String javascript = this.getBooleanString(values, "javascript");
                String php = this.getBooleanString(values, "php");
                String ruby = this.getBooleanString(values, "ruby");
                String python = this.getBooleanString(values, "python");
                String java = this.getBooleanString(values, "java");
                String net = this.getBooleanString(values, "net");
                String siteDevelopment = this.getBooleanString(values, "site_development");
                String applicationDevelopment = this.getBooleanString(values, "application_development");
                String newsletter = this.getBooleanString(values, "newsletter");
                User user = AptanaUser.getSignedInUser();
                HashMap<String, Object> responseData = new HashMap<String, Object>();
                responseData.put("response", UPDATE_USER_ACTION);
                if (user != null) {
                    user.setField("first_name", firstName);
                    user.setField("last_name", lastName);
                    user.setField("email", email);
                    user.setField("phone", phone);
                    user.setField("address1", address1);
                    user.setField("address2", address2);
                    user.setField("city", city);
                    user.setField("state", state);
                    user.setField("zipcode", zip);
                    user.setField("country", country);
                    user.setField("role", role);
                    user.setField("company", company);
                    user.setField("organization_type", organizationType);
                    user.setField("organization_size", organizationSize);
                    user.setField("sites_per_year", sitesPerYear);
                    user.setField("ajax", ajax);
                    user.setField("javascript", javascript);
                    user.setField("php", php);
                    user.setField("ruby", ruby);
                    user.setField("python", python);
                    user.setField("java", java);
                    user.setField("net", net);
                    user.setField("site_development", siteDevelopment);
                    user.setField("application_development", applicationDevelopment);
                    user.setField("newsletter", newsletter);
                    com.aptana.ide.core.model.channel.Channel[] channelArray = (com.aptana.ide.core.model.channel.Channel[])user.getChannels().getItems();
                    int n = 0;
                    int n3 = channelArray.length;
                    while (n < n3) {
                        com.aptana.ide.core.model.channel.Channel channel = channelArray[n];
                        ChannelType type = channel.getChannelType();
                        if (type != null && EMAIL_CHANNEL.equals(type.getId()) && channel.isPrimary()) {
                            channel.setField("value", user.getField("email"));
                            break;
                        }
                        ++n;
                    }
                    user.commit();
                    ArrayList<String> errors = new ArrayList<String>();
                    ServiceErrors serviceErrors = user.getLastServiceErrors();
                    if (serviceErrors != null && serviceErrors.getItems() != null) {
                        ServiceError[] serviceErrorArray = (ServiceError[])serviceErrors.getItems();
                        int n4 = 0;
                        int n5 = serviceErrorArray.length;
                        while (n4 < n5) {
                            ServiceError se = serviceErrorArray[n4];
                            errors.add(se.getMessage());
                            ++n4;
                        }
                        responseData.put(SUCCESS, errors.size() > 0 ? Boolean.FALSE : Boolean.TRUE);
                    } else {
                        responseData.put(SUCCESS, Boolean.TRUE);
                    }
                    responseData.put("errors", errors);
                } else {
                    responseData.put(SUCCESS, Boolean.FALSE);
                }
                return responseData;
            }
        }
        return null;
    }

    private String getBooleanString(Map values, String key) {
        Object value = values.get(key);
        if (value == null) {
            return Boolean.FALSE.toString();
        }
        if (value instanceof String) {
            return Boolean.toString(Boolean.parseBoolean((String)value));
        }
        if (value instanceof Boolean) {
            return Boolean.toString((Boolean)value);
        }
        return Boolean.FALSE.toString();
    }

    @Override
    protected String[] getSubscriptionIDs() {
        return new String[]{RESOLVE_USER, CURRENT_USER, LOGIN_USER, LOGOUT_USER, CREATE_USER, UPDATE_USER};
    }

    @Override
    protected String getID(String msgId) {
        return Long.toString(System.currentTimeMillis());
    }
}

