/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.jetty.builder;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.server.jetty.JettyPlugin;
import com.aptana.ide.server.jetty.builder.IContextHandler;
import com.aptana.ide.server.jetty.builder.IServletConfigurator;
import com.aptana.ide.server.jetty.builder.ServletConfigurationException;
import com.aptana.ide.server.jetty.server.IDELoggingHandler;
import com.aptana.jaxer.connectors.servlet.interfaces.IDocumentRootFilter;
import com.aptana.jaxer.connectors.servlet.interfaces.IDocumentRootResolver;
import com.aptana.jaxer.connectors.servlet.interfaces.IErrorPageFilter;
import com.aptana.jaxer.connectors.servlet.interfaces.IErrorPageHandler;
import com.aptana.jaxer.connectors.servlet.interfaces.IHostnameFilter;
import com.aptana.jaxer.connectors.servlet.interfaces.IIgnoreFilter;
import com.aptana.jaxer.connectors.servlet.interfaces.IIgnoreHandler;
import com.aptana.jaxer.connectors.servlet.interfaces.ILoggingFilter;
import com.aptana.jaxer.connectors.servlet.interfaces.ILoggingHandler;
import com.aptana.jaxer.connectors.servlet.interfaces.IRestartManager;
import com.aptana.jaxer.connectors.servlet.interfaces.IRestartableFilter;
import com.aptana.jaxer.connectors.servlet.interfaces.IStatisticsHandler;
import com.aptana.jaxer.connectors.servlet.interfaces.IStatisticsProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.FilterHolder;
import org.mortbay.jetty.servlet.ServletHolder;

public class JettyServerBuilder {
    private static JettyServerBuilder builder;
    public static final String CONTEXT_EXTENSION_POINT = "com.aptana.ide.server.jetty.context";
    public static final String FILTER_ELEMENT = "filter";
    public static final String SERVLET_ELEMENT = "servlet";
    public static final String CONFIGURATOR_ATTR = "configurator";
    public static final String HANDLER_ATTR = "handler";
    public static final String STATISTICS_ATTR = "statistics";
    public static final String RESTART_ATTR = "restart";
    public static final String IGNORE_ATTR = "ignore";
    public static final String ERROR_ATTR = "error";
    public static final String CLASS_ATTR = "class";
    public static final String PATHSPEC_ATTR = "pathSpec";
    public static final String DISPATCHES_ATTR = "dispatches";
    public static final String SERVERID_ATTR = "serverID";
    private List<IConfigurationElement> servlets;
    private List<IConfigurationElement> filters;
    private IDELoggingHandler loggingHandler = new IDELoggingHandler();

    private JettyServerBuilder() {
        this.servlets = new ArrayList<IConfigurationElement>();
        this.filters = new ArrayList<IConfigurationElement>();
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint ep = reg.getExtensionPoint(CONTEXT_EXTENSION_POINT);
        IExtension[] extensions = ep.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] ce = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < ce.length) {
                String type = ce[j].getName();
                if (FILTER_ELEMENT.equals(type)) {
                    this.filters.add(ce[j]);
                } else if (SERVLET_ELEMENT.equals(type)) {
                    this.servlets.add(ce[j]);
                }
                ++j;
            }
            ++i;
        }
    }

    public void buildServer(Context context, String extensionPointID, String serverID, String hostname, int port, IDocumentRootResolver resolver) {
        if (context != null && extensionPointID != null) {
            String pathSpec;
            String id;
            IConfigurationElement curr = null;
            int i = 0;
            while (i < this.servlets.size()) {
                block32: {
                    curr = this.servlets.get(i);
                    id = curr.getAttribute(SERVERID_ATTR);
                    if (id != null && extensionPointID.equals(id)) {
                        pathSpec = curr.getAttribute(PATHSPEC_ATTR);
                        String className = curr.getAttribute(CLASS_ATTR);
                        if (className != null) {
                            try {
                                IContextHandler handler;
                                IStatisticsHandler statsHandler;
                                Object obj = curr.createExecutableExtension(CLASS_ATTR);
                                if (!(obj instanceof Servlet)) break block32;
                                Servlet servlet = (Servlet)obj;
                                if (servlet instanceof IStatisticsProvider && serverID != null && (statsHandler = this.getStatisticsHandler(curr)) != null) {
                                    statsHandler.setID(serverID);
                                    ((IStatisticsProvider)servlet).setStatisticsHandler(statsHandler);
                                }
                                if ((handler = this.getContextHandler(curr)) != null && !handler.shouldAddServlet()) break block32;
                                ServletHolder holder = new ServletHolder(servlet);
                                if (curr.getAttribute(CONFIGURATOR_ATTR) != null) {
                                    try {
                                        IServletConfigurator configurator = (IServletConfigurator)curr.createExecutableExtension(CONFIGURATOR_ATTR);
                                        try {
                                            configurator.configure(holder);
                                        }
                                        catch (ServletConfigurationException ex) {
                                            IdeLog.logError((Plugin)JettyPlugin.getDefault(), (String)("Unable configuring servlet holder " + holder.getClassName()), (Throwable)ex);
                                        }
                                    }
                                    catch (Throwable th) {
                                        IdeLog.logError((Plugin)JettyPlugin.getDefault(), (String)"Unable creating servlet configurator", (Throwable)th);
                                    }
                                }
                                if (pathSpec != null) {
                                    String[] pathSpecsArray;
                                    String[] stringArray = pathSpecsArray = pathSpec.trim().split(Pattern.quote(","));
                                    int n = 0;
                                    int n2 = stringArray.length;
                                    while (n < n2) {
                                        String aPathSpec = stringArray[n];
                                        context.addServlet(holder, aPathSpec.trim());
                                        ++n;
                                    }
                                } else {
                                    holder.setName(servlet.getClass().getName());
                                    context.getServletHandler().addServlet(holder);
                                }
                            }
                            catch (CoreException e) {
                                IdeLog.logInfo((Plugin)JettyPlugin.getDefault(), (String)"Error loading servlet extension point", (Throwable)e);
                            }
                        }
                    }
                }
                ++i;
            }
            i = 0;
            while (i < this.filters.size()) {
                curr = this.filters.get(i);
                id = curr.getAttribute(SERVERID_ATTR);
                if (id != null && extensionPointID.equals(id)) {
                    pathSpec = curr.getAttribute(PATHSPEC_ATTR);
                    String dispatches = curr.getAttribute(DISPATCHES_ATTR);
                    String className = curr.getAttribute(CLASS_ATTR);
                    if (pathSpec != null && className != null && dispatches != null) {
                        String[] allPathSpecs = new String[]{pathSpec};
                        try {
                            allPathSpecs = pathSpec.split(",");
                        }
                        catch (Exception e) {
                            IdeLog.logError((Plugin)JettyPlugin.getDefault(), (String)"Error splitting path spec", (Throwable)e);
                        }
                        try {
                            int intDispatches = Integer.parseInt(dispatches);
                            Object obj = curr.createExecutableExtension(CLASS_ATTR);
                            if (obj instanceof Filter) {
                                Filter filter = (Filter)obj;
                                IContextHandler handler = this.getContextHandler(curr);
                                IIgnoreHandler ignoreHandler = this.getIgnoreHandler(curr);
                                IErrorPageHandler errorHandler = this.getErrorHandler(curr);
                                IStatisticsHandler statsHandler = this.getStatisticsHandler(curr);
                                IRestartManager restartHandler = this.getRestartHandler(curr);
                                if (filter instanceof IStatisticsProvider && serverID != null && statsHandler != null) {
                                    statsHandler.setID(serverID);
                                    ((IStatisticsProvider)filter).setStatisticsHandler(statsHandler);
                                }
                                if (filter instanceof IRestartableFilter && serverID != null && restartHandler != null) {
                                    restartHandler.setID(serverID);
                                    restartHandler.setFilter((IRestartableFilter)filter);
                                }
                                if (filter instanceof IHostnameFilter) {
                                    ((IHostnameFilter)filter).setHostname(hostname);
                                    ((IHostnameFilter)filter).setPort(port);
                                }
                                if (filter instanceof IDocumentRootFilter) {
                                    ((IDocumentRootFilter)filter).setDocumentRootResolver(resolver);
                                }
                                if (filter instanceof IIgnoreFilter) {
                                    ((IIgnoreFilter)filter).setIgnoreHandler(ignoreHandler);
                                }
                                if (filter instanceof IErrorPageFilter) {
                                    ((IErrorPageFilter)filter).setErrorPageHandler(errorHandler);
                                }
                                if (filter instanceof ILoggingFilter) {
                                    ((ILoggingFilter)filter).setLoggingHandler((ILoggingHandler)this.loggingHandler);
                                }
                                if (handler == null || handler.shouldaddFilter()) {
                                    int paths = 0;
                                    while (paths < allPathSpecs.length) {
                                        context.addFilter(new FilterHolder(filter), allPathSpecs[paths].trim(), intDispatches);
                                        ++paths;
                                    }
                                }
                            }
                        }
                        catch (CoreException e) {
                            IdeLog.logInfo((Plugin)JettyPlugin.getDefault(), (String)"Error loading servlet extension point", (Throwable)e);
                        }
                    }
                }
                ++i;
            }
        }
    }

    private IContextHandler getContextHandler(IConfigurationElement element) {
        IContextHandler handler = null;
        if (element.getAttribute(HANDLER_ATTR) != null) {
            try {
                Object oHandler = element.createExecutableExtension(HANDLER_ATTR);
                if (oHandler instanceof IContextHandler) {
                    handler = (IContextHandler)oHandler;
                }
            }
            catch (CoreException e) {
                IdeLog.logInfo((Plugin)JettyPlugin.getDefault(), (String)"Error loading context handler", (Throwable)e);
            }
        }
        return handler;
    }

    private IStatisticsHandler getStatisticsHandler(IConfigurationElement element) {
        IStatisticsHandler handler = null;
        if (element.getAttribute(STATISTICS_ATTR) != null) {
            try {
                Object oHandler = element.createExecutableExtension(STATISTICS_ATTR);
                if (oHandler instanceof IStatisticsHandler) {
                    handler = (IStatisticsHandler)oHandler;
                }
            }
            catch (CoreException e) {
                IdeLog.logInfo((Plugin)JettyPlugin.getDefault(), (String)"Error loading statistics handler", (Throwable)e);
            }
        }
        return handler;
    }

    private IRestartManager getRestartHandler(IConfigurationElement element) {
        IRestartManager handler = null;
        if (element.getAttribute(RESTART_ATTR) != null) {
            try {
                Object oHandler = element.createExecutableExtension(RESTART_ATTR);
                if (oHandler instanceof IRestartManager) {
                    handler = (IRestartManager)oHandler;
                }
            }
            catch (CoreException e) {
                IdeLog.logInfo((Plugin)JettyPlugin.getDefault(), (String)"Error loading restart manager", (Throwable)e);
            }
        }
        return handler;
    }

    private IIgnoreHandler getIgnoreHandler(IConfigurationElement element) {
        IIgnoreHandler handler = null;
        if (element.getAttribute(IGNORE_ATTR) != null) {
            try {
                Object oHandler = element.createExecutableExtension(IGNORE_ATTR);
                if (oHandler instanceof IIgnoreHandler) {
                    handler = (IIgnoreHandler)oHandler;
                }
            }
            catch (CoreException e) {
                IdeLog.logInfo((Plugin)JettyPlugin.getDefault(), (String)"Error loading ignore handler", (Throwable)e);
            }
        }
        return handler;
    }

    private IErrorPageHandler getErrorHandler(IConfigurationElement element) {
        IErrorPageHandler handler = null;
        if (element.getAttribute(ERROR_ATTR) != null) {
            try {
                Object oHandler = element.createExecutableExtension(ERROR_ATTR);
                if (oHandler instanceof IErrorPageHandler) {
                    handler = (IErrorPageHandler)oHandler;
                }
            }
            catch (CoreException e) {
                IdeLog.logInfo((Plugin)JettyPlugin.getDefault(), (String)"Error loading error handler", (Throwable)e);
            }
        }
        return handler;
    }

    public static JettyServerBuilder getInstance() {
        if (builder == null) {
            builder = new JettyServerBuilder();
        }
        return builder;
    }
}

