/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.jetty;

import com.aptana.ide.server.jetty.JettyPlugin;
import com.aptana.ide.server.jetty.comet.CometResponderClient;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.progress.UIJob;

public class PreferenceClient
extends CometResponderClient {
    public static final String PREFERENCE_CHANNEL = "/portal/preferences";
    public static final String SET_ACTION = "set";
    public static final String GET_ACTION = "get";
    public static final String SHOW_ACTION = "show";
    public static final String NAME = "name";
    public static final String VALUE = "value";

    protected Object getResponse(String toChannel, Object request) {
        Map requestData;
        if (PREFERENCE_CHANNEL.equals(toChannel) && request instanceof Map && (requestData = (Map)request).containsKey("request")) {
            String type = requestData.get("request").toString();
            if (SET_ACTION.equals(type) && requestData.containsKey(VALUE) && requestData.containsKey(NAME)) {
                String name = requestData.get(NAME).toString();
                String value = requestData.get(VALUE).toString();
                JettyPlugin.getDefault().getPreferenceStore().setValue(name, value);
            } else {
                if (GET_ACTION.equals(type) && requestData.containsKey(NAME)) {
                    String name = requestData.get(NAME).toString();
                    HashMap<String, String> responseData = new HashMap<String, String>();
                    responseData.put("response", GET_ACTION);
                    responseData.put(NAME, name);
                    responseData.put(VALUE, JettyPlugin.getDefault().getPreferenceStore().getString(name));
                    return responseData;
                }
                if (SHOW_ACTION.equals(type) && requestData.containsKey("id")) {
                    final String pageId = requestData.get("id").toString();
                    UIJob job = new UIJob("Running Jaxer action"){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)this.getDisplay().getActiveShell(), (String)pageId, (String[])new String[0], null);
                            dialog.open();
                            return Status.OK_STATUS;
                        }
                    };
                    job.setSystem(true);
                    job.schedule();
                }
            }
        }
        return null;
    }

    protected String[] getSubscriptionIDs() {
        return new String[]{PREFERENCE_CHANNEL};
    }
}

