/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.debug.internal.ui.dialogs;

import com.aptana.ide.core.StringUtils;
import com.aptana.ide.debug.core.DetailFormatter;
import com.aptana.ide.debug.internal.ui.StatusInfo;
import com.aptana.ide.debug.internal.ui.dialogs.JSTypeSelectionDialog;
import com.aptana.ide.debug.internal.ui.dialogs.Messages;
import java.util.List;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class DetailFormatterDialog
extends StatusDialog {
    private Text typeName;
    private Button enabled;
    private SourceViewer snippetViewer;
    private DetailFormatter formatter;
    private String type;
    private List definedTypes;
    private boolean editTypeName;

    public DetailFormatterDialog(Shell parent, DetailFormatter detailFormatter, List definedTypes, boolean editDialog) {
        this(parent, detailFormatter, definedTypes, true, editDialog);
    }

    public DetailFormatterDialog(Shell parent, DetailFormatter formatter, List definedTypes, boolean editTypeName, boolean editDialog) {
        super(parent);
        this.formatter = formatter;
        this.editTypeName = editTypeName;
        this.definedTypes = definedTypes;
        this.setShellStyle(this.getShellStyle() | 0x400 | 0x10);
        this.setTitle(editDialog ? Messages.DetailFormatterDialog_EditDetailFormatter : Messages.DetailFormatterDialog_AddDetailFormatter);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Font font = parent.getFont();
        Label label = new Label(composite, 0);
        label.setText(Messages.DetailFormatterDialog_QualifiedTypeName);
        GridDataFactory.swtDefaults().applyTo((Control)label);
        label.setFont(font);
        Composite container = new Composite(composite, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)container);
        container.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).create());
        this.typeName = new Text(container, 2052);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.typeName);
        this.typeName.setEditable(this.editTypeName);
        this.typeName.setText(this.formatter.getTypeName());
        this.typeName.setFont(font);
        Button searchButton = new Button(container, 8);
        GridDataFactory.swtDefaults().align(131072, 0x1000000).hint(Math.max(this.convertHorizontalDLUsToPixels(61), searchButton.computeSize((int)-1, (int)-1, (boolean)true).x), -1).applyTo((Control)searchButton);
        searchButton.setText(StringUtils.ellipsify((String)Messages.DetailFormatterDialog_SelectNType));
        searchButton.setEnabled(this.editTypeName);
        searchButton.setFont(font);
        label = new Label(composite, 0);
        label.setText(Messages.DetailFormatterDialog_DetailFormatterCodeSnippet);
        GridDataFactory.swtDefaults().applyTo((Control)label);
        label.setFont(font);
        this.snippetViewer = new SourceViewer(composite, null, 2816);
        GridDataFactory.fillDefaults().grab(true, true).hint(this.convertWidthInCharsToPixels(80), this.convertHeightInCharsToPixels(10)).applyTo(this.snippetViewer.getControl());
        this.enabled = new Button(composite, 16416);
        this.enabled.setText(Messages.DetailFormatterDialog_Enable);
        GridDataFactory.swtDefaults().applyTo((Control)this.enabled);
        this.enabled.setFont(font);
        this.typeName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DetailFormatterDialog.this.checkValues();
            }
        });
        searchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DetailFormatterDialog.this.selectType();
            }
        });
        this.snippetViewer.setInput((Object)this);
        this.snippetViewer.setEditable(true);
        this.snippetViewer.setDocument((IDocument)new Document(this.formatter.getSnippet()));
        this.snippetViewer.getDocument().addDocumentListener(new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                DetailFormatterDialog.this.checkValues();
            }
        });
        if (this.formatter.getTypeName().length() > 0) {
            this.snippetViewer.getControl().setFocus();
        }
        this.enabled.setSelection(this.formatter.isEnabled());
        this.checkValues();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.aptana.ide.debug.ui.edit_detail_formatter_dialog_context");
        return composite;
    }

    private void selectType() {
        Object[] types;
        JSTypeSelectionDialog dlg = new JSTypeSelectionDialog(this.getShell());
        dlg.setTitle(Messages.DetailFormatterDialog_SelectType);
        dlg.setMessage(Messages.DetailFormatterDialog_SelectTypeToFormatWhenDisplayingDetail);
        dlg.setInitialSelections(new Object[]{this.typeName.getText()});
        if (dlg.open() == 0 && (types = dlg.getResult()) != null && types.length > 0) {
            this.type = (String)types[0];
            this.typeName.setText(this.type);
        }
    }

    protected void okPressed() {
        this.formatter.setEnabled(this.enabled.getSelection());
        this.formatter.setTypeName(this.typeName.getText().trim());
        this.formatter.setSnippet(this.snippetViewer.getDocument().get());
        super.okPressed();
    }

    private void checkValues() {
        StatusInfo status = new StatusInfo();
        String name = this.typeName.getText().trim();
        if (name.length() == 0) {
            status.setError(Messages.DetailFormatterDialog_QualifiedTypeNameMustNotBeEmpty);
        } else if (this.definedTypes != null && this.definedTypes.contains(this.typeName)) {
            status.setError(Messages.DetailFormatterDialog_DetailFormatterIsDefinedForThisType);
        } else if (this.snippetViewer.getDocument().get().trim().length() == 0) {
            status.setError(Messages.DetailFormatterDialog_CodeSnippetMustNotBeEmpty);
        } else if (this.type == null) {
            status.setWarning(Messages.DetailFormatterDialog_NoTypeWithGivenNameFoundInWorkspace);
        }
        this.updateStatus(status);
    }
}

