/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.debug.internal.ui.console;

import com.aptana.ide.core.StringUtils;
import com.aptana.ide.debug.internal.ui.console.Messages;
import com.aptana.ide.debug.internal.ui.util.SourceDisplayUtil;
import com.aptana.ide.debug.ui.DebugUiPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.TextConsole;

public class JSConsoleHyperlink
implements IHyperlink {
    private TextConsole fConsole;
    private String fFilename;
    private int fLineNumber;

    public JSConsoleHyperlink(TextConsole console, String fileName, int lineNumber) {
        this.fConsole = console;
        this.fFilename = fileName;
        this.fLineNumber = lineNumber;
    }

    public void linkEntered() {
    }

    public void linkExited() {
    }

    public void linkActivated() {
        try {
            Object sourceElement = DebugUITools.lookupSource((Object)this.fFilename, (ISourceLocator)this.getSourceLocator()).getSourceElement();
            IEditorInput editorInput = SourceDisplayUtil.getEditorInput(sourceElement);
            if (editorInput != null) {
                SourceDisplayUtil.openInEditor(editorInput, this.fLineNumber);
                return;
            }
            MessageDialog.openInformation((Shell)DebugUiPlugin.getActiveWorkbenchShell(), (String)Messages.getString("JSConsoleHyperlink.Information"), (String)StringUtils.format((String)Messages.getString("JSConsoleHyperlink.SourceNotFoundFor_0"), (Object[])new String[]{this.fFilename}));
        }
        catch (CoreException e) {
            DebugUiPlugin.errorDialog(Messages.getString("JSConsoleHyperlink.ExceptionWhileFollowingLink"), e);
        }
    }

    private ISourceLocator getSourceLocator() {
        ILaunch launch;
        ISourceLocator sourceLocator = null;
        IProcess process = (IProcess)this.getConsole().getAttribute(IDebugUIConstants.ATTR_CONSOLE_PROCESS);
        if (process != null && (launch = process.getLaunch()) != null) {
            sourceLocator = launch.getSourceLocator();
        }
        return sourceLocator;
    }

    private TextConsole getConsole() {
        return this.fConsole;
    }
}

