/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.debug.internal.ui;

import com.aptana.ide.core.CoreStrings;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.ui.WorkbenchHelper;
import com.aptana.ide.debug.internal.ui.Messages;
import com.aptana.ide.debug.ui.DebugUiPlugin;
import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class InstallDebuggerPromptStatusHandler
implements IStatusHandler {
    public Object handleStatus(IStatus status, Object source) throws CoreException {
        Shell shell = DebugUiPlugin.getActiveWorkbenchShell();
        String title = Messages.InstallDebuggerPromptStatusHandler_InstallDebuggerExtension;
        if ("install".equals(source)) {
            MessageDialog.openInformation((Shell)shell, (String)title, (String)Messages.InstallDebuggerPromptStatusHandler_WaitbrowserLaunches_AcceptExtensionInstallation_Quit);
            return null;
        }
        if ("postinstall".equals(source)) {
            MessageDialog.openInformation((Shell)shell, (String)title, (String)Messages.InstallDebuggerPromptStatusHandler_WaitbrowserLaunches_Quit);
            return null;
        }
        if ("nopdm".equals(source)) {
            MessageDialog md = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), title, null, Messages.InstallDebuggerPromptStatusHandler_PDMNotInstalled, 4, new String[]{StringUtils.ellipsify((String)Messages.InstallDebuggerPromptStatusHandler_Download), CoreStrings.CONTINUE, CoreStrings.CANCEL, CoreStrings.HELP}, 0);
            switch (md.open()) {
                case 0: {
                    WorkbenchHelper.launchBrowser((String)"http://www.aptana.com/pro/pdm.php", (String)"org.eclipse.ui.browser.ie");
                }
                case 1: {
                    return new Boolean(true);
                }
                case 3: {
                    WorkbenchHelper.launchBrowser((String)"http://www.aptana.com/docs/index.php/Installing_the_IE_debugger");
                    return new Boolean(true);
                }
            }
            return null;
        }
        if (source instanceof String && ((String)source).startsWith("quit_")) {
            MessageDialog.openInformation((Shell)shell, (String)title, (String)StringUtils.format((String)Messages.InstallDebuggerPromptStatusHandler_BrowserIsRunning, (Object[])new String[]{((String)source).substring(5)}));
            return null;
        }
        if (source instanceof String && ((String)source).startsWith("installed_")) {
            MessageDialog.openInformation((Shell)shell, (String)title, (String)StringUtils.format((String)Messages.InstallDebuggerPromptStatusHandler_ExtensionInstalled, (Object[])new String[]{((String)source).substring(10)}));
            return null;
        }
        if (source instanceof String && ((String)source).startsWith("warning_")) {
            MessageDialog.openWarning((Shell)shell, (String)title, (String)((String)source).substring(8));
            return null;
        }
        if (source instanceof String && ((String)source).startsWith("failed_")) {
            MessageDialog md = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), title, null, MessageFormat.format(Messages.InstallDebuggerPromptStatusHandler_ExtensionInstallFailed, ((String)source).substring(7)), 1, new String[]{IDialogConstants.OK_LABEL, CoreStrings.HELP}, 0);
            while (true) {
                switch (md.open()) {
                    case 0: {
                        return null;
                    }
                }
                WorkbenchHelper.launchBrowser((String)(((String)source).indexOf("Internet Explorer") != -1 ? "http://www.aptana.com/docs/index.php/Installing_the_IE_debugger" : "http://www.aptana.com/docs/index.php/Installing_the_JavaScript_debugger"));
            }
        }
        IPreferenceStore store = DebugUiPlugin.getDefault().getPreferenceStore();
        String pref = store.getString("com.aptana.ide.debug.ui.install_debugger");
        if (pref != null && pref.equals("always")) {
            return new Boolean(true);
        }
        String message = StringUtils.format((String)Messages.InstallDebuggerPromptStatusHandler_ExtensionNotInstalled, (Object[])new String[]{(String)source});
        MessageDialogWithToggle dialog = new MessageDialogWithToggle(shell, title, null, message, 2, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, CoreStrings.HELP}, 2, null, false);
        dialog.setPrefKey("com.aptana.ide.debug.ui.install_debugger");
        dialog.setPrefStore(store);
        while (true) {
            switch (dialog.open()) {
                case 2: {
                    return new Boolean(true);
                }
                case 3: {
                    return new Boolean(false);
                }
            }
            WorkbenchHelper.launchBrowser((String)(((String)source).indexOf("Internet Explorer") != -1 ? "http://www.aptana.com/docs/index.php/Installing_the_IE_debugger" : "http://www.aptana.com/docs/index.php/Installing_the_JavaScript_debugger"));
        }
    }
}

