/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.views.outline;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.unified.ContributedOutline;
import com.aptana.ide.editors.unified.EditorFileContext;
import com.aptana.ide.editors.unified.IFileService;
import com.aptana.ide.editors.unified.IFileServiceChangeListener;
import com.aptana.ide.editors.unified.UnifiedEditor;
import com.aptana.ide.lexer.IRange;
import com.aptana.ide.parsing.nodes.IParseNode;
import com.aptana.ide.views.outline.BaseFilter;
import com.aptana.ide.views.outline.CollapseAction;
import com.aptana.ide.views.outline.FilterActionInfo;
import com.aptana.ide.views.outline.HidePrivateAction;
import com.aptana.ide.views.outline.IResolvableItem;
import com.aptana.ide.views.outline.IUnifiedOutlinePage;
import com.aptana.ide.views.outline.Messages;
import com.aptana.ide.views.outline.OutlineItem;
import com.aptana.ide.views.outline.SortAction;
import com.aptana.ide.views.outline.SplitOutlinesAction;
import com.aptana.ide.views.outline.UnifiedOutlineProvider;
import com.aptana.ide.views.outline.UnifiedViewerFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.progress.WorkbenchJob;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnifiedOutlinePage
extends ContentOutlinePage
implements ISelectionChangedListener,
IUnifiedOutlinePage {
    private static final int FILTER_REFRESH_DELAY = 200;
    private static final int REFRESH_DELAY = 500;
    private Composite _composite;
    private SashForm _outlineSash;
    private SashForm _outlineTabsSash;
    private CTabFolder _outlineTabs;
    private UnifiedEditor _editor;
    private PatternFilter _filter;
    private String _pattern;
    private WorkbenchJob _filterRefreshJob;
    private WorkbenchJob _delayedRefreshJob;
    private Text _searchBox;
    private TreeViewer _treeViewer;
    private IDocumentListener _documentListener;
    private IFileServiceChangeListener _serviceListener;
    private IDocument _document;
    private boolean _hide;
    private ActionContributionItem _sortItem;
    private ActionContributionItem _collapseItem;
    private ActionContributionItem _expandItem;
    private ActionContributionItem _hidePrivateItem;
    private ActionContributionItem _splitItem;
    private HidePrivateAction _hidePrivateAction;
    private Map<String, ContributedOutline> _outlines;
    private UnifiedOutlineProvider outlineProvider;
    private BaseFilter[] _filters;
    private IActionBars _actionBars;
    private ActionContributionItem openAction;

    public UnifiedOutlinePage(UnifiedEditor editor) {
        this._editor = editor;
        editor.getViewer().getTextWidget().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (UnifiedOutlinePage.this.outlineProvider != null) {
                    UnifiedOutlinePage.this.outlineProvider.pageActivated(UnifiedOutlinePage.this);
                }
            }
        });
        editor.getViewer().getTextWidget().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (UnifiedOutlinePage.this.outlineProvider != null) {
                    UnifiedOutlinePage.this.outlineProvider.pageClosed(UnifiedOutlinePage.this);
                }
            }
        });
        this._outlines = new HashMap<String, ContributedOutline>();
    }

    public void addOutline(ContributedOutline outline, String name) {
        this._outlines.put(name, outline);
    }

    private Composite createComposite(Composite parent) {
        GridLayout contentAreaLayout = new GridLayout();
        contentAreaLayout.numColumns = 1;
        contentAreaLayout.makeColumnsEqualWidth = false;
        contentAreaLayout.marginHeight = 0;
        contentAreaLayout.marginWidth = 0;
        contentAreaLayout.verticalSpacing = 0;
        contentAreaLayout.horizontalSpacing = 0;
        Composite result = new Composite(parent, 0);
        result.setLayout((Layout)contentAreaLayout);
        result.setLayoutData((Object)new GridData(4, 4, true, true));
        return result;
    }

    private void createContributedOutlines(CTabFolder outlineTabs, SashForm outlineSash) {
        for (String key : this._outlines.keySet()) {
            ContributedOutline outline = this._outlines.get(key);
            CTabItem tab = new CTabItem(outlineTabs, 0);
            Composite previewComp = new Composite((Composite)outlineSash, 0);
            GridLayout contentAreaLayout = new GridLayout();
            contentAreaLayout.numColumns = 1;
            contentAreaLayout.makeColumnsEqualWidth = true;
            contentAreaLayout.marginHeight = 0;
            contentAreaLayout.marginWidth = 0;
            contentAreaLayout.verticalSpacing = 0;
            contentAreaLayout.horizontalSpacing = 0;
            previewComp.setLayout((Layout)contentAreaLayout);
            previewComp.setLayoutData((Object)new GridData(4, 4, true, true));
            Label outlineLabel = new Label(previewComp, 0);
            outlineLabel.setText(key);
            outlineLabel.setLayoutData((Object)new GridData(4, 4, true, false));
            tab.setText(key);
            SashForm preForm = new SashForm((Composite)outlineTabs, 0);
            contentAreaLayout = new GridLayout();
            contentAreaLayout.numColumns = 1;
            contentAreaLayout.makeColumnsEqualWidth = false;
            contentAreaLayout.marginHeight = 0;
            contentAreaLayout.marginWidth = 0;
            contentAreaLayout.verticalSpacing = 0;
            contentAreaLayout.horizontalSpacing = 0;
            preForm.setLayout((Layout)contentAreaLayout);
            preForm.setLayoutData((Object)new GridData(4, 4, true, true));
            outline.createControl((Composite)preForm);
            tab.setControl((Control)preForm);
        }
    }

    public void createControl(Composite parent) {
        this.createControl(parent, true);
    }

    public void createControl(Composite parent, boolean createSearchArea) {
        this._composite = this.createComposite(parent);
        if (createSearchArea) {
            this.createSearchArea(this._composite, false);
        }
        this._outlineSash = this.createSash(this._composite);
        this.createSourceSash();
        this._outlineTabsSash = this.createOutlineTabs(this._composite);
        this._treeViewer = this.createTreeViewer((Composite)this._outlineTabsSash);
        this._treeViewer.addFilter((ViewerFilter)new UnifiedViewerFilter(this));
        this._filter = new PatternFilter(){

            protected boolean isLeafMatch(Viewer viewer, Object element) {
                boolean result = true;
                String label = null;
                if (element instanceof OutlineItem) {
                    label = ((OutlineItem)element).getLabel();
                } else if (element instanceof IParseNode) {
                    label = UnifiedOutlineProvider.getInstance().getText(element);
                }
                if (label != null) {
                    result = this.wordMatches(label);
                }
                return result;
            }
        };
        this._filter.setIncludeLeadingWildcard(true);
        this._treeViewer.addFilter((ViewerFilter)this._filter);
        BaseFilter[] baseFilterArray = this._filters;
        int n = 0;
        int n2 = baseFilterArray.length;
        while (n < n2) {
            BaseFilter filter = baseFilterArray[n];
            this._treeViewer.addFilter((ViewerFilter)filter);
            ++n;
        }
        this._treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this._filterRefreshJob = this.createRefreshJob();
        this._filterRefreshJob.setSystem(true);
        this._delayedRefreshJob = this.createDelayedRefreshJob();
        this._delayedRefreshJob.setSystem(true);
        this.createDocumentListener();
        this.createServiceListener();
        this._document = this._editor.getDocumentProvider().getDocument((Object)this._editor.getEditorInput());
        this._document.addDocumentListener(this._documentListener);
        this._editor.addFileServiceChangeListener(new IFileServiceChangeListener(){

            public void fileServiceChanged(IFileService newService) {
                if (UnifiedOutlinePage.this._document != null) {
                    UnifiedOutlinePage.this._document.removeDocumentListener(UnifiedOutlinePage.this._documentListener);
                }
                UnifiedOutlinePage.this._document = UnifiedOutlinePage.this._editor.getDocumentProvider().getDocument((Object)UnifiedOutlinePage.this._editor.getEditorInput());
                if (UnifiedOutlinePage.this._document != null) {
                    UnifiedOutlinePage.this._document.addDocumentListener(UnifiedOutlinePage.this._documentListener);
                }
            }
        });
        this.updateProviders();
        this.refresh();
    }

    private WorkbenchJob createDelayedRefreshJob() {
        return new WorkbenchJob("Refresh Content"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    if (UnifiedOutlinePage.this._treeViewer.getControl().isDisposed()) {
                        return Status.CANCEL_STATUS;
                    }
                    UnifiedOutlinePage.this.updateProviders();
                    UnifiedOutlinePage.this._treeViewer.setSelection(null);
                    UnifiedOutlinePage.this._treeViewer.refresh();
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)Messages.UnifiedOutlinePage_ErrorRefreshingOutline, (Throwable)e);
                }
                catch (Error e) {
                    IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)Messages.UnifiedOutlinePage_ErrorRefreshingOutline, (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
    }

    private void createDocumentListener() {
        this._documentListener = new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                if (UnifiedOutlinePage.this._delayedRefreshJob != null) {
                    UnifiedOutlinePage.this._delayedRefreshJob.cancel();
                    UnifiedOutlinePage.this._delayedRefreshJob.schedule(500L);
                }
            }
        };
    }

    private SashForm createOutlineTabs(Composite parent) {
        this._outlineTabs = new CTabFolder(parent, 1024);
        this._outlineTabs.setLayoutData((Object)new GridData(4, 4, true, true));
        SashForm sourceForm = new SashForm((Composite)this._outlineTabs, 0);
        sourceForm.setLayoutData((Object)new GridData(4, 4, true, true));
        CTabItem sourceTab = new CTabItem(this._outlineTabs, 0);
        sourceTab.setText(Messages.UnifiedOutlinePage_Source);
        sourceTab.setControl((Control)sourceForm);
        this._outlineTabs.setSelection(sourceTab);
        this.createContributedOutlines(this._outlineTabs, this._outlineSash);
        return sourceForm;
    }

    private WorkbenchJob createRefreshJob() {
        return new WorkbenchJob("Refresh Filter"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (UnifiedOutlinePage.this._treeViewer.getControl().isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                if (UnifiedOutlinePage.this._pattern == null) {
                    return Status.OK_STATUS;
                }
                UnifiedOutlinePage.this._filter.setPattern(UnifiedOutlinePage.this._pattern);
                try {
                    UnifiedOutlinePage.this._treeViewer.getControl().setRedraw(false);
                    UnifiedOutlinePage.this._treeViewer.refresh(true);
                    if (UnifiedOutlinePage.this._pattern.length() > 0) {
                        IStructuredContentProvider provider = (IStructuredContentProvider)UnifiedOutlinePage.this._treeViewer.getContentProvider();
                        Object[] elements = provider.getElements(UnifiedOutlinePage.this._treeViewer.getInput());
                        int i = 0;
                        while (i < elements.length) {
                            if (monitor.isCanceled()) {
                                IStatus iStatus = Status.CANCEL_STATUS;
                                return iStatus;
                            }
                            UnifiedOutlinePage.this._treeViewer.expandToLevel(elements[i], -1);
                            ++i;
                        }
                        TreeItem[] items = UnifiedOutlinePage.this._treeViewer.getTree().getItems();
                        if (items.length > 0) {
                            UnifiedOutlinePage.this._treeViewer.getTree().showItem(items[0]);
                        }
                    }
                }
                finally {
                    UnifiedOutlinePage.this._treeViewer.getControl().setRedraw(true);
                }
                return Status.OK_STATUS;
            }
        };
    }

    private SashForm createSash(Composite parent) {
        GridLayout contentAreaLayout = new GridLayout();
        contentAreaLayout.numColumns = 1;
        contentAreaLayout.makeColumnsEqualWidth = false;
        contentAreaLayout.marginHeight = 0;
        contentAreaLayout.marginWidth = 0;
        contentAreaLayout.verticalSpacing = 0;
        contentAreaLayout.horizontalSpacing = 0;
        GridData gridData = new GridData(4, 4, true, true);
        gridData.exclude = true;
        SashForm result = new SashForm(parent, 512);
        result.setLayoutData((Object)gridData);
        result.setLayout((Layout)contentAreaLayout);
        result.setVisible(false);
        return result;
    }

    public Composite createSearchArea(Composite parent, boolean embedded) {
        GridLayout contentAreaLayout = new GridLayout();
        contentAreaLayout.numColumns = 1;
        contentAreaLayout.makeColumnsEqualWidth = false;
        contentAreaLayout.marginHeight = 3;
        contentAreaLayout.marginWidth = 0;
        contentAreaLayout.verticalSpacing = 0;
        contentAreaLayout.horizontalSpacing = 0;
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)contentAreaLayout);
        top.setLayoutData((Object)new GridData(4, 4, true, false));
        contentAreaLayout = new GridLayout();
        contentAreaLayout.numColumns = 3;
        contentAreaLayout.makeColumnsEqualWidth = false;
        contentAreaLayout.marginHeight = 0;
        contentAreaLayout.marginWidth = 0;
        contentAreaLayout.verticalSpacing = 0;
        contentAreaLayout.horizontalSpacing = 0;
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 1;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = false;
        Composite result = new Composite(top, 0);
        result.setLayout((Layout)contentAreaLayout);
        result.setLayoutData((Object)data);
        if (!embedded) {
            Label searchLabel = new Label(result, 0);
            searchLabel.setText(Messages.UnifiedOutlinePage_Filter);
        }
        int style = 0;
        style = embedded ? 4 : 2052;
        this._searchBox = new Text(result, style);
        this._searchBox.setLayoutData((Object)new GridData(4, 4, true, false));
        this._searchBox.setEditable(true);
        this._searchBox.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                UnifiedOutlinePage.this.textChanged();
            }
        });
        this._searchBox.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000001 || e.keyCode == 0x1000002) {
                    UnifiedOutlinePage.this._treeViewer.getControl().setFocus();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        ToolBar toolBar = new ToolBar(result, 256);
        toolBar.setLayoutData((Object)new GridData(4, 4, false, true));
        ArrayList<BaseFilter> filters = new ArrayList<BaseFilter>();
        EditorFileContext fileContext = this._editor.getFileContext();
        String language = fileContext.getDefaultLanguage();
        FilterActionInfo[] filterActionInfoArray = UnifiedOutlineProvider.getInstance().getFilterActionInfos(language);
        int n = 0;
        int n2 = filterActionInfoArray.length;
        while (n < n2) {
            FilterActionInfo filterInfo = filterActionInfoArray[n];
            final BaseFilter filter = filterInfo.getFilter();
            ToolItem item = new ToolItem(toolBar, 32);
            filters.add(filter);
            item.setImage(filterInfo.getImageDescriptor().createImage());
            item.setToolTipText(filterInfo.getToolTip());
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ToolItem item = (ToolItem)e.widget;
                    filter.setActive(item.getSelection());
                    UnifiedOutlinePage.this._treeViewer.refresh(true);
                }
            });
            ++n;
        }
        this._filters = filters.toArray(new BaseFilter[filters.size()]);
        return result;
    }

    private void createServiceListener() {
        this._serviceListener = new IFileServiceChangeListener(){

            public void fileServiceChanged(IFileService newService) {
                if (UnifiedOutlinePage.this._document != null) {
                    UnifiedOutlinePage.this._document.removeDocumentListener(UnifiedOutlinePage.this._documentListener);
                }
                UnifiedOutlinePage.this._document = UnifiedOutlinePage.this._editor.getDocumentProvider().getDocument((Object)UnifiedOutlinePage.this._editor.getEditorInput());
                if (UnifiedOutlinePage.this._document != null) {
                    UnifiedOutlinePage.this._document.addDocumentListener(UnifiedOutlinePage.this._documentListener);
                }
            }
        };
    }

    private void createSourceSash() {
        Composite previewComp = new Composite((Composite)this._outlineSash, 0);
        GridLayout contentAreaLayout = new GridLayout();
        contentAreaLayout.numColumns = 1;
        contentAreaLayout.makeColumnsEqualWidth = false;
        contentAreaLayout.marginHeight = 0;
        contentAreaLayout.marginWidth = 0;
        contentAreaLayout.verticalSpacing = 0;
        contentAreaLayout.horizontalSpacing = 0;
        previewComp.setLayout((Layout)contentAreaLayout);
        previewComp.setLayoutData((Object)new GridData(4, 4, true, true));
        Label outlineLabel = new Label(previewComp, 0);
        outlineLabel.setText(Messages.UnifiedOutlinePage_Source);
        outlineLabel.setLayoutData((Object)new GridData(4, 4, true, false));
    }

    private TreeViewer createTreeViewer(Composite parent) {
        TreeViewer result = new TreeViewer(new Tree(parent, 772));
        this.outlineProvider = UnifiedOutlineProvider.getInstance();
        this.outlineProvider.setOutlinePage(this);
        result.setLabelProvider((IBaseLabelProvider)this.outlineProvider);
        result.setContentProvider((IContentProvider)this.outlineProvider);
        result.setInput((Object)this._editor);
        result.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object item;
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.size() == 1 && (item = selection.getFirstElement()) != null && item instanceof OutlineItem) {
                    OutlineItem outlineItem = (OutlineItem)selection.getFirstElement();
                    if (UnifiedOutlinePage.this._treeViewer != null && UnifiedOutlinePage.this._treeViewer.getTree() != null && !UnifiedOutlinePage.this._treeViewer.getTree().isDisposed() && UnifiedOutlinePage.this._treeViewer.getTree().isFocusControl()) {
                        UnifiedOutlinePage.this._editor.selectAndReveal(outlineItem.getStartingOffset(), 0);
                    }
                }
            }
        });
        result.setComparer(new IElementComparer(){

            public boolean equals(Object a, Object b) {
                boolean result = false;
                if (a instanceof OutlineItem && b instanceof OutlineItem) {
                    OutlineItem item1 = (OutlineItem)a;
                    OutlineItem item2 = (OutlineItem)b;
                    result = item1.equals(item2);
                } else if (a instanceof IParseNode && b instanceof IParseNode) {
                    if (a == b) {
                        result = true;
                    } else {
                        IParseNode node1 = (IParseNode)a;
                        IParseNode node2 = (IParseNode)b;
                        String path1 = node1.getUniquePath();
                        String path2 = node2.getUniquePath();
                        result = path1.equals(path2);
                    }
                } else {
                    result = a == b;
                }
                return result;
            }

            public int hashCode(Object element) {
                return 0;
            }
        });
        return result;
    }

    public void dispose() {
        super.dispose();
        if (this._delayedRefreshJob != null && this._editor != null) {
            IEditorInput editorInput = this._editor.getEditorInput();
            IDocument document = this._editor.getDocumentProvider().getDocument((Object)editorInput);
            if (document != null) {
                document.removeDocumentListener(this._documentListener);
            }
            this._editor.removeFileServiceChangeListener(this._serviceListener);
        }
    }

    @Override
    public Map<String, ContributedOutline> getContributedOutlines() {
        return this._outlines;
    }

    public Control getControl() {
        return this._composite;
    }

    @Override
    public SashForm getOutlineSash() {
        return this._outlineSash;
    }

    @Override
    public CTabFolder getOutlineTabs() {
        return this._outlineTabs;
    }

    @Override
    public TreeViewer getTreeViewer() {
        return this._treeViewer;
    }

    @Override
    public UnifiedEditor getUnifiedEditor() {
        return this._editor;
    }

    @Override
    public boolean hidePrivateMembers() {
        return this._hide;
    }

    @Override
    public void refresh() {
        if (!this._treeViewer.getControl().isDisposed()) {
            this._treeViewer.refresh();
        }
    }

    private void removeOpenActionIfNeeded() {
        if (this.openAction != null) {
            this._actionBars.getToolBarManager().remove((IContributionItem)this.openAction);
            this.openAction = null;
            this._actionBars.getToolBarManager().update(false);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        if (selection.size() == 1) {
            Object element = selection.getFirstElement();
            if (element instanceof IResolvableItem) {
                IResolvableItem item = (IResolvableItem)element;
                if (item.isResolvable()) {
                    if (this.openAction != null) {
                        this._actionBars.getToolBarManager().remove((IContributionItem)this.openAction);
                    }
                    this.openAction = new ActionContributionItem((IAction)new OpenExternalAction(item));
                    this._actionBars.getToolBarManager().add((IContributionItem)this.openAction);
                    this._actionBars.getToolBarManager().update(false);
                    while (!item.stillHighlight()) {
                        if ((item = item.getParentItem()) != null) continue;
                        return;
                    }
                    if (item instanceof IParseNode) {
                        int position = ((IParseNode)item).getStartingOffset();
                        this._editor.selectAndReveal(position, 0);
                        return;
                    }
                } else {
                    this.removeOpenActionIfNeeded();
                }
            }
            this.removeOpenActionIfNeeded();
            if (element instanceof IRange) {
                int position = ((IRange)element).getStartingOffset();
                this._editor.selectAndReveal(position, 0);
            }
        } else {
            this.removeOpenActionIfNeeded();
            this._editor.getViewer().removeRangeIndication();
        }
    }

    public void setActionBars(IActionBars actionBars) {
        if (this._outlines.size() > 0) {
            SplitOutlinesAction splitAction = new SplitOutlinesAction(this);
            splitAction.setEnabled(this._composite.isReparentable());
            this._splitItem = new ActionContributionItem((IAction)splitAction);
            actionBars.getToolBarManager().add((IContributionItem)this._splitItem);
        }
        this._actionBars = actionBars;
        SortAction sortAction = new SortAction(this);
        IPreferenceStore store = UnifiedEditorsPlugin.getDefault().getPreferenceStore();
        boolean sort = store.getBoolean("com.aptana.ide.editors.SORT_OUTLINE_ALPHABETICALLY");
        sortAction.setChecked(sort);
        if (sort) {
            this.getTreeViewer().setSorter((ViewerSorter)SortAction.SORTER);
        }
        this._sortItem = new ActionContributionItem((IAction)sortAction);
        actionBars.getToolBarManager().add((IContributionItem)this._sortItem);
        this._hidePrivateAction = new HidePrivateAction(this);
        this._hidePrivateItem = new ActionContributionItem((IAction)this._hidePrivateAction);
        actionBars.getToolBarManager().add((IContributionItem)this._hidePrivateItem);
        CollapseAction collapseAction = new CollapseAction(this);
        this._collapseItem = new ActionContributionItem((IAction)collapseAction);
        actionBars.getToolBarManager().add((IContributionItem)this._collapseItem);
        Action expandAction = new Action(Messages.UnifiedOutlinePage_ExpandAll){

            public void run() {
                UnifiedOutlinePage.this.getTreeViewer().expandAll();
            }
        };
        expandAction.setImageDescriptor(UnifiedEditorsPlugin.getImageDescriptor("icons/expandall.gif"));
        expandAction.setToolTipText(Messages.UnifiedOutlinePage_CollapseAll);
        this._expandItem = new ActionContributionItem((IAction)expandAction);
        actionBars.getToolBarManager().add((IContributionItem)this._expandItem);
        super.setActionBars(actionBars);
    }

    public void contributeToQuickOutlineMenu(IMenuManager manager) {
        if (this._outlines.size() > 0) {
            SplitOutlinesAction splitAction = new SplitOutlinesAction(this);
            splitAction.setEnabled(this._composite.isReparentable());
            this._splitItem = new ActionContributionItem((IAction)splitAction);
            manager.add((IContributionItem)this._splitItem);
        }
        SortAction sortAction = new SortAction(this);
        IPreferenceStore store = UnifiedEditorsPlugin.getDefault().getPreferenceStore();
        boolean sort = store.getBoolean("com.aptana.ide.editors.SORT_OUTLINE_ALPHABETICALLY");
        sortAction.setChecked(sort);
        if (sort) {
            this.getTreeViewer().setSorter((ViewerSorter)SortAction.SORTER);
        }
        this._sortItem = new ActionContributionItem((IAction)sortAction);
        manager.add((IContributionItem)this._sortItem);
        this._hidePrivateAction = new HidePrivateAction(this);
        this._hidePrivateItem = new ActionContributionItem((IAction)this._hidePrivateAction);
        manager.add((IContributionItem)this._hidePrivateItem);
        CollapseAction collapseAction = new CollapseAction(this);
        this._collapseItem = new ActionContributionItem((IAction)collapseAction);
        manager.add((IContributionItem)this._collapseItem);
        Action expandAction = new Action(Messages.UnifiedOutlinePage_ExpandAll){

            public void run() {
                UnifiedOutlinePage.this.getTreeViewer().expandAll();
            }
        };
        expandAction.setImageDescriptor(UnifiedEditorsPlugin.getImageDescriptor("icons/expandall.gif"));
        expandAction.setToolTipText(Messages.UnifiedOutlinePage_CollapseAll);
        this._expandItem = new ActionContributionItem((IAction)expandAction);
        manager.add((IContributionItem)this._expandItem);
    }

    public void setFocus() {
        this._treeViewer.getControl().setFocus();
    }

    public Control getSearchBox() {
        return this._searchBox;
    }

    private void textChanged() {
        this._filterRefreshJob.cancel();
        this._filterRefreshJob.schedule(200L);
        this._pattern = this._searchBox.getText();
        this._filter.setPattern(this._pattern);
        Iterator<ContributedOutline> outlineIter = this._outlines.values().iterator();
        while (outlineIter.hasNext()) {
            outlineIter.next().setFilterText(this._pattern);
        }
    }

    @Override
    public void togglePrivateMemberVisibility() {
        this._hide = !this._hide;
        this.refresh();
    }

    private void updateProviders() {
        EditorFileContext fileContext = this._editor.getFileContext();
        if (fileContext != null) {
            UnifiedOutlineProvider provider = UnifiedOutlineProvider.getInstance();
            provider.setCurrentLanguage(fileContext.getDefaultLanguage());
            provider.fireBeforeRefreshEvent(fileContext);
        }
    }

    private static final class OpenExternalAction
    extends Action {
        IResolvableItem item;
        String editorId;

        OpenExternalAction(IResolvableItem item) {
            try {
                IEditorDescriptor editorDescriptor = IDE.getEditorDescriptor((String)item.getEditorInput().getName());
                this.editorId = editorDescriptor.getId();
                this.setImageDescriptor(editorDescriptor.getImageDescriptor());
            }
            catch (PartInitException e) {
                IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)e.getMessage());
            }
            this.item = item;
            this.setToolTipText(Messages.UnifiedOutlinePage_Open);
        }

        public void run() {
            IEditorInput input = this.item.getEditorInput();
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            try {
                IEditorPart openEditor = IDE.openEditor((IWorkbenchPage)activePage, (IEditorInput)input, (String)this.editorId);
                if (openEditor instanceof ITextEditor) {
                    ITextEditor ed = (ITextEditor)openEditor;
                    if (this.item instanceof IRange) {
                        int position = ((IRange)this.item).getStartingOffset();
                        ed.selectAndReveal(position, 0);
                        return;
                    }
                    if (this.item instanceof OutlineItem) {
                        int position = ((OutlineItem)((Object)this.item)).getStartingOffset();
                        ed.selectAndReveal(position, 0);
                        return;
                    }
                }
                return;
            }
            catch (PartInitException e) {
                IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)e.getMessage());
                return;
            }
        }
    }
}

