/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.unified.folding;

import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.unified.IUnifiedEditor;
import com.aptana.ide.editors.unified.UnifiedEditor;
import com.aptana.ide.editors.unified.folding.IFoldingContextHandler;
import com.aptana.ide.editors.unified.folding.LanguageProjectAnnotation;
import com.aptana.ide.editors.unified.folding.Messages;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.texteditor.ITextEditor;

public final class FoldingExtensionPointLoader {
    public static final String EXPAND_CURRENT_ACTION_ID = "org.eclipse.ui.edit.text.folding.expand";
    public static final String COLLAPSE_CURRENT_ACTION_ID = "org.eclipse.ui.edit.text.folding.collapse";
    private Map structs = new HashMap();
    private static FoldingExtensionPointLoader instance;

    private FoldingExtensionPointLoader() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint ep = reg.getExtensionPoint("com.aptana.ide.editors.folding");
        if (ep != null && ep.getExtensions() != null) {
            IExtension[] extensions = ep.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] ce = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < ce.length) {
                    String language = ce[j].getAttribute("language");
                    String label = ce[j].getAttribute("label");
                    String foldParents = ce[j].getAttribute("foldAllParents");
                    if (language != null && label != null) {
                        FoldingStructure fs = null;
                        if (this.structs.containsKey(language)) {
                            fs = (FoldingStructure)this.structs.get(language);
                        } else {
                            fs = new FoldingStructure();
                            this.structs.put(language, fs);
                        }
                        fs.language = language;
                        fs.label = label;
                        fs.foldAllParents = Boolean.valueOf(foldParents);
                        String handlerClass = ce[j].getAttribute("contextHandler");
                        if (handlerClass != null) {
                            try {
                                Object obj = ce[j].createExecutableExtension("contextHandler");
                                if (obj instanceof IFoldingContextHandler) {
                                    fs.handler = (IFoldingContextHandler)obj;
                                }
                            }
                            catch (CoreException coreException) {}
                        }
                        IConfigurationElement[] types = ce[j].getChildren("type");
                        int k = 0;
                        while (k < types.length) {
                            String name = types[k].getAttribute("name");
                            String typeLabel = types[k].getAttribute("label");
                            if (name != null) {
                                fs.types.put(name, typeLabel);
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public static FoldingExtensionPointLoader getInstance() {
        if (instance == null) {
            instance = new FoldingExtensionPointLoader();
        }
        return instance;
    }

    public static void createFoldingActions(final UnifiedEditor editor) {
        FoldingExtensionPointLoader loader = FoldingExtensionPointLoader.getInstance();
        String[] supportedTypes = editor.getBaseContributor().getContentTypes();
        FoldingAction fAllCollapseAll = new FoldingAction(Messages.FoldingExtensionPointLoader_10, 1){

            public void run() {
                ProjectionViewer viewer;
                if (editor.getViewer() != null && editor.getViewer() instanceof ProjectionViewer && (viewer = (ProjectionViewer)editor.getViewer()).canDoOperation(21)) {
                    viewer.doOperation(21);
                }
            }
        };
        editor.setAction(FoldingExtensionPointLoader.createCollapseAllActionId(), (IAction)fAllCollapseAll);
        FoldingAction fAllExpandAll = new FoldingAction(Messages.FoldingExtensionPointLoader_11, 1){

            public void run() {
                ProjectionViewer viewer;
                if (editor.getViewer() != null && editor.getViewer() instanceof ProjectionViewer && (viewer = (ProjectionViewer)editor.getViewer()).canDoOperation(20)) {
                    viewer.doOperation(20);
                }
            }
        };
        editor.setAction(FoldingExtensionPointLoader.createExpandAllActionId(), (IAction)fAllExpandAll);
        FoldingAction fExpandCurrent = new FoldingAction(Messages.FoldingExtensionPointLoader_12, 1){

            public void run() {
                ISelection selection;
                ProjectionViewer viewer;
                if (editor.getViewer() != null && editor.getViewer() instanceof ProjectionViewer && (viewer = (ProjectionViewer)editor.getViewer()).getProjectionAnnotationModel() != null && (selection = viewer.getSelection()) != null && selection instanceof TextSelection) {
                    TextSelection textSelection = (TextSelection)selection;
                    ProjectionAnnotationModel model = viewer.getProjectionAnnotationModel();
                    model.expandAll(textSelection.getOffset(), textSelection.getLength());
                }
            }
        };
        fExpandCurrent.setActionDefinitionId(EXPAND_CURRENT_ACTION_ID);
        editor.setAction(FoldingExtensionPointLoader.createExpandCurrentActionId(), (IAction)fExpandCurrent);
        FoldingAction fCollapseCurrent = new FoldingAction(Messages.FoldingExtensionPointLoader_13, 1){

            public void run() {
                ISelection selection;
                ProjectionViewer viewer;
                if (editor.getViewer() != null && editor.getViewer() instanceof ProjectionViewer && (viewer = (ProjectionViewer)editor.getViewer()).getProjectionAnnotationModel() != null && (selection = viewer.getSelection()) != null && selection instanceof TextSelection) {
                    TextSelection cfr_ignored_0 = (TextSelection)selection;
                    ProjectionAnnotationModel model = viewer.getProjectionAnnotationModel();
                    Iterator iterator = model.getAnnotationIterator();
                    ArrayList<AnnotationPosition> annotations = new ArrayList<AnnotationPosition>();
                    while (iterator.hasNext()) {
                        Position position;
                        ProjectionAnnotation annotation = (ProjectionAnnotation)iterator.next();
                        if (annotation.isCollapsed() || (position = model.getPosition((Annotation)annotation)) == null || !position.overlapsWith(position.getOffset(), position.getLength())) continue;
                        annotations.add(new AnnotationPosition(position, (Annotation)annotation));
                    }
                    if (annotations.size() != 0) {
                        model.collapse(((AnnotationPosition)annotations.get(annotations.size() - 1)).getAnnotation());
                    }
                }
            }
        };
        fCollapseCurrent.setActionDefinitionId(COLLAPSE_CURRENT_ACTION_ID);
        editor.setAction(FoldingExtensionPointLoader.createCollapseCurrentActionId(), (IAction)fCollapseCurrent);
        int i = 0;
        while (i < supportedTypes.length) {
            if (loader.structs.containsKey(supportedTypes[i])) {
                final FoldingStructure fs = (FoldingStructure)loader.structs.get(supportedTypes[i]);
                final String prefID = FoldingExtensionPointLoader.createEnablePreferenceId(fs.language);
                final FoldingAction fExpandAll = new FoldingAction(Messages.FoldingExtensionPointLoader_14, 1){

                    public void run() {
                        ProjectionViewer viewer;
                        if (editor.getViewer() != null && editor.getViewer() instanceof ProjectionViewer && (viewer = (ProjectionViewer)editor.getViewer()).getProjectionAnnotationModel() != null) {
                            ArrayList<LanguageProjectAnnotation> mods = new ArrayList<LanguageProjectAnnotation>();
                            Iterator annotationIterator = viewer.getProjectionAnnotationModel().getAnnotationIterator();
                            if (annotationIterator != null) {
                                while (annotationIterator.hasNext()) {
                                    LanguageProjectAnnotation lpa;
                                    Annotation annotation = (Annotation)annotationIterator.next();
                                    if (!(annotation instanceof LanguageProjectAnnotation) || !fs.language.equals((lpa = (LanguageProjectAnnotation)annotation).getLanguage()) || !lpa.isCollapsed()) continue;
                                    lpa.markExpanded();
                                    mods.add(lpa);
                                }
                                viewer.getProjectionAnnotationModel().modifyAnnotations(null, null, mods.toArray(new Annotation[mods.size()]));
                            }
                        }
                    }
                };
                editor.setAction(FoldingExtensionPointLoader.createExpandAllActionId(fs.language), (IAction)fExpandAll);
                final FoldingAction fCollapseAll = new FoldingAction(Messages.FoldingExtensionPointLoader_15, 1){

                    public void run() {
                        ProjectionViewer viewer;
                        if (editor.getViewer() != null && editor.getViewer() instanceof ProjectionViewer && (viewer = (ProjectionViewer)editor.getViewer()).getProjectionAnnotationModel() != null) {
                            ArrayList<LanguageProjectAnnotation> mods = new ArrayList<LanguageProjectAnnotation>();
                            Iterator annotationIterator = viewer.getProjectionAnnotationModel().getAnnotationIterator();
                            if (annotationIterator != null) {
                                while (annotationIterator.hasNext()) {
                                    LanguageProjectAnnotation lpa;
                                    Annotation annotation = (Annotation)annotationIterator.next();
                                    if (!(annotation instanceof LanguageProjectAnnotation) || !fs.language.equals((lpa = (LanguageProjectAnnotation)annotation).getLanguage()) || lpa.isCollapsed()) continue;
                                    lpa.markCollapsed();
                                    mods.add(lpa);
                                }
                                viewer.getProjectionAnnotationModel().modifyAnnotations(null, null, mods.toArray(new Annotation[mods.size()]));
                            }
                        }
                    }
                };
                editor.setAction(FoldingExtensionPointLoader.createCollapseAllActionId(fs.language), (IAction)fCollapseAll);
                FoldingAction fToggle = new FoldingAction("Enable Folding", 2){

                    public void run() {
                        UnifiedEditorsPlugin.getDefault().getPreferenceStore().setValue(prefID, this.isChecked());
                        fCollapseAll.setEnabled(this.isChecked());
                        fExpandAll.setEnabled(this.isChecked());
                    }
                };
                fToggle.setEnabled(true);
                fToggle.setChecked(true);
                editor.setAction(FoldingExtensionPointLoader.createToggleActionId(fs.language), (IAction)fToggle);
                for (String name : fs.types.keySet()) {
                    String label = (String)fs.types.get(name);
                    if (label == null) continue;
                    FoldingAction nameExpandAction = new FoldingAction(String.valueOf(Messages.FoldingExtensionPointLoader_16) + label, 1){

                        public void run() {
                            super.run();
                        }
                    };
                    editor.setAction(FoldingExtensionPointLoader.createExpandActionId(fs.language, name), (IAction)nameExpandAction);
                    FoldingAction nameCollapseAction = new FoldingAction(String.valueOf(Messages.FoldingExtensionPointLoader_17) + label, 1){

                        public void run() {
                            super.run();
                        }
                    };
                    editor.setAction(FoldingExtensionPointLoader.createCollapseActionId(fs.language, name), (IAction)nameCollapseAction);
                }
            }
            ++i;
        }
    }

    public static Map loadChildTypes(UnifiedEditor editor) {
        HashMap<String, FoldingStructure> childTypes = new HashMap<String, FoldingStructure>();
        FoldingExtensionPointLoader loader = FoldingExtensionPointLoader.getInstance();
        Iterator iter = loader.structs.keySet().iterator();
        while (iter.hasNext()) {
            FoldingStructure fs = (FoldingStructure)loader.structs.get(iter.next());
            boolean containsLanguage = false;
            String[] supportedTypes = editor.getBaseContributor().getContentTypes();
            int i = 0;
            while (i < supportedTypes.length) {
                if (fs.language.equals(supportedTypes[i])) {
                    containsLanguage = true;
                    break;
                }
                ++i;
            }
            if (!containsLanguage) continue;
            childTypes.put(fs.language, fs);
        }
        return childTypes;
    }

    public static void registerKeyBindings(ITextEditor editor, IKeyBindingService service) {
        IAction fExpandCurrentAction = editor.getAction(FoldingExtensionPointLoader.createExpandCurrentActionId());
        if (fExpandCurrentAction != null) {
            service.registerAction(fExpandCurrentAction);
        }
    }

    private static String createCollapseAllActionId() {
        return "FoldingCollapseAllLanguages";
    }

    private static String createExpandAllActionId() {
        return "FoldingExpandAllLanguages";
    }

    private static String createExpandCurrentActionId() {
        return "FoldingExpandCurrent";
    }

    private static String createCollapseCurrentActionId() {
        return "FoldingECollapseCurrent";
    }

    private static String createCollapseActionId(String language, String name) {
        return "FoldingCollapse" + language + name;
    }

    private static String createExpandActionId(String language, String name) {
        return "FoldingExpand" + language + name;
    }

    private static String createToggleActionId(String language) {
        return "FoldingToggle" + language;
    }

    private static String createCollapseAllActionId(String language) {
        return "FoldingCollapseAll" + language;
    }

    private static String createExpandAllActionId(String language) {
        return "FoldingExpandAll" + language;
    }

    public static String createEnablePreferenceId(String language) {
        return "com.aptana.ide.editors.EDITOR_FOLDING_ENABLED." + language;
    }

    public static String createInitialFoldingPreferenceId(String language, String name) {
        return "com.aptana.ide.editor.INITIAL_FOLDING_ENABLED." + language + "." + name;
    }

    private static void updateLanguageActions(ITextEditor editor, FoldingStructure fs) {
        IAction cAction;
        IAction eAction;
        IPreferenceStore store = UnifiedEditorsPlugin.getDefault().getPreferenceStore();
        String prefId = FoldingExtensionPointLoader.createEnablePreferenceId(fs.language);
        boolean fold = store.getBoolean(prefId);
        IAction tAction = editor.getAction(FoldingExtensionPointLoader.createToggleActionId(fs.language));
        if (tAction != null) {
            tAction.setChecked(fold);
            tAction.setEnabled(true);
        }
        if ((eAction = editor.getAction(FoldingExtensionPointLoader.createExpandAllActionId(fs.language))) != null) {
            eAction.setEnabled(fold);
        }
        if ((cAction = editor.getAction(FoldingExtensionPointLoader.createCollapseAllActionId(fs.language))) != null) {
            cAction.setEnabled(fold);
        }
        for (String name : fs.types.keySet()) {
            IAction cnAction;
            IAction enAction = editor.getAction(FoldingExtensionPointLoader.createExpandActionId(fs.language, name));
            if (enAction != null) {
                enAction.setEnabled(fold);
            }
            if ((cnAction = editor.getAction(FoldingExtensionPointLoader.createCollapseActionId(fs.language, name))) == null) continue;
            cnAction.setEnabled(fold);
        }
    }

    public static void updateActions(IUnifiedEditor editor) {
        FoldingExtensionPointLoader loader = FoldingExtensionPointLoader.getInstance();
        String[] supportedTypes = editor.getBaseContributor().getContentTypes();
        if (editor instanceof ITextEditor) {
            ITextEditor tEditor = (ITextEditor)editor;
            if (supportedTypes.length == 1 && loader.structs.containsKey(supportedTypes[0])) {
                FoldingStructure fs = (FoldingStructure)loader.structs.get(supportedTypes[0]);
                FoldingExtensionPointLoader.updateLanguageActions(tEditor, fs);
            } else {
                int i = 0;
                while (i < supportedTypes.length) {
                    if (loader.structs.containsKey(supportedTypes[i])) {
                        FoldingStructure fs = (FoldingStructure)loader.structs.get(supportedTypes[i]);
                        FoldingExtensionPointLoader.updateLanguageActions(tEditor, fs);
                    }
                    ++i;
                }
            }
        }
    }

    public static void fillRulerContextMenu(UnifiedEditor editor, IMenuManager menu) {
        FoldingExtensionPointLoader loader = FoldingExtensionPointLoader.getInstance();
        MenuManager foldingMenu = new MenuManager("Folding", "projection");
        menu.appendToGroup("rulers", (IContributionItem)foldingMenu);
        String[] supportedTypes = editor.getBaseContributor().getContentTypes();
        FoldingExtensionPointLoader.updateActions(editor);
        if (supportedTypes.length == 1) {
            FoldingStructure fs = (FoldingStructure)loader.structs.get(supportedTypes[0]);
            if (fs != null) {
                FoldingExtensionPointLoader.addFoldingStructureAction((IMenuManager)foldingMenu, fs, editor);
            }
        } else {
            IAction action = editor.getAction(FoldingExtensionPointLoader.createExpandAllActionId());
            if (action != null) {
                foldingMenu.add(action);
            }
            if ((action = editor.getAction(FoldingExtensionPointLoader.createCollapseAllActionId())) != null) {
                foldingMenu.add(action);
            }
            Iterator iter = loader.structs.keySet().iterator();
            while (iter.hasNext()) {
                FoldingStructure fs = (FoldingStructure)loader.structs.get(iter.next());
                boolean containsLanguage = false;
                int i = 0;
                while (i < supportedTypes.length) {
                    if (fs.language.equals(supportedTypes[i])) {
                        containsLanguage = true;
                        break;
                    }
                    ++i;
                }
                if (!containsLanguage) continue;
                MenuManager languageMenu = new MenuManager(fs.label, fs.language);
                foldingMenu.add((IContributionItem)languageMenu);
                FoldingExtensionPointLoader.addFoldingStructureAction((IMenuManager)languageMenu, fs, editor);
            }
        }
    }

    private static void addFoldingStructureAction(IMenuManager parent, FoldingStructure fs, UnifiedEditor editor) {
        IAction action = editor.getAction(FoldingExtensionPointLoader.createToggleActionId(fs.language));
        if (action != null) {
            parent.add(action);
        }
        if ((action = editor.getAction(FoldingExtensionPointLoader.createExpandAllActionId(fs.language))) != null) {
            parent.add(action);
        }
        if ((action = editor.getAction(FoldingExtensionPointLoader.createCollapseAllActionId(fs.language))) != null) {
            parent.add(action);
        }
        for (String name : fs.types.keySet()) {
            action = editor.getAction(FoldingExtensionPointLoader.createExpandActionId(fs.language, name));
            if (action != null) {
                parent.add(action);
            }
            if ((action = editor.getAction(FoldingExtensionPointLoader.createCollapseActionId(fs.language, name))) == null) continue;
            parent.add(action);
        }
    }

    public static void collapseAll(ProjectionAnnotationModel model, String lang, String node) {
        Iterator annotationIterator = model.getAnnotationIterator();
        while (annotationIterator.hasNext()) {
            LanguageProjectAnnotation projectionAnnotation;
            Annotation annotation = (Annotation)annotationIterator.next();
            if (!(annotation instanceof LanguageProjectAnnotation) || !(projectionAnnotation = (LanguageProjectAnnotation)annotation).getLanguage().equals(lang) || !projectionAnnotation.getNodeType().equals(node)) continue;
            model.collapse(annotation);
        }
    }

    public static void expandAll(ProjectionAnnotationModel model, String lang, String node) {
        Iterator annotationIterator = model.getAnnotationIterator();
        while (annotationIterator.hasNext()) {
            LanguageProjectAnnotation projectionAnnotation;
            Annotation annotation = (Annotation)annotationIterator.next();
            if (!(annotation instanceof LanguageProjectAnnotation) || !(projectionAnnotation = (LanguageProjectAnnotation)annotation).getLanguage().equals(lang) || !projectionAnnotation.getNodeType().equals(node)) continue;
            model.expand(annotation);
        }
    }

    public class FoldingStructure {
        String language;
        String label;
        IFoldingContextHandler handler;
        Map types = new HashMap();
        boolean foldAllParents = true;

        public boolean foldAllParents() {
            return this.foldAllParents;
        }

        public void setFoldAllParents(boolean foldAllParents) {
            this.foldAllParents = foldAllParents;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getLanguage() {
            return this.language;
        }

        public void setLanguage(String language) {
            this.language = language;
        }

        public Map getTypes() {
            return this.types;
        }

        public void setTypes(Map types) {
            this.types = types;
        }

        public boolean isFoldAllParents() {
            return this.foldAllParents;
        }

        public IFoldingContextHandler getHandler() {
            return this.handler;
        }

        public void setHandler(IFoldingContextHandler handler) {
            this.handler = handler;
        }
    }

    private static abstract class FoldingAction
    extends Action {
        public FoldingAction(String name, int style) {
            super(name, style);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AnnotationPosition
    implements Comparable<AnnotationPosition> {
        private Position position;
        private Annotation annotation;

        public AnnotationPosition(Position position, Annotation annotation) {
            this.position = position;
            this.annotation = annotation;
        }

        public Position getPosition() {
            return this.position;
        }

        public Annotation getAnnotation() {
            return this.annotation;
        }

        @Override
        public int compareTo(AnnotationPosition o) {
            return o.getPosition().getLength() - this.getPosition().getLength();
        }
    }
}

