/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.unified.context;

import com.aptana.ide.editors.unified.context.LexemeOffsetComparator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import org.eclipse.swt.graphics.Image;

public class ContextItem {
    private static LexemeOffsetComparator lexemeOffsetComparator = new LexemeOffsetComparator();
    private ArrayList children = null;
    private ContextItem[] currentItems = null;
    public String name = null;
    public int offset = -1;
    public int length = -1;
    public Hashtable values = null;
    public Image icon = null;
    public String doc = null;

    public String getName() {
        return this.name;
    }

    public void setName(String s) {
        this.name = s;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int i) {
        this.offset = i;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int i) {
        this.length = i;
    }

    public ContextItem() {
        this(null);
    }

    public ContextItem(String name) {
        this.name = name;
        this.values = new Hashtable();
        this.children = new ArrayList();
    }

    public ContextItem[] getItems() {
        ContextItem[] items = this.getItems(null);
        Arrays.sort(items, lexemeOffsetComparator);
        return items;
    }

    public ContextItem[] getItems(String startsWith) {
        if (this.currentItems == null) {
            this.currentItems = this.buildCurrentItems();
        }
        if (startsWith == null) {
            return this.currentItems;
        }
        ArrayList<ContextItem> results = new ArrayList<ContextItem>();
        int i = 0;
        while (i < this.currentItems.length) {
            if (this.currentItems[i].name.startsWith(startsWith)) {
                results.add(this.currentItems[i]);
            }
            ++i;
        }
        return results.toArray(new ContextItem[0]);
    }

    public ContextItem containsItem(String name) {
        int i = 0;
        while (i < this.children.size()) {
            ContextItem item = (ContextItem)this.children.get(i);
            if (item.name.equals(name)) {
                return item;
            }
            ++i;
        }
        return null;
    }

    private ContextItem[] buildCurrentItems() {
        ArrayList<ContextItem> results = new ArrayList<ContextItem>();
        ContextItem[] items = this.children.toArray(new ContextItem[0]);
        int i = 0;
        while (i < items.length) {
            results.add(items[i]);
            ++i;
        }
        return results.toArray(new ContextItem[0]);
    }

    public void addItem(ContextItem item) {
        this.children.add(item);
        this.currentItems = null;
    }

    public void clearAll() {
        this.children.clear();
        this.currentItems = null;
    }

    public void dispose() {
        if (this.icon != null) {
            this.icon.dispose();
        }
    }
}

