/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.unified.colorizer;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.ui.PreferenceUtils;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.preferences.ColorCellEditor;
import com.aptana.ide.editors.preferences.ColorizationScrolledComposite;
import com.aptana.ide.editors.preferences.RegionSorter;
import com.aptana.ide.editors.unified.UnifiedColorManager;
import com.aptana.ide.editors.unified.colorizer.ColorizationStyle;
import com.aptana.ide.editors.unified.colorizer.IErrorHandler;
import com.aptana.ide.editors.unified.colorizer.LanguageStructureProvider;
import com.aptana.ide.editors.unified.colorizer.Region;
import com.aptana.ide.lexer.IToken;
import com.aptana.ide.lexer.LexerException;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;

public class LanguageColorizationWidget {
    private ColorizationScrolledComposite scrolls;
    private ExpandableComposite regionExpandable;
    private ExpandableComposite tokenExpandable;
    private ExpandableComposite editorExpandable;
    private Label description;
    private Composite displayArea;
    private TreeViewer viewer;
    private Tree tree;
    private Table table;
    private TableViewer regionViewer;
    private RGB black;
    private LanguageStructureProvider provider;
    private Button importButton;
    private Button exportButton;
    private Button remove;
    private Button addRegion;
    private Button override;
    private ColorSelector backgroundSelector;
    private ColorSelector lineHighlightSelector;
    private ColorSelector selectionForegroundSelector;
    private ColorSelector selectionBackgroundSelector;
    private ColorSelector foldingBackgroundSelector;
    private ColorSelector foldingForegroundSelector;
    private ColorSelector caretSelector;
    private Composite mainComp;
    private IErrorHandler errorHandler;
    private static final Object INPUT = new Object();
    private static final String[] COLUMNS = new String[]{"Category", "!", "Token", "R", "FG", "B", "I", "U"};
    private static final String[] REGION_COLUMNS = new String[]{"Name", "Offset", "Length", "FG", "B", "I", "U"};
    private static final String[] REGION_TABLE_COLUMNS = new String[]{"Name", "Offset", "Length", "", "", "", ""};
    private static final int ICON_COLUMN_WIDTH = 17;
    private IStructuredContentProvider regionContentProvider = new IStructuredContentProvider(){

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Map) {
                Map map = (Map)inputElement;
                return map.values().toArray();
            }
            return null;
        }
    };
    private ITableLabelProvider nullLabelProvider = new ITableLabelProvider(){

        public void removeListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void dispose() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public String getColumnText(Object element, int columnIndex) {
            return "";
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    };
    private ITreeContentProvider nullContentProvider = new ITreeContentProvider(){

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return new Object[0];
        }

        public boolean hasChildren(Object element) {
            return false;
        }

        public Object getParent(Object element) {
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            return new Object[0];
        }
    };
    private ITableLabelProvider regionLabelProvider = new ITableLabelProvider(){
        private Map imageMap = new HashMap();

        public void removeListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void dispose() {
            Iterator iter = this.imageMap.values().iterator();
            while (iter.hasNext()) {
                ((Image)iter.next()).dispose();
            }
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public String getColumnText(Object element, int columnIndex) {
            Region region = (Region)element;
            if (columnIndex == 0) {
                return region.getName();
            }
            if (columnIndex == 1) {
                return region.getOffsetString();
            }
            if (columnIndex == 2) {
                return region.getLengthString();
            }
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            Region region = (Region)element;
            ColorizationStyle style = region.getStyle();
            if (columnIndex == 3 && style != null) {
                Color fg = style.getForegroundColor();
                Image img = null;
                if (!this.imageMap.containsKey(fg.getRGB())) {
                    img = new Image((Device)Display.getCurrent(), 16, 16);
                    GC gc = new GC((Drawable)img);
                    gc.setBackground(fg);
                    gc.fillRectangle(1, 1, 13, 13);
                    gc.setForeground(UnifiedColorManager.getInstance().getColor(new RGB(0, 0, 0)));
                    gc.drawRectangle(1, 1, 13, 13);
                    gc.dispose();
                    this.imageMap.put(fg.getRGB(), img);
                } else {
                    img = (Image)this.imageMap.get(fg.getRGB());
                }
                return img;
            }
            if (columnIndex == 4) {
                if (style != null && style.isBold()) {
                    return UnifiedEditorsPlugin.getImage("icons/bold_on.gif");
                }
                return UnifiedEditorsPlugin.getImage("icons/bold_off.gif");
            }
            if (columnIndex == 5) {
                if (style != null && style.isItalic()) {
                    return UnifiedEditorsPlugin.getImage("icons/italic_on.gif");
                }
                return UnifiedEditorsPlugin.getImage("icons/italic_off.gif");
            }
            if (columnIndex == 6) {
                if (style != null && style.isUnderline()) {
                    return UnifiedEditorsPlugin.getImage("icons/underline_on.gif");
                }
                return UnifiedEditorsPlugin.getImage("icons/underline_off.gif");
            }
            return null;
        }
    };
    private ICellModifier regionModifier = new ICellModifier(){

        public void modify(Object element, String property, Object value) {
            if (element instanceof Item) {
                element = ((Item)element).getData();
            }
            ColorizationStyle style = null;
            if (element instanceof Region) {
                style = ((Region)element).getStyle();
            }
            if (style != null) {
                if (value instanceof Boolean) {
                    Boolean bool = (Boolean)value;
                    if (property == REGION_COLUMNS[4]) {
                        style.setBold(bool);
                    } else if (property == REGION_COLUMNS[5]) {
                        style.setItalic(bool);
                    } else if (property == REGION_COLUMNS[6]) {
                        style.setUnderline(bool);
                    }
                } else if (value instanceof RGB) {
                    RGB rgb = (RGB)value;
                    if (property == REGION_COLUMNS[3]) {
                        style.setForegroundColor(UnifiedColorManager.getInstance().getColor(rgb));
                    }
                } else if (value instanceof String) {
                    String text = (String)value;
                    Region region = (Region)element;
                    if (property == REGION_COLUMNS[0]) {
                        IToken token = (IToken)LanguageColorizationWidget.this.viewer.getTree().getSelection()[0].getData();
                        LanguageColorizationWidget.this.provider.removeRegion(token, region.getName());
                        region.setName(text);
                        LanguageColorizationWidget.this.provider.addRegion(token, region);
                    } else if (property == REGION_COLUMNS[1]) {
                        boolean offsetRelative = false;
                        try {
                            int offsetInt;
                            if (text.startsWith("LENGTH")) {
                                offsetInt = Integer.parseInt(text.substring("LENGTH".length(), text.length()));
                                offsetRelative = true;
                            } else {
                                offsetInt = Integer.parseInt(text);
                            }
                            region.setOffset(offsetInt);
                            region.setRelativeOffset(offsetRelative);
                            region.setOffsetString(text);
                        }
                        catch (Exception exception) {}
                    } else if (property == REGION_COLUMNS[2]) {
                        boolean lengthRelative = false;
                        try {
                            int lengthInt;
                            if (text.startsWith("LENGTH")) {
                                lengthInt = Integer.parseInt(text.substring("LENGTH".length(), text.length()));
                                lengthRelative = true;
                            } else {
                                lengthInt = Integer.parseInt(text);
                            }
                            region.setLength(lengthInt);
                            region.setRelativeLength(lengthRelative);
                            region.setLengthString(text);
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            LanguageColorizationWidget.this.regionViewer.update(element, null);
        }

        public Object getValue(Object element, String property) {
            ColorizationStyle style = null;
            if (element instanceof Region) {
                style = ((Region)element).getStyle();
            }
            if (style != null) {
                if (property == REGION_COLUMNS[0]) {
                    return ((Region)element).getName();
                }
                if (property == REGION_COLUMNS[1]) {
                    return ((Region)element).getOffsetString();
                }
                if (property == REGION_COLUMNS[2]) {
                    return ((Region)element).getLengthString();
                }
                if (property == REGION_COLUMNS[3]) {
                    return style.getForegroundColor().getRGB();
                }
                if (property == REGION_COLUMNS[4]) {
                    return style.isBold();
                }
                if (property == REGION_COLUMNS[5]) {
                    return style.isItalic();
                }
                if (property == REGION_COLUMNS[6]) {
                    return style.isUnderline();
                }
            }
            return null;
        }

        public boolean canModify(Object element, String property) {
            return true;
        }
    };

    public void dispose() {
        if (this.provider != null) {
            this.provider.disposeImages();
        }
        this.regionLabelProvider.dispose();
    }

    public void createControl(Composite parent, GridData mainCompositeData) {
        this.black = new RGB(0, 0, 0);
        this.mainComp = new Composite(parent, 0);
        this.mainComp.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.mainComp.setLayout((Layout)layout);
        this.mainComp.setLayoutData((Object)mainCompositeData);
        this.scrolls = new ColorizationScrolledComposite(this.mainComp);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = false;
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 5;
        this.scrolls.setLayout((Layout)layout);
        GridData gridData = new GridData(4, 4, true, true);
        this.scrolls.setLayoutData(gridData);
        this.displayArea = this.scrolls.getBody();
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = false;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 10;
        layout.horizontalSpacing = 0;
        this.displayArea.setLayout((Layout)layout);
        this.displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.description = new Label(this.displayArea, 64);
        this.description.setText("Colorize the language");
        this.styleImportExport();
        this.styleEditorOptions();
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this.tokenExpandable = new ExpandableComposite(this.displayArea, 0, 18);
        this.tokenExpandable.setText("Tokens");
        this.tokenExpandable.setLayoutData((Object)new GridData(4, 4, true, false));
        this.tokenExpandable.setLayout((Layout)gridLayout);
        this.tokenExpandable.setExpanded(UnifiedEditorsPlugin.getDefault().getPreferenceStore().getBoolean("com.aptana.ide.editors.EXPAND_TOKENS"));
        this.tokenExpandable.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                LanguageColorizationWidget.this.expandedStateChanged((ExpandableComposite)e.getSource());
            }
        });
        this.makeScrollableCompositeAware((Control)this.tokenExpandable);
        Composite inner = new Composite((Composite)this.tokenExpandable, 0);
        inner.setLayout((Layout)gridLayout);
        this.tokenExpandable.setClient((Control)inner);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this.tree = new Tree(inner, 68100);
        this.tree.setHeaderVisible(false);
        this.tree.setLinesVisible(false);
        GridData treeLayoutData = new GridData(4, 4, true, true);
        treeLayoutData.heightHint = this.tree.getItemHeight() * 16;
        treeLayoutData.widthHint = 300;
        this.tree.setLayoutData((Object)treeLayoutData);
        this.tree.setLayout((Layout)gridLayout);
        this.viewer = new TreeViewer(this.tree);
        this.viewer.setAutoExpandLevel(2);
        this.styleCells();
        this.tree.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private Map empty = new HashMap();

            public void widgetSelected(SelectionEvent e) {
                Object data = LanguageColorizationWidget.this.viewer.getTree().getSelection()[0].getData();
                LanguageColorizationWidget.this.remove.setEnabled(false);
                if (data instanceof IToken) {
                    Map regionMap = LanguageColorizationWidget.this.provider.getRegions((IToken)data);
                    LanguageColorizationWidget.this.regionViewer.setInput((Object)regionMap);
                    LanguageColorizationWidget.this.addRegion.setEnabled(LanguageColorizationWidget.this.provider.getStyle((IToken)data) != null);
                } else {
                    LanguageColorizationWidget.this.addRegion.setEnabled(false);
                    LanguageColorizationWidget.this.regionViewer.setInput((Object)this.empty);
                }
            }
        });
        this.loadRegions();
    }

    public Control getControl() {
        return this.mainComp;
    }

    private void loadEditorOptions() {
        if (this.provider != null) {
            this.override.setSelection(this.provider.getBackgroundColor() != null && this.provider.getCaretColor() != null && this.provider.getLineHighlightColor() != null && this.provider.getSelectionForegroundColor() != null && this.provider.getSelectionBackgroundColor() != null);
        } else {
            this.override.setSelection(false);
        }
        this.backgroundSelector.setColorValue(this.override.getSelection() ? this.provider.getBackgroundColor().getRGB() : this.black);
        this.backgroundSelector.setEnabled(this.override.getSelection());
        this.caretSelector.setColorValue(this.override.getSelection() ? this.provider.getCaretColor().getRGB() : this.black);
        this.caretSelector.setEnabled(this.override.getSelection());
        this.lineHighlightSelector.setColorValue(this.override.getSelection() ? this.provider.getLineHighlightColor().getRGB() : this.black);
        this.lineHighlightSelector.setEnabled(this.override.getSelection());
        this.selectionForegroundSelector.setColorValue(this.override.getSelection() ? this.provider.getSelectionForegroundColor().getRGB() : this.black);
        this.selectionForegroundSelector.setEnabled(this.override.getSelection());
        this.selectionBackgroundSelector.setColorValue(this.override.getSelection() ? this.provider.getSelectionBackgroundColor().getRGB() : this.black);
        this.selectionBackgroundSelector.setEnabled(this.override.getSelection());
        this.foldingBackgroundSelector.setColorValue(this.override.getSelection() && this.provider.getFoldingBackgroundColor() != null ? this.provider.getFoldingBackgroundColor().getRGB() : this.black);
        this.foldingBackgroundSelector.setEnabled(this.override.getSelection());
        this.foldingForegroundSelector.setColorValue(this.override.getSelection() && this.provider.getFoldingForegroundColor() != null ? this.provider.getFoldingForegroundColor().getRGB() : this.black);
        this.foldingForegroundSelector.setEnabled(this.override.getSelection());
    }

    private void makeScrollableCompositeAware(Control control) {
        ColorizationScrolledComposite parentScrolledComposite = this.getParentScrolledComposite(control);
        if (parentScrolledComposite != null) {
            parentScrolledComposite.adaptChild(control);
        }
    }

    private void expandedStateChanged(ExpandableComposite expandable) {
        ColorizationScrolledComposite parentScrolledComposite = this.getParentScrolledComposite((Control)expandable);
        if (parentScrolledComposite != null) {
            parentScrolledComposite.reflow(true);
        }
    }

    private ColorizationScrolledComposite getParentScrolledComposite(Control control) {
        Composite parent = control.getParent();
        while (!(parent instanceof ColorizationScrolledComposite) && parent != null) {
            parent = parent.getParent();
        }
        if (parent instanceof ColorizationScrolledComposite) {
            return (ColorizationScrolledComposite)parent;
        }
        return null;
    }

    private void styleEditorOptions() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this.editorExpandable = new ExpandableComposite(this.displayArea, 0, 18);
        this.editorExpandable.setText("Editor Options");
        this.editorExpandable.setLayoutData((Object)new GridData(4, 4, true, false));
        this.editorExpandable.setLayout((Layout)gridLayout);
        this.editorExpandable.setExpanded(UnifiedEditorsPlugin.getDefault().getPreferenceStore().getBoolean("com.aptana.ide.editors.EXPAND_EDITOR_OPTIONS"));
        this.editorExpandable.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                LanguageColorizationWidget.this.expandedStateChanged((ExpandableComposite)e.getSource());
            }
        });
        this.makeScrollableCompositeAware((Control)this.editorExpandable);
        Composite inner = new Composite((Composite)this.editorExpandable, 0);
        inner.setLayout((Layout)gridLayout);
        this.editorExpandable.setClient((Control)inner);
        this.override = new Button(inner, 32);
        this.override.setEnabled(false);
        this.override.setText("Override Eclipse editor settings");
        this.override.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean isSelected = LanguageColorizationWidget.this.override.getSelection();
                if (isSelected) {
                    Color blackColor = UnifiedColorManager.getInstance().getColor(LanguageColorizationWidget.this.black);
                    Color grayColor = UnifiedColorManager.getInstance().getColor(new RGB(139, 139, 139));
                    IPreferenceStore store = EditorsPlugin.getDefault().getPreferenceStore();
                    RGB background = PreferenceConverter.getColor((IPreferenceStore)store, (String)"AbstractTextEditor.Color.Background");
                    RGB lineHighlight = PreferenceConverter.getColor((IPreferenceStore)store, (String)"currentLineColor");
                    RGB selectionFg = LanguageColorizationWidget.this.getControl().getDisplay().getSystemColor(27).getRGB();
                    RGB selectionBg = LanguageColorizationWidget.this.getControl().getDisplay().getSystemColor(26).getRGB();
                    Color eclipseBackgroundColor = UnifiedColorManager.getInstance().getColor(background);
                    Color eclipseLineHighlightColor = UnifiedColorManager.getInstance().getColor(lineHighlight);
                    Color eclipseSelectionFgColor = UnifiedColorManager.getInstance().getColor(selectionFg);
                    Color eclipseSelectionBgColor = UnifiedColorManager.getInstance().getColor(selectionBg);
                    Color systemWidgetBGColor = LanguageColorizationWidget.this.getControl().getDisplay().getSystemColor(22);
                    LanguageColorizationWidget.this.provider.setBackgroundColor(eclipseBackgroundColor);
                    LanguageColorizationWidget.this.provider.setCaretColor(blackColor);
                    LanguageColorizationWidget.this.provider.setLineHighlightColor(eclipseLineHighlightColor);
                    LanguageColorizationWidget.this.provider.setSelectionForegroundColor(eclipseSelectionFgColor);
                    LanguageColorizationWidget.this.provider.setSelectionBackgroundColor(eclipseSelectionBgColor);
                    LanguageColorizationWidget.this.provider.setFoldingBackgroundColor(systemWidgetBGColor);
                    LanguageColorizationWidget.this.provider.setFoldingForegroundColor(grayColor);
                    LanguageColorizationWidget.this.backgroundSelector.setColorValue(LanguageColorizationWidget.this.provider.getBackgroundColor().getRGB());
                    LanguageColorizationWidget.this.lineHighlightSelector.setColorValue(LanguageColorizationWidget.this.provider.getLineHighlightColor().getRGB());
                    LanguageColorizationWidget.this.selectionForegroundSelector.setColorValue(LanguageColorizationWidget.this.provider.getSelectionForegroundColor().getRGB());
                    LanguageColorizationWidget.this.selectionBackgroundSelector.setColorValue(LanguageColorizationWidget.this.provider.getSelectionBackgroundColor().getRGB());
                    LanguageColorizationWidget.this.foldingBackgroundSelector.setColorValue(LanguageColorizationWidget.this.provider.getFoldingBackgroundColor().getRGB());
                    LanguageColorizationWidget.this.foldingForegroundSelector.setColorValue(LanguageColorizationWidget.this.provider.getFoldingForegroundColor().getRGB());
                    LanguageColorizationWidget.this.caretSelector.setColorValue(LanguageColorizationWidget.this.provider.getCaretColor().getRGB());
                } else {
                    LanguageColorizationWidget.this.provider.setBackgroundColor(null);
                    LanguageColorizationWidget.this.provider.setCaretColor(null);
                    LanguageColorizationWidget.this.provider.setLineHighlightColor(null);
                    LanguageColorizationWidget.this.provider.setSelectionForegroundColor(null);
                    LanguageColorizationWidget.this.provider.setSelectionBackgroundColor(null);
                    LanguageColorizationWidget.this.provider.setFoldingBackgroundColor(null);
                    LanguageColorizationWidget.this.provider.setFoldingForegroundColor(null);
                }
                LanguageColorizationWidget.this.backgroundSelector.setEnabled(isSelected);
                LanguageColorizationWidget.this.lineHighlightSelector.setEnabled(isSelected);
                LanguageColorizationWidget.this.selectionForegroundSelector.setEnabled(isSelected);
                LanguageColorizationWidget.this.selectionBackgroundSelector.setEnabled(isSelected);
                LanguageColorizationWidget.this.foldingBackgroundSelector.setEnabled(isSelected);
                LanguageColorizationWidget.this.foldingForegroundSelector.setEnabled(isSelected);
                LanguageColorizationWidget.this.caretSelector.setEnabled(isSelected);
            }
        });
        Composite buttons = new Composite(inner, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginLeft = 0;
        gridLayout.makeColumnsEqualWidth = true;
        buttons.setLayout((Layout)gridLayout);
        buttons.setLayoutData((Object)new GridData(4, 4, true, true));
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginRight = 0;
        gridLayout.marginLeft = 0;
        gridLayout.horizontalSpacing = 5;
        gridLayout.verticalSpacing = 0;
        gridLayout.makeColumnsEqualWidth = false;
        Composite bgComp = new Composite(buttons, 0);
        bgComp.setLayout((Layout)gridLayout);
        bgComp.setLayoutData((Object)new GridData(131072, 4, true, true));
        Label bgLabel = new Label(bgComp, 131072);
        bgLabel.setText("Background");
        this.backgroundSelector = new ColorSelector(bgComp);
        this.backgroundSelector.addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                LanguageColorizationWidget.this.provider.setBackgroundColor(UnifiedColorManager.getInstance().getColor((RGB)event.getNewValue()));
            }
        });
        Composite lComp = new Composite(buttons, 0);
        lComp.setLayoutData((Object)new GridData(131072, 4, true, true));
        lComp.setLayout((Layout)gridLayout);
        Label lLabel = new Label(lComp, 131072);
        lLabel.setText("Line Highlight");
        this.lineHighlightSelector = new ColorSelector(lComp);
        this.lineHighlightSelector.addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                LanguageColorizationWidget.this.provider.setLineHighlightColor(UnifiedColorManager.getInstance().getColor((RGB)event.getNewValue()));
            }
        });
        Composite sfComp = new Composite(buttons, 0);
        sfComp.setLayoutData((Object)new GridData(131072, 4, true, true));
        sfComp.setLayout((Layout)gridLayout);
        Label sfLabel = new Label(sfComp, 131072);
        sfLabel.setText("Selection Foreground");
        this.selectionForegroundSelector = new ColorSelector(sfComp);
        this.selectionForegroundSelector.addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                LanguageColorizationWidget.this.provider.setSelectionForegroundColor(UnifiedColorManager.getInstance().getColor((RGB)event.getNewValue()));
            }
        });
        Composite sbComp = new Composite(buttons, 0);
        sbComp.setLayoutData((Object)new GridData(131072, 4, true, true));
        sbComp.setLayout((Layout)gridLayout);
        Label sbLabel = new Label(sbComp, 131072);
        sbLabel.setText("Selection Background");
        this.selectionBackgroundSelector = new ColorSelector(sbComp);
        this.selectionBackgroundSelector.addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                LanguageColorizationWidget.this.provider.setSelectionBackgroundColor(UnifiedColorManager.getInstance().getColor((RGB)event.getNewValue()));
            }
        });
        Composite fbgComp = new Composite(buttons, 0);
        fbgComp.setLayoutData((Object)new GridData(131072, 4, true, true));
        fbgComp.setLayout((Layout)gridLayout);
        Label fbgLabel = new Label(fbgComp, 131072);
        fbgLabel.setText("Folding Background");
        this.foldingBackgroundSelector = new ColorSelector(fbgComp);
        this.foldingBackgroundSelector.addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                LanguageColorizationWidget.this.provider.setFoldingBackgroundColor(UnifiedColorManager.getInstance().getColor((RGB)event.getNewValue()));
            }
        });
        Composite ffgComp = new Composite(buttons, 0);
        ffgComp.setLayoutData((Object)new GridData(131072, 4, true, true));
        ffgComp.setLayout((Layout)gridLayout);
        Label ffgLabel = new Label(ffgComp, 131072);
        ffgLabel.setText("Folding Foreground");
        this.foldingForegroundSelector = new ColorSelector(ffgComp);
        this.foldingForegroundSelector.addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                LanguageColorizationWidget.this.provider.setFoldingForegroundColor(UnifiedColorManager.getInstance().getColor((RGB)event.getNewValue()));
            }
        });
        Composite cComp = new Composite(buttons, 0);
        cComp.setLayoutData((Object)new GridData(131072, 4, true, true));
        cComp.setLayout((Layout)gridLayout);
        Label cLabel = new Label(cComp, 131072);
        cLabel.setText("Caret Color");
        this.caretSelector = new ColorSelector(cComp);
        this.caretSelector.addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                LanguageColorizationWidget.this.provider.setCaretColor(UnifiedColorManager.getInstance().getColor((RGB)event.getNewValue()));
            }
        });
        if (Platform.getOS().equals("macosx")) {
            cComp.setVisible(false);
        }
        this.loadEditorOptions();
        if (this.provider != null) {
            this.viewer.setContentProvider((IContentProvider)this.provider);
            this.viewer.setLabelProvider((IBaseLabelProvider)this.provider);
            this.loadColorizer();
        }
    }

    private void styleCells() {
        CheckboxCellEditor editor = new CheckboxCellEditor((Composite)this.tree);
        ColorCellEditor colorEditor = new ColorCellEditor((Composite)this.tree);
        CellEditor[] editors = new CellEditor[COLUMNS.length];
        editors[0] = null;
        editors[1] = editor;
        editors[2] = null;
        editors[3] = null;
        editors[4] = colorEditor;
        editors[5] = editor;
        editors[6] = editors[5];
        editors[7] = editors[5];
        ICellModifier modifier = new ICellModifier(){

            public void modify(Object element, String property, Object value) {
                Boolean bool;
                if (element instanceof Item) {
                    element = ((Item)element).getData();
                }
                ColorizationStyle style = null;
                if (element instanceof IToken) {
                    style = LanguageColorizationWidget.this.provider.getStyle((IToken)element);
                } else if (element instanceof LanguageStructureProvider.Category) {
                    style = ((LanguageStructureProvider.Category)element).getStyle();
                }
                if (style != null) {
                    if (value instanceof Boolean) {
                        Boolean bool2 = (Boolean)value;
                        if (element instanceof IToken && property == COLUMNS[1]) {
                            LanguageColorizationWidget.this.provider.removeStyle((IToken)element);
                            LanguageColorizationWidget.this.regionViewer.refresh();
                        } else if (property == COLUMNS[5]) {
                            style.setBold(bool2);
                        } else if (property == COLUMNS[6]) {
                            style.setItalic(bool2);
                        } else if (property == COLUMNS[7]) {
                            style.setUnderline(bool2);
                        }
                    } else if (value instanceof RGB) {
                        RGB rgb = (RGB)value;
                        if (property == COLUMNS[4]) {
                            style.setForegroundColor(UnifiedColorManager.getInstance().getColor(rgb));
                        }
                    }
                } else if (element instanceof IToken && value instanceof Boolean && property == COLUMNS[1] && (bool = (Boolean)value).booleanValue()) {
                    IToken token = (IToken)element;
                    style = new ColorizationStyle();
                    style.setForegroundColor(UnifiedColorManager.getInstance().getColor(LanguageColorizationWidget.this.black));
                    style.setName(String.valueOf(token.getCategory()) + "_" + token.getType());
                    LanguageColorizationWidget.this.provider.addStyle((IToken)element, style);
                }
                LanguageColorizationWidget.this.viewer.update(element, null);
            }

            public Object getValue(Object element, String property) {
                ColorizationStyle style = null;
                if (element instanceof IToken) {
                    style = LanguageColorizationWidget.this.provider.getStyle((IToken)element);
                } else if (element instanceof LanguageStructureProvider.Category) {
                    style = ((LanguageStructureProvider.Category)element).getStyle();
                }
                if (style != null) {
                    if (property == COLUMNS[1]) {
                        return true;
                    }
                    if (property == COLUMNS[4]) {
                        return style.getForegroundColor().getRGB();
                    }
                    if (property == COLUMNS[5]) {
                        return style.isBold();
                    }
                    if (property == COLUMNS[6]) {
                        return style.isItalic();
                    }
                    if (property == COLUMNS[7]) {
                        return style.isUnderline();
                    }
                } else if (property == COLUMNS[1]) {
                    return false;
                }
                return null;
            }

            public boolean canModify(Object element, String property) {
                boolean canModify = false;
                ColorizationStyle style = null;
                if (element instanceof IToken) {
                    style = LanguageColorizationWidget.this.provider.getStyle((IToken)element);
                    if (property == COLUMNS[1]) {
                        canModify = true;
                    }
                } else if (element instanceof LanguageStructureProvider.Category) {
                    style = ((LanguageStructureProvider.Category)element).getStyle();
                }
                if (style != null) {
                    canModify = true;
                }
                return canModify;
            }
        };
        TreeColumn column0 = new TreeColumn(this.tree, 16384);
        column0.setWidth(100);
        column0.setText(COLUMNS[0]);
        TreeColumn column1 = new TreeColumn(this.tree, 16384);
        column1.setWidth(17);
        column1.setText(COLUMNS[1]);
        TreeColumn column2 = new TreeColumn(this.tree, 16384);
        column2.setWidth(125);
        column2.setText(COLUMNS[2]);
        TreeColumn column3 = new TreeColumn(this.tree, 0x1000000);
        column3.setWidth(17);
        column3.setText(COLUMNS[3]);
        column3.pack();
        TreeColumn column4 = new TreeColumn(this.tree, 0x1000000);
        column4.setWidth(17);
        column4.setText(COLUMNS[4]);
        column4.pack();
        TreeColumn column5 = new TreeColumn(this.tree, 0x1000000);
        column5.setWidth(17);
        column5.setText(COLUMNS[5]);
        column5.pack();
        TreeColumn column6 = new TreeColumn(this.tree, 0x1000000);
        column6.setWidth(17);
        column6.setText(COLUMNS[6]);
        column6.pack();
        TreeColumn column7 = new TreeColumn(this.tree, 0x1000000);
        column7.setWidth(17);
        column7.setText(COLUMNS[7]);
        column7.pack();
        this.viewer.setColumnProperties(COLUMNS);
        this.viewer.setCellEditors(editors);
        this.viewer.setCellModifier(modifier);
    }

    public void setErrorHandler(IErrorHandler handler) {
        this.errorHandler = handler;
    }

    private TextCellEditor createRegionNameEditor() {
        TextCellEditor nameEditor = new TextCellEditor((Composite)this.table);
        nameEditor.setValidator(new ICellEditorValidator(){

            public String isValid(Object value) {
                IToken token = (IToken)LanguageColorizationWidget.this.viewer.getTree().getSelection()[0].getData();
                Region region = (Region)LanguageColorizationWidget.this.table.getSelection()[0].getData();
                String text = (String)value;
                if (!region.getName().equals(text) && LanguageColorizationWidget.this.regionNameExists(text, token)) {
                    String message = "Region name already exists.";
                    if (LanguageColorizationWidget.this.errorHandler != null) {
                        LanguageColorizationWidget.this.errorHandler.setErrorMessage(message);
                    }
                    return message;
                }
                if (LanguageColorizationWidget.this.errorHandler != null) {
                    LanguageColorizationWidget.this.errorHandler.setErrorMessage(null);
                }
                return null;
            }
        });
        return nameEditor;
    }

    private TextCellEditor createRegionOffsetEditor() {
        TextCellEditor offsetEditor = new TextCellEditor((Composite)this.table);
        offsetEditor.setValidator(new ICellEditorValidator(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public String isValid(Object value) {
                String text = (String)value;
                Region region = (Region)LanguageColorizationWidget.this.table.getSelection()[0].getData();
                if (region == null) return null;
                try {
                    if (text.startsWith("LENGTH")) {
                        String number = text.substring("LENGTH".length(), text.length());
                        if ((number = number.trim()).length() <= 1 || number.charAt(0) != '-') throw new Exception();
                        Integer.parseInt(number);
                    } else {
                        Integer.parseInt(text);
                    }
                    if (LanguageColorizationWidget.this.errorHandler == null) return null;
                    LanguageColorizationWidget.this.errorHandler.setErrorMessage(null);
                    return null;
                }
                catch (Exception exception) {
                    String message = "Region " + region.getName() + " must have a valid offset";
                    if (LanguageColorizationWidget.this.errorHandler == null) return message;
                    LanguageColorizationWidget.this.errorHandler.setErrorMessage(message);
                    return message;
                }
            }
        });
        return offsetEditor;
    }

    private TextCellEditor createRegionLengthEditor() {
        TextCellEditor lengthEditor = new TextCellEditor((Composite)this.table);
        lengthEditor.setValidator(new ICellEditorValidator(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public String isValid(Object value) {
                String text = (String)value;
                Region region = (Region)LanguageColorizationWidget.this.table.getSelection()[0].getData();
                if (region == null) return null;
                try {
                    if (text.startsWith("LENGTH")) {
                        String number = text.substring("LENGTH".length(), text.length());
                        if ((number = number.trim()).length() <= 1 || number.charAt(0) != '-') throw new Exception();
                        Integer.parseInt(number);
                    } else {
                        Integer.parseInt(text);
                    }
                    if (LanguageColorizationWidget.this.errorHandler == null) return null;
                    LanguageColorizationWidget.this.errorHandler.setErrorMessage(null);
                    return null;
                }
                catch (Exception exception) {
                    String message = "Region " + region.getName() + " must have a valid length";
                    if (LanguageColorizationWidget.this.errorHandler == null) return message;
                    LanguageColorizationWidget.this.errorHandler.setErrorMessage(message);
                    return message;
                }
            }
        });
        return lengthEditor;
    }

    private void loadRegions() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this.regionExpandable = new ExpandableComposite(this.displayArea, 0, 18);
        this.regionExpandable.setText("Region Colorizations");
        this.regionExpandable.setLayoutData((Object)new GridData(4, 4, true, false));
        this.regionExpandable.setLayout((Layout)gridLayout);
        this.regionExpandable.setExpanded(UnifiedEditorsPlugin.getDefault().getPreferenceStore().getBoolean("com.aptana.ide.editors.EXPAND_REGIONS"));
        this.regionExpandable.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                LanguageColorizationWidget.this.expandedStateChanged((ExpandableComposite)e.getSource());
            }
        });
        this.makeScrollableCompositeAware((Control)this.regionExpandable);
        Composite inner = new Composite((Composite)this.regionExpandable, 0);
        inner.setLayout((Layout)gridLayout);
        this.regionExpandable.setClient((Control)inner);
        Composite addRemove = new Composite(inner, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        layout.marginHeight = 5;
        layout.marginWidth = 0;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 5;
        addRemove.setLayout((Layout)layout);
        addRemove.setLayoutData((Object)new GridData(4, 4, false, false));
        this.addRegion = new Button(addRemove, 8);
        this.addRegion.setText(StringUtils.ellipsify((String)"Add new region"));
        this.addRegion.setEnabled(false);
        this.remove = new Button(addRemove, 8);
        this.remove.setText("Remove");
        this.remove.setEnabled(false);
        Label formatLabel = new Label(inner, 64);
        formatLabel.setText("Note: Offset and length must either be an integer or \nthe keyword LENGTH plus an integer (i.e. 'LENGTH-1').");
        formatLabel.setLayoutData((Object)new GridData(4, 4, true, false));
        this.table = new Table(inner, 67588);
        this.regionViewer = new TableViewer(this.table);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LanguageColorizationWidget.this.remove.setEnabled(true);
            }
        });
        GridData tableLayoutData = new GridData(4, 4, true, true);
        tableLayoutData.heightHint = this.tree.getItemHeight() * 10;
        tableLayoutData.widthHint = 300;
        this.table.setLayoutData((Object)tableLayoutData);
        CheckboxCellEditor editor = new CheckboxCellEditor((Composite)this.table);
        TextCellEditor nameEditor = this.createRegionNameEditor();
        TextCellEditor offsetEditor = this.createRegionOffsetEditor();
        TextCellEditor lengthEditor = this.createRegionLengthEditor();
        CellEditor[] editors = new CellEditor[REGION_COLUMNS.length];
        ColorCellEditor colorEditor = new ColorCellEditor((Composite)this.table);
        editors[0] = nameEditor;
        editors[1] = offsetEditor;
        editors[2] = lengthEditor;
        editors[3] = colorEditor;
        editors[4] = editor;
        editors[5] = editor;
        editors[6] = editor;
        TableColumn column = new TableColumn(this.table, 16384);
        column.setWidth(125);
        column.setText(REGION_TABLE_COLUMNS[0]);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LanguageColorizationWidget.this.regionViewer.setSorter((ViewerSorter)new RegionSorter(1));
            }
        });
        column = new TableColumn(this.table, 16384);
        column.setWidth(75);
        column.setText(REGION_TABLE_COLUMNS[1]);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LanguageColorizationWidget.this.regionViewer.setSorter((ViewerSorter)new RegionSorter(2));
            }
        });
        column = new TableColumn(this.table, 16384);
        column.setWidth(75);
        column.setText(REGION_TABLE_COLUMNS[2]);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LanguageColorizationWidget.this.regionViewer.setSorter((ViewerSorter)new RegionSorter(3));
            }
        });
        column = new TableColumn(this.table, 0x1000000);
        column.setWidth(17);
        column.setText(REGION_TABLE_COLUMNS[3]);
        column = new TableColumn(this.table, 0x1000000);
        column.setWidth(17);
        column.setText(REGION_TABLE_COLUMNS[4]);
        column = new TableColumn(this.table, 0x1000000);
        column.setWidth(17);
        column.setText(REGION_TABLE_COLUMNS[5]);
        column = new TableColumn(this.table, 0x1000000);
        column.setWidth(17);
        column.setText(REGION_TABLE_COLUMNS[6]);
        this.regionViewer.setSorter((ViewerSorter)new RegionSorter(2));
        this.table.setSortColumn(this.table.getColumn(1));
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(false);
        this.regionViewer.setColumnProperties(REGION_COLUMNS);
        this.regionViewer.setCellEditors(editors);
        this.regionViewer.setContentProvider((IContentProvider)this.regionContentProvider);
        this.regionViewer.setLabelProvider((IBaseLabelProvider)this.regionLabelProvider);
        this.regionViewer.setCellModifier(this.regionModifier);
        PreferenceUtils.persist((IPreferenceStore)UnifiedEditorsPlugin.getDefault().getPreferenceStore(), (Table)this.regionViewer.getTable(), (String)"regionViewer");
        this.addRegionButtonListeners();
    }

    private boolean regionNameExists(String newName, IToken token) {
        Map regions = this.provider.getRegions(token);
        Iterator iter = regions.values().iterator();
        while (iter.hasNext()) {
            String name = ((Region)iter.next()).getName();
            if (!name.equals(newName)) continue;
            return true;
        }
        return false;
    }

    private void addRegionButtonListeners() {
        this.remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IToken token = (IToken)LanguageColorizationWidget.this.viewer.getTree().getSelection()[0].getData();
                Region region = (Region)LanguageColorizationWidget.this.table.getSelection()[0].getData();
                LanguageColorizationWidget.this.provider.removeRegion(token, region.getName());
                LanguageColorizationWidget.this.regionViewer.setInput((Object)LanguageColorizationWidget.this.provider.getRegions(token));
                LanguageColorizationWidget.this.remove.setEnabled(false);
                LanguageColorizationWidget.this.viewer.update((Object)token, null);
            }
        });
        this.addRegion.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final IToken token = (IToken)LanguageColorizationWidget.this.viewer.getTree().getSelection()[0].getData();
                InputDialog name = new InputDialog(LanguageColorizationWidget.this.addRegion.getShell(), "Enter region name", "Region Name:", String.valueOf(token.getType()) + " region", new IInputValidator(){

                    public String isValid(String newText) {
                        if (LanguageColorizationWidget.this.regionNameExists(newText, token)) {
                            return "Region name already exists.";
                        }
                        return null;
                    }
                });
                name.setBlockOnOpen(true);
                int rc = name.open();
                if (rc == 0) {
                    ColorizationStyle style = new ColorizationStyle();
                    style.setName(String.valueOf(token.getCategory()) + "_" + token.getType() + "_" + name.getValue());
                    style.setForegroundColor(UnifiedColorManager.getInstance().getColor(LanguageColorizationWidget.this.black));
                    Region region = new Region(0, false, 1, false, style);
                    region.setName(name.getValue());
                    region.setLengthString("1");
                    region.setOffsetString("0");
                    Map regionMap = LanguageColorizationWidget.this.provider.getRegions(token);
                    regionMap.put(region.getName(), region);
                    LanguageColorizationWidget.this.regionViewer.setInput((Object)regionMap);
                    LanguageColorizationWidget.this.viewer.update((Object)token, null);
                }
            }
        });
    }

    public void collapseAll() {
        if (this.regionExpandable != null && this.tokenExpandable != null && this.editorExpandable != null) {
            this.regionExpandable.setExpanded(false);
            this.tokenExpandable.setExpanded(false);
            this.editorExpandable.setExpanded(false);
        }
    }

    private void loadColorizer() {
        this.override.setEnabled(this.provider != null);
        this.importButton.setEnabled(this.provider != null);
        this.exportButton.setEnabled(this.provider != null);
        this.viewer.setInput(INPUT);
        TreeItem[] items = this.tree.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getData() instanceof LanguageStructureProvider.Category) {
                items[i].setBackground(UnifiedColorManager.getInstance().getColor(new RGB(192, 192, 192)));
            }
            ++i;
        }
        if (this.tree.getItemCount() > 0) {
            this.tree.showItem(this.tree.getItem(0));
            this.tree.showColumn(this.tree.getColumn(0));
        }
    }

    private void styleImportExport() {
        Group io = new Group(this.displayArea, 0);
        io.setText("Manage Colorization");
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 2;
        io.setLayout((Layout)layout);
        io.setLayoutData((Object)new GridData(4, 4, true, false));
        this.importButton = new Button((Composite)io, 8);
        this.importButton.setEnabled(false);
        this.importButton.setText(StringUtils.ellipsify((String)"Import"));
        this.importButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(LanguageColorizationWidget.this.displayArea.getShell(), 4096);
                dialog.setFilterExtensions(new String[]{"*.col"});
                dialog.setText("Load colorization");
                String path = dialog.open();
                if (path != null) {
                    File file = new File(path);
                    LanguageColorizationWidget.this.provider.importColorization(file);
                    LanguageColorizationWidget.this.loadEditorOptions();
                    LanguageColorizationWidget.this.loadColorizer();
                    LanguageColorizationWidget.this.regionViewer.refresh();
                }
            }
        });
        this.exportButton = new Button((Composite)io, 8);
        this.exportButton.setEnabled(false);
        this.exportButton.setText(StringUtils.ellipsify((String)"Export"));
        this.exportButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(LanguageColorizationWidget.this.displayArea.getShell(), 8192);
                dialog.setFilterExtensions(new String[]{"*.col"});
                dialog.setText("Save colorization");
                dialog.setFileName("colorization.col");
                String path = dialog.open();
                if (path != null) {
                    File file = new File(path);
                    try {
                        LanguageColorizationWidget.this.provider.buildColorizationFile(file);
                    }
                    catch (LexerException lexerException) {
                        IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)"Error exporting colorization");
                    }
                }
            }
        });
    }

    public void saveStyles() {
        UnifiedEditorsPlugin.getDefault().getPreferenceStore().setValue("com.aptana.ide.editors.EXPAND_EDITOR_OPTIONS", this.editorExpandable.isExpanded());
        UnifiedEditorsPlugin.getDefault().getPreferenceStore().setValue("com.aptana.ide.editors.EXPAND_TOKENS", this.tokenExpandable.isExpanded());
        UnifiedEditorsPlugin.getDefault().getPreferenceStore().setValue("com.aptana.ide.editors.EXPAND_REGIONS", this.regionExpandable.isExpanded());
    }

    private void resetWidget() {
        this.loadColorizer();
        this.loadEditorOptions();
        this.regionViewer.getTable().deselectAll();
        this.addRegion.setEnabled(false);
        this.remove.setEnabled(false);
        this.regionViewer.refresh();
    }

    public void resetToDefaults() {
        this.provider.resetToLanguageDefaults();
        this.resetWidget();
    }

    public LanguageStructureProvider getProvider() {
        return this.provider;
    }

    public void setProvider(LanguageStructureProvider provider) {
        if (this.mainComp != null) {
            if (provider != null) {
                this.viewer.setContentProvider((IContentProvider)provider);
                this.viewer.setLabelProvider((IBaseLabelProvider)provider);
            } else {
                this.viewer.setContentProvider((IContentProvider)this.nullContentProvider);
                this.viewer.setLabelProvider((IBaseLabelProvider)this.nullLabelProvider);
            }
            this.provider = provider;
            this.loadColorizer();
            this.loadEditorOptions();
        }
    }
}

