/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.unified;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.resources.IUniformResource;
import com.aptana.ide.core.resources.IUniformResourceChangeEvent;
import com.aptana.ide.core.resources.IUniformResourceChangeListener;
import com.aptana.ide.core.resources.IUniformResourceMarker;
import com.aptana.ide.core.resources.MarkerUtils;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.unified.Messages;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;

public class UniformResourceMarkerAnnotationModel
extends AbstractMarkerAnnotationModel {
    private IUniformResource resource;
    private IUniformResourceChangeListener resourceChangeListener = new ResourceChangeListener();

    public UniformResourceMarkerAnnotationModel(IUniformResource resource) {
        this.resource = resource;
    }

    protected IMarker[] retrieveMarkers() throws CoreException {
        return MarkerUtils.findMarkers((IUniformResource)this.resource, (String)"org.eclipse.core.resources.marker", (boolean)true);
    }

    protected void deleteMarkers(final IMarker[] markers) throws CoreException {
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    int i = 0;
                    while (i < markers.length) {
                        markers[i].delete();
                        ++i;
                    }
                }
            }, null, 1, null);
        }
        catch (CoreException e) {
            IdeLog.logInfo((Plugin)UnifiedEditorsPlugin.getDefault(), (String)Messages.UniformResourceMarkerAnnotationModel_ErrorDeletingMarkers, (Throwable)e);
        }
    }

    protected void listenToMarkerChanges(boolean listen) {
        if (listen) {
            MarkerUtils.addResourceChangeListener((IUniformResourceChangeListener)this.resourceChangeListener);
        } else {
            MarkerUtils.removeResourceChangeListener((IUniformResourceChangeListener)this.resourceChangeListener);
        }
    }

    protected boolean isAcceptable(IMarker marker) {
        return marker instanceof IUniformResourceMarker && this.resource.equals(((IUniformResourceMarker)marker).getUniformResource());
    }

    protected void update(IMarkerDelta[] markerDeltas) {
        if (markerDeltas.length == 0) {
            return;
        }
        int i = 0;
        while (i < markerDeltas.length) {
            IMarkerDelta delta = markerDeltas[i];
            switch (delta.getKind()) {
                case 1: {
                    this.addMarkerAnnotation(delta.getMarker());
                    break;
                }
                case 2: {
                    this.removeMarkerAnnotation(delta.getMarker());
                    break;
                }
                case 4: {
                    this.modifyMarkerAnnotation(delta.getMarker());
                    break;
                }
            }
            ++i;
        }
        this.fireModelChanged();
    }

    private class ResourceChangeListener
    implements IUniformResourceChangeListener {
        private ResourceChangeListener() {
        }

        public void resourceChanged(IUniformResourceChangeEvent event) {
            if (UniformResourceMarkerAnnotationModel.this.resource.equals(event.getResource())) {
                UniformResourceMarkerAnnotationModel.this.update(event.getMarkerDeltas());
            }
        }
    }
}

