/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.unified;

import com.aptana.ide.editors.unified.ITextTripleClickStrategy;
import com.aptana.ide.editors.unified.IUnifiedViewer;
import com.aptana.ide.editors.unified.TripleClickConnector;
import com.aptana.ide.editors.unified.UnifiedConfiguration;
import com.aptana.ide.editors.unified.contentassist.IUnifiedContentAssistant;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class UnifiedViewer
extends ProjectionViewer
implements IUnifiedViewer {
    private boolean hotkeyActivated = false;
    private boolean idleActivated = false;
    private TextPresentation presentation;
    protected Map<String, ITextTripleClickStrategy> fTripleClickStrategies;
    protected TripleClickConnector fTripleClickStrategyConnector;

    public UnifiedViewer(Composite parent, IVerticalRuler ruler, IOverviewRuler overviewRuler, boolean showsAnnotationOverview, int styles) {
        super(parent, ruler, overviewRuler, showsAnnotationOverview, styles);
    }

    protected Layout createLayout() {
        return new SourceViewer.RulerLayout((SourceViewer)this, 0);
    }

    protected void shift(boolean useDefaultPrefixes, boolean right) {
        this.shift(useDefaultPrefixes, right, false);
    }

    protected StyledText createTextWidget(Composite parent, int styles) {
        return new StyledText(parent, styles){
            boolean swap;
            {
                this.swap = false;
            }

            public void setLineBackground(int startLine, int lineCount, Color background) {
                this.swap = true;
                super.setLineBackground(startLine, lineCount, background);
                this.swap = false;
            }

            public boolean isListening(int eventType) {
                if (this.swap && eventType == 3001) {
                    return false;
                }
                return super.isListening(eventType);
            }

            public void invokeAction(int action) {
                if (this.getWordWrap() && 0x1000002 == action) {
                    int line;
                    int previous = this.getCaretOffset();
                    super.invokeAction(action);
                    if (previous == this.getCaretOffset() && (line = this.getLineAtOffset(previous)) + 1 < this.getLineCount()) {
                        this.setCaretOffset(this.getOffsetAtLine(line + 1));
                    }
                } else {
                    super.invokeAction(action);
                }
            }
        };
    }

    protected void shift(boolean useDefaultPrefixes, boolean right, boolean ignoreWhitespace) {
        block24: {
            Map partitioners;
            IDocument d;
            block23: {
                if (this.fUndoManager != null) {
                    this.fUndoManager.beginCompoundChange();
                }
                this.setRedraw(false);
                this.startSequentialRewriteMode(true);
                d = this.getDocument();
                partitioners = null;
                try {
                    try {
                        Point selection = this.getSelectedRange();
                        IRegion block = this.getTextBlockFromSelection(selection);
                        ITypedRegion[] regions = TextUtilities.computePartitioning((IDocument)d, (String)this.getDocumentPartitioning(), (int)block.getOffset(), (int)block.getLength(), (boolean)false);
                        int lineCount = 0;
                        int[] lines = new int[regions.length * 2];
                        int i = 0;
                        int j = 0;
                        while (i < regions.length) {
                            lines[j] = this.getFirstCompleteLineOfRegion((IRegion)regions[i]);
                            int length = regions[i].getLength();
                            int offset = regions[i].getOffset() + length;
                            if (length > 0) {
                                --offset;
                            }
                            lines[j + 1] = lines[j] == -1 ? -1 : d.getLineOfOffset(offset);
                            lineCount += lines[j + 1] - lines[j] + 1;
                            ++i;
                            j += 2;
                        }
                        if (lineCount >= 20) {
                            partitioners = TextUtilities.removeDocumentPartitioners((IDocument)d);
                        }
                        ShiftPositionUpdater positionUpdater = new ShiftPositionUpdater("__TextViewer_shifting");
                        Position rememberedSelection = new Position(selection.x, selection.y);
                        d.addPositionCategory("__TextViewer_shifting");
                        d.addPositionUpdater((IPositionUpdater)positionUpdater);
                        try {
                            d.addPosition("__TextViewer_shifting", rememberedSelection);
                        }
                        catch (BadPositionCategoryException badPositionCategoryException) {}
                        Map map = useDefaultPrefixes ? this.fDefaultPrefixChars : this.fIndentChars;
                        int i2 = 0;
                        int j2 = 0;
                        while (i2 < regions.length) {
                            String[] prefixes = (String[])this.selectContentTypePlugin(regions[i2].getType(), map);
                            if (prefixes != null && prefixes.length > 0 && lines[j2] >= 0 && lines[j2 + 1] >= 0) {
                                if (right) {
                                    UnifiedViewer.shiftRight(lines[j2], lines[j2 + 1], prefixes[0], d);
                                } else {
                                    UnifiedViewer.shiftLeft(lines[j2], lines[j2 + 1], prefixes, ignoreWhitespace, d);
                                }
                            }
                            ++i2;
                            j2 += 2;
                        }
                        this.setSelectedRange(rememberedSelection.getOffset(), rememberedSelection.getLength());
                        try {
                            d.removePositionUpdater((IPositionUpdater)positionUpdater);
                            d.removePositionCategory("__TextViewer_shifting");
                        }
                        catch (BadPositionCategoryException badPositionCategoryException) {}
                    }
                    catch (BadLocationException badLocationException) {
                        break block23;
                    }
                }
                catch (Throwable throwable) {
                    if (partitioners != null) {
                        TextUtilities.addDocumentPartitioners((IDocument)d, partitioners);
                    }
                    this.stopSequentialRewriteMode();
                    this.setRedraw(true);
                    if (this.fUndoManager != null) {
                        this.fUndoManager.endCompoundChange();
                    }
                    throw throwable;
                }
                if (partitioners != null) {
                    TextUtilities.addDocumentPartitioners((IDocument)d, (Map)partitioners);
                }
                this.stopSequentialRewriteMode();
                this.setRedraw(true);
                if (this.fUndoManager != null) {
                    this.fUndoManager.endCompoundChange();
                }
                break block24;
            }
            if (partitioners != null) {
                TextUtilities.addDocumentPartitioners((IDocument)d, partitioners);
            }
            this.stopSequentialRewriteMode();
            this.setRedraw(true);
            if (this.fUndoManager != null) {
                this.fUndoManager.endCompoundChange();
            }
        }
    }

    public static void shiftRight(int startLine, int endLine, String prefix, IDocument document) {
        try {
            while (startLine <= endLine) {
                document.replace(document.getLineOffset(startLine++), 0, prefix);
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    public static void shiftLeft(int startLine, int endLine, String[] prefixes, boolean ignoreWhitespace, IDocument document) {
        try {
            IRegion[] occurrences = new IRegion[endLine - startLine + 1];
            int i = 0;
            while (i < occurrences.length) {
                int length;
                IRegion line = document.getLineInformation(startLine + i);
                String text = document.get(line.getOffset(), line.getLength());
                int index = -1;
                int[] found = TextUtilities.indexOf((String[])prefixes, (String)text, (int)0);
                if (found[0] != -1) {
                    if (ignoreWhitespace) {
                        String s = document.get(line.getOffset(), found[0]);
                        if ((s = s.trim()).length() == 0) {
                            index = line.getOffset() + found[0];
                        }
                    } else if (found[0] == 0) {
                        index = line.getOffset();
                    }
                }
                occurrences[i] = index > -1 ? ((length = prefixes[found[1]].length()) == 0 && !ignoreWhitespace && line.getLength() > 0 ? new Region(index, 0) : new Region(index, length)) : new Region(index, 0);
                ++i;
            }
            int decrement = 0;
            int i2 = 0;
            while (i2 < occurrences.length) {
                IRegion r = occurrences[i2];
                if (r.getLength() != 0) {
                    document.replace(r.getOffset() - decrement, r.getLength(), "");
                    decrement += r.getLength();
                }
                ++i2;
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    private IRegion getTextBlockFromSelection(Point selection) {
        try {
            IDocument document = this.getDocument();
            IRegion line = document.getLineInformationOfOffset(selection.x);
            int length = selection.y == 0 ? line.getLength() : selection.y + (selection.x - line.getOffset());
            return new Region(line.getOffset(), length);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private int getFirstCompleteLineOfRegion(IRegion region) {
        try {
            IDocument d = this.getDocument();
            int startLine = d.getLineOfOffset(region.getOffset());
            int offset = d.getLineOffset(startLine);
            if (offset >= region.getOffset()) {
                return startLine;
            }
            offset = d.getLineOffset(startLine + 1);
            return offset > region.getOffset() + region.getLength() ? -1 : startLine + 1;
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    private Object selectContentTypePlugin(String type, Map plugins) {
        if (plugins == null) {
            return null;
        }
        return plugins.get(type);
    }

    public boolean isHotkeyActivated() {
        return this.hotkeyActivated;
    }

    public void setHotkeyActivated(boolean value) {
        this.hotkeyActivated = value;
    }

    public void closeContentAssist() {
        if (this.fContentAssistant != null && this.fContentAssistant instanceof IUnifiedContentAssistant) {
            ((IUnifiedContentAssistant)this.fContentAssistant).hide();
        }
    }

    public void activatePlugins() {
        super.activatePlugins();
    }

    public void setTextTripleClickStrategy(ITextTripleClickStrategy strategy, String contentType) {
        if (strategy != null) {
            if (this.fTripleClickStrategies == null) {
                this.fTripleClickStrategies = new HashMap<String, ITextTripleClickStrategy>();
            }
            this.fTripleClickStrategies.put(contentType, strategy);
        } else if (this.fTripleClickStrategies != null) {
            this.fTripleClickStrategies.remove(contentType);
        }
    }

    public void configure(SourceViewerConfiguration configuration) {
        super.configure(configuration);
        if (configuration instanceof UnifiedConfiguration) {
            UnifiedConfiguration conf = (UnifiedConfiguration)configuration;
            String[] types = configuration.getConfiguredContentTypes((ISourceViewer)this);
            int i = 0;
            while (i < types.length) {
                String t = types[i];
                this.setTextTripleClickStrategy(conf.getTripleClickStrategy(this, t), t);
                ++i;
            }
        }
        this.activateTripleClickStrategies();
    }

    private void activateTripleClickStrategies() {
        if (this.fTripleClickStrategies != null && !this.fTripleClickStrategies.isEmpty() && this.fTripleClickStrategyConnector == null) {
            this.fTripleClickStrategyConnector = new TripleClickConnector(){

                public void mouseTripleClick(MouseEvent e) {
                    ITextTripleClickStrategy s = (ITextTripleClickStrategy)UnifiedViewer.this.selectContentTypePlugin(UnifiedViewer.this.getSelectedRange().x, UnifiedViewer.this.fTripleClickStrategies);
                    s.tripleClicked((ITextViewer)UnifiedViewer.this);
                }
            };
            this.getTextWidget().addMouseListener((MouseListener)this.fTripleClickStrategyConnector);
        }
    }

    public void changeTextPresentation(TextPresentation presentation, boolean controlRedraw) {
        super.changeTextPresentation(presentation, controlRedraw);
        this.presentation = presentation;
        this.getTextWidget().redraw();
    }

    public TextPresentation getTextPresentation() {
        return this.presentation;
    }

    static class ShiftPositionUpdater
    extends DefaultPositionUpdater {
        protected ShiftPositionUpdater(String category) {
            super(category);
        }

        protected void adaptToInsert() {
            int myStart = this.fPosition.offset;
            int myEnd = this.fPosition.offset + this.fPosition.length - 1;
            myEnd = Math.max(myStart, myEnd);
            int yoursStart = this.fOffset;
            int yoursEnd = this.fOffset + this.fReplaceLength - 1;
            yoursEnd = Math.max(yoursStart, yoursEnd);
            if (myEnd < yoursStart) {
                return;
            }
            if (myStart <= yoursStart) {
                this.fPosition.length += this.fReplaceLength;
                return;
            }
            if (myStart > yoursStart) {
                this.fPosition.offset += this.fReplaceLength;
            }
        }
    }
}

