/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.unified;

import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.unified.IHasCustomFoldingType;
import com.aptana.ide.editors.unified.IUnifiedEditor;
import com.aptana.ide.editors.unified.LanguageRegistry;
import com.aptana.ide.editors.unified.UnifiedEditor;
import com.aptana.ide.editors.unified.colorizer.LanguageColorizer;
import com.aptana.ide.editors.unified.folding.FoldingExtensionPointLoader;
import com.aptana.ide.editors.unified.folding.LanguageProjectAnnotation;
import com.aptana.ide.lexer.LexemeList;
import com.aptana.ide.parsing.IParseState;
import com.aptana.ide.parsing.nodes.IParseNode;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

public class UnifiedReconcilingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    private UnifiedEditor _editor;
    private IDocument _document;
    private boolean _isDisposing = false;
    private boolean firstReconcile = true;
    private Color foldingFgColor;
    protected final Map annotations = new HashMap();
    protected Map childTypes = new HashMap();

    public void dispose() {
        this._isDisposing = true;
        this._editor = null;
        this._document = null;
    }

    public IUnifiedEditor getEditor() {
        return this._editor;
    }

    public void setEditor(UnifiedEditor editor) {
        this._editor = editor;
        this.childTypes = FoldingExtensionPointLoader.loadChildTypes(editor);
    }

    public void setDocument(IDocument document) {
        this._document = document;
    }

    public IDocument getDocument() {
        return this._document;
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        this.calculatePositions();
    }

    public void reconcile(IRegion partition) {
        this.calculatePositions();
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
    }

    public void initialReconcile() {
        if (this._isDisposing) {
            return;
        }
        this.calculatePositions();
        this.firstReconcile = false;
    }

    protected void calculatePositions() {
        if (this._isDisposing) {
            return;
        }
        this.annotations.clear();
        LexemeList ll = this._editor.getFileContext().getLexemeList();
        if (ll != null) {
            IParseState parseState = this._editor.getFileContext().getParseState();
            this.parseForRegions(parseState);
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (!UnifiedReconcilingStrategy.this._isDisposing) {
                    UnifiedReconcilingStrategy.this._editor.updateFoldingStructure(UnifiedReconcilingStrategy.this.annotations);
                }
            }
        });
    }

    public void emitPosition(int startOffset, int length, String type, String language) {
        if (this._isDisposing) {
            return;
        }
        try {
            int endLine;
            int startLine;
            IDocument doc = this._document;
            if (doc != null && (startLine = doc.getLineOfOffset(startOffset)) < (endLine = doc.getLineOfOffset(startOffset + length))) {
                int start = doc.getLineOffset(startLine);
                int end = doc.getLineOffset(endLine) + doc.getLineLength(endLine);
                Position position = new Position(start, end - start);
                LanguageProjectAnnotation annotation = new LanguageProjectAnnotation(language, type);
                LanguageColorizer colorizer = LanguageRegistry.getLanguageColorizer(language);
                Color fgColor = null;
                Color bgColor = null;
                if (colorizer != null && colorizer.getFoldingFg() != null) {
                    fgColor = colorizer.getFoldingFg();
                    bgColor = colorizer.getFoldingBg();
                    annotation.setColor(colorizer.getFoldingFg());
                } else if (this.foldingFgColor != null) {
                    fgColor = this.foldingFgColor;
                    annotation.setColor(this.foldingFgColor);
                }
                if (fgColor != null) {
                    annotation.setCollapsedImage(annotation.getCollapsedImage(), fgColor, bgColor);
                    annotation.setExpandedImage(annotation.getExpandedImage(), fgColor, bgColor);
                }
                String pref = FoldingExtensionPointLoader.createInitialFoldingPreferenceId(language, type);
                IPreferenceStore store = UnifiedEditorsPlugin.getDefault().getPreferenceStore();
                if (this.firstReconcile && store.getBoolean(pref)) {
                    annotation.markCollapsed();
                }
                this.annotations.put(annotation, position);
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    public void parseForRegions(IParseState parseState) {
        IParseNode node = parseState.getParseResults();
        if (node != null) {
            this.emitChildren(node.getChildren());
            this.emitChildren(parseState.getCommentRegions());
        }
    }

    private void emitChildren(IParseNode[] nodes) {
        IPreferenceStore store = UnifiedEditorsPlugin.getDefault().getPreferenceStore();
        int i = 0;
        while (i < nodes.length) {
            IParseNode node = nodes[i];
            if (node.getStartingOffset() >= 0 && this.childTypes.containsKey(node.getLanguage())) {
                FoldingExtensionPointLoader.FoldingStructure fs = (FoldingExtensionPointLoader.FoldingStructure)this.childTypes.get(node.getLanguage());
                if (node.getChildCount() > 0) {
                    String prefID;
                    if ((fs.getHandler() == null || fs.getHandler().nodeIsFoldable(node)) && (fs.foldAllParents() || fs.getTypes().containsKey(node.getName())) && store.getBoolean(prefID = FoldingExtensionPointLoader.createEnablePreferenceId(fs.getLanguage()))) {
                        this.emitPosition(node.getStartingOffset(), node.getEndingOffset() - node.getStartingOffset(), node.getName(), node.getLanguage());
                    }
                    this.emitChildren(node.getChildren());
                } else {
                    String prefID;
                    String nm;
                    String string = nm = node instanceof IHasCustomFoldingType ? ((IHasCustomFoldingType)node).getFoldingTypeName() : node.getName();
                    if ((fs.getTypes().containsKey(nm) || fs.getHandler() != null && fs.getHandler().nodeIsFoldable(node)) && store.getBoolean(prefID = FoldingExtensionPointLoader.createEnablePreferenceId(fs.getLanguage()))) {
                        this.emitPosition(node.getStartingOffset(), node.getEndingOffset() - node.getStartingOffset(), node.getName(), node.getLanguage());
                    }
                }
            }
            ++i;
        }
    }

    public void setFoldingAnnotationHoverColor(Color color) {
        this.foldingFgColor = color;
    }
}

