/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.toolbar;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.toolbar.ToolBarContribution;
import com.aptana.ide.editors.toolbar.ToolBarContributionRegistry;
import com.aptana.ide.editors.unified.IUnifiedEditor;
import com.aptana.ide.editors.unified.UnifiedColorManager;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class ToolbarWidget {
    private CTabFolder types;
    private ToolItem linkItem;
    private Composite buttons;
    private Font toolbarFont;
    private List<String> mimeTypes;
    private List<String> mimeTypeLabels;
    private IPreferenceStore store;
    private IUnifiedEditor editor;
    private String linkPreference;
    private List<Image> images = new ArrayList<Image>();
    public static final Color TAB_TEXT = UnifiedColorManager.getInstance().getColor(new RGB(75, 75, 75));
    public static final Color TOOLBAR_BG = UnifiedColorManager.getInstance().getColor(new RGB(200, 200, 200));
    public static final Color TAB_SELECTED_COLOR = UnifiedColorManager.getInstance().getColor(new RGB(175, 175, 175));

    public ToolbarWidget(String[] mimeTypes, String[] mimeTypeLabels, IPreferenceStore store, String linkPreference, IUnifiedEditor editor) {
        this.mimeTypes = new ArrayList<String>();
        this.mimeTypeLabels = new ArrayList<String>();
        this.store = store;
        this.linkPreference = linkPreference;
        this.editor = editor;
        if (mimeTypes != null && mimeTypes.length > 0 && mimeTypeLabels != null && mimeTypeLabels.length > 0 && mimeTypes.length == mimeTypeLabels.length) {
            int i = 0;
            while (i < mimeTypes.length) {
                this.mimeTypes.add(mimeTypes[i]);
                this.mimeTypeLabels.add(mimeTypeLabels[i]);
                ++i;
            }
        }
    }

    public void dispose() {
        int i = 0;
        while (i < this.images.size()) {
            this.images.get(i).dispose();
            ++i;
        }
        if (this.toolbarFont != null) {
            this.toolbarFont.dispose();
        }
    }

    public void setVisible(boolean visible) {
        if (this.buttons != null && !this.buttons.isDisposed()) {
            this.buttons.setVisible(visible);
            GridData data = (GridData)this.buttons.getLayoutData();
            data.exclude = !visible;
        }
    }

    public boolean isVisible() {
        if (this.buttons != null && !this.buttons.isDisposed()) {
            return this.buttons.isVisible();
        }
        return false;
    }

    public Composite createControl(Composite parent) {
        this.buttons = new Composite(parent, 0);
        GridLayout bLayout = new GridLayout(1, true);
        bLayout.marginHeight = 0;
        bLayout.marginWidth = 0;
        this.buttons.setLayout((Layout)bLayout);
        this.buttons.setLayoutData((Object)new GridData(4, 4, true, false));
        int toolbarsFound = 0;
        if (this.mimeTypes.size() > 1) {
            this.types = new CTabFolder(this.buttons, 0x800080);
            this.types.setSimple(true);
            this.types.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    e.gc.setBackground(e.display.getSystemColor(18));
                    e.gc.fillRectangle(0, 0, 1, 2);
                    e.gc.fillRectangle(0, 0, 2, 1);
                    if (e.width - 2 > -1) {
                        e.gc.fillRectangle(e.width - 1, 0, 1, 2);
                        e.gc.fillRectangle(e.width - 2, 0, 2, 1);
                    }
                }
            });
            Composite gradient = new Composite((Composite)this.types, 0);
            GridLayout gLayout = new GridLayout(1, true);
            gLayout.marginHeight = 0;
            gLayout.marginWidth = 0;
            gradient.setLayout((Layout)gLayout);
            gradient.setLayoutData((Object)new GridData(4, 4, true, true));
            gradient.setBackground(TOOLBAR_BG);
            ToolBar tb = new ToolBar(gradient, 0x800040);
            tb.setBackground(TOOLBAR_BG);
            GridData tbData = new GridData(0x1000008, 4, true, false);
            tb.setLayoutData((Object)tbData);
            this.linkItem = new ToolItem(tb, 32);
            this.linkItem.setImage(UnifiedEditorsPlugin.getImage("icons/link.gif"));
            this.linkItem.setToolTipText("Link with cursor");
            this.linkItem.setSelection(this.store.getBoolean(this.linkPreference));
            this.linkItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ToolbarWidget.this.store.setValue(ToolbarWidget.this.linkPreference, ToolbarWidget.this.linkItem.getSelection());
                }
            });
            this.types.setTopRight((Control)gradient, 4);
            this.types.setBackground(TOOLBAR_BG);
            this.types.setForeground(TAB_TEXT);
            GridLayout tLayout = new GridLayout(1, true);
            tLayout.marginHeight = 0;
            tLayout.marginWidth = 0;
            this.types.setLayout((Layout)tLayout);
            this.types.setBorderVisible(true);
            this.types.setSelectionBackground(TAB_SELECTED_COLOR);
            this.types.setSelectionForeground(TAB_TEXT);
            this.types.setLayoutData((Object)new GridData(4, 4, true, false));
            int fontsize = 8;
            if ("macosx".equals(Platform.getOS())) {
                fontsize = 10;
            }
            this.toolbarFont = new Font((Device)this.types.getDisplay(), "Arial", fontsize, 0);
            this.types.setFont(this.toolbarFont);
            String[] languages = this.mimeTypes.toArray(new String[0]);
            String[] labels = this.mimeTypeLabels.toArray(new String[0]);
            this.types.setTabHeight(14);
            int i = 0;
            while (i < languages.length) {
                String mimeType = languages[i];
                List items = ToolBarContributionRegistry.getInstance().getContributions(mimeType);
                toolbarsFound += items.size();
                if (items.size() > 0) {
                    tb = new ToolBar((Composite)this.types, 0x800040);
                    tb.setBackground(TOOLBAR_BG);
                    tbData = new GridData(4, 4, true, false);
                    tb.setLayoutData((Object)tbData);
                    CTabItem tab = new CTabItem(this.types, 0);
                    tab.setData((Object)mimeType);
                    tab.setControl((Control)tb);
                    tab.setText(labels[i]);
                    for (final ToolBarContribution item : items) {
                        if (item == null) continue;
                        ToolItem tItem = new ToolItem(tb, 8);
                        tItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                item.getInstance().execute(ToolbarWidget.this.editor, "");
                            }
                        });
                        if (item.getIcon() != null) {
                            try {
                                Image image = item.getIcon().createImage();
                                this.images.add(image);
                                tItem.setImage(image);
                            }
                            catch (SWTException ex) {
                                IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)StringUtils.format((String)"Unable to load image for snippet {0}", (String)item.getText()), (Throwable)ex);
                            }
                        } else {
                            tItem.setText(item.getText());
                        }
                        tItem.setToolTipText(item.getTooltipText());
                    }
                }
                ++i;
            }
            this.types.setSelection(0);
        } else if (this.mimeTypes.size() == 1) {
            String mimeType = this.mimeTypes.get(0);
            List items = ToolBarContributionRegistry.getInstance().getContributions(mimeType);
            toolbarsFound += items.size();
            if (items.size() > 0) {
                ToolBar tb = new ToolBar(this.buttons, 0x800040);
                tb.setBackground(TOOLBAR_BG);
                GridData tbData = new GridData(4, 4, true, false);
                tb.setLayoutData((Object)tbData);
                for (final ToolBarContribution item : items) {
                    if (item == null) continue;
                    ToolItem tItem = new ToolItem(tb, 8);
                    tItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            item.getInstance().execute(ToolbarWidget.this.editor, "");
                        }
                    });
                    if (item.getIcon() != null) {
                        try {
                            Image image = item.getIcon().createImage();
                            this.images.add(image);
                            tItem.setImage(image);
                        }
                        catch (SWTException ex) {
                            IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)StringUtils.format((String)"Unable to load image for snippet {0}", (String)item.getText()), (Throwable)ex);
                        }
                    } else {
                        tItem.setText(item.getText());
                    }
                    tItem.setToolTipText(item.getTooltipText());
                }
            }
        }
        if (toolbarsFound == 0) {
            IdeLog.logWarning((Plugin)UnifiedEditorsPlugin.getDefault(), (String)("No Toolbar Contributers in Registry for MimeTypes: " + this.mimeTypes.toString()));
            this.setVisible(false);
        }
        return this.buttons;
    }

    public void hookCursorListener() {
        final ISourceViewer viewer = this.editor.getViewer();
        if (viewer instanceof TextViewer) {
            ((TextViewer)viewer).addPostSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ITextSelection selection = (ITextSelection)event.getSelection();
                    int offset = selection.getOffset();
                    if (ToolbarWidget.this.linkItem != null && ToolbarWidget.this.linkItem.getSelection() && ToolbarWidget.this.types != null) {
                        try {
                            String type = TextUtilities.getContentType((IDocument)viewer.getDocument(), (String)"__unified_partitioning", (int)offset, (boolean)true);
                            CTabItem[] items = ToolbarWidget.this.types.getItems();
                            int i = 0;
                            while (i < items.length) {
                                if (items[i].getData().equals(type)) {
                                    ToolbarWidget.this.types.setSelection(items[i]);
                                    break;
                                }
                                ++i;
                            }
                        }
                        catch (BadLocationException badLocationException) {}
                    }
                }
            });
        }
    }
}

