/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.profiles;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.profiles.IProfileFileProcessor;
import com.aptana.ide.editors.profiles.ProfileFileTypeInfo;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileFileTypeManager {
    private static final String FILE_PROCESSOR_ID = "fileProcessor";
    private static final Object TAG_FILE_PROCESSOR = "fileProcessor";
    private static final String ATTR_EXTENSION = "extension";
    private static final String ATTR_PROCESSOR = "processor";
    private static ProfileFileTypeManager instance;
    private Map<String, ProfileFileTypeInfo> _infoMap;

    public static ProfileFileTypeManager getInstance() {
        if (instance == null) {
            instance = new ProfileFileTypeManager();
        }
        return instance;
    }

    private ProfileFileTypeManager() {
    }

    public ProfileFileTypeInfo[] getAllInfos() {
        this.loadInfoMap();
        Collection<ProfileFileTypeInfo> infos = this._infoMap.values();
        return infos.toArray(new ProfileFileTypeInfo[infos.size()]);
    }

    public ProfileFileTypeInfo getInfo(String extension) {
        this.loadInfoMap();
        return this._infoMap.get(extension.toLowerCase(Locale.getDefault()));
    }

    private ProfileFileTypeInfo[] loadExtensions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        ArrayList<ProfileFileTypeInfo> processors = new ArrayList<ProfileFileTypeInfo>();
        if (registry != null) {
            IExtension[] extensions;
            IExtensionPoint extensionPoint = registry.getExtensionPoint("com.aptana.ide.editors", FILE_PROCESSOR_ID);
            IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
            int n = 0;
            int n2 = iExtensionArray.length;
            while (n < n2) {
                IExtension extension = iExtensionArray[n];
                this.processExtension(extension, processors);
                ++n;
            }
        }
        return processors.toArray(new ProfileFileTypeInfo[processors.size()]);
    }

    private void loadInfoMap() {
        if (this._infoMap == null) {
            this._infoMap = new HashMap<String, ProfileFileTypeInfo>();
            ProfileFileTypeInfo[] profileFileTypeInfoArray = this.loadExtensions();
            int n = 0;
            int n2 = profileFileTypeInfoArray.length;
            while (n < n2) {
                ProfileFileTypeInfo info = profileFileTypeInfoArray[n];
                this._infoMap.put(info.fileExtension, info);
                ++n;
            }
        }
    }

    private void processExtension(IExtension extension, List<ProfileFileTypeInfo> processors) {
        IConfigurationElement[] elements = extension.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (element.getName().equals(TAG_FILE_PROCESSOR)) {
                String fileExtension = element.getAttribute(ATTR_EXTENSION);
                IProfileFileProcessor processor = null;
                try {
                    processor = (IProfileFileProcessor)element.createExecutableExtension(ATTR_PROCESSOR);
                }
                catch (CoreException coreException) {
                    IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)MessageFormat.format("Unable to instantiate profile file processor for .{0}: {1}", fileExtension, element.getAttribute(ATTR_PROCESSOR)));
                }
                processors.add(new ProfileFileTypeInfo(fileExtension, processor));
            }
            ++i;
        }
    }
}

