/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.profiles;

import com.aptana.ide.core.PluginUtils;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.profiles.IProfileChangeListener;
import com.aptana.ide.editors.profiles.ProfileURI;
import com.aptana.ide.editors.profiles.TransientProfileURI;
import java.util.ArrayList;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;

public class Profile {
    private static final String JS_EXTENSION = ".js";
    private static final String SDOC_EXTENSION = ".sdoc";
    private static String PROFILE_NAME_PREF_PREFIX = "profile.";
    private static String PROFILE_LIST_KEY = "list";
    private static String PROFILE_FILES_KEY = "files";
    private ArrayList _listeners = new ArrayList();
    private ArrayList _fileList = new ArrayList();
    private String _profileName = null;
    private String _profileURI = null;
    private boolean _dynamic = false;

    public Profile(String name, String uri) {
        this(name, uri, false);
    }

    public Profile(String name, String uri, boolean dynamic) {
        this._profileName = name;
        this._profileURI = uri;
        this._dynamic = dynamic;
        this.load();
    }

    public String getName() {
        return this._profileName;
    }

    public String getURI() {
        return this._profileURI;
    }

    public void addURIs(String[] uris) {
        ArrayList<ProfileURI> ipaths = new ArrayList<ProfileURI>();
        int i = 0;
        while (i < uris.length) {
            if (!uris[i].endsWith(SDOC_EXTENSION)) {
                ipaths.add(new ProfileURI(uris[i], this));
            }
            ++i;
        }
        this.addURIsNoSave(ipaths.toArray(new ProfileURI[0]));
        ipaths.clear();
        i = 0;
        while (i < uris.length) {
            if (uris[i].endsWith(SDOC_EXTENSION)) {
                String jsFile = String.valueOf(uris[i].substring(0, uris[i].lastIndexOf(SDOC_EXTENSION))) + JS_EXTENSION;
                int index = this.containsURI(jsFile);
                if (index != -1) {
                    ProfileURI path = (ProfileURI)this._fileList.get(index);
                    ProfileURI[] currentChildren = path.getChildren();
                    boolean contains = false;
                    int j = 0;
                    while (j < currentChildren.length) {
                        if (currentChildren[j].getURI().equals(uris[i])) {
                            contains = true;
                            break;
                        }
                        ++j;
                    }
                    if (!contains) {
                        path.addChild(new ProfileURI(uris[i], this));
                    }
                } else {
                    ipaths.add(new ProfileURI(uris[i], this));
                }
            }
            ++i;
        }
        this.addURIs(ipaths.toArray(new ProfileURI[0]));
    }

    public void addTransientURIs(String[] uris) {
        ArrayList<TransientProfileURI> ipaths = new ArrayList<TransientProfileURI>();
        int i = 0;
        while (i < uris.length) {
            if (!uris[i].endsWith(SDOC_EXTENSION) && this.containsURI(uris[i]) == -1) {
                ipaths.add(new TransientProfileURI(uris[i], this));
            }
            ++i;
        }
        this.addURIsNoSave(ipaths.toArray(new ProfileURI[0]));
        ipaths.clear();
        i = 0;
        while (i < uris.length) {
            if (uris[i].endsWith(SDOC_EXTENSION)) {
                String jsFile = String.valueOf(uris[i].substring(0, uris[i].lastIndexOf(SDOC_EXTENSION))) + JS_EXTENSION;
                int index = this.containsURI(jsFile);
                if (index != -1) {
                    ProfileURI path = (ProfileURI)this._fileList.get(index);
                    path.addChild(new TransientProfileURI(uris[i], this));
                } else {
                    ipaths.add(new TransientProfileURI(uris[i], this));
                }
            }
            ++i;
        }
        this.addURIs(ipaths.toArray(new ProfileURI[0]));
    }

    private void addURIs(ProfileURI[] paths) {
        this.addURIsNoSave(paths);
        this.save();
    }

    private void addURIsNoSave(ProfileURI[] paths) {
        int i = 0;
        while (i < paths.length) {
            if (!this._fileList.contains(paths[i])) {
                this._fileList.add(paths[i]);
            }
            ++i;
        }
    }

    public void removeURIs(ProfileURI[] paths) {
        int i = 0;
        while (i < paths.length) {
            if (this._fileList.contains(paths[i])) {
                this._fileList.remove(paths[i]);
            }
            ++i;
        }
        this.save();
    }

    public void replaceAllURIs(String[] oldURIs, String[] newURIs) {
        this.removeURIsAsStringsNoSave(oldURIs);
        this.addTransientURIs(newURIs);
    }

    public void removeURIsAsStrings(String[] uris) {
        this.removeURIsAsStringsNoSave(uris);
        this.save();
    }

    private void removeURIsAsStringsNoSave(String[] uris) {
        int i = 0;
        while (i < uris.length) {
            ProfileURI path = new ProfileURI(uris[i]);
            if (this._fileList.contains(path)) {
                this._fileList.remove(path);
            }
            ++i;
        }
    }

    public void removeTransientURIs(String[] uris) {
        int j = 0;
        while (j < uris.length) {
            int index = this.containsURI(uris[j]);
            if (index != -1) {
                this._fileList.remove(index);
            }
            ++j;
        }
        if (uris.length > 0) {
            this.save();
        }
    }

    public int containsURI(String uri) {
        int i = 0;
        while (i < this._fileList.size()) {
            ProfileURI path = (ProfileURI)this._fileList.get(i);
            if (path.getURI().equals(uri)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public ProfileURI[] getURIs() {
        ProfileURI[] files = this._fileList.toArray(new ProfileURI[0]);
        return files;
    }

    public ProfileURI[] getURIsIncludingChildren() {
        ProfileURI[] files = this._fileList.toArray(new ProfileURI[0]);
        ArrayList<ProfileURI> list = new ArrayList<ProfileURI>();
        int i = 0;
        while (i < files.length) {
            list.add(files[i]);
            ProfileURI[] children = files[i].getChildren();
            int j = 0;
            while (j < children.length) {
                list.add(children[j]);
                ++j;
            }
            ++i;
        }
        return list.toArray(new ProfileURI[0]);
    }

    public String[] getURIsIncludingChildrenAsStrings() {
        ProfileURI[] files = this.getURIsIncludingChildren();
        String[] result = new String[files.length];
        int i = 0;
        while (i < result.length) {
            result[i] = files[i].getURI();
            ++i;
        }
        return result;
    }

    public String[] getURIsAsStrings() {
        return this.getURIsAsStrings(this._fileList);
    }

    public String[] getURIsAsStrings(ArrayList fileList) {
        String[] files = new String[fileList.size()];
        int i = 0;
        while (i < fileList.size()) {
            files[i] = ((ProfileURI)fileList.get(i)).getURI();
            ++i;
        }
        return files;
    }

    public void moveURIsUp(ProfileURI[] paths) {
        int i = 0;
        while (i < paths.length) {
            if (this._fileList.contains(paths[i])) {
                ProfileURI path = paths[i];
                int index = this._fileList.indexOf(path);
                if (index <= 0) {
                    return;
                }
                this._fileList.remove(path);
                this._fileList.add(index - 1, path);
            }
            ++i;
        }
        this.save();
    }

    public void moveURIsDown(ProfileURI[] paths) {
        int i = 0;
        while (i < paths.length) {
            if (this._fileList.contains(paths[i])) {
                ProfileURI path = paths[i];
                int index = this._fileList.indexOf(path);
                if (index >= this._fileList.size() - 1) {
                    return;
                }
                this._fileList.remove(path);
                this._fileList.add(index + 1, path);
            }
            ++i;
        }
        this.save();
    }

    public void clear() {
        this._fileList.clear();
        this.save();
    }

    public void load() {
        if (!this._dynamic) {
            try {
                Preferences prefs = UnifiedEditorsPlugin.getDefault().getPluginPreferences();
                String pathsString = prefs.getString(this.getProfileFilesKey(PROFILE_FILES_KEY));
                if (pathsString != null && !pathsString.trim().equals("")) {
                    this.load(pathsString.split(","));
                }
            }
            catch (Exception exception) {}
        }
    }

    public void load(String[] paths) {
        this._fileList.clear();
        this.addURIs(paths);
    }

    public void save() {
        if (!this._dynamic && PluginUtils.isPluginLoaded((Plugin)UnifiedEditorsPlugin.getDefault())) {
            Preferences prefs = UnifiedEditorsPlugin.getDefault().getPluginPreferences();
            String pathsString = this.profileURIsToString(this.getURIsIncludingChildren());
            prefs.setValue(this.getProfileFilesKey(PROFILE_FILES_KEY), pathsString);
            if (pathsString.length() > 0) {
                this.addProfileToMasterList(prefs);
            } else {
                this.removeProfileFromMasterList(prefs);
            }
            UnifiedEditorsPlugin.getDefault().savePluginPreferences();
        }
        this.fireProfileChangeEvent(this);
    }

    private void addProfileToMasterList(Preferences prefs) {
        boolean found = false;
        String profilesList = prefs.getString(Profile.getProfileListKey());
        if (profilesList != null && profilesList.length() > 0) {
            String[] names = profilesList.split(",");
            int i = 0;
            while (i < names.length) {
                if (names[i].equals(this.constructProfileKey())) {
                    found = true;
                    break;
                }
                ++i;
            }
        }
        if (!found) {
            if (profilesList == null || profilesList.length() == 0) {
                prefs.setValue(Profile.getProfileListKey(), this.constructProfileKey());
            } else {
                prefs.setValue(Profile.getProfileListKey(), String.valueOf(profilesList) + "," + this.constructProfileKey());
            }
        }
    }

    private String constructProfileKey() {
        return String.valueOf(this.getName()) + "=" + this.getURI();
    }

    private void removeProfileFromMasterList(Preferences prefs) {
        String newList = "";
        String profilesList = prefs.getString(Profile.getProfileListKey());
        if (profilesList != null && profilesList.length() > 0) {
            String[] names = profilesList.split(",");
            int i = 0;
            while (i < names.length) {
                if (!names[i].equals(this.constructProfileKey())) {
                    if (newList.length() > 0) {
                        newList = String.valueOf(newList) + ",";
                    }
                    newList = String.valueOf(newList) + names[i];
                }
                ++i;
            }
        }
        prefs.setValue(Profile.getProfileListKey(), newList);
    }

    public void fireProfileChangeEvent(Profile p) {
        int i = 0;
        while (i < this._listeners.size()) {
            IProfileChangeListener listener = (IProfileChangeListener)this._listeners.get(i);
            listener.onProfileChanged(p);
            ++i;
        }
    }

    public void addProfileChangeListener(IProfileChangeListener l) {
        this._listeners.add(l);
    }

    public void removeProfileChangeListener(IProfileChangeListener l) {
        this._listeners.remove(l);
    }

    public String profileURIsToString(ProfileURI[] paths) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < paths.length) {
            if (sb.length() != 0) {
                sb.append(",");
            }
            sb.append(paths[i].getURI());
            ++i;
        }
        String str = sb.toString();
        return str;
    }

    private String getProfileFilesKey(String keyName) {
        return String.valueOf(PROFILE_NAME_PREF_PREFIX) + this._profileURI + "." + keyName;
    }

    public static String getProfileListKey() {
        return String.valueOf(PROFILE_NAME_PREF_PREFIX) + "." + PROFILE_LIST_KEY;
    }

    public void setDynamic(boolean dynamic) {
        this._dynamic = dynamic;
    }

    public boolean isDynamic() {
        return this._dynamic;
    }

    public boolean isEquivalent(Profile p) {
        ProfileURI[] compareUris;
        if (p == null) {
            return false;
        }
        if (!this.getURI().equals(p.getURI())) {
            return false;
        }
        ProfileURI[] thisUris = this.getURIsIncludingChildren();
        if (thisUris.length != (compareUris = p.getURIsIncludingChildren()).length || thisUris.length == 0) {
            return false;
        }
        int i = 0;
        while (i < thisUris.length) {
            ProfileURI profileURI = thisUris[i];
            if (profileURI.equals(compareUris)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

