/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.actions;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.actions.Messages;
import com.aptana.ide.editors.unified.IUnifiedEditor;
import com.aptana.ide.editors.unified.IUnifiedEditorContributor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class ShowPianoKeys
extends TextEditorAction {
    private static boolean state = false;

    public ShowPianoKeys() {
        super(Messages.getResourceBundle(), "ShowPianoKeysAction.", null, 2);
        this.update();
    }

    public static boolean isInstanceChecked() {
        return state;
    }

    public void run() {
        state = this.isChecked();
        UnifiedEditorsPlugin plugin = UnifiedEditorsPlugin.getDefault();
        Preferences prefs = plugin.getPluginPreferences();
        prefs.setValue("com.aptana.ide.editors.SHOW_PIANO_KEYS", state);
        plugin.savePluginPreferences();
        this.setPianoKeys(state);
    }

    private void setPianoKeys(boolean state) {
        try {
            IUnifiedEditor uniEditor;
            ITextEditor editor = this.getTextEditor();
            if (editor instanceof IUnifiedEditor && (uniEditor = (IUnifiedEditor)editor) != null) {
                uniEditor.showPianoKeys(state);
                if (uniEditor.getBaseContributor() != null) {
                    IWorkbenchPage page;
                    IWorkbenchWindow window;
                    String language = uniEditor.getBaseContributor().getLocalContentType();
                    IWorkbench wb = PlatformUI.getWorkbench();
                    if (wb != null && language != null && (window = wb.getActiveWorkbenchWindow()) != null && (page = window.getActivePage()) != null) {
                        IEditorReference[] refs = page.getEditorReferences();
                        int i = 0;
                        while (refs != null && i < refs.length) {
                            IUnifiedEditorContributor contrib;
                            IEditorPart openEditor = refs[i].getEditor(false);
                            if (openEditor != null && openEditor instanceof IUnifiedEditor && (contrib = ((IUnifiedEditor)openEditor).getBaseContributor()) != null && language.equals(contrib.getLocalContentType())) {
                                ((IUnifiedEditor)openEditor).showPianoKeys(state);
                            }
                            ++i;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            IdeLog.logInfo((Plugin)UnifiedEditorsPlugin.getDefault(), (String)"Error setting piano keys preference", (Throwable)e);
        }
    }

    public void update() {
        UnifiedEditorsPlugin plugin = UnifiedEditorsPlugin.getDefault();
        Preferences prefs = plugin.getPluginPreferences();
        state = prefs.getBoolean("com.aptana.ide.editors.SHOW_PIANO_KEYS");
        this.setChecked(state);
    }
}

