/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source.projection;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;

public class UnifiedProjectionAnnotation
extends ProjectionAnnotation {
    public static final String TYPE = "org.eclipse.projection";
    private static final int COLOR = 15;
    private Image fgCollapsedImage;
    private Image fgExpandedImage;
    private Color color;
    private boolean fIsCollapsed = false;
    private boolean fIsRangeIndication = false;

    public UnifiedProjectionAnnotation() {
        this(false);
    }

    public UnifiedProjectionAnnotation(boolean isCollapsed) {
        super(isCollapsed);
        this.fIsCollapsed = isCollapsed;
    }

    public void setRangeIndication(boolean rangeIndication) {
        this.fIsRangeIndication = rangeIndication;
    }

    private void drawRangeIndication(GC gc, Canvas canvas, Rectangle r) {
        Color fg = gc.getForeground();
        gc.setForeground(this.color == null ? canvas.getDisplay().getSystemColor(15) : this.color);
        gc.setLineWidth(1);
        int height = Math.min(r.y + r.height - 3, canvas.getSize().y);
        gc.drawLine(r.x + 4, r.y + 12, r.x + 4, height);
        gc.drawLine(r.x + 4, height, r.x + r.width - 3, height);
        gc.setForeground(fg);
    }

    public void paint(GC gc, Canvas canvas, Rectangle rectangle) {
        Image image = this.getImage(canvas);
        if (image != null) {
            int valign = 128;
            if (image != null) {
                Rectangle bounds = image.getBounds();
                int y = 0;
                switch (valign) {
                    case 128: {
                        FontMetrics fontMetrics = gc.getFontMetrics();
                        y = (fontMetrics.getHeight() - bounds.height) / 2;
                        break;
                    }
                    case 0x1000000: {
                        y = (rectangle.height - bounds.height) / 2;
                        break;
                    }
                    case 1024: {
                        FontMetrics fontMetrics = gc.getFontMetrics();
                        y = rectangle.height - (fontMetrics.getHeight() + bounds.height) / 2;
                    }
                }
                gc.drawImage(image, 2, rectangle.y + y + 2);
            }
            if (this.fIsRangeIndication) {
                FontMetrics fontMetrics = gc.getFontMetrics();
                int delta = (fontMetrics.getHeight() - image.getBounds().height) / 2;
                rectangle.y += delta;
                rectangle.height -= delta;
                this.drawRangeIndication(gc, canvas, rectangle);
            }
        }
    }

    public int getLayer() {
        return 0;
    }

    private Image getImage(Canvas canvas) {
        this.initializeImages(canvas);
        return this.isCollapsed() ? this.fgCollapsedImage : this.fgExpandedImage;
    }

    public ImageDescriptor getCollapsedImage() {
        return ImageDescriptor.createFromFile(UnifiedProjectionAnnotation.class, (String)"images/collapsed.png");
    }

    public ImageDescriptor getExpandedImage() {
        return ImageDescriptor.createFromFile(UnifiedProjectionAnnotation.class, (String)"images/expanded.png");
    }

    private void initializeImages(Canvas canvas) {
        if (this.fgCollapsedImage == null) {
            ImageDescriptor descriptor = this.getCollapsedImage();
            this.fgCollapsedImage = descriptor.createImage((Device)canvas.getDisplay());
            descriptor = this.getExpandedImage();
            this.fgExpandedImage = descriptor.createImage((Device)canvas.getDisplay());
            canvas.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (UnifiedProjectionAnnotation.this.fgCollapsedImage != null) {
                        UnifiedProjectionAnnotation.this.fgCollapsedImage.dispose();
                        UnifiedProjectionAnnotation.this.fgCollapsedImage = null;
                    }
                    if (UnifiedProjectionAnnotation.this.fgExpandedImage != null) {
                        UnifiedProjectionAnnotation.this.fgExpandedImage.dispose();
                        UnifiedProjectionAnnotation.this.fgExpandedImage = null;
                    }
                }
            });
        }
    }

    public boolean isCollapsed() {
        return this.fIsCollapsed;
    }

    public void markCollapsed() {
        this.fIsCollapsed = true;
    }

    public void markExpanded() {
        this.fIsCollapsed = false;
    }

    public void setColor(Color color) {
        this.color = color;
    }
}

