/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.framework.jaxer.views.console;

import com.aptana.ide.framework.jaxer.views.console.Messages;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class ProxyComboControl {
    private Combo cmb;
    private CCombo ccmb;

    public ProxyComboControl(Composite controlBar) {
        if ("linux".equals(Platform.getOS())) {
            this.initCCombo(controlBar);
        } else {
            this.initCombo(controlBar);
        }
        Combo cm = this.cmb != null ? this.cmb : this.ccmb.getTabList()[0];
        cm.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                if (ProxyComboControl.this.getSelectionIndex() == -1) {
                    String text;
                    int height = event.gc.getFontMetrics().getHeight();
                    int vertOffset = (ProxyComboControl.this.getControl().getSize().y - height) / 2;
                    int count = ProxyComboControl.this.cmb != null ? ProxyComboControl.this.cmb.getItemCount() : ProxyComboControl.this.ccmb.getItemCount();
                    String string = text = count != 0 ? Messages.JaxerConsoleView_PLEASE_SELECT_COMMAND : Messages.JaxerConsoleView_HISTORY_CMB_TITLE;
                    if ("macosx".equals(Platform.getOS())) {
                        event.gc.drawText(text, 10, vertOffset - 5, true);
                    } else {
                        event.gc.drawText(text, 5, vertOffset, true);
                    }
                }
            }
        });
    }

    private void initCombo(Composite controlBar) {
        this.cmb = new Combo(controlBar, 2056);
        this.cmb.setVisibleItemCount(8);
    }

    private void initCCombo(Composite controlBar) {
        this.ccmb = new CCombo(controlBar, 2056);
        this.ccmb.setVisibleItemCount(8);
    }

    Control getControl() {
        if (this.cmb != null) {
            return this.cmb;
        }
        if (this.ccmb != null) {
            return this.ccmb;
        }
        return null;
    }

    public void add(String item) {
        if (this.cmb != null) {
            this.cmb.add(item);
        } else {
            this.ccmb.add(item);
        }
        this.redraw();
    }

    public void setEnabled(boolean b) {
        this.getControl().setEnabled(b);
        this.redraw();
    }

    public int getSelectionIndex() {
        if (this.cmb != null) {
            return this.cmb.getSelectionIndex();
        }
        return this.ccmb.getSelectionIndex();
    }

    public void select(int i) {
        if (this.cmb != null) {
            this.cmb.select(i);
        } else {
            this.ccmb.select(i);
        }
        this.redraw();
    }

    public void remove(int i) {
        if (this.cmb != null) {
            this.cmb.remove(i);
        } else {
            this.ccmb.remove(i);
        }
        this.redraw();
    }

    public boolean isEnabled() {
        return this.getControl().isEnabled();
    }

    public void setItems(String[] items) {
        if (this.ccmb != null) {
            this.ccmb.setItems(items);
        } else {
            this.cmb.setItems(items);
        }
        this.redraw();
    }

    public void redraw() {
        if (this.ccmb != null) {
            this.ccmb.layout(true, true);
            this.ccmb.redraw();
        } else {
            this.cmb.layout(true, true);
            this.cmb.redraw();
        }
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        if (this.cmb != null) {
            this.cmb.addSelectionListener(selectionListener);
        } else {
            this.ccmb.addSelectionListener(selectionListener);
        }
    }
}

