/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.framework.jaxer.server.manager;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.framework.jaxer.JaxerPlugin;
import com.aptana.ide.framework.jaxer.server.manager.BaseCommand;
import com.aptana.ide.framework.jaxer.server.manager.ICommand;
import com.aptana.ide.framework.jaxer.server.manager.IServerManager;
import com.aptana.ide.framework.jaxer.server.manager.Messages;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public final class ServerManager {
    public static final int HEADER_ONLY = 0;
    public static final int CONNECTED = 1;
    public static final int RECEIVED = 2;
    private static ServerManager manager;

    private ServerManager() {
    }

    public static ServerManager getInstance() {
        if (manager == null) {
            manager = new ServerManager();
        }
        return manager;
    }

    public void addHeartbeat(final IServerManager serverManager, final int interval, final int timeout) {
        Job job = new Job(String.valueOf(Messages.ServerManager_Monitoring) + serverManager.getHostname() + ":" + serverManager.getPort()){

            protected IStatus run(IProgressMonitor monitor) {
                int tries = 1;
                while (tries <= 5) {
                    BaseCommand command = new BaseCommand(serverManager.getPingData());
                    ServerManager.this.runCommand(serverManager, command, timeout, false, true);
                    if (command.getResponse() != null && command.getResponse().length() > 0) {
                        if (serverManager.heartbeatCallback(true, command.getResponse())) {
                            this.schedule(interval);
                            break;
                        }
                    } else if (tries == 5) {
                        IdeLog.logInfo((Plugin)JaxerPlugin.getDefault(), (String)"Signaling failed heartback callback after five consecutive heartbeat failures to JaxerManager");
                        if (serverManager.heartbeatCallback(false, command.getResponse())) {
                            this.schedule(interval);
                        }
                    } else {
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    ++tries;
                }
                return Status.OK_STATUS;
            }
        };
        job.setPriority(20);
        job.setSystem(true);
        job.schedule((long)interval);
    }

    private String getFirstString(ICommand command, String hostname, int port, int timeout) {
        String firstLine = "";
        String request = command.getRequest();
        try {
            Socket socket = new Socket();
            socket.setKeepAlive(false);
            socket.setSoLinger(false, 0);
            socket.setSoTimeout(timeout);
            socket.setTcpNoDelay(true);
            socket.connect(new InetSocketAddress(hostname, port), timeout);
            boolean connected = socket.isConnected();
            if (connected) {
                command.setStatus(1);
                OutputStream os = socket.getOutputStream();
                PrintWriter writer = new PrintWriter(os, true);
                writer.println(request);
                writer.flush();
                InputStream is = socket.getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                String line = reader.readLine();
                if (line != null) {
                    while (line.length() != 0) {
                        line = reader.readLine();
                    }
                    command.setStatus(0);
                    firstLine = reader.readLine();
                    if (firstLine == null) {
                        command.setStatus(0);
                    } else {
                        command.setStatus(2);
                    }
                }
                reader.close();
                writer.close();
                socket.close();
            }
        }
        catch (Exception e) {
            IdeLog.logInfo((Plugin)JaxerPlugin.getDefault(), (String)("Error occurred contacting server: " + hostname + ":" + port), (Throwable)e);
        }
        return firstLine;
    }

    public void runCommand(IServerManager manager, ICommand command, int timeout) {
        this.runCommand(manager, command, timeout, false, true);
    }

    public void runCommand(IServerManager manager, ICommand command, int timeout, boolean asynchronously, final boolean executeCallback) {
        if (asynchronously) {
            final IServerManager mng = manager;
            final int to = timeout;
            final ICommand cmd = command;
            Job job = new Job(Messages.ServerManager_RunningServerCommand){

                protected IStatus run(IProgressMonitor monitor) {
                    String response = ServerManager.this.getFirstString(cmd, mng.getHostname(), mng.getPort(), to);
                    cmd.setResponse(response);
                    if (executeCallback) {
                        mng.commandCallback(cmd);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setPriority(20);
            job.setSystem(true);
            job.schedule();
        } else {
            String response = this.getFirstString(command, manager.getHostname(), manager.getPort(), timeout);
            command.setResponse(response);
            if (executeCallback) {
                manager.commandCallback(command);
            }
        }
    }
}

