/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.framework.jaxer.server.dialogs;

import com.aptana.ide.core.ui.IValidator;
import com.aptana.ide.framework.jaxer.server.dialogs.JaxerConfigurationBlock;
import com.aptana.ide.framework.jaxer.server.dialogs.Messages;
import com.aptana.ide.server.core.IAbstractConfiguration;
import com.aptana.ide.server.core.IServer;
import com.aptana.ide.server.ui.IConfigurationDialog;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class JaxerConfigurationDialog
extends TitleAreaDialog
implements IConfigurationDialog,
IValidator {
    public static int RESTORE_DEFAULTS_ID = 500;
    private boolean isEdit;
    private IAbstractConfiguration configuration;
    private Composite displayArea;
    private JaxerConfigurationBlock block;
    private boolean isInternal = false;
    private IServer server;

    public void create() {
        super.create();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), "com.aptana.ide.server.ui.servers_add_jaxer");
    }

    public JaxerConfigurationDialog() {
        super(Display.getDefault().getActiveShell());
    }

    protected Control createDialogArea(Composite parent) {
        this.isInternal = "jaxerInternalServer".equals(this.getConfiguration().getStringAttribute("id"));
        this.setTitle(Messages.JaxerConfigurationDialog_JaxerServer);
        this.getShell().setText(Messages.JaxerConfigurationDialog_AddJaxerServer);
        this.setMessage(Messages.JaxerConfigurationDialog_ConfigureJaxerServer);
        this.displayArea = new Composite(parent, 0);
        GridLayout daLayout = new GridLayout(3, false);
        daLayout.marginHeight = 10;
        daLayout.marginWidth = 10;
        this.displayArea.setLayout((Layout)daLayout);
        GridData daData = new GridData(4, 4, true, true);
        daData.widthHint = 600;
        this.displayArea.setLayoutData((Object)daData);
        this.block = new JaxerConfigurationBlock();
        this.block.setInternal(this.isInternal);
        this.block.setValidator(this);
        this.block.setConfiguration(this.getConfiguration());
        this.block.createContents(this.displayArea);
        return this.displayArea;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == RESTORE_DEFAULTS_ID && this.isInternal) {
            this.block.restoreDefaults();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (this.isInternal) {
            this.createButton(parent, RESTORE_DEFAULTS_ID, Messages.JaxerConfigurationDialog_RESTORE_DEFAULTS, false);
        }
        super.createButtonsForButtonBar(parent);
    }

    protected Control createContents(Composite parent) {
        Control c = super.createContents(parent);
        this.block.validateConfiguration();
        return c;
    }

    public void validate() {
        Button ok = this.getButton(0);
        if (ok != null) {
            String msg = this.block.getErrorMessage();
            if (this.server != null && this.server.getServerState() != 4 && this.server.getServerState() != 0) {
                msg = Messages.JaxerConfigurationDialog_ONLY_STOPPED_MAY_BE_CHANGED;
            }
            this.setErrorMessage(msg);
            ok.setEnabled(msg == null);
        }
    }

    protected void okPressed() {
        this.block.save();
        super.okPressed();
    }

    public Dialog getDialog() {
        return this;
    }

    public boolean isEdit() {
        return this.isEdit;
    }

    public void setEdit(boolean isEdit) {
        this.isEdit = isEdit;
    }

    public IAbstractConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(IAbstractConfiguration configuration) {
        this.configuration = configuration;
    }

    public void setServer(IServer server) {
        this.server = server;
    }
}

