/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.framework.jaxer.server.dialogs;

import com.aptana.ide.core.ui.IValidator;
import com.aptana.ide.framework.jaxer.JaxerPlugin;
import com.aptana.ide.framework.jaxer.server.JaxerServerProvider;
import com.aptana.ide.framework.jaxer.server.JaxerServerTypeDelegate;
import com.aptana.ide.framework.jaxer.server.dialogs.Messages;
import com.aptana.ide.server.ServerCore;
import com.aptana.ide.server.core.IAbstractConfiguration;
import com.aptana.ide.server.core.IServer;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class JaxerConfigurationBlock {
    private IValidator validator;
    private String errorMessage;
    private Set<String> serverNames = new HashSet<String>();
    private IAbstractConfiguration configuration;
    private boolean internal = false;
    private Composite displayArea;
    private Label serverNameLabel;
    private Text serverNameText;
    private Button localJaxer;
    private Label jaxerFolderLabel;
    private Text jaxerFolderText;
    private Button jaxerFolderBrowse;
    private Label webPortLabel;
    private Text webPortText;
    private Label minProcessesLabel;
    private Spinner minProcessesSpinner;
    private Label maxProcessesLabel;
    private Spinner maxProcessesSpinner;
    private Label timeoutLabel;
    private Spinner timeoutSpinner;
    private Label secondsLabel;
    private Button useTraceLogging;
    private Label hostnameLabel;
    private Text hostnameText;
    private Label portLabel;
    private Text portText;
    private Label bindToLocal;
    private Combo locals;
    private ModifyListener mListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            JaxerConfigurationBlock.this.validateConfiguration();
        }
    };
    private Text serverDescText;
    private Label serverDescLabel;
    private Text log;

    public void setValidator(IValidator validator) {
        this.validator = validator;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setConfiguration(IAbstractConfiguration configuration) {
        this.configuration = configuration;
    }

    public Composite getControl() {
        return this.displayArea;
    }

    public void createContents(Composite parent) {
        this.initDublicateNames();
        this.displayArea = new Composite(parent, 0);
        GridLayout daLayout = new GridLayout(3, false);
        daLayout.marginHeight = 10;
        daLayout.marginWidth = 10;
        this.displayArea.setLayout((Layout)daLayout);
        GridData daData = new GridData(4, 4, true, true);
        daData.widthHint = 500;
        this.displayArea.setLayoutData((Object)daData);
        this.serverNameLabel = new Label(this.displayArea, 16384);
        this.serverNameLabel.setText(Messages.JaxerConfigurationDialog_ServerName);
        this.serverNameText = new Text(this.displayArea, 2052);
        GridData sntData = new GridData(4, 4, true, false);
        sntData.horizontalSpan = 2;
        this.serverNameText.setLayoutData((Object)sntData);
        if (this.configuration != null) {
            this.serverNameText.setText(this.configuration.getStringAttribute("name"));
        }
        this.serverNameText.setEnabled(!this.internal);
        this.serverNameText.addModifyListener(this.mListener);
        this.serverDescLabel = new Label(this.displayArea, 16384);
        this.serverDescLabel.setText(Messages.JaxerConfigurationDialog_Description);
        this.serverDescText = new Text(this.displayArea, 2052);
        this.serverDescText.setEnabled(!this.internal);
        GridData sndData = new GridData(4, 4, true, false);
        sndData.horizontalSpan = 2;
        this.serverDescText.setLayoutData((Object)sndData);
        if (this.configuration != null) {
            this.serverDescText.setText(this.configuration.getStringAttribute("description"));
        }
        this.serverDescText.addModifyListener(this.mListener);
        this.hostnameLabel = new Label(this.displayArea, 16384);
        this.hostnameLabel.setText(Messages.JaxerConfigurationDialog_Hostname);
        this.hostnameText = new Text(this.displayArea, 2052);
        this.hostnameText.setEnabled(!this.internal);
        String path = this.configuration.getStringAttribute("JAXER_SERVER_REMOTE_HOSTNAME_KEY");
        if (path.length() == 0) {
            path = "127.0.0.1";
        }
        this.hostnameText.setText(path);
        this.hostnameText.addModifyListener(this.mListener);
        GridData htData = new GridData(4, 4, true, false);
        htData.horizontalSpan = 2;
        this.hostnameText.setLayoutData((Object)htData);
        this.portLabel = new Label(this.displayArea, 16384);
        this.portLabel.setText(Messages.JaxerConfigurationDialog_AdminPort);
        this.portText = new Text(this.displayArea, 2052);
        String adminPort = this.configuration.getStringAttribute("JAXER_SERVER_ADMIN_PORT_KEY");
        if (adminPort.length() != 0) {
            this.portText.setText(adminPort);
        } else {
            this.portText.setText("4328");
        }
        this.portText.addModifyListener(this.mListener);
        GridData ptData = new GridData(4, 4, true, false);
        ptData.horizontalSpan = 2;
        this.portText.setLayoutData((Object)ptData);
        this.webPortLabel = new Label(this.displayArea, 16384);
        GridData wptData = new GridData(4, 4, true, false);
        wptData.horizontalSpan = 2;
        this.webPortLabel.setText(Messages.JaxerConfigurationBlock_WebPort);
        this.webPortText = new Text(this.displayArea, 2052);
        this.webPortText.setLayoutData((Object)wptData);
        String webPort = this.configuration.getStringAttribute("JAXER_SERVER_WEB_PORT_KEY");
        if (webPort.length() != 0) {
            this.webPortText.setText(webPort);
        } else {
            this.webPortText.setText("4327");
        }
        this.webPortText.addModifyListener(this.mListener);
        this.log = this.createOpenExecutable(Messages.JaxerConfigurationBlock_PATH_TO_LOG_FILE, this.displayArea, "logpath");
        this.bindToLocal = new Label(this.displayArea, 16384);
        this.bindToLocal.setText(Messages.JaxerConfigurationDialog_BindToWebServer);
        this.locals = new Combo(this.displayArea, 4);
        GridData lData = new GridData(4, 4, true, false);
        lData.horizontalSpan = 2;
        this.locals.setLayoutData((Object)lData);
        if (!this.internal) {
            IServer[] servers;
            IServer[] iServerArray = servers = ServerCore.getServerManager().getServers();
            int n = 0;
            int n2 = iServerArray.length;
            while (n < n2) {
                IServer s = iServerArray[n];
                if (JaxerServerTypeDelegate.isCompatibleWebServer(s.getServerType().getId())) {
                    this.locals.add(s.getName());
                }
                ++n;
            }
        }
        this.locals.setText(this.configuration.getStringAttribute("JAXER_JETTY_ASSOCIATION"));
        this.locals.setEnabled(!this.internal);
        this.locals.addModifyListener(this.mListener);
        this.localJaxer = new Button(this.displayArea, 32);
        this.localJaxer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = JaxerConfigurationBlock.this.localJaxer.getSelection();
                JaxerConfigurationBlock.this.jaxerFolderText.setEnabled(selected);
                JaxerConfigurationBlock.this.jaxerFolderBrowse.setEnabled(selected);
                JaxerConfigurationBlock.this.minProcessesSpinner.setEnabled(selected);
                JaxerConfigurationBlock.this.maxProcessesSpinner.setEnabled(selected);
                JaxerConfigurationBlock.this.timeoutSpinner.setEnabled(selected);
                JaxerConfigurationBlock.this.useTraceLogging.setEnabled(selected);
                JaxerConfigurationBlock.this.validateConfiguration();
            }
        });
        this.localJaxer.setText(Messages.JaxerConfigurationDialog_ManageLocalJaxer);
        this.localJaxer.setEnabled(!this.internal);
        boolean useLocal = false;
        if (this.configuration != null && this.configuration.getStringAttribute("JAXER_SERVER_REMOTE_HOSTNAME_KEY").length() != 0) {
            useLocal = this.configuration.getBooleanAttribute("JAXER_IS_LOCAL_SERVER_KEY");
        }
        this.secondPart(useLocal);
    }

    private void secondPart(boolean useLocal) {
        GridData ljData = new GridData(4, 4, true, false);
        ljData.horizontalIndent = 5;
        ljData.horizontalSpan = 3;
        this.localJaxer.setLayoutData((Object)ljData);
        this.jaxerFolderLabel = new Label(this.displayArea, 16384);
        GridData jfData = new GridData(4, 0x1000000, false, false);
        jfData.horizontalIndent = 20;
        this.jaxerFolderLabel.setLayoutData((Object)jfData);
        this.jaxerFolderLabel.setText(Messages.JaxerConfigurationDialog_LocalJaxerFolder);
        this.jaxerFolderText = new Text(this.displayArea, 2052);
        this.jaxerFolderText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        if (useLocal && this.configuration != null) {
            String localPath = this.configuration.getStringAttribute("JAXER_SERVER_LOCAL_PATH_KEY");
            this.jaxerFolderText.setText(localPath);
        }
        this.jaxerFolderText.addModifyListener(this.mListener);
        this.jaxerFolderBrowse = new Button(this.displayArea, 8);
        this.jaxerFolderBrowse.setText(Messages.JaxerConfigurationDialog_Browse);
        this.jaxerFolderBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(JaxerConfigurationBlock.this.jaxerFolderBrowse.getShell());
                String managerFile = dialog.open();
                if (managerFile != null) {
                    JaxerConfigurationBlock.this.jaxerFolderText.setText(managerFile);
                    File pathToJaxer = new File(managerFile);
                    File upOneLevel = pathToJaxer.getParentFile();
                    File logs = new File(upOneLevel, "logs");
                    JaxerConfigurationBlock.this.log.setText(new File(logs, "jaxer.log").getAbsolutePath());
                }
            }
        });
        this.localJaxer.setSelection(useLocal);
        this.jaxerFolderBrowse.setEnabled(useLocal);
        this.jaxerFolderText.setEnabled(useLocal);
        this.minProcessesLabel = new Label(this.displayArea, 16384);
        GridData minproData = new GridData(4, 0x1000000, false, false);
        minproData.horizontalIndent = 20;
        this.minProcessesLabel.setLayoutData((Object)minproData);
        GridData mplData = new GridData(1, 4, false, false);
        mplData.horizontalSpan = 2;
        this.minProcessesLabel.setText(Messages.JaxerConfigurationBlock_MinimumJaxerProcess);
        this.minProcessesSpinner = new Spinner(this.displayArea, 2048);
        this.minProcessesSpinner.setMinimum(1);
        this.minProcessesSpinner.setMaximum(100);
        this.minProcessesSpinner.setIncrement(1);
        this.minProcessesSpinner.setLayoutData((Object)mplData);
        this.minProcessesSpinner.setBackground(this.minProcessesSpinner.getDisplay().getSystemColor(1));
        this.minProcessesSpinner.setEnabled(useLocal);
        int min = this.configuration.getIntAttribute("JAXER_MIN_PROCESSES");
        if (min < 0) {
            min = 3;
        }
        this.minProcessesSpinner.setSelection(min);
        this.minProcessesSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JaxerConfigurationBlock.this.maxProcessesSpinner.setMinimum(JaxerConfigurationBlock.this.minProcessesSpinner.getSelection());
            }
        });
        this.maxProcessesLabel = new Label(this.displayArea, 16384);
        GridData maxproData = new GridData(4, 0x1000000, false, false);
        maxproData.horizontalIndent = 20;
        this.maxProcessesLabel.setLayoutData((Object)maxproData);
        GridData maxData = new GridData(1, 4, false, false);
        maxData.horizontalSpan = 2;
        this.maxProcessesLabel.setText(Messages.JaxerConfigurationBlock_MaximumJaxerProcesses);
        this.maxProcessesSpinner = new Spinner(this.displayArea, 2048);
        this.maxProcessesSpinner.setMinimum(min);
        this.maxProcessesSpinner.setMaximum(100);
        this.maxProcessesSpinner.setIncrement(1);
        this.maxProcessesSpinner.setLayoutData((Object)maxData);
        this.maxProcessesSpinner.setBackground(this.maxProcessesSpinner.getDisplay().getSystemColor(1));
        this.maxProcessesSpinner.setEnabled(useLocal);
        int max = this.configuration.getIntAttribute("JAXER_MAX_PROCESSES");
        if (max <= 0) {
            max = 10;
        }
        this.maxProcessesSpinner.setSelection(max);
        this.timeoutLabel = new Label(this.displayArea, 16384);
        GridData tlData = new GridData(4, 0x1000000, false, false);
        tlData.horizontalIndent = 20;
        this.timeoutLabel.setLayoutData((Object)tlData);
        this.timeoutLabel.setText(Messages.JaxerConfigurationBlock_Timeout);
        Composite toComp = new Composite(this.displayArea, 0);
        GridLayout toLayout = new GridLayout(2, false);
        toLayout.marginWidth = 0;
        toLayout.marginHeight = 0;
        toComp.setLayout((Layout)toLayout);
        GridData tolData = new GridData(4, 4, true, false);
        tolData.horizontalSpan = 2;
        toComp.setLayoutData((Object)tolData);
        this.timeoutSpinner = new Spinner(toComp, 2048);
        this.timeoutSpinner.setMinimum(20);
        this.timeoutSpinner.setMaximum(200);
        this.timeoutSpinner.setIncrement(5);
        this.timeoutSpinner.setBackground(this.timeoutSpinner.getDisplay().getSystemColor(1));
        this.timeoutSpinner.setEnabled(useLocal);
        int to = this.configuration.getIntAttribute("JAXER_TIMEOUT");
        if (to < 0) {
            to = 45;
        }
        this.timeoutSpinner.setSelection(to);
        this.secondsLabel = new Label(toComp, 16384);
        this.secondsLabel.setText(Messages.JaxerConfigurationBlock_SECONDS);
        this.useTraceLogging = new Button(this.displayArea, 32);
        this.useTraceLogging.setText("Enable verbose logging");
        GridData tdata = new GridData(4, 4, true, false);
        tdata.horizontalIndent = 20;
        this.useTraceLogging.setLayoutData((Object)tdata);
        this.useTraceLogging.setSelection(this.configuration.getBooleanAttribute("VERBOSE_LOGGING"));
    }

    protected Text createOpenExecutable(String label, final Composite parent, String key) {
        Label ll = new Label(parent, 0);
        ll.setText(label);
        final Text t = new Text(parent, 2052);
        GridData ptData = new GridData(4, 0x1000000, true, false);
        ptData.horizontalSpan = 1;
        t.setLayoutData((Object)ptData);
        if (this.configuration != null) {
            t.setText(this.configuration.getStringAttribute(key));
        }
        t.addModifyListener(this.mListener);
        Button browser = new Button(parent, 8);
        browser.setText(Messages.JaxerConfigurationBlock_BROWSE_LOG);
        browser.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                String open;
                File file;
                File parentFile;
                FileDialog fdlg = new FileDialog(parent.getShell(), 4096);
                String text = t.getText();
                if (text.length() > 0 && (parentFile = (file = new File(text)).getParentFile()) != null) {
                    fdlg.setFilterPath(parentFile.getPath());
                }
                if ((open = fdlg.open()) != null) {
                    t.setText(open);
                }
            }
        });
        return t;
    }

    public void setEnabled(boolean enabled) {
        this.serverNameText.setEnabled(enabled);
        this.hostnameText.setEnabled(enabled);
        this.portText.setEnabled(enabled);
        this.locals.setEnabled(enabled);
        this.serverDescText.setEnabled(enabled);
        this.localJaxer.setEnabled(enabled);
        this.jaxerFolderText.setEnabled(enabled && this.localJaxer.getSelection());
        this.jaxerFolderBrowse.setEnabled(enabled && this.localJaxer.getSelection());
    }

    public void restoreDefaults() {
        if (this.internal) {
            IPreferenceStore store = JaxerPlugin.getDefault().getPreferenceStore();
            this.minProcessesSpinner.setSelection(store.getDefaultInt("JAXER_MIN_PROCESSES"));
            this.maxProcessesSpinner.setSelection(store.getDefaultInt("JAXER_MAX_PROCESSES"));
            this.timeoutSpinner.setSelection(store.getDefaultInt("JAXER_TIMEOUT"));
            this.webPortText.setText(store.getDefaultString("JAXER_SERVER_WEB_PORT_KEY"));
            this.portText.setText(store.getDefaultString("JAXER_SERVER_ADMIN_PORT_KEY"));
            this.jaxerFolderText.setText(store.getString("JAXER_INTERNAL_SERVER_LOCAL_PATH_KEY"));
            this.useTraceLogging.setSelection(false);
            this.log.setText(JaxerServerProvider.getLogFileLocation().toOSString());
        }
    }

    private void savePreferences() {
        if (this.internal) {
            IPreferenceStore store = JaxerPlugin.getDefault().getPreferenceStore();
            store.setValue("JAXER_MAX_PROCESSES", this.maxProcessesSpinner.getSelection());
            store.setValue("JAXER_MIN_PROCESSES", this.minProcessesSpinner.getSelection());
            store.setValue("JAXER_TIMEOUT", this.timeoutSpinner.getSelection());
            store.setValue("JAXER_SERVER_WEB_PORT_KEY", this.webPortText.getText());
            store.setValue("JAXER_SERVER_ADMIN_PORT_KEY", this.portText.getText());
            store.setValue("JAXER_SERVER_LOCAL_PATH_KEY", this.jaxerFolderText.getText());
            store.setValue("VERBOSE_LOGGING", this.useTraceLogging.getSelection());
        }
    }

    public void save() {
        this.savePreferences();
        this.configuration.setStringAttribute("name", this.serverNameText.getText());
        this.configuration.setStringAttribute("description", this.serverDescText.getText());
        if (this.localJaxer.getSelection()) {
            this.configuration.setBooleanAttribute("JAXER_IS_LOCAL_SERVER_KEY", true);
            this.configuration.setStringAttribute("JAXER_SERVER_LOCAL_PATH_KEY", this.jaxerFolderText.getText());
        } else {
            this.configuration.setBooleanAttribute("JAXER_IS_LOCAL_SERVER_KEY", false);
        }
        this.configuration.setIntAttribute("JAXER_SERVER_ADMIN_PORT_KEY", Integer.parseInt(this.portText.getText()));
        this.configuration.setStringAttribute("JAXER_SERVER_REMOTE_HOSTNAME_KEY", this.hostnameText.getText());
        this.configuration.setIntAttribute("JAXER_SERVER_WEB_PORT_KEY", Integer.parseInt(this.webPortText.getText()));
        this.configuration.setIntAttribute("JAXER_MIN_PROCESSES", this.minProcessesSpinner.getSelection());
        this.configuration.setIntAttribute("JAXER_MAX_PROCESSES", this.maxProcessesSpinner.getSelection());
        this.configuration.setIntAttribute("JAXER_TIMEOUT", this.timeoutSpinner.getSelection());
        this.configuration.setBooleanAttribute("VERBOSE_LOGGING", this.useTraceLogging.getSelection());
        this.configuration.setStringAttribute("logpath", this.log.getText());
        String name = this.locals.getText().trim();
        this.configuration.setStringAttribute("JAXER_JETTY_ASSOCIATION", name);
    }

    public void validateConfiguration() {
        Integer i;
        File file;
        String name = this.serverNameText.getText();
        String path = this.jaxerFolderText.getText().trim();
        String hostname = this.hostnameText.getText();
        String localBind = this.locals.getText();
        String port = this.portText.getText();
        String webPort = this.webPortText.getText();
        boolean isLocal = this.localJaxer.getSelection();
        boolean error = false;
        if (name.trim().length() == 0) {
            this.errorMessage = Messages.JaxerConfigurationDialog_ServerNameMustNotBeBlank;
            error = true;
        } else if (this.serverNames.contains(name)) {
            this.errorMessage = Messages.JaxerConfigurationDialog_ServerNameAlreadyExists;
            error = true;
        } else if (hostname.trim().length() == 0) {
            this.errorMessage = Messages.JaxerConfigurationDialog_HostNameMustNotBeBlank;
            error = true;
        } else if (isLocal && path.length() == 0) {
            this.errorMessage = Messages.JaxerConfigurationDialog_JaxerPathMustNotBeBlank;
            error = true;
        } else if (isLocal && path.length() > 0) {
            file = new File(path.trim());
            if (!file.exists()) {
                this.errorMessage = Messages.JaxerConfigurationBlock_PathMustBeValidFolder;
                error = true;
            } else {
                File[] files = file.listFiles();
                boolean exists = false;
                int i2 = 0;
                while (i2 < files.length) {
                    String fileName;
                    if (files[i2].isFile() && files[i2].exists() && ((fileName = files[i2].getName()).startsWith("JaxerManager") || fileName.equalsIgnoreCase("JaxerManager"))) {
                        exists = true;
                        break;
                    }
                    ++i2;
                }
                if (!exists) {
                    error = true;
                    this.errorMessage = Messages.JaxerConfigurationBlock_JaxerFolderMustContainJaxerManager;
                }
            }
        } else if (localBind.trim().length() != 0 && this.locals.getEnabled()) {
            String item = localBind.trim();
            String[] items = this.locals.getItems();
            boolean valid = false;
            int i3 = 0;
            while (i3 < items.length) {
                if (item.equals(items[i3])) {
                    valid = true;
                }
                ++i3;
            }
            if (!valid) {
                this.errorMessage = Messages.JaxerConfigurationDialog_LocalWebServerNameMustBeValid;
                error = true;
            }
        }
        if (!error) {
            try {
                i = Integer.parseInt(port);
                if (i < 0 || i > 65535) {
                    this.errorMessage = Messages.JaxerConfigurationDialog_AdminPortMustBeInRange;
                    error = true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.errorMessage = Messages.JaxerConfigurationDialog_AdminPortMustBeAnInteger;
                error = true;
            }
        }
        if (!error) {
            try {
                i = Integer.parseInt(webPort);
                if (i < 0 || i > 65535) {
                    this.errorMessage = Messages.JaxerConfigurationBlock_WebPortMustBeInRange;
                    error = true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.errorMessage = Messages.JaxerConfigurationBlock_WebPortMustBeAnInteger;
                error = true;
            }
        }
        if (!error) {
            if (!(this.log.getText().length() == 0 || (file = new File(this.log.getText())).exists() && file.isFile())) {
                this.errorMessage = Messages.JaxerConfigurationBlock_PATH_SHOULD_BE_EMPTY_OR_POINT_TO_FILE;
                error = true;
            }
            this.errorMessage = null;
        }
        if (this.validator != null) {
            this.validator.validate();
        }
    }

    private void initDublicateNames() {
        IServer[] servers;
        IServer[] iServerArray = servers = ServerCore.getServerManager().getServers();
        int n = 0;
        int n2 = iServerArray.length;
        while (n < n2) {
            IServer s = iServerArray[n];
            if (this.configuration == null || !s.getId().equals(this.configuration.getStringAttribute("id"))) {
                this.serverNames.add(s.getName());
            }
            ++n;
        }
    }

    public boolean isInternal() {
        return this.internal;
    }

    public void setInternal(boolean internal) {
        this.internal = internal;
    }
}

