/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.framework.jaxer.server;

import com.aptana.ide.core.FileUtils;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.framework.jaxer.JaxerPlugin;
import com.aptana.ide.framework.jaxer.handlers.JaxerStatisticsHandler;
import com.aptana.ide.framework.jaxer.server.JaxerServer;
import com.aptana.ide.framework.jaxer.server.Messages;
import com.aptana.ide.server.ServerCore;
import com.aptana.ide.server.core.IAbstractConfiguration;
import com.aptana.ide.server.core.IServer;
import com.aptana.ide.server.core.IServerManagerListener;
import com.aptana.ide.server.core.IServerType;
import com.aptana.ide.server.core.impl.Configuration;
import com.aptana.ide.server.core.impl.servers.ServerManager;
import com.aptana.ide.server.core.model.IServerProviderDelegate;
import com.aptana.ide.server.jetty.JettyDocumentRootResolver;
import com.aptana.ide.server.jetty.ResourceBaseServlet;
import com.aptana.ide.server.jetty.builder.JettyServerBuilder;
import com.aptana.jaxer.connectors.servlet.interfaces.IDocumentRootResolver;
import com.aptana.jaxer.connectors.servlet.interfaces.IStatisticsHandler;
import com.aptana.jaxer.connectors.servlet.interfaces.IStatisticsProvider;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import javax.servlet.Servlet;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;
import org.osgi.framework.Bundle;

public abstract class JaxerServerProvider
implements IServerProviderDelegate {
    public static final String INTERNAL_JAXER_SERVER_ID = "jaxerInternalServer";
    public static final String DEFAULT_LOCAL_JAXER_FOLDER = "/jam/jaxer/default_local_jaxer";
    public static final String CONFIG_APPS_FILE = "configApps.js";
    public static final String CONFIG_APPS_LOCATION = "/jam/jaxer/default_local_jaxer/conf/configApps.js";
    public static final String CONFIG_LOG_FILE = "configLog.js";
    public static final String CONFIG_LOG_LOCATION = "/jam/jaxer/default_local_jaxer/conf/configLog.js";
    public static final String CONFIG_FILE = "config.js";
    public static final String CONFIG_FILE_LOCATION = "/jam/jaxer/default_local_jaxer/conf/config.js";
    public static final String JAXER_MANAGER_CFG_FILE = "JaxerManager.cfg";
    public static final String JAXER_MANAGER_CFG_FILE_LOCATION = "/jam/jaxer/default_local_jaxer/conf/JaxerManager.cfg";
    public static final String JAXER_LOG_FILE = "jaxer.log";
    public static final String JAXER_STUDIO_DATA = "jaxer_studio_data";
    public static final String LOGS_FOLDER = "logs";
    public static final String DATA_FOLDER = "data";
    public static final String CONF_FOLDER = "conf";
    public static final String TEMP_FOLDER = "temp";
    public static final String EXTENSIONS_FOLDER = "extensions";
    public static final String LOCAL_JAXER_FOLDER = "local_jaxer";
    public static final String APPDATA_SQLITE = "appdata.sqlite";
    public static final String FRAMEWORKDATA_SQLITE = "frameworkdata.sqlite";

    public void addServerChangeListener(IServerManagerListener listener) {
    }

    protected void setConfigAttributes(IAbstractConfiguration config, String cmd) {
        String valuePath;
        IPreferenceStore store = JaxerPlugin.getDefault().getPreferenceStore();
        String defaultPath = store.getString("JAXER_INTERNAL_SERVER_LOCAL_PATH_KEY");
        if (defaultPath.equals(valuePath = store.getString("JAXER_SERVER_LOCAL_PATH_KEY")) || defaultPath.equals("")) {
            store.setValue("JAXER_SERVER_LOCAL_PATH_KEY", cmd);
        }
        store.setValue("JAXER_INTERNAL_SERVER_LOCAL_PATH_KEY", cmd);
        config.setBooleanAttribute("JAXER_IS_LOCAL_SERVER_KEY", true);
        config.setIntAttribute("JAXER_MIN_PROCESSES", store.getInt("JAXER_MIN_PROCESSES"));
        config.setIntAttribute("JAXER_MAX_PROCESSES", store.getInt("JAXER_MAX_PROCESSES"));
        config.setIntAttribute("JAXER_TIMEOUT", store.getInt("JAXER_TIMEOUT"));
        config.setStringAttribute("JAXER_SERVER_LOCAL_PATH_KEY", store.getString("JAXER_SERVER_LOCAL_PATH_KEY"));
        config.setIntAttribute("JAXER_CALLBACK_TO_WEB_SERVER", store.getInt("JAXER_CALLBACK_TO_WEB_SERVER"));
        config.setIntAttribute("JAXER_REQUEST_FROM_WEB_SERVER", store.getInt("JAXER_REQUEST_FROM_WEB_SERVER"));
        config.setIntAttribute("JAXER_REQUEST_TO_WEB_SERVER", store.getInt("JAXER_REQUEST_TO_WEB_SERVER"));
        config.setBooleanAttribute("VERBOSE_LOGGING", store.getBoolean("VERBOSE_LOGGING"));
        int adminPort = store.isDefault("JAXER_SERVER_ADMIN_PORT_KEY") ? ServerManager.findFreePort((int)5375, (int)5383) : store.getInt("JAXER_SERVER_ADMIN_PORT_KEY");
        config.setIntAttribute("JAXER_SERVER_ADMIN_PORT_KEY", adminPort);
        if (store.isDefault("JAXER_SERVER_WEB_PORT_KEY")) {
            config.setIntAttribute("JAXER_SERVER_WEB_PORT_KEY", ServerManager.findFreePort((int)5374, (int)5383, (int[])new int[]{adminPort}));
        } else {
            config.setIntAttribute("JAXER_SERVER_WEB_PORT_KEY", store.getInt("JAXER_SERVER_WEB_PORT_KEY"));
        }
        config.setStringAttribute("JAXER_JETTY_ASSOCIATION", "Built-in Preview Server");
        config.setStringAttribute("JAXER_SERVER_REMOTE_HOSTNAME_KEY", "127.0.0.1");
        config.setStringAttribute("name", Messages.JaxerServerProvider_JaxerInternalServer);
        config.setStringAttribute("id", INTERNAL_JAXER_SERVER_ID);
        config.setStringAttribute("description", "Jaxer Server");
    }

    protected void createConsole(IAbstractConfiguration config, URL console, int endPort) throws Exception {
        Server fServer = new Server(endPort);
        fServer.getConnectors()[0].setHost("127.0.0.1");
        Context context = new Context((HandlerContainer)fServer, "/", 1);
        ResourceBaseServlet servlet = new ResourceBaseServlet(console.getPath());
        context.addServlet(new ServletHolder((Servlet)servlet), "/");
        JettyServerBuilder.getInstance().buildServer(context, "com.aptana.ide.editor.html.preview.server", null, "127.0.0.1", config.getIntAttribute("JAXER_SERVER_WEB_PORT_KEY"), (IDocumentRootResolver)new JettyDocumentRootResolver(console.getPath()));
        fServer.setStopAtShutdown(true);
        fServer.start();
        IdeLog.logInfo((Plugin)JaxerPlugin.getDefault(), (String)(String.valueOf(Messages.JaxerServerProvider_StartingJettyToHostConsole) + endPort));
        IdeLog.logInfo((Plugin)JaxerPlugin.getDefault(), (String)("Hosting internal Jaxer Shell at:" + console.getPath()));
    }

    public abstract String getBundleID();

    public IServer[] getServers() {
        Bundle bundle = Platform.getBundle((String)this.getBundleID());
        URL jam = bundle.getEntry("/jam");
        JaxerServer server = null;
        try {
            jam = FileLocator.toFileURL((URL)jam);
            URL start = bundle.getEntry("/jam/jaxer/");
            if (start == null) {
                return new IServer[0];
            }
            start = FileLocator.toFileURL((URL)start);
            String cmd = start.getPath();
            IServerType tt = ServerCore.getServerManager().getServerType("com.aptana.ide.server.jaxer.jaxerHttpServer");
            Configuration config = new Configuration();
            this.setConfigAttributes((IAbstractConfiguration)config, cmd);
            URL console = bundle.getEntry("/jam/jaxer/aptana/tools/shell-studio/");
            String consoleURL = null;
            if (console != null) {
                console = FileLocator.toFileURL((URL)console);
                int endPort = ServerManager.findFreePort((int)8300, (int)8500);
                if (console != null) {
                    try {
                        this.createConsole((IAbstractConfiguration)config, console, endPort);
                        consoleURL = "http://127.0.0.1:" + endPort + "/index.html";
                    }
                    catch (Exception e) {
                        IdeLog.logError((Plugin)JaxerPlugin.getDefault(), (String)"Error starting console server for internal jaxer", (Throwable)e);
                        consoleURL = null;
                    }
                }
                IdeLog.logInfo((Plugin)JaxerPlugin.getDefault(), (String)("Internal Jaxer Shell URL:" + consoleURL));
            }
            final JaxerStatisticsHandler handler = new JaxerStatisticsHandler();
            handler.setID(INTERNAL_JAXER_SERVER_ID);
            final String finalConsoleURL = consoleURL;
            server = new JaxerServer(tt, 4, (IAbstractConfiguration)config){

                public String getConfigurationDescription() {
                    return Messages.JaxerServerProvider_UsedForHTMLPreviews;
                }

                public String getConsoleAddress() {
                    if (finalConsoleURL != null) {
                        return finalConsoleURL;
                    }
                    return super.getConsoleAddress();
                }

                protected IStatus start(String mode, IProgressMonitor monitor) {
                    JaxerPlugin.showInfoDialog(false);
                    JaxerPlugin.getDefault().getPreferenceStore().setValue("com.aptana.ide.framework.jaxer.preferences.ENABLE_BUILTIN_JAXER", true);
                    return super.start(mode, monitor);
                }

                protected IStatus stop(boolean force, IProgressMonitor monitor) {
                    JaxerPlugin.getDefault().getPreferenceStore().setValue("com.aptana.ide.framework.jaxer.preferences.ENABLE_BUILTIN_JAXER", false);
                    return super.stop(force, monitor);
                }

                protected void setStatisticsForAssociation(IStatisticsProvider provider) {
                    provider.setStatisticsHandler((IStatisticsHandler)handler);
                }

                public synchronized void heartbeatFailed(String response) {
                    IdeLog.logError((Plugin)JaxerPlugin.getDefault(), (String)"Disabling internal jaxer due to heartbeat failure");
                    JaxerPlugin.getDefault().getPreferenceStore().setValue("com.aptana.ide.framework.jaxer.preferences.ENABLE_BUILTIN_JAXER", false);
                    super.heartbeatFailed(response);
                }

                public void localJaxerFailed(Exception e) {
                    if (e != null) {
                        IdeLog.logError((Plugin)JaxerPlugin.getDefault(), (String)"Disabling internal jaxer server", (Throwable)e);
                        JaxerPlugin.getDefault().getPreferenceStore().setValue("com.aptana.ide.framework.jaxer.preferences.ENABLE_BUILTIN_JAXER", false);
                    }
                    super.localJaxerFailed(e);
                }
            };
            server.setLogFilePath(JaxerServerProvider.getLogFileLocation());
            this.addConfigOptions(server);
            if (JaxerPlugin.getDefault().getPreferenceStore().getBoolean("com.aptana.ide.framework.jaxer.preferences.ENABLE_BUILTIN_JAXER")) {
                server.start();
            }
            return new IServer[]{server};
        }
        catch (Exception e) {
            IdeLog.logInfo((Plugin)JaxerPlugin.getDefault(), (String)"Exception thrown creating internal Jaxer Server", (Throwable)e);
            if (server != null) {
                return new IServer[]{server};
            }
            return new IServer[0];
        }
    }

    public static IPath getLogFileLocation() {
        IPath logFile = null;
        IPath root = JaxerPlugin.getDefault().getStateLocation();
        IPath jaxerStudioData = root.append(JAXER_STUDIO_DATA);
        File jaxerStudioDataFolder = jaxerStudioData.toFile();
        if (!jaxerStudioDataFolder.exists()) {
            jaxerStudioDataFolder.mkdir();
        }
        if (jaxerStudioDataFolder.exists()) {
            IPath logsFolder = jaxerStudioData.append(LOGS_FOLDER);
            File logsFolderFile = logsFolder.toFile();
            if (!logsFolderFile.exists()) {
                logsFolderFile.mkdir();
            }
            if (logsFolderFile.exists()) {
                logFile = logsFolder.append(JAXER_LOG_FILE);
            }
        }
        return logFile;
    }

    private void addConfigOptions(JaxerServer server) {
        ArrayList<String> configs = new ArrayList<String>();
        configs.add("PLATFORM_CONF_PATH=resource:///framework/studio_config.js");
        IPath root = JaxerPlugin.getDefault().getStateLocation();
        IPath jaxerStudioData = root.append(JAXER_STUDIO_DATA);
        File jaxerStudioDataFolder = jaxerStudioData.toFile();
        if (!jaxerStudioDataFolder.exists() && !jaxerStudioDataFolder.mkdirs()) {
            IdeLog.logImportant((Plugin)JaxerPlugin.getDefault(), (String)("Failed to create " + jaxerStudioDataFolder));
            return;
        }
        configs.add("WORKSPACE_DATA_PATH=" + CoreUIUtils.getURI((File)jaxerStudioDataFolder));
        IPath tempFolder = jaxerStudioData.append(TEMP_FOLDER);
        File tempFolderFile = tempFolder.toFile();
        if (!tempFolderFile.exists() && !tempFolderFile.mkdirs()) {
            IdeLog.logImportant((Plugin)JaxerPlugin.getDefault(), (String)("Failed to create " + tempFolderFile));
        }
        String tempDirURI = tempFolderFile.getAbsolutePath();
        server.setTempDirectory(tempDirURI);
        Bundle bundle = Platform.getBundle((String)this.getBundleID());
        IPath localJaxerFolder = jaxerStudioData.append(LOCAL_JAXER_FOLDER);
        File localJaxerFolderFile = localJaxerFolder.toFile();
        if (!localJaxerFolderFile.exists()) {
            if (!localJaxerFolderFile.mkdirs()) {
                IdeLog.logImportant((Plugin)JaxerPlugin.getDefault(), (String)("Failed to create " + localJaxerFolderFile));
            }
            if (localJaxerFolderFile.exists()) {
                URL defaultlocalJaxerFolderURL = bundle.getEntry(DEFAULT_LOCAL_JAXER_FOLDER);
                try {
                    defaultlocalJaxerFolderURL = FileLocator.toFileURL((URL)defaultlocalJaxerFolderURL);
                    File defaultlocalJaxerFolder = new File(defaultlocalJaxerFolderURL.getFile());
                    FileUtils.copy((File)defaultlocalJaxerFolder, (File)localJaxerFolderFile);
                }
                catch (IOException iOException) {
                    IdeLog.logError((Plugin)JaxerPlugin.getDefault(), (String)"Error copying /jam/jaxer/default_local_jaxer");
                }
            }
        }
        if (localJaxerFolderFile.exists()) {
            IPath extsFolder;
            File extsFolderFile;
            IPath dataFolder;
            File dataFolderFile;
            IPath confFolder = localJaxerFolder.append(CONF_FOLDER);
            File confFolderFile = confFolder.toFile();
            if (!confFolderFile.exists()) {
                URL defaultConfFolderURL;
                if (!confFolderFile.mkdirs()) {
                    IdeLog.logImportant((Plugin)JaxerPlugin.getDefault(), (String)("Failed to create " + confFolderFile));
                }
                if (confFolderFile.exists() && (defaultConfFolderURL = bundle.getEntry("/jam/jaxer/default_local_jaxer/conf")) != null) {
                    try {
                        defaultConfFolderURL = FileLocator.toFileURL((URL)defaultConfFolderURL);
                        File defaultConfFolder = new File(defaultConfFolderURL.getFile());
                        FileUtils.copy((File)defaultConfFolder, (File)confFolderFile);
                    }
                    catch (IOException iOException) {
                        IdeLog.logError((Plugin)JaxerPlugin.getDefault(), (String)"Error copying /jam/jaxer/default_local_jaxer/conf");
                    }
                }
            }
            if (confFolderFile.exists()) {
                server.setConfigDirectory(confFolder.makeAbsolute().toOSString());
                this.addDefaultConfigs(confFolderFile);
                File confFile = new File(confFolderFile, CONFIG_FILE);
                File confLog = new File(confFolderFile, CONFIG_LOG_FILE);
                File confRoutes = new File(confFolderFile, CONFIG_APPS_FILE);
                File cfgFile = new File(confFolderFile, JAXER_MANAGER_CFG_FILE);
                if (confFile.exists()) {
                    server.setConfigFile(confFile.getAbsolutePath());
                }
                if (confLog.exists()) {
                    server.setConfigLogFile(confLog.getAbsolutePath());
                }
                if (confRoutes.exists()) {
                    server.setConfigRoutesFile(confRoutes.getAbsolutePath());
                }
                if (cfgFile.exists()) {
                    server.setJaxerManagerCfg(cfgFile.getAbsolutePath());
                }
            }
            if (!(dataFolderFile = (dataFolder = localJaxerFolder.append(DATA_FOLDER)).toFile()).exists()) {
                URL defaultDataFolderURL;
                if (!dataFolderFile.mkdirs()) {
                    IdeLog.logImportant((Plugin)JaxerPlugin.getDefault(), (String)("Failed to create " + confFolderFile));
                }
                if (dataFolderFile.exists() && (defaultDataFolderURL = bundle.getEntry("/jam/jaxer/default_local_jaxer/data")) != null) {
                    try {
                        defaultDataFolderURL = FileLocator.toFileURL((URL)defaultDataFolderURL);
                        File defaultDataFolder = new File(defaultDataFolderURL.getFile());
                        FileUtils.copy((File)defaultDataFolder, (File)dataFolderFile);
                    }
                    catch (IOException iOException) {
                        IdeLog.logError((Plugin)JaxerPlugin.getDefault(), (String)"Error copying /jam/jaxer/default_local_jaxer/data");
                    }
                }
            }
            if (dataFolderFile.exists()) {
                server.setDataDirectory(dataFolder.makeAbsolute().toOSString());
            }
            if (!(extsFolderFile = (extsFolder = localJaxerFolder.append(EXTENSIONS_FOLDER)).toFile()).exists()) {
                URL defaultExtensionFolderURL;
                if (!extsFolderFile.mkdirs()) {
                    IdeLog.logImportant((Plugin)JaxerPlugin.getDefault(), (String)("Failed to create " + extsFolderFile));
                }
                if (extsFolderFile.exists() && (defaultExtensionFolderURL = bundle.getEntry("/jam/jaxer/default_local_jaxer/extensions")) != null) {
                    try {
                        defaultExtensionFolderURL = FileLocator.toFileURL((URL)defaultExtensionFolderURL);
                        File defaultExtensionFolder = new File(defaultExtensionFolderURL.getFile());
                        FileUtils.copy((File)defaultExtensionFolder, (File)extsFolderFile);
                    }
                    catch (IOException iOException) {
                        IdeLog.logError((Plugin)JaxerPlugin.getDefault(), (String)"Error copying /jam/jaxer/default_local_jaxer/extensions");
                    }
                }
            }
            if (extsFolderFile.exists()) {
                server.setExtensionsDirectory(extsFolder.makeAbsolute().toOSString());
            }
        }
        server.setConfigOptions(configs.toArray(new String[0]));
    }

    private void addDefaultConfigs(File confFolderFile) {
        File logFile;
        File routesFile;
        File cfgFile;
        Bundle bundle = Platform.getBundle((String)this.getBundleID());
        File confFile = new File(confFolderFile, CONFIG_FILE);
        if (!confFile.exists()) {
            URL configURL = bundle.getEntry(CONFIG_FILE_LOCATION);
            boolean createEmpty = false;
            if (configURL != null) {
                try {
                    configURL = FileLocator.toFileURL((URL)configURL);
                    File targetConf = new File(configURL.getFile());
                    FileUtils.copy((File)targetConf, (File)confFile);
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)JaxerPlugin.getDefault(), (String)"Error copying config.js for internal Jaxer", (Throwable)e);
                    createEmpty = true;
                }
            } else {
                createEmpty = true;
            }
            if (createEmpty) {
                try {
                    confFile.createNewFile();
                }
                catch (IOException e) {
                    IdeLog.logError((Plugin)JaxerPlugin.getDefault(), (String)"Error creating config.js for internal Jaxer", (Throwable)e);
                }
            }
        }
        if (!(cfgFile = new File(confFolderFile, JAXER_MANAGER_CFG_FILE)).exists()) {
            URL cfgURL = bundle.getEntry(JAXER_MANAGER_CFG_FILE_LOCATION);
            boolean createEmpty = false;
            if (cfgURL != null) {
                try {
                    cfgURL = FileLocator.toFileURL((URL)cfgURL);
                    File targetCfg = new File(cfgURL.getFile());
                    FileUtils.copy((File)targetCfg, (File)cfgFile);
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)JaxerPlugin.getDefault(), (String)"Error copying JaxerManager.cfg for internal Jaxer", (Throwable)e);
                    createEmpty = true;
                }
            } else {
                createEmpty = true;
            }
            if (createEmpty) {
                try {
                    cfgFile.createNewFile();
                }
                catch (IOException e) {
                    IdeLog.logError((Plugin)JaxerPlugin.getDefault(), (String)"Error creating JaxerManager.cfg for internal Jaxer", (Throwable)e);
                }
            }
        }
        if (!(routesFile = new File(confFolderFile, CONFIG_APPS_FILE)).exists()) {
            URL routesURL = bundle.getEntry(CONFIG_APPS_LOCATION);
            boolean createEmpty = false;
            if (routesURL != null) {
                try {
                    routesURL = FileLocator.toFileURL((URL)routesURL);
                    File targetRoutes = new File(routesURL.getFile());
                    FileUtils.copy((File)targetRoutes, (File)routesFile);
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)JaxerPlugin.getDefault(), (String)"Error copying configRoutes.js for internal Jaxer", (Throwable)e);
                    createEmpty = true;
                }
            } else {
                createEmpty = true;
            }
            if (createEmpty) {
                try {
                    routesFile.createNewFile();
                }
                catch (IOException e) {
                    IdeLog.logError((Plugin)JaxerPlugin.getDefault(), (String)"Error creating configRoutes.js for internal Jaxer", (Throwable)e);
                }
            }
        }
        if (!(logFile = new File(confFolderFile, CONFIG_LOG_FILE)).exists()) {
            URL logURL = bundle.getEntry(CONFIG_LOG_LOCATION);
            boolean createEmpty = false;
            if (logURL != null) {
                try {
                    logURL = FileLocator.toFileURL((URL)logURL);
                    File targetLog = new File(logURL.getFile());
                    FileUtils.copy((File)targetLog, (File)logFile);
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)JaxerPlugin.getDefault(), (String)"Error copying configLog.js for internal Jaxer", (Throwable)e);
                    createEmpty = true;
                }
            } else {
                createEmpty = true;
            }
            if (createEmpty) {
                try {
                    logFile.createNewFile();
                }
                catch (IOException e) {
                    IdeLog.logError((Plugin)JaxerPlugin.getDefault(), (String)"Error creating configLog.js for internal Jaxer", (Throwable)e);
                }
            }
        }
    }

    public boolean isRemovable(IServer server) {
        return false;
    }

    public void removeServer(IServer server) {
        throw new UnsupportedOperationException();
    }

    public void removeServerChangeListener(IServerManagerListener listener) {
    }
}

