/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.framework.jaxer.server;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.core.ui.preferences.ApplicationPreferences;
import com.aptana.ide.framework.jaxer.JaxerPlugin;
import com.aptana.ide.framework.jaxer.server.Messages;
import com.aptana.ide.framework.jaxer.server.manager.BaseCommand;
import com.aptana.ide.framework.jaxer.server.manager.IManagerListener;
import com.aptana.ide.framework.jaxer.server.manager.JaxerManager;
import com.aptana.ide.framework.jaxer.server.manager.ServerManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.progress.UIJob;

public class JaxerManagerJob {
    public static final String LAST_JAXER_LOCATION = "com.aptana.ide.framework.jaxer.server.LAST_JAXER_LOCATION";
    public static final String LAST_STATE_LOCATION = "com.aptana.ide.framework.jaxer.server.LAST_STATE_LOCATION";
    public static final String WEBPORT = "--webport";
    public static final String COMMANDPORT = "--commandport";
    public static final String MINPROCESSES = "--minprocesses";
    public static final String MAXPROCESSES = "--maxprocesses";
    public static final String TRACE = "--trace";
    public static final String CFG = "--cfg";
    public static final String CONFIGFILE = "--configfile";
    public static final String TIMEOUT = "--timeout";
    public static final String REQUESTTIMEOUT = "--requesttimeout";
    public static final String TEMPDIR = "--cfg:tempdir";
    public static final String JAXER_TEMPDIR = "-tempdir";
    public static final String LOG_OUTPUT = "--log:output";
    public static final String REG = "-reg";
    public static final String JAXER_READY_COMMAND = "JaxerManager";
    public static final String JAXER_ERROR_COMMAND = "Error";
    public static final String LOCAL_EXTENSIONS_DIR = "LOCAL_EXTENSIONS_DIR";
    public static final String LOCAL_CONF_DIR = "LOCAL_CONF_DIR";
    public static final String DB_CONNECTION_PARAMS_PATH = "DB_CONNECTION_PARAMS.PATH";
    public static final String DB_FRAMEWORK_CONNECTION_PARAMS_PATH = "DB_FRAMEWORK_CONNECTION_PARAMS.PATH";
    public static final String LD_LIBRARY_PATH = "LD_LIBRARY_PATH";
    public static final String DYLD_LIBRARY_PATH = "DYLD_LIBRARY_PATH";
    public static final String WORKSPACE_DATA_PATH = "WORKSPACE_DATA_PATH";
    public static final int MINPROCESSES_VALUE = 3;
    public static final int TIMEOUT_VALUE = 45;
    public static final int REQUEST_TIMEOUT_VALUE = 20;
    public static final int MAX_ERROR_DIALOGS = 5;
    public static final IPath JAXER_STUDIO_DATA = JaxerPlugin.getDefault().getStateLocation().append("jaxer_studio_data");
    private String path;
    private Job managerJob;
    private Process managerProcess;
    private boolean ended = false;
    private String name;
    private String[] cfgs;
    private String logFilePath;
    private String tempDir;
    private String cfgFilePath;
    private boolean trace;
    private int adminPort;
    private int webPort;
    private int minProcesses;
    private int maxProcesses;
    private int timeout;
    private int errorCount = 0;
    private IManagerListener listener;
    private static final String JAXER_MANAGER_WIN32_PATH = "JaxerManager.exe";
    private static final String JAXER_MANAGER_MACOSX_PATH = "JaxerManager";
    private static final String JAXER_MANAGER_LINUX_PATH = "jaxermanager";
    private static final String JAXER_WIN32_PATH = "Jaxer";
    private static final String JAXER_MACOSX_PATH = "Jaxer";
    private static final String JAXER_LINUX_PATH = "jaxer";

    public JaxerManagerJob(String path, String serverName, int adminPort, int webPort, IManagerListener managerListener, String[] cfgs, String logFilePath, String tempDir, int minProcesses, int maxProcesses, int timeout, boolean trace) {
        this.name = serverName;
        this.adminPort = adminPort;
        this.webPort = webPort;
        this.listener = managerListener;
        this.cfgs = cfgs;
        this.logFilePath = logFilePath;
        this.minProcesses = minProcesses;
        this.maxProcesses = maxProcesses;
        this.timeout = timeout;
        this.tempDir = tempDir;
        this.trace = trace;
        JaxerPlugin.getDefault().getWorkbench().addWorkbenchListener(new IWorkbenchListener(){

            public boolean preShutdown(IWorkbench workbench, boolean forced) {
                try {
                    if (JaxerManagerJob.this.isRunning()) {
                        JaxerManagerJob.this.ended = true;
                        JaxerManager manager = new JaxerManager("127.0.0.1", JaxerManagerJob.this.adminPort);
                        BaseCommand cmd = new BaseCommand("exit");
                        ServerManager.getInstance().runCommand(manager, cmd, 5000, false, true);
                        if (cmd.getStatus() == -1) {
                            IdeLog.logError((Plugin)JaxerPlugin.getDefault(), (String)"Forcibly quitting Jaxer Manager");
                            JaxerManagerJob.this.stop();
                        }
                    } else {
                        JaxerManagerJob.this.ended = true;
                    }
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)JaxerPlugin.getDefault(), (String)"Error shutting down manager on shutdown", (Throwable)e);
                    JaxerManagerJob.this.ended = true;
                }
                return true;
            }

            public void postShutdown(IWorkbench workbench) {
            }
        });
        this.path = path;
        this.managerJob = new Job(Messages.JaxerManagerJob_RunningManageExe){

            protected IStatus run(IProgressMonitor monitor) {
                File dir = new File(JaxerManagerJob.this.path);
                Path managerDir = new Path(JaxerManagerJob.this.path);
                JaxerManagerJob.this.runJaxerReg(dir, (IPath)managerDir);
                ArrayList<String> commands = new ArrayList<String>();
                String exec = null;
                if (CoreUIUtils.onWindows) {
                    exec = managerDir.append(JaxerManagerJob.JAXER_MANAGER_WIN32_PATH).toOSString();
                } else if (CoreUIUtils.onMacOSX) {
                    exec = managerDir.append("JaxerManager").toOSString();
                } else if (CoreUIUtils.onNix) {
                    exec = managerDir.append(JaxerManagerJob.JAXER_MANAGER_LINUX_PATH).toOSString();
                }
                commands.add(exec);
                commands.add("--commandport=" + JaxerManagerJob.this.adminPort);
                commands.add("--webport=" + JaxerManagerJob.this.webPort);
                commands.add("--minprocesses=" + JaxerManagerJob.this.minProcesses);
                commands.add("--maxprocesses=" + JaxerManagerJob.this.maxProcesses);
                commands.add("--timeout=" + JaxerManagerJob.this.timeout);
                if (JaxerManagerJob.this.trace) {
                    commands.add("--trace=on");
                }
                if (JaxerManagerJob.this.tempDir != null) {
                    commands.add("--cfg:tempdir=" + JaxerManagerJob.this.tempDir);
                }
                if (JaxerManagerJob.this.logFilePath != null) {
                    commands.add("--log:output=" + JaxerManagerJob.this.logFilePath);
                }
                if (JaxerManagerJob.this.cfgs != null && JaxerManagerJob.this.cfgs.length > 0) {
                    int i = 0;
                    while (i < JaxerManagerJob.this.cfgs.length) {
                        commands.add("--cfg:" + JaxerManagerJob.this.cfgs[i]);
                        ++i;
                    }
                }
                if (JaxerManagerJob.this.cfgFilePath != null) {
                    commands.add("--configfile=" + JaxerManagerJob.this.cfgFilePath);
                }
                IdeLog.logInfo((Plugin)JaxerPlugin.getDefault(), (String)("Starting Manager.exe at: " + dir.getAbsolutePath()));
                try {
                    ProcessBuilder builder = new ProcessBuilder(commands);
                    builder.directory(dir);
                    Map<String, String> envs = builder.environment();
                    if (CoreUIUtils.onNix) {
                        envs.put(JaxerManagerJob.LD_LIBRARY_PATH, dir.getAbsolutePath());
                    } else if (CoreUIUtils.onMacOSX) {
                        envs.put(JaxerManagerJob.DYLD_LIBRARY_PATH, dir.getAbsolutePath());
                    }
                    JaxerManagerJob.this.managerProcess = builder.start();
                    final InputStream is = JaxerManagerJob.this.managerProcess.getErrorStream();
                    Job managerOutputJob = new Job(Messages.JaxerManagerJob_MonitoringJaxerManageOuput){

                        protected IStatus run(IProgressMonitor monitor) {
                            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                            try {
                                String line = reader.readLine();
                                while (line != null) {
                                    IdeLog.logError((Plugin)JaxerPlugin.getDefault(), (String)("JaxerManager error:" + line));
                                    if (line.startsWith(JaxerManagerJob.JAXER_ERROR_COMMAND) && JaxerManagerJob.this.errorCount < 5) {
                                        JaxerManagerJob jaxerManagerJob = JaxerManagerJob.this;
                                        jaxerManagerJob.errorCount = jaxerManagerJob.errorCount + 1;
                                        String error = line.substring(line.indexOf(58));
                                        UIJob showError = new UIJob(this, Messages.JaxerManagerJob_ShowingJaxerManagerError, error){
                                            final /* synthetic */ 1 this$2;
                                            private final /* synthetic */ String val$error;
                                            {
                                                this.this$2 = var1_1;
                                                this.val$error = string;
                                                super($anonymous0);
                                            }

                                            public IStatus runInUIThread(IProgressMonitor monitor) {
                                                MessageDialog.openError((Shell)this.getDisplay().getActiveShell(), (String)Messages.JaxerManagerJob_ErrorReportedTitle, (String)StringUtils.format((String)Messages.JaxerManagerJob_ErrorReportedMessage, (Object[])new String[]{JaxerManagerJob.access$17(2.access$0(1.access$0(this.this$2))), this.val$error.trim()}));
                                                return Status.OK_STATUS;
                                            }
                                        };
                                        showError.schedule();
                                    }
                                    line = reader.readLine();
                                }
                            }
                            catch (Exception exception) {}
                            return Status.OK_STATUS;
                        }

                        static /* synthetic */ 2 access$0(1 var0) {
                            return var0.this;
                        }
                    };
                    managerOutputJob.setPriority(40);
                    managerOutputJob.setSystem(true);
                    managerOutputJob.schedule();
                    if (JaxerManagerJob.this.listener != null) {
                        final InputStream out = JaxerManagerJob.this.managerProcess.getInputStream();
                        Job outJob = new Job(Messages.JaxerManagerJob_MonitoringJaxerManageOuput){
                            boolean notified;
                            {
                                super($anonymous0);
                                this.notified = false;
                            }

                            protected IStatus run(IProgressMonitor monitor) {
                                BufferedReader reader = new BufferedReader(new InputStreamReader(out));
                                try {
                                    String line = reader.readLine();
                                    while (line != null) {
                                        IdeLog.logImportant((Plugin)JaxerPlugin.getDefault(), (String)("JaxerManager out:" + line));
                                        if (line.startsWith("JaxerManager") && !this.notified) {
                                            this.notified = true;
                                            if (JaxerManagerJob.this.listener != null) {
                                                JaxerManagerJob.this.listener.localJaxerCreated();
                                            }
                                        }
                                        line = reader.readLine();
                                    }
                                }
                                catch (Exception exception) {}
                                return Status.OK_STATUS;
                            }
                        };
                        outJob.setPriority(40);
                        outJob.setSystem(true);
                        outJob.schedule();
                    }
                    int rc = JaxerManagerJob.this.managerProcess.waitFor();
                    if (JaxerManagerJob.this.listener != null) {
                        JaxerManagerJob.this.listener.localJaxerFailed(null);
                    }
                    IdeLog.logError((Plugin)JaxerPlugin.getDefault(), (String)("Manager terminated with return code of: " + rc));
                }
                catch (Exception e) {
                    UIJob showError = new UIJob(Messages.JaxerManagerJob_ShowingJaxerManagerError){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            MessageDialog.openError((Shell)this.getDisplay().getActiveShell(), (String)Messages.JaxerManagerJob_ErrorReportedByJaxerManagerProcess, (String)e.getMessage());
                            return Status.OK_STATUS;
                        }
                    };
                    showError.schedule();
                    if (JaxerManagerJob.this.listener != null) {
                        JaxerManagerJob.this.listener.localJaxerFailed(e);
                    }
                    IdeLog.logError((Plugin)JaxerPlugin.getDefault(), (String)"Exception thrown starting Jaxer Manager", (Throwable)e);
                }
                JaxerManagerJob.this.ended = true;
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        this.managerJob.setSystem(true);
        this.managerJob.setPriority(40);
    }

    private int runJaxerReg(File dir, IPath directory) {
        int retVal = -1;
        String previousLocation = JaxerPlugin.getDefault().getPreferenceStore().getString(LAST_JAXER_LOCATION);
        String previousStateLocation = ApplicationPreferences.getInstance().getString(LAST_STATE_LOCATION);
        if (!(directory == null || directory.toString().equals(previousLocation) && JaxerPlugin.getDefault().getStateLocation().toString().equals(previousStateLocation))) {
            JaxerPlugin.getDefault().getPreferenceStore().setValue(LAST_JAXER_LOCATION, directory.toString());
            ApplicationPreferences.getInstance().setString(LAST_STATE_LOCATION, JaxerPlugin.getDefault().getStateLocation().toString());
            ApplicationPreferences.getInstance().savePreferences();
            try {
                ArrayList<String> jaxerCommands = new ArrayList<String>();
                String jaxerExec = null;
                if (CoreUIUtils.onWindows) {
                    jaxerExec = directory.append("Jaxer").toOSString();
                } else if (CoreUIUtils.onMacOSX) {
                    jaxerExec = directory.append("Jaxer").toOSString();
                } else if (CoreUIUtils.onNix) {
                    jaxerExec = directory.append(JAXER_LINUX_PATH).toOSString();
                }
                jaxerCommands.add(jaxerExec);
                jaxerCommands.add(REG);
                if (this.tempDir != null) {
                    jaxerCommands.add(JAXER_TEMPDIR);
                    jaxerCommands.add(this.tempDir);
                }
                ProcessBuilder jaxerBuilder = new ProcessBuilder(jaxerCommands);
                jaxerBuilder.directory(dir);
                Map<String, String> jaxerEnvs = jaxerBuilder.environment();
                if (CoreUIUtils.onNix) {
                    jaxerEnvs.put(LD_LIBRARY_PATH, dir.getAbsolutePath());
                } else if (CoreUIUtils.onMacOSX) {
                    jaxerEnvs.put(DYLD_LIBRARY_PATH, dir.getAbsolutePath());
                }
                Process jaxerProcess = jaxerBuilder.start();
                if (jaxerProcess != null) {
                    retVal = jaxerProcess.waitFor();
                }
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)JaxerPlugin.getDefault(), (String)"Error running Jaxer -reg", (Throwable)e);
            }
        }
        return retVal;
    }

    public boolean isEnded() {
        return this.ended;
    }

    public boolean isRunning() {
        return !this.ended && this.managerJob != null && this.managerJob.getResult() == null;
    }

    public void stop() {
        this.errorCount = 0;
        if (this.managerProcess != null) {
            this.managerProcess.destroy();
        }
        if (this.managerJob != null) {
            this.managerJob.cancel();
        }
    }

    public void start() {
        this.stop();
        this.managerJob.schedule();
    }

    public String getCfgFilePath() {
        return this.cfgFilePath;
    }

    public void setCfgFilePath(String cfgFilePath) {
        this.cfgFilePath = cfgFilePath;
    }

    static /* synthetic */ String access$17(JaxerManagerJob jaxerManagerJob) {
        return jaxerManagerJob.name;
    }
}

