/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.framework.jaxer.outline;

import com.aptana.ide.editor.html.parsing.nodes.HTMLElementNode;
import com.aptana.ide.editor.js.outline.JSOutlineItem;
import com.aptana.ide.editor.js.parsing.nodes.JSFunctionNode;
import com.aptana.ide.editor.js.parsing.nodes.JSParseNode;
import com.aptana.ide.framework.jaxer.JaxerPlugin;
import com.aptana.ide.framework.jaxer.ParseNodeUtils;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;

public class JSFontProvider
implements IFontProvider {
    private FontData[] boldData = JFaceResources.getDefaultFont().getFontData();
    private FontData[] italicData;
    private FontData[] bothData;
    private Font bold;
    private Font italic;
    private Font boldAndItalic;

    public JSFontProvider() {
        int i = 0;
        while (i < this.boldData.length) {
            this.boldData[i].setStyle(1);
            ++i;
        }
        this.bold = new Font((Device)Display.getDefault(), this.boldData);
        this.italicData = JFaceResources.getDefaultFont().getFontData();
        i = 0;
        while (i < this.italicData.length) {
            this.italicData[i].setStyle(2);
            ++i;
        }
        this.italic = new Font((Device)Display.getDefault(), this.italicData);
        this.bothData = JFaceResources.getDefaultFont().getFontData();
        i = 0;
        while (i < this.bothData.length) {
            this.bothData[i].setStyle(3);
            ++i;
        }
        this.boldAndItalic = new Font((Device)Display.getDefault(), this.bothData);
    }

    public Font getFont(Object element) {
        if (!JaxerPlugin.getDefault().getPreferenceStore().getBoolean("com.aptana.ide.framework.jaxer.preferences.ENABLE_JAXER_COLORING")) {
            return null;
        }
        Font result = null;
        String runat = null;
        if (element instanceof JSOutlineItem) {
            JSFunctionNode functionNode = ParseNodeUtils.getFunctionNode((JSOutlineItem)element);
            if (functionNode != null) {
                runat = ParseNodeUtils.getRunatValue((JSParseNode)functionNode);
            }
        } else if (element instanceof HTMLElementNode) {
            HTMLElementNode scriptElement = (HTMLElementNode)element;
            runat = ParseNodeUtils.getRunatValue(scriptElement);
        }
        if ("server-nocache".equals(runat) || "both-nocache".equals(runat)) {
            int style = JaxerPlugin.getDefault().getPreferenceStore().getInt("com.aptana.ide.framework.jaxer.preferences.NO_CACHE_FOREGROUND_STYLE");
            if (style == 1) {
                result = this.bold;
            } else if (style == 2) {
                result = this.italic;
            } else if (style == 3) {
                result = this.boldAndItalic;
            }
        } else if ("server-proxy".equals(runat) || "both-proxy".equals(runat)) {
            int style = JaxerPlugin.getDefault().getPreferenceStore().getInt("com.aptana.ide.framework.jaxer.preferences.PROXY_FOREGROUND_STYLE");
            if (style == 1) {
                result = this.bold;
            } else if (style == 2) {
                result = this.italic;
            } else if (style == 3) {
                result = this.boldAndItalic;
            }
        }
        return result;
    }
}

