/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.framework.jaxer.handlers;

import com.aptana.ide.server.jetty.server.HTMLContextRootUtils;
import com.aptana.jaxer.connectors.servlet.interfaces.IIgnoreHandler;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;

public class JaxerPreviewIgnoreHandler
implements IIgnoreHandler {
    public static final String JAXER_INCLUDE = "jaxer-include/";
    public static final String[] TYPES = new String[]{".htm", ".html", ".xhtml", ".HTML", ".HTM", ".XHTML"};
    private IWorkspaceRoot root;
    private List<String> types = Arrays.asList(TYPES);

    public JaxerPreviewIgnoreHandler() {
        this.root = ResourcesPlugin.getWorkspace().getRoot();
    }

    public boolean shouldIgnore(ServletRequest request, ServletResponse response) {
        boolean ignore = false;
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            try {
                HttpServletRequest httpRequest = (HttpServletRequest)request;
                String path = httpRequest.getServletPath();
                if (path != null) {
                    if (path.indexOf(JAXER_INCLUDE) != -1) {
                        ignore = true;
                    } else if (path.indexOf(46) != -1) {
                        ignore = true;
                        for (String type : this.types) {
                            if (!path.endsWith(type)) continue;
                            ignore = false;
                            break;
                        }
                    }
                }
                if (!ignore) {
                    IResource resource;
                    URL url;
                    String refPath;
                    IResource resource2;
                    String ref = httpRequest.getHeader("Referer");
                    if (ref != null && (resource2 = this.root.findMember((IPath)new Path(refPath = (url = new URL(ref)).getPath()))) != null) {
                        IProject project = resource2.getProject();
                        path = HTMLContextRootUtils.resolveURL((IProject)project, (String)path);
                        IResource candidate = this.root.findMember((IPath)new Path(path));
                        if (candidate != null && candidate.getProject().equals((Object)project) && candidate instanceof IFile) {
                            ignore = this.shouldIgnore(project, candidate);
                        } else {
                            candidate = project.findMember((IPath)new Path(path));
                            if (candidate != null && candidate.getProject().equals((Object)project) && candidate instanceof IFile) {
                                ignore = this.shouldIgnore(project, candidate);
                            }
                        }
                    }
                    if ((resource = this.root.findMember((IPath)new Path(path))) != null && resource instanceof IFile) {
                        ignore = this.shouldIgnore(resource.getProject(), resource);
                    }
                }
            }
            catch (Exception exception) {}
        }
        return ignore;
    }

    private boolean shouldIgnore(IProject project, IResource file) {
        boolean ignore;
        block5: {
            ignore = false;
            try {
                String property = project.getPersistentProperty(new QualifiedName("", "com.aptana.ide.framework.jaxer.project.IGNORE_FILES"));
                if (property == null) break block5;
                String[] paths = property.split("___IGNORE___");
                int i = 0;
                while (i < paths.length) {
                    IFolder folder = project.getFolder((IPath)new Path(paths[i]));
                    if (folder.exists() && folder.getFile(file.getProjectRelativePath()).exists()) {
                        ignore = true;
                        break;
                    }
                    IFile candidate = project.getFile((IPath)new Path(paths[i]));
                    if (candidate.exists() && candidate.equals((Object)file)) {
                        ignore = true;
                        break;
                    }
                    ++i;
                }
            }
            catch (CoreException coreException) {}
        }
        return ignore;
    }
}

