/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.framework.jaxer.handlers;

import com.aptana.ide.core.FileUtils;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.framework.jaxer.JaxerPlugin;
import com.aptana.jaxer.connectors.servlet.interfaces.IErrorPageHandler;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.Bundle;

public class JaxerErrorPageHandler
implements IErrorPageHandler {
    private String content = null;

    public void showErrorPage(HttpServletResponse response, Exception exception) {
        response.setStatus(500);
        if (this.content == null) {
            Bundle bundle = JaxerPlugin.getDefault().getBundle();
            URL entry = bundle.getEntry("/resources/error.html");
            try {
                entry = FileLocator.toFileURL((URL)entry);
                this.content = FileUtils.readContent((File)new File(entry.getFile()));
            }
            catch (IOException iOException) {}
        }
        if (this.content != null) {
            try {
                PrintWriter writer = response.getWriter();
                String message = StringUtils.replace((String)this.content, (String)"error_message", (String)exception.getMessage());
                StringWriter sWriter = new StringWriter();
                exception.printStackTrace(new PrintWriter(sWriter));
                message = StringUtils.replace((String)message, (String)"stack_trace", (String)sWriter.getBuffer().toString());
                try {
                    FileUtils.pipe((Reader)new StringReader(message), (Writer)writer);
                    response.setContentLength(message.length());
                }
                catch (Exception e) {
                    IdeLog.logInfo((Plugin)JaxerPlugin.getDefault(), (String)"Error showing error page", (Throwable)e);
                }
            }
            catch (IOException iOException) {}
        }
    }
}

