/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.framework.jaxer.actions;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.framework.jaxer.server.JaxerServer;
import com.aptana.ide.logging.view.LogView;
import com.aptana.ide.server.core.IAbstractConfiguration;
import com.aptana.ide.server.core.ILog;
import com.aptana.ide.server.core.ILogOpener;
import com.aptana.ide.server.core.IServer;
import com.aptana.ide.server.core.impl.Configuration;
import com.aptana.ide.server.core.impl.servers.ServerManager;
import com.aptana.ide.server.ui.ServerUIPlugin;
import com.aptana.ide.server.ui.views.actions.Messages;
import java.io.File;
import java.net.URI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class OpenJaxerInternalServerLogAction
implements IWorkbenchWindowActionDelegate {
    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
        IServer jaxer = ServerManager.getInstance().findServer("jaxerInternalServer");
        if (jaxer != null && jaxer instanceof JaxerServer) {
            JaxerServer oo = (JaxerServer)jaxer;
            Object logOpener = oo.getAdapter(ILogOpener.class);
            ILog log = oo.getLog();
            if (log == null) {
                FileDialog dlg = new FileDialog(Display.getCurrent().getActiveShell(), 4096);
                dlg.setText(Messages.OpenLogAction_CHOOSE_LOG_TITLE);
                dlg.setFilterNames(new String[]{""});
                dlg.setFilterExtensions(new String[]{"*.log"});
                String sm = dlg.open();
                if (sm == null) {
                    return;
                }
                File fl = new File(sm);
                String string = fl.getAbsolutePath();
                Configuration config = new Configuration();
                oo.storeConfiguration((IAbstractConfiguration)config);
                config.setStringAttribute("logpath", string);
                try {
                    oo.reconfigure((IAbstractConfiguration)config);
                }
                catch (CoreException e) {
                    IdeLog.logError((Plugin)ServerUIPlugin.getDefault(), (String)"Core exception while setting log location for server", (Throwable)e);
                }
                log = oo.getLog();
            }
            if (logOpener instanceof ILogOpener) {
                ((ILogOpener)logOpener).openLog(log);
            } else {
                this.openLogView(log.getURI(), oo.getName());
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    private void openLogView(URI uri, String tabName) {
        try {
            LogView showView = (LogView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("com.aptana.ide.logging.LogView");
            showView.addTab(uri, StringUtils.format((String)Messages.OpenLogAction_LOG_NAME, (String)tabName), true);
        }
        catch (PartInitException e) {
            IdeLog.logError((Plugin)ServerUIPlugin.getDefault(), (String)"Part init exception while opening log view", (Throwable)e);
        }
    }
}

