/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.framework.jaxer.actions;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.framework.jaxer.JaxerPlugin;
import com.aptana.ide.framework.jaxer.server.JaxerServer;
import java.io.File;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

public abstract class EditJaxerFileAction
extends Action
implements IObjectActionDelegate {
    protected IAction proxy;
    protected JaxerServer server;

    public abstract String getFile();

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.proxy = action;
    }

    public void run(IAction action) {
        if (this.server != null && this.getFile() != null) {
            File config = new File(this.getFile());
            IEditorInput input = CoreUIUtils.createJavaFileEditorInput((File)config);
            IWorkbench workbench = JaxerPlugin.getDefault().getWorkbench();
            IEditorRegistry editorRegistry = workbench.getEditorRegistry();
            IEditorDescriptor descriptor = editorRegistry.getDefaultEditor(config.getName());
            if (descriptor == null) {
                descriptor = editorRegistry.getDefaultEditor("test.txt");
            }
            if (descriptor != null) {
                try {
                    IDE.openEditor((IWorkbenchPage)workbench.getActiveWorkbenchWindow().getActivePage(), (IEditorInput)input, (String)descriptor.getId());
                }
                catch (PartInitException e) {
                    IdeLog.logError((Plugin)JaxerPlugin.getDefault(), (String)StringUtils.format((String)"Error opening {0}", (String)this.getFile()), (Throwable)e);
                }
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object obj;
        if (selection instanceof IStructuredSelection && (obj = ((StructuredSelection)selection).getFirstElement()) instanceof JaxerServer && this.proxy != null) {
            this.server = (JaxerServer)obj;
            if (this.server.isLocal()) {
                this.proxy.setEnabled(this.getFile() != null);
            } else {
                this.proxy.setEnabled(false);
            }
        }
    }
}

