/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.framework.jaxer.actions;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.io.IVirtualFile;
import com.aptana.ide.core.io.IVirtualFileManager;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.core.ui.io.file.LocalFile;
import com.aptana.ide.core.ui.io.file.LocalProtocolManager;
import com.aptana.ide.core.ui.views.fileexplorer.FileExplorerView;
import com.aptana.ide.framework.jaxer.JaxerPlugin;
import com.aptana.ide.framework.jaxer.server.JaxerServer;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;

public class BrowseConfigFolderAction
extends Action
implements IObjectActionDelegate {
    private JaxerServer server;
    private IAction proxy;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.proxy = action;
    }

    public void run(IAction action) {
        IVirtualFile configDirectory;
        IVirtualFileManager fileManager;
        String configDirectoryPath;
        if (this.server != null && this.proxy != null && (configDirectoryPath = this.server.getConfigDirectory()) != null && (fileManager = LocalProtocolManager.getInstance().createFileManager(true)) != null && (configDirectory = fileManager.createVirtualDirectory(configDirectoryPath)) instanceof LocalFile) {
            BrowseConfigFolderAction.showFileExplorerView((LocalFile)configDirectory.getParentFile());
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object obj;
        if (selection instanceof IStructuredSelection && (obj = ((StructuredSelection)selection).getFirstElement()) instanceof JaxerServer) {
            this.server = (JaxerServer)obj;
        }
    }

    private static void showFileExplorerView(LocalFile file) {
        try {
            IViewPart part = BrowseConfigFolderAction.showView("com.aptana.ide.js.ui.views.FileExplorerView");
            if (part != null && part instanceof FileExplorerView) {
                ((FileExplorerView)part).selectAndReveal(file);
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)JaxerPlugin.getDefault(), (String)"Error showing File Explorer view", (Throwable)e);
        }
    }

    private static IViewPart showView(String viewId) {
        return CoreUIUtils.showView((String)viewId, null);
    }
}

