/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui.views.fileexplorer;

import com.aptana.ide.core.ui.io.file.PermissionsGroup;
import com.aptana.ide.core.ui.views.fileexplorer.Messages;
import com.aptana.ide.io.file.FilePlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class PermissionPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private PermissionsGroup fFilePermissions;
    private PermissionsGroup fDirectoryPermissions;

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        this.doGetPreferenceStore().setValue("FilePermission", this.fFilePermissions.getPermissions());
        this.doGetPreferenceStore().setValue("DirectoryPermission", this.fDirectoryPermissions.getPermissions());
        return super.performOk();
    }

    protected Control createContents(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout());
        Label label = new Label(main, 64);
        label.setText(Messages.PermissionPreferencePage_Notes);
        label.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fFilePermissions = new PermissionsGroup(main);
        this.fFilePermissions.setText(Messages.PermissionPreferencePage_FileGroupTitle);
        this.fFilePermissions.setPermissions(this.doGetPreferenceStore().getInt("FilePermission"));
        this.fFilePermissions.getControl().setLayoutData((Object)new GridData(4, 4, true, false));
        this.fDirectoryPermissions = new PermissionsGroup(main);
        this.fDirectoryPermissions.setText(Messages.PermissionPreferencePage_DirectoryGroupTitle);
        this.fDirectoryPermissions.setPermissions(this.doGetPreferenceStore().getInt("DirectoryPermission"));
        this.fDirectoryPermissions.getControl().setLayoutData((Object)new GridData(4, 4, true, false));
        return main;
    }

    protected void performDefaults() {
        this.fFilePermissions.setPermissions(this.doGetPreferenceStore().getDefaultInt("FilePermission"));
        this.fDirectoryPermissions.setPermissions(this.doGetPreferenceStore().getDefaultInt("DirectoryPermission"));
        super.performDefaults();
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return FilePlugin.getDefault().getPreferenceStore();
    }
}

