/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui.views.fileexplorer;

import com.aptana.ide.core.io.IVirtualFile;
import com.aptana.ide.core.ui.views.fileexplorer.FileExplorerView;
import com.aptana.ide.core.ui.views.fileexplorer.Messages;
import com.aptana.ide.io.file.FilePlugin;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.ui.progress.UIJob;

public class NewVirtualFileDialog
extends SelectionStatusDialog {
    private IVirtualFile parentFolder;
    private ProgressMonitorPart progressMonitorPart;
    private Composite displayArea;
    private Label fileLabel;
    private Text fileText;
    private FileExplorerView view;
    private boolean isFile;

    private static IStatus createStatus(final int severity, final String message) {
        return new IStatus(){

            public boolean matches(int severityMask) {
                return severityMask == severity;
            }

            public boolean isOK() {
                return false;
            }

            public boolean isMultiStatus() {
                return false;
            }

            public int getSeverity() {
                return severity;
            }

            public String getPlugin() {
                return null;
            }

            public String getMessage() {
                return message;
            }

            public Throwable getException() {
                return null;
            }

            public int getCode() {
                return 0;
            }

            public IStatus[] getChildren() {
                return null;
            }
        };
    }

    public NewVirtualFileDialog(IVirtualFile parentFolder, Shell parentShell, FileExplorerView view, boolean isFile) {
        super(parentShell);
        this.setStatusLineAboveButtons(true);
        this.parentFolder = parentFolder;
        this.view = view;
        this.isFile = isFile;
        if (isFile) {
            this.setTitle(Messages.NewVirualFileDialog_CreateRemoteFile);
        } else {
            this.setTitle(Messages.NewVirualFileDialog_CreateRemoteFolder);
        }
    }

    private void performFinish(int buttonId) {
        super.buttonPressed(buttonId);
    }

    protected void buttonPressed(final int buttonId) {
        if (buttonId == 0) {
            this.getOkButton().setEnabled(false);
            String name = this.fileText.getText();
            this.progressMonitorPart.beginTask(String.valueOf(Messages.NewVirualFileDialog_Creating) + name, -1);
            IVirtualFile newFile = null;
            newFile = this.isFile ? this.parentFolder.getFileManager().createVirtualFile(String.valueOf(this.parentFolder.getAbsolutePath()) + "/" + name) : this.parentFolder.getFileManager().createVirtualDirectory(String.valueOf(this.parentFolder.getAbsolutePath()) + "/" + name);
            final IVirtualFile file = newFile;
            Job createJob = new Job(Messages.NewVirualFileDialog_CreatingRemoteFileJob){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        if (file.exists()) {
                            UIJob updateStatus = new UIJob(Messages.NewVirualFileDialog_UpdatingStatus){

                                public IStatus runInUIThread(IProgressMonitor monitor) {
                                    if (NewVirtualFileDialog.this.isFile) {
                                        NewVirtualFileDialog.this.updateStatus(NewVirtualFileDialog.createStatus(4, Messages.NewVirualFileDialog_FileAlreadyExists));
                                    } else {
                                        NewVirtualFileDialog.this.updateStatus(NewVirtualFileDialog.createStatus(4, Messages.NewVirualFileDialog_FolderAlreadyExists));
                                    }
                                    NewVirtualFileDialog.this.progressMonitorPart.done();
                                    return Status.OK_STATUS;
                                }
                            };
                            updateStatus.schedule();
                        } else {
                            IPreferenceStore prefs = FilePlugin.getDefault().getPreferenceStore();
                            if (NewVirtualFileDialog.this.isFile) {
                                file.getFileManager().putStream((InputStream)new ByteArrayInputStream(new byte[0]), file);
                                file.setPermissions((long)prefs.getInt("FilePermission"));
                            } else {
                                file.getFileManager().createLocalDirectory(file);
                                file.setPermissions((long)prefs.getInt("DirectoryPermission"));
                            }
                            UIJob updateStatus = new UIJob(Messages.NewVirualFileDialog_UpdatingStatus){

                                public IStatus runInUIThread(IProgressMonitor monitor) {
                                    NewVirtualFileDialog.this.view.getViewer().refresh((Object)NewVirtualFileDialog.this.parentFolder);
                                    if (NewVirtualFileDialog.this.isFile) {
                                        NewVirtualFileDialog.this.view.openFileInEditor(file);
                                    }
                                    NewVirtualFileDialog.this.updateStatus(NewVirtualFileDialog.createStatus(0, null));
                                    NewVirtualFileDialog.this.progressMonitorPart.done();
                                    NewVirtualFileDialog.this.performFinish(buttonId);
                                    return Status.OK_STATUS;
                                }
                            };
                            updateStatus.schedule();
                        }
                    }
                    catch (Exception exception) {
                        UIJob updateStatus = new UIJob(Messages.NewVirualFileDialog_UpdatingStatus){

                            public IStatus runInUIThread(IProgressMonitor monitor) {
                                if (NewVirtualFileDialog.this.isFile) {
                                    NewVirtualFileDialog.this.updateStatus(NewVirtualFileDialog.createStatus(4, Messages.NewVirualFileDialog_ErrorCreatingRemoteFile));
                                } else {
                                    NewVirtualFileDialog.this.updateStatus(NewVirtualFileDialog.createStatus(4, Messages.NewVirualFileDialog_ErrorCreatingRemoteFolder));
                                }
                                return Status.OK_STATUS;
                            }
                        };
                        updateStatus.schedule();
                    }
                    return Status.OK_STATUS;
                }
            };
            createJob.schedule();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.displayArea = new Composite(composite, 0);
        this.displayArea.setLayout((Layout)new GridLayout(2, false));
        GridData data = new GridData(4, 4, true, true);
        data.widthHint = 500;
        this.displayArea.setLayoutData((Object)data);
        this.fileLabel = new Label(this.displayArea, 16384);
        if (this.isFile) {
            this.fileLabel.setText(Messages.NewVirualFileDialog_EnterFileName);
        } else {
            this.fileLabel.setText(Messages.NewVirualFileDialog_EnterFolderName);
        }
        this.fileText = new Text(this.displayArea, 2052);
        this.fileText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewVirtualFileDialog.this.updateStatus(NewVirtualFileDialog.createStatus(0, null));
            }
        });
        GridLayout pmLayout = new GridLayout();
        this.progressMonitorPart = new ProgressMonitorPart(composite, (Layout)pmLayout);
        this.progressMonitorPart.setLayoutData((Object)new GridData(768));
        return composite;
    }

    protected void computeResult() {
    }
}

