/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui.views.fileexplorer;

import com.aptana.ide.core.CoreStrings;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.PlatformUtils;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.io.ConnectionException;
import com.aptana.ide.core.io.IFileProgressMonitor;
import com.aptana.ide.core.io.IVirtualFile;
import com.aptana.ide.core.io.IVirtualFileManager;
import com.aptana.ide.core.io.IVirtualFileManagerDialog;
import com.aptana.ide.core.io.ProtocolManager;
import com.aptana.ide.core.io.VirtualFile;
import com.aptana.ide.core.io.VirtualFileManagerException;
import com.aptana.ide.core.io.VirtualFileManagerGroup;
import com.aptana.ide.core.io.sync.ISyncManagerChangeListener;
import com.aptana.ide.core.io.sync.SyncManager;
import com.aptana.ide.core.io.sync.VirtualFileManagerSyncPair;
import com.aptana.ide.core.ui.CoreUIPlugin;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.core.ui.EclipseUIUtils;
import com.aptana.ide.core.ui.ImageUtils;
import com.aptana.ide.core.ui.PreferenceUtils;
import com.aptana.ide.core.ui.actions.CheckBoxAction;
import com.aptana.ide.core.ui.actions.PushButtonAction;
import com.aptana.ide.core.ui.io.file.ILocalFile;
import com.aptana.ide.core.ui.io.file.LocalFile;
import com.aptana.ide.core.ui.io.file.LocalFileManager;
import com.aptana.ide.core.ui.io.file.LocalProtocolManager;
import com.aptana.ide.core.ui.io.file.ProjectProtocolManager;
import com.aptana.ide.core.ui.views.IRefreshableView;
import com.aptana.ide.core.ui.views.fileexplorer.DrillDownAdapter;
import com.aptana.ide.core.ui.views.fileexplorer.FileTreeContentProvider;
import com.aptana.ide.core.ui.views.fileexplorer.Messages;
import com.aptana.ide.core.ui.views.fileexplorer.NewVirtualFileDialog;
import com.aptana.ide.core.ui.views.fileexplorer.OpenWithMenuExternal;
import com.aptana.ide.core.ui.wizards.PromoteToProjectWizard;
import com.aptana.ide.io.file.FilePlugin;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.BaseNewWizardMenu;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.editors.text.UntitledTextFileWizard;
import org.eclipse.ui.internal.views.navigator.ResourceNavigatorMessages;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;
import org.eclipse.ui.wizards.IWizardDescriptor;

public class FileExplorerView
extends ViewPart
implements ISyncManagerChangeListener,
IRefreshableView {
    public static final String ID = "com.aptana.ide.js.ui.views.FileExplorerView";
    private static final int MAX_EXPAND_TIME = 30000;
    private static final int EXPAND_INTERVAL = 250;
    private static final String STATE_START_TOKEN = "#APT#";
    private static String DESKTOP = Messages.FileExplorerView_Desktop;
    private static String MY_COMPUTER_GUID = "::{20D04FE0-3AEA-1069-A2D8-08002B30309D}";
    private static String MY_NETWORK_PLACES_GUID = "::{208D2C60-3AEA-1069-A2D7-08002B30309D}";
    public static String lastSelected = null;
    private static int secondaryIdCounter = 1;
    private static ImageDescriptor fSortIconDescriptor = ImageUtils.getImageDescriptor("icons/sort.gif");
    private static ImageDescriptor fCollapseIconDescriptor = ImageUtils.getImageDescriptor("icons/collapse.gif");
    private static ImageDescriptor fWebFilesIconDescriptor = ImageUtils.getImageDescriptor("icons/method_public.gif");
    private static ImageDescriptor fRefreshIconDescriptor = ImageUtils.getImageDescriptor("icons/refresh.gif");
    private static ImageDescriptor fNewIconDescriptor = ImageUtils.getImageDescriptor("icons/file_new.png");
    private static ImageDescriptor fNewFolderIconDescriptor = ImageUtils.getImageDescriptor("icons/folder.gif");
    private static ImageDescriptor fProjectFolderIconDescriptor = ImageUtils.getImageDescriptor("icons/folder_project.gif");
    private static ImageDescriptor fHostedProjectFolderIconDescriptor = ImageUtils.getImageDescriptor("icons/folder_hosted_project.gif");
    private static ImageDescriptor fnewViewActionIconDescriptor = FilePlugin.getImageDescriptor("icons/file_explorer.png");
    private static ImageDescriptor fDeleteIcon = ImageUtils.getImageDescriptor("icons/delete_edit.gif");
    private Action sortAction;
    private Action collapseAction;
    private Action webFilterAction;
    private Action refreshAction;
    private Action refreshAllAction;
    private Action openAction;
    private Action doubleClickAction;
    private Action newAction;
    private Action renameAction;
    private Action deleteAction;
    private Action newFolderAction;
    private Action addLibraryAction;
    private Action convertToProjectAction;
    private Action convertToHostedProjectAction;
    private Action newViewAction;
    private Action editVirtualFileManager;
    private Action addVirtualFileManager;
    private Action editVirtualFileProperties;
    private Action actionShowHideLocal;
    private Action actionNewVirtualFile;
    private Action actionNewVirtualFolder;
    private Action actionNewVirtualProject;
    private TreeViewer viewer;
    private DrillDownAdapter drillDownAdapter;
    private boolean webFiltering;
    private static List transientShortcuts = new ArrayList();
    private Composite parent;
    private boolean alwaysOverwrite;
    private Object[] dragSelection = null;
    private int dragDetail = 0;
    protected boolean showLocalEndpoints = false;
    private Map<IEditorDescriptor, Image> images = new HashMap<IEditorDescriptor, Image>();
    private IEditorRegistry registry = EclipseUIUtils.getWorkbenchEditorRegistry();
    private FileSelectionListener fSelectionListener = new FileSelectionListener();
    private ITreeViewerListener treeListener;
    private Object[] expandedElements;
    Object[] savedElements = null;

    public void dispose() {
        try {
            SyncManager.getSyncManager().removeSyncManagerChangeEvent((ISyncManagerChangeListener)this);
            if (this.viewer != null && this.treeListener != null) {
                this.viewer.removeTreeListener(this.treeListener);
            }
            Job job = new Job("Disconnecting file managers"){

                protected IStatus run(IProgressMonitor monitor) {
                    if (FileExplorerView.this.expandedElements != null) {
                        Object[] objectArray = FileExplorerView.this.expandedElements;
                        int n = 0;
                        int n2 = objectArray.length;
                        while (n < n2) {
                            Object element = objectArray[n];
                            if (element instanceof IVirtualFileManager) {
                                ((IVirtualFileManager)element).disconnect();
                            }
                            ++n;
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setPriority(40);
            job.setSystem(true);
            job.schedule();
            Iterator<Image> iter = this.images.values().iterator();
            while (iter.hasNext()) {
                iter.next().dispose();
            }
        }
        finally {
            super.dispose();
        }
    }

    public void syncManagerEvent(final Object obj, final int actionId) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                switch (actionId) {
                    case 2: {
                        FileExplorerView.this.refresh(obj);
                        if (FileExplorerView.this.viewer == null || FileExplorerView.this.viewer.getTree().isDisposed()) break;
                        FileExplorerView.this.viewer.update(obj, null);
                        break;
                    }
                    case 0: {
                        if (!(obj instanceof IVirtualFileManager) || !FileExplorerView.this.viewerIsAvailable()) break;
                        IVirtualFileManager fileManager = (IVirtualFileManager)obj;
                        ProtocolManager owningManager = fileManager.getProtocolManager();
                        if (FileExplorerView.this.viewer == null || FileExplorerView.this.viewer.getTree() == null || FileExplorerView.this.viewer.getTree().isDisposed() || fileManager == null || owningManager == null) break;
                        FileExplorerView.this.viewer.add((Object)owningManager, (Object)fileManager);
                        FileExplorerView.this.refresh(owningManager);
                        FileExplorerView.this.viewer.setExpandedState((Object)owningManager, true);
                        FileExplorerView.this.viewer.setSelection((ISelection)new StructuredSelection((Object)fileManager), true);
                        break;
                    }
                    case 1: {
                        if (!(obj instanceof IVirtualFileManager) || !FileExplorerView.this.viewerIsAvailable()) break;
                        IVirtualFileManager fileManager = (IVirtualFileManager)obj;
                        ProtocolManager owningManager = fileManager.getProtocolManager();
                        FileExplorerView.this.viewer.remove((Object)owningManager, new Object[]{fileManager});
                        FileExplorerView.this.refresh(owningManager);
                        break;
                    }
                    default: {
                        FileExplorerView.this.refresh(null);
                    }
                }
            }
        });
    }

    public void createPartControl(Composite parent) {
        try {
            ImageUtils.loadImageCache(parent.getDisplay());
        }
        catch (Exception ex) {
            IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)Messages.FileExplorerView_UnableToLoadIconCache, (Throwable)ex);
        }
        this.parent = parent;
        this.viewer = this.createViewer(parent);
        this.treeListener = new ITreeViewerListener(){

            public void treeExpanded(TreeExpansionEvent e) {
                Object[] elements = FileExplorerView.this.viewer.getExpandedElements();
                FileExplorerView.this.expandedElements = new Object[elements.length + 1];
                int i = 0;
                while (i < FileExplorerView.this.expandedElements.length - 1) {
                    ((FileExplorerView)FileExplorerView.this).expandedElements[i] = elements[i];
                    ++i;
                }
                ((FileExplorerView)FileExplorerView.this).expandedElements[i] = e.getElement();
            }

            public void treeCollapsed(TreeExpansionEvent e) {
                FileExplorerView.this.expandedElements = FileExplorerView.this.viewer.getExpandedElements();
            }
        };
        this.viewer.addTreeListener(this.treeListener);
        this.drillDownAdapter = new DrillDownAdapter(this.viewer);
        this.initFilter();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.aptana.ide.js.ui.FileExplorerView");
        this.createDragSource();
        this.createDropTarget();
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
        this.webFiltering = false;
        this.webFilterAction.setChecked(false);
        this.sortAction.setChecked(true);
        this.setInitialState();
        SyncManager.getSyncManager().addSyncManagerChangeEvent((ISyncManagerChangeListener)this);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        PreferenceUtils.registerBackgroundColorPreference((Control)this.viewer.getControl(), (String)"com.aptana.ide.core.ui.background.color.filesView");
        PreferenceUtils.registerForegroundColorPreference((Control)this.viewer.getControl(), (String)"com.aptana.ide.core.ui.foreground.color.filesView");
    }

    protected TreeViewer createViewer(Composite parent) {
        TreeViewer viewer = new TreeViewer(parent, 770);
        this.initLabelProvider(viewer);
        this.initListeners(viewer);
        viewer.setContentProvider((IContentProvider)new FileTreeContentProvider((AbstractTreeViewer)viewer));
        viewer.setSorter((ViewerSorter)new NameSorter());
        viewer.setAutoExpandLevel(1);
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object obj = FileExplorerView.this.getFirstSelectedItem();
                if (obj instanceof IVirtualFileManager) {
                    try {
                        obj = ((IVirtualFileManager)obj).getBaseFile();
                    }
                    catch (Exception exception) {}
                }
                if (!(obj instanceof IVirtualFile)) {
                    return;
                }
                IVirtualFile f = (IVirtualFile)obj;
                if (f.isDirectory()) {
                    this.setLastSelected(f.getPath());
                } else if (f.getParentFile() != null) {
                    this.setLastSelected(f.getParentFile().getPath());
                } else {
                    this.setLastSelected(null);
                }
            }

            private void setLastSelected(String path) {
                lastSelected = path;
                CoreUIPlugin.getDefault().getPreferenceStore().setValue("com.aptana.ide.core.ui.PREF_CURRENT_DIRECTORY", lastSelected != null ? lastSelected : "");
            }
        });
        try {
            viewer.setInput((Object)FileExplorerView.getVirtualRoots(this.showLocalEndpoints));
        }
        catch (IOException e) {
            IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)Messages.FileExplorerView_ErrorCreatingFileView, (Throwable)e);
        }
        return viewer;
    }

    protected void initLabelProvider(TreeViewer viewer) {
        viewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new ViewLabelProvider(), CoreUIPlugin.getDefault().getWorkbench().getDecoratorManager().getLabelDecorator()));
    }

    protected void initListeners(TreeViewer viewer) {
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                FileExplorerView.this.handleSelectionChanged(event);
            }
        });
        viewer.getControl().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent event) {
                FileExplorerView.this.handleKeyPressed(event);
            }

            public void keyReleased(KeyEvent event) {
                FileExplorerView.this.handleKeyReleased(event);
            }
        });
        viewer.getTree().addMouseListener((MouseListener)this.fSelectionListener);
        viewer.getTree().addSelectionListener((SelectionListener)this.fSelectionListener);
    }

    protected void handleKeyPressed(KeyEvent event) {
        if (event.character == '\u007f' && event.stateMask == 0) {
            if (this.deleteAction.isEnabled()) {
                this.deleteAction.run();
            }
            event.doit = false;
        }
    }

    protected void handleSelectionChanged(SelectionChangedEvent event) {
        IStructuredSelection sel = (IStructuredSelection)event.getSelection();
        this.updateStatusLine(sel);
        this.updateActionBars(sel);
    }

    protected void updateActionBars(IStructuredSelection selection) {
        this.getViewSite().getActionBars().updateActionBars();
    }

    protected void updateStatusLine(IStructuredSelection selection) {
        String msg = this.getStatusLineMessage(selection);
        this.getViewSite().getActionBars().getStatusLineManager().setMessage(msg);
    }

    protected String getStatusLineMessage(IStructuredSelection selection) {
        if (selection.size() == 1) {
            Object o = selection.getFirstElement();
            if (o instanceof IVirtualFile) {
                return ((IVirtualFile)o).getAbsolutePath();
            }
            return ResourceNavigatorMessages.ResourceNavigator_oneItemSelected;
        }
        if (selection.size() > 1) {
            return NLS.bind((String)ResourceNavigatorMessages.ResourceNavigator_statusLine, (Object)String.valueOf(selection.size()));
        }
        return "";
    }

    protected void handleKeyReleased(KeyEvent event) {
    }

    private void createDragSource() {
        DragSource ds = new DragSource(this.viewer.getControl(), 3);
        ds.setTransfer(new Transfer[]{LocalSelectionTransfer.getInstance(), FileTransfer.getInstance()});
        ds.addDragListener((DragSourceListener)new DragSourceAdapter(){

            public void dragStart(DragSourceEvent event) {
                IStructuredSelection selection = (IStructuredSelection)FileExplorerView.this.viewer.getSelection();
                FileExplorerView.this.dragSelection = selection.toArray();
                int i = 0;
                while (i < FileExplorerView.this.dragSelection.length) {
                    IVirtualFile base;
                    IVirtualFile f;
                    Object element = FileExplorerView.this.dragSelection[i];
                    if (element instanceof ProtocolManager) {
                        event.doit = false;
                        FileExplorerView.this.dragSelection = null;
                        break;
                    }
                    if (element instanceof IVirtualFile && (f = (IVirtualFile)element).getFileManager() != null && f.getFileManager().getBasePath() != null && (base = f.getFileManager().getBaseFile()) == f) {
                        event.doit = false;
                        FileExplorerView.this.dragSelection = null;
                        break;
                    }
                    ++i;
                }
            }

            public void dragFinished(DragSourceEvent event) {
                super.dragFinished(event);
                FileExplorerView.this.dragSelection = null;
            }

            public void dragSetData(DragSourceEvent event) {
                IStructuredSelection selection = (IStructuredSelection)FileExplorerView.this.viewer.getSelection();
                if (FileTransfer.getInstance().isSupportedType(event.dataType)) {
                    Object[] items = selection.toArray();
                    String[] data = new String[items.length];
                    int i = 0;
                    while (i < items.length) {
                        Object element = items[i];
                        if (element instanceof IVirtualFile) {
                            data[i] = ((IVirtualFile)element).getAbsolutePath();
                        }
                        ++i;
                    }
                    event.data = data;
                }
            }
        });
    }

    private void createDropTarget() {
        DropTarget dt = new DropTarget(this.viewer.getControl(), 17);
        dt.setTransfer(new Transfer[]{LocalSelectionTransfer.getInstance(), FileTransfer.getInstance()});
        dt.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dropAccept(DropTargetEvent event) {
                super.dropAccept(event);
            }

            public void dragEnter(DropTargetEvent event) {
                if (event.detail == 16) {
                    event.detail = (event.operations & 1) != 0 ? 1 : 0;
                }
                FileExplorerView.this.dragDetail = event.detail;
            }

            public void drop(DropTargetEvent event) {
                FileExplorerView.this.handleDrop(event);
            }

            public void dragOver(DropTargetEvent event) {
                if (!CoreUIUtils.runningOnMac) {
                    event.feedback = 25;
                }
                FileExplorerView.this.dragDetail = event.detail;
            }
        });
    }

    protected void handleDrop(DropTargetEvent event) {
        this.alwaysOverwrite = false;
        if (event.data == null) {
            Object treeData = ((TreeItem)event.item).getData();
            IVirtualFile dest = null;
            if (treeData instanceof IVirtualFileManager) {
                IVirtualFileManager vfm = (IVirtualFileManager)treeData;
                if (vfm.getBasePath() == null) {
                    try {
                        if (!vfm.getBaseFile().exists()) {
                            CoreUIUtils.showMessage((String)Messages.FileExplorerView_DestinationDoesNotExist);
                            this.refresh(null);
                            return;
                        }
                    }
                    catch (ConnectionException connectionException) {}
                }
                dest = vfm.getBaseFile();
            } else if (treeData instanceof IVirtualFile) {
                IVirtualFile vf = (IVirtualFile)treeData;
                try {
                    if (!vf.exists()) {
                        CoreUIUtils.showMessage((String)Messages.FileExplorerView_DestinationDoesNotExist);
                        this.refresh(null);
                        return;
                    }
                }
                catch (ConnectionException connectionException) {}
                dest = (IVirtualFile)treeData;
            }
            Object[] sources = this.dragSelection;
            if (dest == null) {
                CoreUIUtils.showMessage((String)Messages.FileExplorerView_UnableToDrop);
                return;
            }
            if (!dest.isDirectory()) {
                dest = dest.getParentFile();
            }
            if (sources == null) {
                CoreUIUtils.showMessage((String)Messages.FileExplorerView_CopyingBetweenFileViewsIsNotCurrentlySupported);
                return;
            }
            ArrayList<Object> filteredSourcesTemp = new ArrayList<Object>();
            int i = 0;
            while (i < sources.length) {
                Object object = sources[i];
                if (object instanceof IVirtualFile) {
                    filteredSourcesTemp.add(object);
                } else if (object instanceof IVirtualFileManager) {
                    filteredSourcesTemp.add(((IVirtualFileManager)object).getBaseFile());
                } else {
                    MessageDialog.openError((Shell)this.viewer.getControl().getShell(), (String)Messages.FileExplorerView_CopyFailed, (String)Messages.FileExplorerView_UnableToDropSourceOntoDestination);
                    return;
                }
                ++i;
            }
            IVirtualFile[] filteredSources = filteredSourcesTemp.toArray(new IVirtualFile[0]);
            if (filteredSources != null) {
                filteredSources = VirtualFile.removeDuplicateFile((IVirtualFile[])filteredSources, (IVirtualFile)dest);
            }
            if (filteredSources == null || filteredSources.length == 0) {
                MessageDialog.openInformation((Shell)this.viewer.getControl().getShell(), (String)Messages.FileExplorerView_CopyStopped, (String)Messages.FileExplorerView_NothingToCopy);
                return;
            }
            if (this.dragDetail == 1) {
                boolean res = MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)Messages.FileExplorerView_AptanaIDE, (String)StringUtils.format((String)Messages.FileExplorerView_AreYouSureYouWishToCopyToDirectory, (Object[])new String[]{String.valueOf(sources.length), dest.getName()}));
                if (res) {
                    ProgressMonitorDialog pmd = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
                    try {
                        final IVirtualFile[] sourceList = filteredSources;
                        final IVirtualFile destination = dest;
                        pmd.run(true, true, new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                monitor.beginTask(Messages.FileExplorerView_CopyingFiles, sourceList.length);
                                int i = 0;
                                while (i < sourceList.length) {
                                    IVirtualFile sfile = sourceList[i];
                                    try {
                                        try {
                                            FileExplorerView.this.copyVirtualFile(monitor, sfile, destination);
                                        }
                                        catch (Exception e) {
                                            throw new InvocationTargetException(e, StringUtils.format((String)Messages.FileExplorerView_UnableToDropOnto, (Object[])new String[]{sfile.getAbsolutePath(), destination.getAbsolutePath()}));
                                        }
                                    }
                                    finally {
                                        monitor.worked(1);
                                    }
                                    ++i;
                                }
                                monitor.done();
                            }
                        });
                    }
                    catch (InvocationTargetException e) {
                        if (e.getCause() instanceof ConnectionException) {
                            CoreUIUtils.fixConnection((IVirtualFileManager)dest.getFileManager());
                        } else {
                            CoreUIUtils.showError((String)e.getMessage(), (Exception)e, (boolean)true);
                        }
                    }
                    catch (InterruptedException interruptedException) {}
                    this.viewer.refresh(treeData);
                }
            } else if (this.dragDetail == 2) {
                MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)Messages.FileExplorerView_AptanaIDE, (String)StringUtils.format((String)Messages.FileExplorerView_OkToMoveFilesToDirectory, (Object[])new String[]{String.valueOf(sources.length), dest.getName()}));
            }
        }
    }

    private void copyVirtualFile(IProgressMonitor monitor, IVirtualFile source, IVirtualFile dest) throws IOException, ConnectionException, VirtualFileManagerException {
        IVirtualFileManager destFileManager = dest.getFileManager();
        String path = String.valueOf(dest.getAbsolutePath()) + destFileManager.getFileSeparator() + source.getName();
        if (source.isFile()) {
            IVirtualFile targetFile = destFileManager.createVirtualFile(path);
            boolean copyFile = false;
            if (!this.alwaysOverwrite && targetFile.exists()) {
                copyFile = this.overwriteConfirmation(path);
            }
            if (this.alwaysOverwrite || copyFile || !targetFile.exists()) {
                monitor.subTask(StringUtils.ellipsify((String)(String.valueOf(Messages.FileExplorerView_Copying) + " " + source.getAbsolutePath())));
                InputStream in = source.getStream();
                final SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
                final long[] lastBytes = new long[1];
                subMonitor.beginTask(source.getAbsolutePath(), (int)(source.getSize() / 1024L));
                try {
                    targetFile.putStream(in, new IFileProgressMonitor(){

                        public void bytesTransferred(long bytes) {
                            long delta = bytes - lastBytes[0];
                            lastBytes[0] = bytes;
                            subMonitor.worked((int)(delta / 1024L));
                        }

                        public void done() {
                            subMonitor.done();
                        }
                    });
                }
                finally {
                    subMonitor.done();
                }
            }
        } else {
            monitor.subTask(StringUtils.ellipsify((String)(String.valueOf(Messages.FileExplorerView_Copying) + " " + source.getAbsolutePath())));
            IVirtualFile newDestDir = dest.getFileManager().createVirtualDirectory(path);
            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
            try {
                try {
                    if (!newDestDir.exists()) {
                        dest.getFileManager().createLocalDirectory(newDestDir);
                    }
                    IVirtualFile[] files = FileExplorerView.getVirtualFilesProtected(source);
                    subMonitor.beginTask(source.getAbsolutePath(), files.length);
                    int i = 0;
                    while (i < files.length) {
                        IVirtualFile file = files[i];
                        this.copyVirtualFile((IProgressMonitor)subMonitor, file, newDestDir);
                        ++i;
                    }
                }
                catch (ConnectionException e) {
                    String errorMsg = StringUtils.format((String)Messages.FileExplorerView_UnableToConnectTo, (String)dest.getFileManager().getNickName());
                    CoreUIUtils.showError((String)errorMsg, (Exception)((Object)e));
                }
                catch (VirtualFileManagerException e) {
                    String errorMsg = StringUtils.format((String)Messages.FileExplorerView_ErrorCopyingFileToDestination, (Object[])new String[]{source.getAbsolutePath(), dest.getAbsolutePath()});
                    CoreUIUtils.showError((String)errorMsg, (Exception)((Object)e));
                }
            }
            finally {
                subMonitor.done();
            }
        }
    }

    private void deleteVirtualFile(IProgressMonitor monitor, IVirtualFile source) throws IOException, ConnectionException, VirtualFileManagerException {
        monitor.subTask(StringUtils.ellipsify((String)(String.valueOf(Messages.FileExplorerView_Deleting) + source.getAbsolutePath())));
        if (source.isFile()) {
            source.delete();
        } else {
            IVirtualFile[] files = FileExplorerView.getVirtualFilesProtected(source);
            int i = 0;
            while (i < files.length) {
                if (monitor.isCanceled()) {
                    return;
                }
                IVirtualFile file = files[i];
                this.deleteVirtualFile(monitor, file);
                ++i;
            }
            if (!source.delete()) {
                CoreUIUtils.showMessage((String)StringUtils.format((String)Messages.FileExplorerView_UnableToDeleteFile, (String)source.getAbsolutePath()));
            }
        }
    }

    public static IVirtualFile[] getVirtualFilesProtected(IVirtualFile source) throws IOException {
        if (source == null) {
            throw new IllegalArgumentException(Messages.FileExplorerView_SourceCannotBeNull);
        }
        IVirtualFile[] files = new IVirtualFile[]{};
        try {
            files = source.getFiles(false, true);
        }
        catch (ConnectionException connectionException) {
            if (source.getFileManager() != null) {
                CoreUIUtils.fixConnection((IVirtualFileManager)source.getFileManager());
                if (source.getFileManager().isConnected()) {
                    files = FileExplorerView.getVirtualFilesProtected(source);
                }
            }
            throw new IllegalArgumentException(Messages.FileExplorerView_SourceNoFileManagerAttached);
        }
        catch (NullPointerException nullPointerException) {
            IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)StringUtils.format((String)Messages.FileExplorerView_EncounteredNullWhenRetrievingFiles, (String)source.getAbsolutePath()));
        }
        ArrayList<IVirtualFile> newFiles = new ArrayList<IVirtualFile>();
        if (files.length > 0) {
            int i = 0;
            while (i < files.length) {
                IVirtualFile file = files[i];
                if (!file.getName().equals(".") && !file.getName().equals("..")) {
                    newFiles.add(file);
                }
                ++i;
            }
            files = newFiles.toArray(new IVirtualFile[0]);
        }
        return files;
    }

    private void initFilter() {
        IPreferenceStore store = CoreUIPlugin.getDefault().getPreferenceStore();
        String editors = store.getString("com.aptana.ide.core.ui.PREF_FILE_EXPLORER_WEB_FILES");
        String[] webFiles = new String[]{};
        if (editors != null && !"".equals(editors)) {
            webFiles = editors.split(";");
        }
        this.viewer.addFilter((ViewerFilter)new AllowOnlyWebFilesFilter(webFiles));
    }

    public static Object[] getVirtualRoots(boolean showLocalEndpoints) throws IOException {
        Image desktopIcon = null;
        ArrayList list = new ArrayList();
        if (transientShortcuts.size() == 0) {
            IVirtualFile file;
            int i;
            IVirtualFile[] files;
            LocalProtocolManager lpm = LocalProtocolManager.getInstance();
            IVirtualFileManager ivfm = lpm.createFileManager();
            ivfm.setBasePath(LocalProtocolManager.FileSystemRoots);
            ivfm.setNickName("Computer");
            ivfm.setHidden(true);
            ivfm.setTransient(true);
            String localizedDesktop = DESKTOP;
            if (CoreUIUtils.runningOnWindows) {
                try {
                    String tempLocalizedDesktop = PlatformUtils.expandEnvironmentStrings((String)"%DesktopDirectory%");
                    if (tempLocalizedDesktop != null) {
                        Path path = new Path(tempLocalizedDesktop);
                        localizedDesktop = path.lastSegment();
                    }
                }
                catch (Exception ex) {
                    IdeLog.logError((Plugin)FilePlugin.getDefault(), (String)Messages.FileExplorerView_LocalizedError, (Throwable)ex);
                }
                files = FileExplorerView.getVirtualFilesProtected(ivfm.getBaseFile());
                i = 0;
                while (i < files.length) {
                    file = (LocalFile)files[i];
                    if (file.getName().equals(localizedDesktop) || file.getFile().getName().equals(localizedDesktop)) {
                        if (desktopIcon == null) {
                            desktopIcon = file.getImage();
                        }
                        IVirtualFile[] desktopFiles = FileExplorerView.getVirtualFilesProtected(file);
                        int j = 0;
                        while (j < desktopFiles.length) {
                            ILocalFile desktopFile = (ILocalFile)desktopFiles[j];
                            String path = desktopFile.getFile().getName();
                            if (path.equals(MY_COMPUTER_GUID) || path.equals(MY_NETWORK_PLACES_GUID) || path.startsWith("::")) {
                                transientShortcuts.add(desktopFile);
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            } else {
                if (CoreUIUtils.runningOnMac) {
                    ivfm.setBasePath("/Volumes");
                }
                files = FileExplorerView.getVirtualFilesProtected(ivfm.getBaseFile());
                i = 0;
                while (i < files.length) {
                    file = files[i];
                    file.setImage(ImageUtils.getDriveIcon());
                    transientShortcuts.add(file);
                    ++i;
                }
            }
            String basePath = null;
            basePath = CoreUIUtils.runningOnWindows ? PlatformUtils.expandEnvironmentStrings((String)"%DesktopDirectory%") : String.valueOf(System.getProperty("user.home")) + File.separator + "Desktop";
            File f = new File(basePath);
            if (f.exists()) {
                ivfm = lpm.createFileManager();
                ivfm.setNickName(localizedDesktop);
                ivfm.setImage(desktopIcon);
                ivfm.setBasePath(basePath);
                ivfm.setTransient(true);
                ivfm.setHidden(true);
                transientShortcuts.add(ivfm);
            }
        }
        Iterator iter = transientShortcuts.iterator();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        ProtocolManager[] pm = ProtocolManager.getPrototcolManagers();
        if (pm != null) {
            int i = 0;
            while (i < pm.length) {
                ProtocolManager manager = pm[i];
                if (!manager.isHidden() || showLocalEndpoints) {
                    list.add(manager);
                }
                ++i;
            }
        }
        return list.toArray();
    }

    private void setInitialState() {
        if (this.savedElements != null) {
            this.viewer.setExpandedElements(this.savedElements);
        }
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                FileExplorerView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.newAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.refreshAllAction);
        manager.add((IAction)this.webFilterAction);
        manager.add((IAction)this.sortAction);
        manager.add((IAction)this.collapseAction);
        manager.add((IAction)this.newViewAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionShowHideLocal);
    }

    private void fillContextMenu(IMenuManager manager) {
        Object obj = this.getFirstSelectedItem();
        if (obj instanceof LocalFile || obj instanceof LocalFileManager) {
            boolean addEntry = true;
            if (obj instanceof LocalFile) {
                addEntry = ((LocalFile)obj).isDirectory();
            }
            if (addEntry) {
                manager.add((IAction)this.newAction);
            }
        }
        if (obj instanceof ProtocolManager && ((ProtocolManager)obj).canAddFileManagers()) {
            this.addVirtualFileManager.setText(StringUtils.format((String)Messages.FileExplorerView_AddNew, (String)((ProtocolManager)obj).getFileManagerName()));
            manager.add((IAction)this.addVirtualFileManager);
        }
        if (obj instanceof IVirtualFile) {
            MenuManager submenu = new MenuManager(ResourceNavigatorMessages.ResourceNavigator_openWith, String.valueOf(CoreUIPlugin.getPluginId()) + ".OpenWithSubMenu");
            IVirtualFile vFile = (IVirtualFile)obj;
            if (vFile.isFile()) {
                manager.add((IAction)this.openAction);
                submenu.add((IContributionItem)new OpenWithMenuExternal((ViewPart)this, (IVirtualFile)obj));
                manager.add((IContributionItem)submenu);
            }
            if (vFile.isDirectory() && !(vFile instanceof LocalFile)) {
                manager.add((IAction)this.actionNewVirtualFile);
                manager.add((IAction)this.actionNewVirtualFolder);
            }
        }
        if (obj instanceof IVirtualFileManager && !(obj instanceof LocalFileManager)) {
            manager.add((IAction)this.actionNewVirtualFile);
            manager.add((IAction)this.actionNewVirtualFolder);
            if (CoreUIPlugin.isKeyValid()) {
                manager.add((IAction)this.actionNewVirtualProject);
            }
        }
        if (!(obj instanceof ProtocolManager) || ((ProtocolManager)obj).allowNavigation()) {
            manager.add((IContributionItem)new Separator());
            this.drillDownAdapter.addNavigationActions(manager);
        }
        manager.add((IContributionItem)new Separator());
        if (obj instanceof IVirtualFile || obj instanceof IVirtualFileManager && ((IVirtualFileManager)obj).isEditable()) {
            manager.add((IAction)this.deleteAction);
        }
        if (obj instanceof IVirtualFile) {
            manager.add((IAction)this.renameAction);
        }
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.refreshAction);
        Separator sep = new Separator("additions");
        manager.add((IContributionItem)sep);
        if (obj instanceof LocalFile && ((LocalFile)obj).isDirectory()) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.convertToProjectAction);
            manager.add((IAction)this.convertToHostedProjectAction);
            manager.add((IContributionItem)new Separator());
        }
        if (obj instanceof IVirtualFileManager && ((IVirtualFileManager)obj).isEditable()) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.editVirtualFileManager);
        }
        if (obj instanceof IVirtualFile) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.editVirtualFileProperties);
        }
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.newAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.collapseAction);
        manager.add((IAction)this.refreshAllAction);
        manager.add((IContributionItem)new Separator());
        this.drillDownAdapter.addNavigationActions(manager);
        Separator sep = new Separator("additions");
        manager.add((IContributionItem)sep);
        sep = new Separator("helpEnd");
        manager.add((IContributionItem)sep);
    }

    private void makeActions() {
        this.createRenameAction();
        this.createDeleteAction();
        this.createConvertToProjectActions();
        this.createAddLibraryAction();
        this.createNewFolderAction();
        this.createNewAction();
        this.createOpenAction();
        this.createRefreshAction();
        this.createRefreshAllAction();
        this.createSortAction();
        this.createCollapseAction();
        this.createWebFilterAction();
        this.createDoubleClickAction();
        this.createNewViewAction();
        this.createEditVirtualFileManagerAction();
        this.createAddVirtualFileManagerAction();
        this.createEditVirtualFilePropertiesAction();
        this.createShowHideLocalAction();
        this.createNewVirtualFileAction();
        this.createNewVirtualFolderAction();
        this.createNewVirtualProjectAction();
    }

    private void createNewViewAction() {
        this.newViewAction = new Action(){

            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    int n = secondaryIdCounter;
                    secondaryIdCounter = n + 1;
                    page.showView(FileExplorerView.ID, new Integer(n).toString(), 3);
                }
                catch (PartInitException e) {
                    CoreUIUtils.showError((String)Messages.FileExplorerView_ErrorCreatingDuplicateFileView, (Exception)((Object)e));
                }
            }
        };
        this.newViewAction.setText(Messages.FileExplorerView_CreateANewFileExplorer);
        this.newViewAction.setImageDescriptor(fnewViewActionIconDescriptor);
    }

    private void createDoubleClickAction() {
        this.doubleClickAction = new Action(){

            public void run() {
                ISelection selection = FileExplorerView.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (obj == null) {
                    return;
                }
                if (obj instanceof IVirtualFile && ((IVirtualFile)obj).isFile()) {
                    IVirtualFile f = (IVirtualFile)obj;
                    FileExplorerView.this.openFileInEditor(f);
                } else if (FileExplorerView.this.viewer.getExpandedState(obj)) {
                    FileExplorerView.this.viewer.collapseToLevel(obj, 1);
                } else {
                    FileExplorerView.this.viewer.expandToLevel(obj, 1);
                }
            }
        };
    }

    private void createShowHideLocalAction() {
        this.actionShowHideLocal = new CheckBoxAction(Messages.FileExplorerView_ShowHideLocalConnections){

            public void run() {
                FileExplorerView.this.showLocalEndpoints = !FileExplorerView.this.showLocalEndpoints;
                try {
                    FileExplorerView.this.viewer.setInput((Object)FileExplorerView.getVirtualRoots(FileExplorerView.this.showLocalEndpoints));
                }
                catch (IOException e) {
                    IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)Messages.FileExplorerView_ErrorCreatingFileView, (Throwable)e);
                }
            }
        };
        this.actionShowHideLocal.setToolTipText(Messages.FileExplorerView_ShowHideLocalConnections);
        this.actionShowHideLocal.setImageDescriptor(fNewFolderIconDescriptor);
        this.actionShowHideLocal.setChecked(this.showLocalEndpoints);
    }

    private void createWebFilterAction() {
        this.webFilterAction = new CheckBoxAction(Messages.FileExplorerView_ShowWebFilesOnly){

            public void run() {
                if (this.isChecked()) {
                    FileExplorerView.this.webFiltering = true;
                } else {
                    FileExplorerView.this.webFiltering = false;
                }
                FileExplorerView.this.refresh(null);
            }
        };
        this.webFilterAction.setToolTipText(Messages.FileExplorerView_ShowWebFilesOnlyTT);
        this.webFilterAction.setImageDescriptor(fWebFilesIconDescriptor);
    }

    private void createCollapseAction() {
        this.collapseAction = new Action(){

            public void run() {
                FileExplorerView.this.viewer.collapseAll();
            }
        };
        this.collapseAction.setText(Messages.FileExplorerView_CollapseAll);
        this.collapseAction.setToolTipText(Messages.FileExplorerView_CollapseAllTT);
        this.collapseAction.setImageDescriptor(fCollapseIconDescriptor);
    }

    private void createSortAction() {
        this.sortAction = new CheckBoxAction(Messages.FileExplorerView_SortFiles){

            public void run() {
                if (this.isChecked()) {
                    FileExplorerView.this.viewer.setSorter((ViewerSorter)new NameSorter());
                } else {
                    FileExplorerView.this.viewer.setSorter(null);
                }
            }
        };
        this.sortAction.setToolTipText(Messages.FileExplorerView_SortFilesTT);
        this.sortAction.setImageDescriptor(fSortIconDescriptor);
    }

    private void createRefreshAction() {
        this.refreshAction = new PushButtonAction(Messages.FileExplorerView_Refresh){

            public void run() {
                ISelection selection = FileExplorerView.this.viewer.getSelection();
                if (selection.isEmpty()) {
                    FileExplorerView.this.viewer.refresh();
                    return;
                }
                IStructuredSelection items = (IStructuredSelection)selection;
                for (Object element : items) {
                    if (element instanceof IVirtualFileManager) {
                        IVirtualFileManager vfm = (IVirtualFileManager)element;
                        vfm.refresh();
                    }
                    FileExplorerView.this.viewer.refresh(element);
                }
            }
        };
        this.refreshAction.setToolTipText(Messages.FileExplorerView_RefreshTT);
        this.refreshAction.setImageDescriptor(fRefreshIconDescriptor);
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)this.refreshAction);
    }

    private void createRefreshAllAction() {
        this.refreshAllAction = new PushButtonAction(Messages.FileExplorerView_Refresh){

            public void run() {
                FileExplorerView.this.viewer.refresh(null);
            }
        };
        this.refreshAllAction.setToolTipText(Messages.FileExplorerView_RefreshTT);
        this.refreshAllAction.setImageDescriptor(fRefreshIconDescriptor);
    }

    private void createOpenAction() {
        this.openAction = new PushButtonAction(Messages.FileExplorerView_Open){

            public void run() {
                Object o = FileExplorerView.this.getFirstSelectedItem();
                if (o instanceof IVirtualFile) {
                    FileExplorerView.this.openFileInEditor((IVirtualFile)o);
                }
            }
        };
    }

    private void createNewVirtualFileAction() {
        this.actionNewVirtualFile = new PushButtonAction(Messages.FileExplorerView_NewFile){

            public void run() {
                Object o = FileExplorerView.this.getFirstSelectedItem();
                IVirtualFileManager manager = null;
                if (o instanceof IVirtualFileManager) {
                    manager = (IVirtualFileManager)o;
                    o = manager.getBaseFile();
                }
                if (o instanceof IVirtualFile) {
                    IVirtualFile folder = (IVirtualFile)o;
                    if (!folder.canWrite()) {
                        MessageBox box = new MessageBox(FileExplorerView.this.getSite().getShell(), 33);
                        box.setText(Messages.FileExplorerView_ReadOnlyText);
                        box.setMessage(Messages.FileExplorerView_ReadOnlyMessage);
                        box.open();
                        return;
                    }
                    NewVirtualFileDialog dialog = new NewVirtualFileDialog(folder, FileExplorerView.this.getSite().getShell(), FileExplorerView.this, true);
                    int rc = dialog.open();
                    if (rc == 0 && manager != null) {
                        FileExplorerView.this.viewer.refresh((Object)manager);
                    }
                }
            }
        };
    }

    private void createNewVirtualFolderAction() {
        this.actionNewVirtualFolder = new PushButtonAction(Messages.FileExplorerView_NewFolder){

            public void run() {
                Object o = FileExplorerView.this.getFirstSelectedItem();
                IVirtualFileManager manager = null;
                if (o instanceof IVirtualFileManager) {
                    manager = (IVirtualFileManager)o;
                    o = manager.getBaseFile();
                }
                if (o instanceof IVirtualFile) {
                    IVirtualFile folder = (IVirtualFile)o;
                    if (!folder.canWrite()) {
                        MessageBox box = new MessageBox(FileExplorerView.this.getSite().getShell(), 33);
                        box.setText(Messages.FileExplorerView_ReadOnlyText);
                        box.setMessage(Messages.FileExplorerView_ReadOnlyMessage);
                        box.open();
                        return;
                    }
                    NewVirtualFileDialog dialog = new NewVirtualFileDialog(folder, FileExplorerView.this.getSite().getShell(), FileExplorerView.this, false);
                    int rc = dialog.open();
                    if (rc == 0 && manager != null) {
                        FileExplorerView.this.viewer.refresh((Object)manager);
                    }
                }
            }
        };
    }

    private void createNewVirtualProjectAction() {
        this.actionNewVirtualProject = new PushButtonAction(Messages.FileExplorerView_CreateProject){

            public void run() {
                IWizardDescriptor descriptor = PlatformUI.getWorkbench().getNewWizardRegistry().findWizard("com.aptana.ide.wizards.RemoteProjectWizard");
                if (descriptor != null) {
                    try {
                        IWorkbenchWizard wizard = descriptor.createWizard();
                        IStructuredSelection selectionToPass = (IStructuredSelection)FileExplorerView.this.viewer.getSelection();
                        wizard.init(FilePlugin.getDefault().getWorkbench(), selectionToPass);
                        if (wizard instanceof IWizard) {
                            WizardDialog dialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
                            dialog.create();
                            if (wizard.getPageCount() > 0) {
                                dialog.open();
                            }
                        }
                    }
                    catch (Exception e) {
                        IdeLog.logError((Plugin)FilePlugin.getDefault(), (String)Messages.FileExplorerView_OpenRemoteError, (Throwable)e);
                    }
                }
            }
        };
    }

    private void createNewAction() {
        this.newAction = new NewButtonAction(CoreStrings.NEW){

            public void run() {
                UntitledTextFileWizard w = new UntitledTextFileWizard();
                w.init(FileExplorerView.this.getViewSite().getWorkbenchWindow().getWorkbench(), (IStructuredSelection)FileExplorerView.this.viewer.getSelection());
                w.performFinish();
                w.dispose();
            }
        };
        this.newAction.setToolTipText(Messages.FileExplorerView_NewTT);
        this.newAction.setImageDescriptor(fNewIconDescriptor);
    }

    private void createEditVirtualFileManagerAction() {
        this.editVirtualFileManager = new Action(Messages.FileExplorerView_Properties){

            public void run() {
                Object obj = FileExplorerView.this.getFirstSelectedItem();
                if (obj instanceof IVirtualFileManager) {
                    CoreUIUtils.editVirtualFileManagerProperties((IVirtualFileManager)((IVirtualFileManager)obj));
                }
            }
        };
        this.editVirtualFileManager.setToolTipText(Messages.FileExplorerView_PropertiesForConnection);
    }

    private void createAddVirtualFileManagerAction() {
        this.addVirtualFileManager = new Action(Messages.FileExplorerView_PropertiesTT2){

            public void run() {
                ProtocolManager pm;
                IVirtualFileManagerDialog nld;
                Object obj = FileExplorerView.this.getFirstSelectedItem();
                if (obj instanceof ProtocolManager && (nld = (pm = (ProtocolManager)obj).createPropertyDialog(FileExplorerView.this.viewer.getTree().getShell(), 67696)) != null) {
                    IVirtualFileManager vfm = pm.createFileManager(false);
                    IVirtualFileManager[] managers = (IVirtualFileManager[])SyncManager.getSyncManager().getItems(vfm.getClass());
                    HashSet<String> names = new HashSet<String>();
                    int i = 0;
                    while (i < managers.length) {
                        names.add(managers[i].getNickName());
                        ++i;
                    }
                    String nickName = StringUtils.format((String)Messages.FileExplorerView_AddNewFileManager, (String)pm.getFileManagerName());
                    if (names.contains(nickName)) {
                        String base = nickName;
                        int index = 1;
                        nickName = String.valueOf(base) + "-" + Integer.toString(index);
                        while (names.contains(nickName)) {
                            nickName = String.valueOf(base) + "-" + Integer.toString(++index);
                        }
                    }
                    vfm.setNickName(nickName);
                    nld.setItem(vfm, true);
                    IVirtualFileManager item = nld.open();
                    if (item != null) {
                        ProtocolManager pmInItem = item.getProtocolManager();
                        pmInItem.addFileManager(item);
                    }
                }
            }
        };
        this.addVirtualFileManager.setToolTipText(Messages.FileExplorerView_AddANewItem2);
    }

    private void createEditVirtualFilePropertiesAction() {
        this.editVirtualFileProperties = new Action(Messages.FileExplorerView_Properties){

            public void run() {
                Object obj = FileExplorerView.this.getFirstSelectedItem();
                if (obj instanceof IVirtualFile) {
                    IVirtualFile item = (IVirtualFile)obj;
                    item.editProperties(FileExplorerView.this.viewer.getTree().getShell());
                }
            }
        };
        this.addVirtualFileManager.setToolTipText(Messages.FileExplorerView_PropertiesTT3);
    }

    private void createNewFolderAction() {
        this.newFolderAction = new PushButtonAction(Messages.FileExplorerView_NewFolder){

            public void run() {
                ISelection selection = FileExplorerView.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                IVirtualFile file = FileExplorerView.this.getFile(obj);
                if (file != null) {
                    String path = file.getAbsolutePath();
                    if (path.startsWith("::")) {
                        CoreUIUtils.showMessage((String)Messages.FileExplorerView_CannotCreateFolderInThisSystemDirectory);
                        return;
                    }
                    String baseDir = file.isDirectory() ? file.getAbsolutePath() : file.getParentFile().getAbsolutePath();
                    InputDialog input = new InputDialog(FileExplorerView.this.getSite().getShell(), Messages.FileExplorerView_NewFolderName, Messages.FileExplorerView_EnterFolderName, "", null);
                    if (input.open() == 0) {
                        path = String.valueOf(baseDir) + file.getFileManager().getFileSeparator() + input.getValue();
                        IVirtualFile newDir = file.getFileManager().createVirtualDirectory(path);
                        try {
                            if (!newDir.exists()) {
                                file.getFileManager().createLocalDirectory(newDir);
                            }
                            FileExplorerView.this.viewer.refresh(obj);
                        }
                        catch (ConnectionException connectionException) {
                            CoreUIUtils.showMessage((String)StringUtils.format((String)Messages.FileExplorerView_CouldNotCreateFolder, (String)path));
                        }
                        catch (VirtualFileManagerException virtualFileManagerException) {
                            CoreUIUtils.showMessage((String)StringUtils.format((String)Messages.FileExplorerView_CouldNotCreateFolder, (String)path));
                        }
                    }
                } else {
                    CoreUIUtils.showMessage((String)Messages.FileExplorerView_CannotCreateAFolderInThisTypeOfItem);
                }
            }
        };
        this.newFolderAction.setToolTipText(Messages.FileExplorerView_NewFolderTT);
        this.newFolderAction.setImageDescriptor(fNewFolderIconDescriptor);
    }

    private void createAddLibraryAction() {
        this.addLibraryAction = new PushButtonAction(Messages.FileExplorerView_AddJavaScriptLibrary){

            public void run() {
            }
        };
        this.addLibraryAction.setToolTipText(Messages.FileExplorerView_AddJavaScriptLibraryTT);
    }

    private void createConvertToProjectActions() {
        this.convertToProjectAction = new ConvertToProjectAction(Messages.FileExplorerView_ConvertToProject, false);
        this.convertToProjectAction.setToolTipText(Messages.FileExplorerView_ConvertToProject);
        this.convertToProjectAction.setImageDescriptor(fProjectFolderIconDescriptor);
        this.convertToHostedProjectAction = new ConvertToProjectAction(Messages.FileExplorerView_ConvertToHostedProject, true);
        this.convertToHostedProjectAction.setToolTipText(Messages.FileExplorerView_ConvertToHostedProject);
        this.convertToHostedProjectAction.setImageDescriptor(fHostedProjectFolderIconDescriptor);
    }

    private void createDeleteAction() {
        this.deleteAction = new PushButtonAction(Messages.FileExplorerView_Delete){

            public void run() {
                IVirtualFile sfile;
                ISelection selection = FileExplorerView.this.viewer.getSelection();
                Object[] objs = ((IStructuredSelection)selection).toArray();
                HashSet<Object> refreshList = new HashSet<Object>();
                ArrayList<Object> deleteList = new ArrayList<Object>();
                if (!MessageDialog.openQuestion((Shell)FileExplorerView.this.viewer.getControl().getShell(), (String)Messages.FileExplorerView_ConfirmDelete, (String)StringUtils.format((String)Messages.FileExplorerView_AreYouSureYouWantToDeleteThis, (int)objs.length))) {
                    return;
                }
                int i = 0;
                while (i < objs.length) {
                    Object object = objs[i];
                    if (object instanceof IVirtualFile) {
                        sfile = (IVirtualFile)object;
                        TreeItem ti = FileExplorerView.this.findTreeItem(FileExplorerView.this.viewer.getTree().getItems(), sfile);
                        if (ti != null && !refreshList.contains(ti.getParentItem().getData())) {
                            refreshList.add(ti.getParentItem().getData());
                        }
                        deleteList.add(object);
                    } else if (object instanceof IVirtualFileManager) {
                        IVirtualFileManager manager = (IVirtualFileManager)object;
                        VirtualFileManagerSyncPair[] pairs = SyncManager.getSyncPairs((IVirtualFileManager)manager);
                        if (pairs.length > 0) {
                            ArrayList<String> pairNames = new ArrayList<String>();
                            int j = 0;
                            while (j < pairs.length) {
                                VirtualFileManagerSyncPair object2 = pairs[j];
                                pairNames.add(object2.getNickName());
                                ++j;
                            }
                            if (MessageDialog.openQuestion((Shell)FileExplorerView.this.viewer.getControl().getShell(), (String)Messages.FileExplorerView_ConfirmDelete, (String)StringUtils.format((String)Messages.FileExplorerView_AreYouSureYouWantToDeleteThisFileManager, (Object[])new String[]{manager.getNickName(), StringUtils.join((String)", ", (String[])pairNames.toArray(new String[0]))}))) {
                                deleteList.add(object);
                            }
                        } else {
                            deleteList.add(object);
                        }
                    }
                    ++i;
                }
                if (deleteList.size() == 0) {
                    return;
                }
                i = 0;
                while (i < deleteList.size()) {
                    block21: {
                        Object e = deleteList.get(i);
                        if (e instanceof IVirtualFile) {
                            sfile = (IVirtualFile)e;
                            ProgressMonitorDialog pmd = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
                            try {
                                pmd.run(true, true, new IRunnableWithProgress(){

                                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                        monitor.beginTask(Messages.FileExplorerView_DeletingFiles, -1);
                                        try {
                                            FileExplorerView.this.deleteVirtualFile(monitor, sfile);
                                        }
                                        catch (Exception e) {
                                            throw new InvocationTargetException(e);
                                        }
                                        monitor.done();
                                    }
                                });
                            }
                            catch (InvocationTargetException e2) {
                                if (e2.getCause() instanceof ConnectionException) {
                                    CoreUIUtils.fixConnection((IVirtualFileManager)sfile.getFileManager());
                                    break block21;
                                }
                                CoreUIUtils.showError((String)StringUtils.format((String)Messages.FileExplorerView_UnableToDelete, (String)sfile.getAbsolutePath()), (Exception)e2, (boolean)true);
                            }
                            catch (InterruptedException interruptedException) {}
                        } else if (e instanceof IVirtualFileManager) {
                            IVirtualFileManager f = (IVirtualFileManager)e;
                            f.getProtocolManager().removeFileManager(f);
                        } else {
                            MessageDialog.openError((Shell)FileExplorerView.this.viewer.getControl().getShell(), (String)Messages.FileExplorerView_DeleteFailed, (String)Messages.FileExplorerView_UnableToDeleteItemsOfThisType);
                        }
                    }
                    ++i;
                }
                for (Object e : refreshList) {
                    FileExplorerView.this.refresh(e);
                }
            }
        };
        this.deleteAction.setToolTipText(Messages.FileExplorerView_DeleteTT);
        this.deleteAction.setImageDescriptor(fDeleteIcon);
    }

    private void createRenameAction() {
        this.renameAction = new PushButtonAction(Messages.FileExplorerView_Rename){

            public void run() {
                FileExplorerView.this.rename();
            }
        };
        this.renameAction.setToolTipText(Messages.FileExplorerView_RenameTT);
    }

    public void refresh() {
        this.refresh(null);
    }

    public void refresh(Object toRefresh) {
        if (this.viewerIsAvailable()) {
            if (toRefresh == null) {
                this.viewer.refresh();
            } else {
                this.viewer.refresh(toRefresh);
            }
        }
    }

    private boolean viewerIsAvailable() {
        return this.viewer != null && this.viewer.getControl() != null && !this.viewer.getControl().isDisposed();
    }

    private void renameFile(final TreeItem item) {
        if (!(item.getData() instanceof IVirtualFile)) {
            return;
        }
        if ("macosx".equals(Platform.getOS())) {
            InputDialog dialog = new InputDialog(this.getSite().getShell(), Messages.FileExplorerView_RenameTitle, Messages.FileExplorerView_NewName, item.getText(), null);
            int rc = dialog.open();
            if (rc == 0) {
                boolean renamed = this.renameItem(item, dialog.getValue());
                if (renamed) {
                    item.setText(dialog.getValue());
                } else {
                    CoreUIUtils.showError((String)StringUtils.format((String)Messages.FileExplorerView_UnableToRenameFile, (String)((IVirtualFile)item.getData()).getName()), null);
                }
                this.refresh(item);
            }
        } else {
            final Tree tree = this.viewer.getTree();
            TreeEditor editor = new TreeEditor(this.viewer.getTree());
            final Text text = new Text((Composite)tree, 2048);
            text.setText(item.getText());
            text.selectAll();
            editor.horizontalAlignment = 16384;
            editor.verticalAlignment = 128;
            editor.grabHorizontal = true;
            editor.setEditor((Control)text, item);
            Listener textListener = new Listener(){

                public void handleEvent(Event e) {
                    switch (e.detail) {
                        case 4: {
                            boolean renamed = FileExplorerView.this.renameItem(item, text.getText());
                            if (renamed) {
                                item.setText(text.getText());
                            } else {
                                CoreUIUtils.showError((String)StringUtils.format((String)Messages.FileExplorerView_UnableToRenameFile, (String)((IVirtualFile)item.getData()).getName()), null);
                            }
                            FileExplorerView.this.refresh(item);
                        }
                        case 2: {
                            text.dispose();
                            e.doit = true;
                            e.detail = 0;
                        }
                    }
                }
            };
            tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    tree.removeSelectionListener((SelectionListener)this);
                    text.dispose();
                }
            });
            FocusAdapter listener = new FocusAdapter(){

                public void focusLost(FocusEvent fe) {
                    boolean renamed = FileExplorerView.this.renameItem(item, text.getText());
                    if (renamed) {
                        item.setText(text.getText());
                    } else {
                        CoreUIUtils.showError((String)StringUtils.format((String)Messages.FileExplorerView_UnableToRenameFile, (String)((IVirtualFile)item.getData()).getName()), null);
                    }
                    text.dispose();
                }
            };
            text.addFocusListener((FocusListener)listener);
            text.addListener(31, textListener);
            text.setFocus();
        }
    }

    public void openFileInEditor(IVirtualFile file) {
        IEditorDescriptor editorDesc = null;
        try {
            if (file.exists()) {
                editorDesc = IDE.getEditorDescriptor((String)file.getName());
                CoreUIUtils.openFileInEditor((IVirtualFile)file, (IEditorDescriptor)editorDesc);
            } else if (file.isLink()) {
                CoreUIUtils.showError((String)Messages.FileExplorerView_LinkNotExistError, null, (boolean)false);
            } else {
                CoreUIUtils.showError((String)Messages.FileExplorerView_FileNotExistError, null);
            }
        }
        catch (PartInitException e) {
            IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)Messages.FileExplorerView_ErrorInGetEditorDescriptor, (Throwable)e);
        }
        catch (ConnectionException e) {
            e.printStackTrace();
        }
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                FileExplorerView.this.doubleClickAction.run();
            }
        });
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        String state;
        super.init(site, memento);
        if (memento != null && (state = memento.getString("tree")) != null && state.trim().length() > 0 && state.startsWith(STATE_START_TOKEN)) {
            state = state.trim();
            try {
                state = state.substring(STATE_START_TOKEN.length());
                String[] parts = state.split("\\|");
                if (parts == null || parts.length == 0) {
                    return;
                }
                int count = Integer.parseInt(parts[0]);
                if (count > 0) {
                    ArrayList<LocalFile> elements = new ArrayList<LocalFile>();
                    int i = 0;
                    while (i < count) {
                        if (i + 1 < parts.length) {
                            String src = parts[i + 1];
                            elements.add(new LocalFile(null, new File(src)));
                        }
                        ++i;
                    }
                    this.savedElements = elements.toArray(new Object[0]);
                }
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)Messages.FileExplorerView_ErrorInitializingFileView, (Throwable)e);
            }
        }
    }

    public void selectAndReveal(IVirtualFileManager manager) {
        if (manager != null && manager.getProtocolManager() != null) {
            ProtocolManager protocolManager = manager.getProtocolManager();
            this.viewer.expandToLevel((Object)protocolManager, 1);
            if (protocolManager.hasCustomContent()) {
                Object[] content;
                Object[] objectArray = content = protocolManager.getContent();
                int n = 0;
                int n2 = objectArray.length;
                while (n < n2) {
                    VirtualFileManagerGroup group;
                    Object element = objectArray[n];
                    if (element instanceof VirtualFileManagerGroup && (group = (VirtualFileManagerGroup)element).contains(manager)) {
                        this.viewer.expandToLevel((Object)group, 1);
                        break;
                    }
                    ++n;
                }
            }
            this.viewer.expandToLevel((Object)manager, 1);
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)manager), true);
        }
    }

    public void selectAndReveal(final IVirtualFile file) {
        if (file instanceof LocalFile) {
            this.selectAndReveal(file);
        } else {
            final IVirtualFileManager vfm = file.getFileManager();
            if (vfm != null && vfm.getProtocolManager() != null && vfm.getBasePath() != null && file != null && file.getAbsolutePath() != null) {
                ProtocolManager protocolManager = vfm.getProtocolManager();
                this.viewer.expandToLevel((Object)protocolManager, 1);
                if (protocolManager.hasCustomContent()) {
                    Object[] content;
                    Object[] objectArray = content = protocolManager.getContent();
                    int n = 0;
                    int n2 = objectArray.length;
                    while (n < n2) {
                        VirtualFileManagerGroup group;
                        Object element = objectArray[n];
                        if (element instanceof VirtualFileManagerGroup && (group = (VirtualFileManagerGroup)element).contains(vfm)) {
                            this.viewer.expandToLevel((Object)group, 1);
                            break;
                        }
                        ++n;
                    }
                }
                this.viewer.expandToLevel((Object)vfm, 1);
                final Path path = new Path(file.getAbsolutePath().replace(vfm.getBasePath(), ""));
                StructuredSelection selection = new StructuredSelection((Object)file);
                this.viewer.setSelection((ISelection)new StructuredSelection((Object)file), true);
                final ISelection current = this.viewer.getSelection();
                if (!selection.equals(this.viewer.getSelection())) {
                    UIJob job = new UIJob("Refreshing File view", (ISelection)selection){
                        int totalTime;
                        int segment;
                        String folderPath;
                        private final /* synthetic */ ISelection val$selection;
                        {
                            this.val$selection = iSelection2;
                            super($anonymous0);
                            this.segment = 0;
                            this.folderPath = iVirtualFileManager.getBasePath();
                        }

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            if (FileExplorerView.this.viewer != null && !FileExplorerView.this.viewer.getTree().isDisposed() && this.totalTime < 30000) {
                                if (this.segment < path.segmentCount() - 1) {
                                    String folder = path.segment(this.segment);
                                    String newFolder = String.valueOf(this.folderPath) + "/" + folder;
                                    IVirtualFile f = vfm.createVirtualDirectory(newFolder);
                                    Widget widget = FileExplorerView.this.viewer.testFindItem((Object)f);
                                    if (widget != null) {
                                        FileExplorerView.this.viewer.expandToLevel((Object)f, 1);
                                        if (widget instanceof TreeItem && ((TreeItem)widget).getItemCount() == 0) {
                                            return Status.CANCEL_STATUS;
                                        }
                                        ++this.segment;
                                        this.folderPath = newFolder;
                                    }
                                    this.totalTime += 250;
                                    this.schedule(250L);
                                } else {
                                    if (current.equals(FileExplorerView.this.viewer.getSelection())) {
                                        FileExplorerView.this.viewer.setSelection((ISelection)new StructuredSelection((Object)file), true);
                                        if (file.isDirectory()) {
                                            FileExplorerView.this.viewer.expandToLevel((Object)file, 1);
                                        }
                                    }
                                    if (!this.val$selection.equals(FileExplorerView.this.viewer.getSelection())) {
                                        this.totalTime += 250;
                                        this.schedule(250L);
                                    }
                                }
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    job.schedule(100L);
                } else if (file.isDirectory()) {
                    this.viewer.expandToLevel((Object)file, 1);
                }
            }
        }
    }

    public void selectAndReveal(LocalFile file) {
        LocalFile lf;
        int i;
        TreeItem[] items = this.viewer.getTree().getItems();
        File target = new File(file.getAbsolutePath());
        ArrayList<String> segments = new ArrayList<String>();
        segments.add(target.getAbsolutePath());
        File parent = target.getParentFile();
        while (parent != null) {
            segments.add(parent.getAbsolutePath());
            parent = parent.getParentFile();
        }
        TreeItem startItem = null;
        if (CoreUIUtils.runningOnWindows) {
            i = 0;
            while (i < items.length) {
                if (items[i].getData() instanceof LocalFile && (lf = (LocalFile)items[i].getData()).getPath().equals(MY_COMPUTER_GUID)) {
                    this.viewer.expandToLevel((Object)lf, 1);
                    startItem = items[i];
                    break;
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < items.length) {
                if (items[i].getData() instanceof LocalFile && (lf = (LocalFile)items[i].getData()).getAbsolutePath().equals("/")) {
                    this.viewer.expandToLevel((Object)lf, 1);
                    startItem = items[i];
                }
                ++i;
            }
        }
        if (startItem != null) {
            int s = segments.size() - 1;
            while (s >= 0) {
                items = startItem.getItems();
                int t = 0;
                while (t < items.length) {
                    LocalFile currFile;
                    if (items[t].getData() instanceof LocalFile && (currFile = (LocalFile)items[t].getData()).getAbsolutePath().equals(segments.get(s))) {
                        this.viewer.expandToLevel((Object)currFile, 1);
                        if (s == 0) {
                            this.viewer.setSelection((ISelection)new StructuredSelection((Object)currFile), true);
                        }
                        startItem = items[t];
                    }
                    ++t;
                }
                --s;
            }
        }
    }

    public void saveState(IMemento memento) {
        Object[] elements = this.viewer.getExpandedElements();
        String state = "";
        int count = 0;
        try {
            int i = 0;
            while (i < elements.length) {
                if (elements[i] instanceof IVirtualFile) {
                    String path = ((IVirtualFile)elements[i]).getPath();
                    state = String.valueOf(state) + path + "|";
                    ++count;
                }
                ++i;
            }
            if (count > 0) {
                state = STATE_START_TOKEN + count + "|" + state;
                memento.putString("tree", state);
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)Messages.FileExplorerView_UnableToSaveFileViewState, (Throwable)e);
        }
    }

    private Object getFirstSelectedItem() {
        ISelection selection = this.viewer.getSelection();
        return ((IStructuredSelection)selection).getFirstElement();
    }

    private IVirtualFile getFile(Object obj) {
        IVirtualFile file = null;
        if (obj instanceof IVirtualFile) {
            file = (IVirtualFile)obj;
        } else if (obj instanceof IVirtualFileManager) {
            file = ((IVirtualFileManager)obj).getBaseFile();
        }
        return file;
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    public void setViewer(TreeViewer viewer) {
        this.viewer = viewer;
    }

    public TreeItem findTreeItem(TreeItem[] treeItems, Object dataToFind) {
        TreeItem result = null;
        int i = 0;
        while (i < treeItems.length) {
            Object itemData = treeItems[i].getData();
            result = itemData == dataToFind ? treeItems[i] : this.findTreeItem(treeItems[i].getItems(), dataToFind);
            if (result != null) break;
            ++i;
        }
        return result;
    }

    private boolean overwriteConfirmation(String filename) {
        final boolean[] result = new boolean[1];
        if (!this.alwaysOverwrite) {
            this.viewer.getControl().getDisplay().syncExec(new Runnable(){

                public void run() {
                    MessageDialog dlg = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), Messages.FileReplaceDialog_ReplaceFile, null, Messages.FileReplaceDialog_OverwriteExistingItem, 3, new String[]{IDialogConstants.NO_LABEL, IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL}, 0);
                    switch (dlg.open()) {
                        case 2: {
                            FileExplorerView.this.alwaysOverwrite = true;
                        }
                        case 1: {
                            result[0] = true;
                        }
                    }
                }
            });
        } else {
            result[0] = true;
        }
        return result[0];
    }

    private void rename() {
        ISelection selection = this.viewer.getSelection();
        Object obj = ((IStructuredSelection)selection).getFirstElement();
        if (!(obj instanceof IVirtualFile)) {
            CoreUIUtils.showMessage((String)Messages.FileExplorerView_CannotRenameThisItem);
            return;
        }
        TreeItem[] items = this.viewer.getTree().getSelection();
        if (items.length > 0) {
            this.renameFile(items[0]);
        }
        this.viewer.refresh(obj);
    }

    private boolean renameItem(TreeItem item, String text) {
        boolean renamed = true;
        try {
            IVirtualFile file = (IVirtualFile)item.getData();
            if (file == null) {
                renamed = false;
            } else if (!file.getName().equals(text)) {
                renamed = file.rename(text);
            }
        }
        catch (ConnectionException connectionException) {
            CoreUIUtils.fixConnection((IVirtualFileManager)((IVirtualFile)item.getData()).getFileManager());
        }
        catch (VirtualFileManagerException ex) {
            CoreUIUtils.showError((String)StringUtils.format((String)Messages.FileExplorerView_UnableToRenameFile, (String)((IVirtualFile)item.getData()).getName()), (Exception)((Object)ex));
        }
        return renamed;
    }

    private class ViewLabelProvider
    extends LabelProvider {
        private WorkbenchLabelProvider backupProvider = new WorkbenchLabelProvider();

        private ViewLabelProvider() {
        }

        public String getText(Object element) {
            String retVal = null;
            if (element instanceof ProtocolManager) {
                ProtocolManager pm = (ProtocolManager)element;
                retVal = pm.getDisplayName();
            } else if (element instanceof VirtualFileManagerGroup) {
                VirtualFileManagerGroup group = (VirtualFileManagerGroup)element;
                retVal = group.getName();
            } else if (element instanceof IVirtualFileManager) {
                retVal = ((IVirtualFileManager)element).getDescriptiveLabel();
            } else if (element instanceof IVirtualFile) {
                IVirtualFile f = (IVirtualFile)element;
                retVal = f.getName();
            } else if (element instanceof IAdaptable) {
                Object adapter = ((IAdaptable)element).getAdapter(FileTreeContentProvider.class);
                retVal = this.backupProvider.getText(adapter);
            } else {
                retVal = this.backupProvider.getText(element);
            }
            if (element == FileTreeContentProvider.LOADING) {
                return Messages.FileExplorerView_Loading;
            }
            if (retVal == null) {
                retVal = Messages.FileExplorerView_UnknownElement;
            }
            return retVal;
        }

        public Image getImage(Object element) {
            Image image = null;
            if (element instanceof ProtocolManager) {
                ProtocolManager pm = (ProtocolManager)element;
                image = pm.getImage();
            } else {
                if (element instanceof VirtualFileManagerGroup) {
                    VirtualFileManagerGroup group = (VirtualFileManagerGroup)element;
                    return group.getImage();
                }
                if (element instanceof IVirtualFileManager) {
                    IVirtualFileManager fm = (IVirtualFileManager)element;
                    image = fm.getImage();
                } else if (element instanceof IVirtualFile) {
                    IVirtualFile f = (IVirtualFile)element;
                    image = f.getImage();
                    if (image == null) {
                        IEditorDescriptor desc = FileExplorerView.this.registry.getDefaultEditor(f.getName());
                        if (desc == null || desc.getImageDescriptor() == null) {
                            IWorkbench workbench = PlatformUI.getWorkbench();
                            if (workbench != null) {
                                ISharedImages sharedImages = workbench.getSharedImages();
                                if (f.isDirectory()) {
                                    image = sharedImages.getImage("IMG_OBJ_FOLDER");
                                } else {
                                    image = ImageUtils.getIcon(f.getExtension());
                                    if (image == null) {
                                        image = sharedImages.getImage("IMG_OBJ_FILE");
                                    }
                                }
                            }
                        } else if (FileExplorerView.this.images.containsKey(desc)) {
                            image = (Image)FileExplorerView.this.images.get(desc);
                        } else {
                            image = desc.getImageDescriptor().createImage();
                            FileExplorerView.this.images.put(desc, image);
                        }
                    }
                } else {
                    if (element == FileTreeContentProvider.LOADING) {
                        return FilePlugin.getImage("icons/hourglass.png");
                    }
                    if (element instanceof IAdaptable) {
                        Object adapter = ((IAdaptable)element).getAdapter(FileTreeContentProvider.class);
                        image = this.backupProvider.getImage(adapter);
                    } else {
                        image = this.backupProvider.getImage(element);
                    }
                }
            }
            return image;
        }
    }

    private class NameSorter
    extends ViewerSorter {
        private NameSorter() {
        }

        public int category(Object element) {
            if (element instanceof ProjectProtocolManager) {
                return 2;
            }
            if (element instanceof ProtocolManager) {
                return 3;
            }
            if (element instanceof IVirtualFileManager) {
                return 1;
            }
            if (element instanceof IVirtualFile) {
                IVirtualFile f = (IVirtualFile)element;
                return f.isDirectory() ? 0 : 1;
            }
            return 0;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int cat2;
            int cat1 = this.category(e1);
            if (cat1 != (cat2 = this.category(e2))) {
                return cat1 - cat2;
            }
            if (e1 instanceof ProtocolManager && e2 instanceof ProtocolManager) {
                return ((ProtocolManager)e1).compareTo(e2);
            }
            if (e1 instanceof IVirtualFileManager && e2 instanceof IVirtualFileManager) {
                return ((IVirtualFileManager)e1).compareTo(e2);
            }
            if (e1 instanceof IVirtualFile && e2 instanceof IVirtualFile) {
                return ((IVirtualFile)e1).compareTo(e2);
            }
            return 0;
        }
    }

    private class AllowOnlyWebFilesFilter
    extends ViewerFilter {
        List<String> list = null;

        public AllowOnlyWebFilesFilter(String[] extensions) {
            this.list = new ArrayList<String>((Collection)Arrays.asList(extensions));
        }

        public boolean select(Viewer viewer, Object parent, Object element) {
            if (FileExplorerView.this.webFiltering && element instanceof IVirtualFile) {
                IVirtualFile f = (IVirtualFile)element;
                if (f.isDirectory()) {
                    return true;
                }
                String extension = "*" + f.getExtension();
                return this.list.contains(extension);
            }
            return true;
        }
    }

    private class FileSelectionListener
    implements SelectionListener,
    MouseListener {
        private static final int INTERVAL = 2000;
        private boolean shouldRename;
        private TreeItem selection;
        private long firstSelectionTime;

        private FileSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            TreeItem[] selections = FileExplorerView.this.viewer.getTree().getSelection();
            if (selections.length == 0) {
                return;
            }
            Object obj = FileExplorerView.this.getFirstSelectedItem();
            if (!(obj instanceof IVirtualFile)) {
                return;
            }
            if (this.selection == null || selections.length > 1 || this.selection != selections[0]) {
                this.selection = selections[0];
                this.firstSelectionTime = Calendar.getInstance().getTimeInMillis();
            } else {
                long currentTime = Calendar.getInstance().getTimeInMillis();
                if (currentTime - this.firstSelectionTime < 2000L) {
                    this.shouldRename = true;
                    this.selection = null;
                } else {
                    this.firstSelectionTime = currentTime;
                }
            }
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseUp(MouseEvent e) {
            if (this.shouldRename) {
                FileExplorerView.this.rename();
                this.shouldRename = false;
            }
        }
    }

    protected class NewButtonAction
    extends Action {
        protected boolean fRecreateMenu;
        private IMenuCreator menuCreator;

        public NewButtonAction(String text) {
            super(text, 4);
            this.fRecreateMenu = false;
            this.menuCreator = new IMenuCreator(){
                private MenuManager dropDownMenuMgr;

                private void createDropDownMenuMgr() {
                    if (this.dropDownMenuMgr == null) {
                        this.dropDownMenuMgr = new MenuManager();
                        this.dropDownMenuMgr.add((IContributionItem)new NewWizardMenu(FileExplorerView.this.getViewSite().getWorkbenchWindow()));
                    }
                }

                public Menu getMenu(Control parent) {
                    this.createDropDownMenuMgr();
                    return this.dropDownMenuMgr.createContextMenu(parent);
                }

                public Menu getMenu(Menu parent) {
                    this.createDropDownMenuMgr();
                    Menu menu = new Menu(parent);
                    ActionContributionItem newItem = new ActionContributionItem((IAction)FileExplorerView.this.newFolderAction);
                    newItem.fill(menu, 0);
                    IContributionItem[] items = this.dropDownMenuMgr.getItems();
                    int i = 0;
                    while (i < items.length) {
                        IContributionItem item = items[i];
                        newItem = item;
                        if (item instanceof ActionContributionItem) {
                            newItem = new ActionContributionItem(((ActionContributionItem)item).getAction());
                        }
                        newItem.fill(menu, -1);
                        ++i;
                    }
                    return menu;
                }

                public void dispose() {
                    if (this.dropDownMenuMgr != null) {
                        this.dropDownMenuMgr.dispose();
                        this.dropDownMenuMgr = null;
                    }
                }
            };
            this.setMenuCreator(this.menuCreator);
        }
    }

    public class NewWizardMenu
    extends BaseNewWizardMenu {
        private boolean enabled;

        public NewWizardMenu(IWorkbenchWindow window) {
            this(window, null);
        }

        public NewWizardMenu(IWorkbenchWindow window, String id) {
            super(window, id);
            this.enabled = true;
        }

        public NewWizardMenu(IMenuManager innerMgr, IWorkbenchWindow window, boolean register) {
            this(window, null);
            this.fillMenu((IContributionManager)innerMgr);
        }

        private void fillMenu(IContributionManager innerMgr) {
            innerMgr.removeAll();
            IContributionItem[] items = this.getContributionItems();
            int i = 0;
            while (i < items.length) {
                innerMgr.add(items[i]);
                ++i;
            }
        }

        public void deregisterListeners() {
        }

        protected void addItems(List list) {
            list.add(new Separator());
            if (this.addShortcuts(list)) {
                list.add(new Separator());
            }
            list.add(new ActionContributionItem(this.getShowDialogAction()));
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabledValue) {
            this.enabled = enabledValue;
        }

        protected IContributionItem[] getContributionItems() {
            if (this.isEnabled()) {
                return super.getContributionItems();
            }
            return new IContributionItem[0];
        }
    }

    private class ConvertToProjectAction
    extends PushButtonAction {
        private boolean createHostedSite;

        public ConvertToProjectAction(String text, boolean createHostedSite) {
            super(text);
            this.createHostedSite = createHostedSite;
        }

        public void run() {
            ISelection selection = FileExplorerView.this.viewer.getSelection();
            Object obj = ((IStructuredSelection)selection).getFirstElement();
            if (obj instanceof LocalFile) {
                String path = ((LocalFile)obj).getPath();
                PromoteToProjectWizard wizard = new PromoteToProjectWizard(path);
                wizard.setCreatingHostedSite(this.createHostedSite);
                WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wizard);
                dialog.create();
                CoreUIUtils.placeDialogInScreenCenter((Shell)Display.getCurrent().getActiveShell(), (Shell)dialog.getShell());
                dialog.open();
            }
        }
    }
}

