/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui.io.file;

import com.aptana.ide.core.FileUtils;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.PluginUtils;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.io.ConnectionException;
import com.aptana.ide.core.io.FileTransferListener;
import com.aptana.ide.core.io.IFileProgressMonitor;
import com.aptana.ide.core.io.IVirtualFile;
import com.aptana.ide.core.io.IVirtualFileManager;
import com.aptana.ide.core.io.ProtocolManager;
import com.aptana.ide.core.io.VirtualFile;
import com.aptana.ide.core.io.VirtualFileManagerException;
import com.aptana.ide.core.io.VirtualManagerBase;
import com.aptana.ide.core.ui.CoreUIPlugin;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.core.ui.ImageUtils;
import com.aptana.ide.core.ui.io.file.CompressedFile;
import com.aptana.ide.core.ui.io.file.LocalFile;
import com.aptana.ide.core.ui.io.file.LocalProtocolManager;
import com.aptana.ide.core.ui.io.file.Messages;
import com.aptana.ide.core.ui.syncing.SyncingConsole;
import com.aptana.ide.io.file.FilePlugin;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.filechooser.FileSystemView;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalFileManager
extends VirtualManagerBase {
    private String _basePath;
    private Image _image;
    private Image _disabledImage;

    public LocalFileManager(ProtocolManager protocolManager) {
        super(protocolManager);
        this.addFileTransferListener(new FileTransferListener(){

            public void addText(String eventText) {
                SyncingConsole.println((String)eventText);
            }
        });
    }

    public IVirtualFile createVirtualFile(String path) {
        return new LocalFile(this, new File(path));
    }

    public boolean createLocalDirectory(IVirtualFile directoryFile) {
        File f = new File(directoryFile.getAbsolutePath());
        return f.mkdirs();
    }

    public IVirtualFile createVirtualDirectory(String path) {
        return new LocalFile(this, new File(path));
    }

    public IVirtualFile getBaseFile() {
        String basePath = this.getBasePath();
        if (basePath == null) {
            throw new IllegalArgumentException(Messages.LocalFileManager_BasePathCannotBeNull);
        }
        return new LocalFile(this, new File(basePath));
    }

    public String getBasePath() {
        return this._basePath;
    }

    public void setBasePath(String path) {
        if (path == null || path.equals("")) {
            throw new IllegalArgumentException(Messages.LocalFileManager_pathCannotBeEmptyOrNull);
        }
        this._basePath = path;
    }

    public IVirtualFile[] getFiles(IVirtualFile file) {
        return this.getFiles(file, false, true);
    }

    public IVirtualFile[] getFiles(IVirtualFile file, boolean recurse, boolean includeCloakedFiles) {
        IVirtualFile[] result = null;
        if (file instanceof LocalFile) {
            ArrayList<IVirtualFile> list = new ArrayList<IVirtualFile>();
            File f = ((LocalFile)file).getFile();
            this.getFiles(f, recurse, list, includeCloakedFiles);
            result = list.toArray(new IVirtualFile[0]);
        }
        return result;
    }

    public String getFileTimeString(IVirtualFile file) {
        return Long.toString(file.getModificationMillis());
    }

    private void getFiles(File file, boolean recurse, List<IVirtualFile> list, boolean includeCloakedFiles) {
        if (file == null) {
            return;
        }
        this.fireGetFilesEvent(file.getAbsolutePath());
        File[] children = null;
        if (!CoreUIUtils.runningOnMac) {
            children = file.getName().equals(LocalProtocolManager.FileSystemRoots) ? FileSystemView.getFileSystemView().getRoots() : FileSystemView.getFileSystemView().getFiles(file, false);
        } else {
            File[] kids = file.getName().equals(LocalProtocolManager.FileSystemRoots) ? File.listRoots() : file.listFiles();
            File[] fileArray = children = kids == null ? new File[]{} : kids;
        }
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                File child = children[i];
                VirtualFile localFile = CoreUIPlugin.getDefault().getPreferenceStore().getBoolean("com.aptana.ide.core.ui.PREF_FILE_EXPLORER_SHOW_COMPRESSED") && (child.getName().endsWith(".zip") || child.getName().endsWith(".jar") || child.getName().endsWith(".gz")) ? new CompressedFile(this, child) : new LocalFile(this, child);
                boolean addingFile = false;
                if (includeCloakedFiles || !localFile.isCloaked()) {
                    list.add((IVirtualFile)localFile);
                    addingFile = true;
                }
                if (recurse && child.isDirectory() && addingFile) {
                    this.getFiles(child, recurse, list, includeCloakedFiles);
                }
                ++i;
            }
        }
    }

    public boolean hasFiles(IVirtualFile file) {
        return file.hasFiles();
    }

    public String getFileSeparator() {
        return File.separator;
    }

    public String getGroup(IVirtualFile file) {
        return null;
    }

    public void setGroup(IVirtualFile file, String groupName) {
    }

    public Image getImage() {
        if (this._image == null) {
            return ImageUtils.getFolderIcon();
        }
        return this._image;
    }

    public void setImage(Image image) {
        this._image = image;
    }

    public Image getDisabledImage() {
        if (this._disabledImage == null) {
            return ImageUtils.getFolderIcon();
        }
        return this._disabledImage;
    }

    public void setDisabledImage(Image image) {
        this._disabledImage = image;
    }

    public String getOwner(IVirtualFile file) {
        return null;
    }

    public void setOwner(IVirtualFile file, String ownerName) {
    }

    public long getTimeOffset() throws ConnectionException {
        return 0L;
    }

    public int compareTo(Object o) {
        if (o instanceof IVirtualFileManager) {
            return this.getNickName().compareToIgnoreCase(((LocalFileManager)((Object)o)).getNickName());
        }
        return 0;
    }

    private static boolean deleteDirectory(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            int i = 0;
            while (i < children.length) {
                boolean result = LocalFileManager.deleteDirectory(new File(dir, children[i]));
                if (!result) {
                    return false;
                }
                ++i;
            }
        }
        return dir.delete();
    }

    public boolean deleteFile(IVirtualFile file) {
        boolean result = false;
        if (file == null || !(file instanceof LocalFile)) {
            return result;
        }
        LocalFile lf = (LocalFile)file;
        File target = lf.getFile();
        if (target != null && target.exists()) {
            result = LocalFileManager.deleteDirectory(target);
        }
        return result;
    }

    public InputStream getStream(IVirtualFile file) {
        FileInputStream result = null;
        try {
            result = new FileInputStream(file.getAbsolutePath());
        }
        catch (FileNotFoundException e) {
            IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)StringUtils.format((String)Messages.LocalFileManager_UnableToCreateFileStreamForFile, (String)file.getAbsolutePath()), (Throwable)e);
        }
        return result;
    }

    public void putToLocalFile(IVirtualFile file, File localFile) {
        if (file.isLocal()) {
            FileUtils.copy((File)new File(file.getAbsolutePath()), (File)localFile);
        } else {
            try {
                FileUtils.pipe((InputStream)file.getStream(), (OutputStream)new FileOutputStream(localFile), (boolean)false);
                localFile.setLastModified(System.currentTimeMillis());
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)FilePlugin.getDefault(), (String)"Error copying local file", (Throwable)e);
            }
        }
    }

    public boolean moveFile(IVirtualFile source, IVirtualFile destination) {
        boolean result = false;
        if (source == null || destination == null || !(source instanceof LocalFile)) {
            return result;
        }
        result = this.moveFile(source.getAbsolutePath(), destination.getAbsolutePath());
        return result;
    }

    private boolean moveFile(String from, String to) {
        boolean result = FileUtils.copy((String)from, (String)to);
        if (result) {
            File fromFile = new File(from);
            result = fromFile.delete();
        }
        return result;
    }

    public void putStream(InputStream input, IVirtualFile targetFile, IFileProgressMonitor monitor) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException(Messages.LocalFileManager_InputStreamCannotBeNull);
        }
        File file = new File(targetFile.getAbsolutePath());
        try {
            if (file.exists() || file.createNewFile()) {
                FileOutputStream output = new FileOutputStream(file);
                FileUtils.pipe((InputStream)input, (OutputStream)output, (boolean)false, null, (IFileProgressMonitor)monitor);
                output.close();
                if (monitor != null) {
                    monitor.done();
                }
            }
        }
        catch (Throwable throwable) {
            try {
                input.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            input.close();
        }
        catch (IOException iOException) {}
    }

    public boolean renameFile(IVirtualFile file, String newName) {
        File parent;
        boolean result = false;
        if (file == null || !(file instanceof LocalFile)) {
            return result;
        }
        LocalFile lf = (LocalFile)file;
        File target = lf.getFile();
        File newFile = new File(newName);
        File newParent = newFile.getParentFile();
        if (newParent == null && (parent = target.getParentFile()) != null) {
            String path = String.valueOf(parent.getAbsolutePath()) + File.separator + newName;
            newFile = new File(path);
        }
        try {
            result = this.renameFile(target, newFile);
            if (result) {
                lf.setInternalFile(newFile);
            }
        }
        catch (IOException iOException) {
            result = false;
        }
        return result;
    }

    public void refresh() {
    }

    private boolean renameFile(File source, File destination) throws IOException {
        File parent;
        boolean result = false;
        if (destination.isDirectory() && (parent = destination.getParentFile()) != null && !parent.exists()) {
            parent.mkdirs();
        }
        if (source.getAbsolutePath().toLowerCase().equals(destination.getAbsolutePath().toLowerCase())) {
            result = source.renameTo(destination);
            return result;
        }
        if (destination.isFile() && destination.exists()) {
            throw new IOException(String.valueOf(Messages.LocalFileManager_UnableToRemoveExistingFile) + destination);
        }
        result = source.renameTo(destination);
        return result;
    }

    public String getHashString() {
        String result = "";
        result = String.valueOf(result) + this.getNickName() + "%%%%";
        result = String.valueOf(result) + this.getBasePath() + "%%%%";
        result = String.valueOf(result) + this.getId() + "%%%%";
        result = String.valueOf(result) + this.isAutoCalculateServerTimeOffset() + "%%%%";
        try {
            result = String.valueOf(result) + this.getTimeOffset() + "%%%%";
        }
        catch (ConnectionException connectionException) {
            result = String.valueOf(result) + "0%%%%";
        }
        result = String.valueOf(result) + this.serializeCloakedFiles(this.getCloakedFiles()) + "%%%%";
        result = String.valueOf(result) + StringUtils.join((String)"}}}}", (String[])this.getCloakedFileExpressions()) + "%%%%";
        return result;
    }

    public boolean containsFile(IVirtualFile file) {
        Path otherPath = new Path(file.getAbsolutePath());
        if (this.getBasePath() != null) {
            Path thisPath = new Path(this.getBaseFile().getAbsolutePath());
            return thisPath.isPrefixOf((IPath)otherPath);
        }
        return false;
    }

    public String getType() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String toSerializableString() {
        return this.getHashString();
    }

    public void fromSerializableString(String s) {
        String[] items = s.split("%%%%");
        if (items.length >= 3) {
            this.setNickName(items[0]);
            if (items[1] == null || "".equals(items[1])) {
                this.setBasePath("/");
            } else {
                this.setBasePath(items[1]);
            }
            this.setId(Long.parseLong(items[2]));
        }
        if (items.length >= 5) {
            this.setAutoCalculateServerTimeOffset(Boolean.valueOf(items[3]));
            this.setTimeOffset(Long.parseLong(items[4]));
        }
        if (items.length >= 7) {
            IVirtualFile[] files = this.deserializeCloakedFiles(items[5]);
            int i = 0;
            while (i < files.length) {
                IVirtualFile file = files[i];
                this.addCloakedFile(file);
                ++i;
            }
            String[] files2 = items[6].split("}}}}");
            int i2 = 0;
            while (i2 < files.length) {
                String file2 = files2[i2];
                this.addCloakExpression(file2);
                ++i2;
            }
        }
    }

    public String getDescriptiveLabel() {
        String label = this.getNickName();
        if (label == null || "".equals(label)) {
            return this.getBasePath();
        }
        return label;
    }

    public void connect() {
    }

    public void disconnect() {
    }

    public void resolveBasePath() throws ConnectionException, VirtualFileManagerException {
        if (!CoreUIUtils.runningOnMac) {
            File[] root = FileSystemView.getFileSystemView().getRoots();
            if (root.length > 0) {
                this._basePath = root[0].getAbsolutePath();
            }
        } else {
            File[] root = File.listRoots();
            if (root.length > 0) {
                this._basePath = root[0].getAbsolutePath();
            }
        }
    }

    public boolean isConnected() {
        return true;
    }

    protected IPreferenceStore getPreferenceStore() {
        if (PluginUtils.isPluginLoaded((Plugin)CoreUIPlugin.getDefault())) {
            return CoreUIPlugin.getDefault().getPreferenceStore();
        }
        return null;
    }

    public static void addGlobalSyncCloakExpression(String expression) {
        ArrayList<String> newExpressions = new ArrayList<String>();
        IPreferenceStore store = CoreUIPlugin.getDefault().getPreferenceStore();
        String editors = store.getString("com.aptana.ide.core.PREF_GLOBAL_SYNC_CLOAKING_EXTENSIONS");
        if (editors != null && !"".equals(editors)) {
            String[] array = editors.split(";");
            boolean found = false;
            int i = 0;
            while (i < array.length) {
                String string = array[i];
                if (string.equals(expression)) {
                    found = true;
                }
                newExpressions.add(string);
                ++i;
            }
            if (!found) {
                newExpressions.add(expression);
            }
        } else {
            newExpressions.add(expression);
        }
        editors = StringUtils.join((String)";", (String[])newExpressions.toArray(new String[0]));
        store.setValue("com.aptana.ide.core.PREF_GLOBAL_SYNC_CLOAKING_EXTENSIONS", editors);
        CoreUIPlugin.getDefault().savePluginPreferences();
    }

    public static void removeGlobalSyncCloakExpression(String expression) {
        ArrayList<String> newExpressions = new ArrayList<String>();
        IPreferenceStore store = CoreUIPlugin.getDefault().getPreferenceStore();
        String editors = store.getString("com.aptana.ide.core.PREF_GLOBAL_SYNC_CLOAKING_EXTENSIONS");
        if (editors != null && !"".equals(editors)) {
            String[] array = editors.split(";");
            int i = 0;
            while (i < array.length) {
                String string = array[i];
                if (!string.equals(expression)) {
                    newExpressions.add(string);
                }
                ++i;
            }
        }
        editors = StringUtils.join((String)";", (String[])newExpressions.toArray(new String[0]));
        store.setValue("com.aptana.ide.core.PREF_GLOBAL_SYNC_CLOAKING_EXTENSIONS", editors);
        CoreUIPlugin.getDefault().savePluginPreferences();
    }

    public boolean isValid() {
        File f = new File(this.getBasePath());
        return f.exists();
    }

    public IVirtualFileManager cloneManager() {
        LocalFileManager manager = new LocalFileManager(this.getProtocolManager());
        manager.setId(this.getId());
        manager.setBasePath(this.getBasePath());
        manager.setCloakedFiles(this.getCloakedFiles());
        manager.setImage(this.getImage());
        manager.setDisabledImage(this.getDisabledImage());
        manager.setTransient(this.isTransient());
        return manager;
    }
}

