/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui.io.file;

import com.aptana.ide.core.CoreStrings;
import com.aptana.ide.core.io.IVirtualFile;
import com.aptana.ide.core.ui.SWTUtils;
import com.aptana.ide.core.ui.dialogs.GenericDialog;
import com.aptana.ide.core.ui.io.file.Messages;
import java.text.DateFormat;
import java.util.Date;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class InfoDialog
extends GenericDialog {
    private IVirtualFile _item;
    protected Object result;
    protected Shell shell;
    private Text _where;
    private Text _kind;
    private Text _size;
    private Text _modified;

    public InfoDialog(Shell parent, int style) {
        super(parent, style);
    }

    public InfoDialog(Shell parent) {
        this(parent, 0);
    }

    public void setItem(IVirtualFile item) {
        this._item = item;
    }

    public Object open() {
        this.createContents();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        SWTUtils.centerAndPack((Shell)this.shell, (Shell)this.getParent());
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    protected void createContents() {
        this.shell = new Shell(this.getParent(), 67680);
        this.addCloseBoxListener(this.shell);
        GridLayout gridLayout_3 = new GridLayout();
        gridLayout_3.numColumns = 2;
        this.shell.setLayout((Layout)gridLayout_3);
        this.shell.setSize(252, 414);
        this.shell.setText(Messages.InfoDialog_Info);
        Group generalGroup = new Group((Composite)this.shell, 0);
        generalGroup.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        generalGroup.setLayout((Layout)gridLayout);
        generalGroup.setText(Messages.InfoDialog_General);
        Label kindLabel = new Label((Composite)generalGroup, 8);
        kindLabel.setText(Messages.InfoDialog_Kind);
        this._kind = new Text((Composite)generalGroup, 8);
        this._kind.setEditable(false);
        this._kind.setBackground(Display.getCurrent().getSystemColor(22));
        Label sizeLabel = new Label((Composite)generalGroup, 0);
        sizeLabel.setText(Messages.InfoDialog_Size);
        this._size = new Text((Composite)generalGroup, 8);
        this._size.setEditable(false);
        this._size.setBackground(Display.getCurrent().getSystemColor(22));
        Label whereLabel = new Label((Composite)generalGroup, 0);
        whereLabel.setText(Messages.InfoDialog_Where);
        this._where = new Text((Composite)generalGroup, 8);
        this._where.setEditable(false);
        this._where.setBackground(Display.getCurrent().getSystemColor(22));
        Label modifiedLabel = new Label((Composite)generalGroup, 0);
        modifiedLabel.setText(Messages.InfoDialog_Modified);
        this._modified = new Text((Composite)generalGroup, 8);
        this._modified.setEditable(false);
        this._modified.setBackground(Display.getCurrent().getSystemColor(22));
        Composite composite = new Composite((Composite)this.shell, 0);
        composite.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        GridLayout gridLayout_4 = new GridLayout();
        gridLayout_4.verticalSpacing = 10;
        gridLayout_4.numColumns = 1;
        composite.setLayout((Layout)gridLayout_4);
        Button applyButton = new Button(composite, 0);
        applyButton.setText(CoreStrings.OK);
        applyButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                InfoDialog.this.shell.dispose();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.setInitialFieldValues();
    }

    protected void setInitialFieldValues() {
        this._kind.setText(this._item.isDirectory() ? Messages.InfoDialog_Folder : Messages.InfoDialog_File);
        this._size.setText(String.valueOf(this._item.getSize()) + Messages.InfoDialog_Bytes);
        this._where.setText(this._item.getAbsolutePath());
        if (this._item.getModificationMillis() != 0L) {
            DateFormat df = DateFormat.getDateTimeInstance(1, 1);
            this._modified.setText(df.format(new Date(this._item.getModificationMillis())));
        } else if (this._item.getTimeStamp() != null) {
            this._modified.setText(this._item.getTimeStamp());
        }
    }

    public void handleCancel() {
        this.shell.dispose();
    }
}

