/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui.io.file;

import com.aptana.ide.core.io.ConnectionException;
import com.aptana.ide.core.io.IFileProgressMonitor;
import com.aptana.ide.core.io.IVirtualFile;
import com.aptana.ide.core.io.IVirtualFileManager;
import com.aptana.ide.core.io.VirtualFile;
import com.aptana.ide.core.io.VirtualFileManagerException;
import com.aptana.ide.core.ui.io.file.CompressedFile;
import com.aptana.ide.core.ui.io.file.ILocalFile;
import com.aptana.ide.core.ui.io.file.LocalFileManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

public class CompressedFileEntry
extends VirtualFile
implements ILocalFile {
    private ZipEntry entry;
    private LocalFileManager manager;
    private CompressedFile parent;
    private String name;
    private List<CompressedFileEntry> entries;

    public CompressedFileEntry(ZipEntry entry, LocalFileManager manager, CompressedFile parent) {
        this.entry = entry;
        this.manager = manager;
        this.parent = parent;
        this.entries = new ArrayList<CompressedFileEntry>();
        this.name = null;
    }

    public void addEntry(CompressedFileEntry child) {
        this.entries.add(child);
    }

    public CompressedFileEntry getEntry(String name) {
        for (CompressedFileEntry entry : this.entries) {
            if (!entry.getName().equals(name)) continue;
            return entry;
        }
        return null;
    }

    public boolean canRead() {
        return true;
    }

    public boolean canWrite() {
        return false;
    }

    public boolean delete() throws ConnectionException, VirtualFileManagerException {
        return false;
    }

    public boolean exists() throws ConnectionException {
        return true;
    }

    public String getAbsolutePath() {
        if (this.entry != null) {
            return this.entry.getName();
        }
        return this.name;
    }

    public long getCreationMillis() {
        return 0L;
    }

    public String getExtension() {
        String path;
        int lastDot;
        String result = "";
        if (this.entry != null && (lastDot = (path = this.entry.getName()).lastIndexOf(".")) > -1 && lastDot < path.length() - 2) {
            result = path.substring(lastDot);
        }
        return result;
    }

    public IVirtualFileManager getFileManager() {
        return this.manager;
    }

    public IVirtualFile[] getFiles(boolean recurse, boolean includeCloakedFiles) throws ConnectionException, IOException {
        return this.entries.toArray(new IVirtualFile[0]);
    }

    public String getGroup() {
        return null;
    }

    public Image getImage() {
        return null;
    }

    public long getModificationMillis() {
        return 0L;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getOwner() {
        return null;
    }

    public IVirtualFile getParentFile() {
        return this.parent;
    }

    public String getPath() {
        return this.getAbsolutePath();
    }

    public long getPermissions() {
        return 0L;
    }

    public String getRelativePath() {
        return this.getAbsolutePath();
    }

    public long getSize() {
        if (this.entry != null) {
            return this.entry.getSize();
        }
        return 0L;
    }

    public InputStream getStream() throws ConnectionException, VirtualFileManagerException {
        if (this.entry != null && this.parent != null & this.parent.getCompressedFile() != null) {
            try {
                return this.parent.getCompressedFile().getInputStream(this.entry);
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    public boolean hasFiles() {
        return this.entries != null && this.entries.size() > 0;
    }

    public boolean isDirectory() {
        if (this.entry != null) {
            return this.entry.isDirectory();
        }
        return true;
    }

    public boolean isFile() {
        return !this.isDirectory();
    }

    public boolean isLink() {
        return false;
    }

    public void putStream(InputStream input, IFileProgressMonitor monitor) throws ConnectionException, VirtualFileManagerException, IOException {
    }

    public boolean rename(String newName) throws ConnectionException, VirtualFileManagerException {
        return false;
    }

    public void setGroup(String group) {
    }

    public void setImage(Image image) {
    }

    public void setModificationMillis(long modificationTime) throws IOException, ConnectionException {
    }

    public void setOwner(String owner) {
    }

    public void setPermissions(long permissions) {
    }

    public void editProperties(Shell shell) {
    }

    public boolean isCloaked() {
        return this.manager.isFileCloaked(this);
    }

    public void setCloaked(boolean cloak) {
        if (cloak) {
            this.manager.addCloakedFile(this);
        } else {
            this.manager.removeCloakedFile(this);
        }
    }

    public int compareTo(Object o) {
        if (o instanceof CompressedFileEntry) {
            return this.getName().compareToIgnoreCase(((CompressedFileEntry)o).getName());
        }
        return 0;
    }

    public File getFile() {
        return null;
    }
}

