/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui.io.file;

import com.aptana.ide.core.io.ConnectionException;
import com.aptana.ide.core.io.IFileProgressMonitor;
import com.aptana.ide.core.io.IVirtualFile;
import com.aptana.ide.core.io.IVirtualFileManager;
import com.aptana.ide.core.io.VirtualFile;
import com.aptana.ide.core.io.VirtualFileManagerException;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.core.ui.ImageUtils;
import com.aptana.ide.core.ui.io.file.CompressedFileEntry;
import com.aptana.ide.core.ui.io.file.ILocalFile;
import com.aptana.ide.core.ui.io.file.InfoDialog;
import com.aptana.ide.core.ui.io.file.LocalFile;
import com.aptana.ide.core.ui.io.file.LocalFileManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.swing.filechooser.FileSystemView;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

public class CompressedFile
extends VirtualFile
implements ILocalFile {
    protected static FileSystemView filesys;
    private long permissions = 0L;
    private File file;
    private LocalFileManager manager;
    private ZipFile zippedFile;
    private Image image = null;

    static {
        if (!CoreUIUtils.onMacOSX) {
            filesys = FileSystemView.getFileSystemView();
        }
    }

    public CompressedFile(LocalFileManager manager, File file) {
        this.file = file;
        this.manager = manager;
        try {
            this.zippedFile = new ZipFile(this.file);
        }
        catch (ZipException zipException) {
        }
        catch (IOException iOException) {}
    }

    public boolean canRead() {
        boolean result = false;
        if (this.file != null) {
            result = this.file.canRead();
        }
        return result;
    }

    public boolean canWrite() {
        boolean result = false;
        if (this.file != null) {
            result = this.file.canWrite();
        }
        return result;
    }

    public boolean delete() throws ConnectionException, VirtualFileManagerException {
        boolean result = false;
        if (this.file != null) {
            result = this.file.delete();
        }
        return result;
    }

    public boolean exists() throws ConnectionException {
        if (this.file != null) {
            return this.file.exists();
        }
        return false;
    }

    public String getAbsolutePath() {
        try {
            return this.file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return this.file.getAbsolutePath();
        }
    }

    public long getCreationMillis() {
        return 0L;
    }

    public String getExtension() {
        String result = "";
        String path = this.file.getName();
        int lastDot = path.lastIndexOf(".");
        if (lastDot > -1 && lastDot < path.length() - 2) {
            result = path.substring(lastDot);
        }
        return result;
    }

    public IVirtualFileManager getFileManager() {
        return this.manager;
    }

    public IVirtualFile[] getFiles(boolean recurse, boolean includeCloakedFiles) throws ConnectionException, IOException {
        HashMap<String, CompressedFileEntry> vfs = new HashMap<String, CompressedFileEntry>();
        if (this.zippedFile != null) {
            ArrayList<ZipEntry> entries = new ArrayList<ZipEntry>();
            Enumeration<? extends ZipEntry> files = this.zippedFile.entries();
            while (files.hasMoreElements()) {
                ZipEntry entry = files.nextElement();
                entries.add(entry);
            }
            Collections.sort(entries, new Comparator<ZipEntry>(){

                @Override
                public int compare(ZipEntry o1, ZipEntry o2) {
                    return o1.getName().compareToIgnoreCase(o2.getName());
                }
            });
            for (ZipEntry entry : entries) {
                String name = entry.getName();
                String[] paths = name.split("/");
                if (paths.length == 1) {
                    CompressedFileEntry cfe = new CompressedFileEntry(entry, this.manager, this);
                    cfe.setName(paths[0]);
                    if (!includeCloakedFiles && cfe.isCloaked()) continue;
                    vfs.put(cfe.getName(), cfe);
                    continue;
                }
                if (paths.length <= 1) continue;
                CompressedFileEntry parentEntry = (CompressedFileEntry)vfs.get(paths[0]);
                if (parentEntry == null) {
                    parentEntry = new CompressedFileEntry(null, this.manager, this);
                    parentEntry.setName(paths[0]);
                    if (includeCloakedFiles || !parentEntry.isCloaked()) {
                        vfs.put(parentEntry.getName(), parentEntry);
                    }
                }
                int i = 1;
                while (i < paths.length - 1) {
                    CompressedFileEntry newParentEntry = parentEntry.getEntry(paths[i]);
                    if (newParentEntry == null) {
                        newParentEntry = new CompressedFileEntry(null, this.manager, this);
                        newParentEntry.setName(paths[i]);
                        parentEntry.addEntry(newParentEntry);
                    }
                    parentEntry = newParentEntry;
                    ++i;
                }
                if (parentEntry == null) continue;
                CompressedFileEntry cfe = new CompressedFileEntry(entry, this.manager, this);
                cfe.setName(paths[paths.length - 1]);
                if (!includeCloakedFiles && cfe.isCloaked()) continue;
                parentEntry.addEntry(cfe);
            }
        }
        return vfs.values().toArray(new IVirtualFile[0]);
    }

    public String getGroup() {
        return "";
    }

    public Image getImage() {
        if (this.image == null) {
            return ImageUtils.getIcon(this.file, null);
        }
        return this.image;
    }

    public long getModificationMillis() {
        return this.file.lastModified();
    }

    public String getName() {
        String tempFileName;
        String fileName = this.file.getName();
        if (!(CoreUIUtils.onMacOSX || fileName != null && !"".equals(fileName) && filesys.isFileSystem(this.file) || (tempFileName = filesys.getSystemDisplayName(this.file)) == null)) {
            fileName = tempFileName;
        }
        return fileName;
    }

    public String getOwner() {
        return null;
    }

    public IVirtualFile getParentFile() {
        return null;
    }

    public String getPath() {
        return this.file.getPath();
    }

    public long getPermissions() {
        return this.permissions;
    }

    public String getRelativePath() {
        String basePath = "";
        if (this.getFileManager().getBasePath() != null) {
            basePath = this.getFileManager().getBaseFile().getAbsolutePath();
        }
        if (basePath.length() <= this.getAbsolutePath().length()) {
            return this.getAbsolutePath().substring(basePath.length());
        }
        return this.getAbsolutePath();
    }

    public long getSize() {
        if (this.file != null) {
            return this.file.length();
        }
        return 0L;
    }

    public InputStream getStream() throws ConnectionException, VirtualFileManagerException {
        return null;
    }

    public boolean hasFiles() {
        return this.zippedFile != null && this.zippedFile.size() > 0;
    }

    public boolean isDirectory() {
        return false;
    }

    public boolean isFile() {
        return this.zippedFile == null || this.zippedFile.size() == 0;
    }

    public boolean isLink() {
        return false;
    }

    public void putStream(InputStream input, IFileProgressMonitor monitor) throws ConnectionException, VirtualFileManagerException, IOException {
    }

    public boolean rename(String newName) throws ConnectionException, VirtualFileManagerException {
        return false;
    }

    public void setGroup(String group) {
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public void setModificationMillis(long modificationTime) throws IOException, ConnectionException {
        if (this.file != null) {
            this.file.setLastModified(modificationTime);
        }
    }

    public void setOwner(String owner) {
    }

    public void setPermissions(long permissions) {
        this.permissions = permissions;
    }

    public void editProperties(Shell shell) {
        InfoDialog nld = new InfoDialog(shell, 2160);
        nld.setItem(this);
        nld.open();
    }

    public boolean isCloaked() {
        return this.manager.isFileCloaked(this);
    }

    public void setCloaked(boolean cloak) {
        if (cloak) {
            this.manager.addCloakedFile(this);
        } else {
            this.manager.removeCloakedFile(this);
        }
    }

    public int compareTo(Object o) {
        if (o instanceof LocalFile) {
            return this.getName().compareToIgnoreCase(((LocalFile)o).getName());
        }
        return 0;
    }

    public File getFile() {
        return this.file;
    }

    public ZipFile getCompressedFile() {
        return this.zippedFile;
    }
}

